Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Prefix.
Require Import Metarouting.Inference.Semigroups.Seq.
Require Import Metarouting.Constructions.Bisemigroups.PrefixSeq.

Definition prefixSeqBisemigroup_props {a} (ap : dsProp a) : bsProp (prefixSeqBisemigroup a).
   intros.
   apply (Build_bsProp (prefixSeqBisemigroup a)
         (projPlusBSmgIso _ _ _ (prefixSemigroup_props ap))
         (projTimesBSmgIso _ _ _ (seqSemigroup_props ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opInit (@PrefixSeq.isLeftDistributive a)).
   apply None.

   (* IsRightDistributive *)
   apply (opMap (@PrefixSeq.isRightDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.isRightDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesAnnihilator *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* PlusAnnihilatorIsTimesIdentity *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsRightStrictStable *)
   apply (opMap (@PrefixSeq.isRightStrictStable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.isRightStrictStable_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftStrictStable *)
   apply (opInit (@PrefixSeq.isLeftStrictStable a)).
   apply None.

   (* IsRightCompEqCancel *)
   apply (opInit (@PrefixSeq.isRightCompEqCancel a)).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opInit (@PrefixSeq.isLeftCompEqCancel a)).
   apply None.

   (* IsRightCompCancel *)
   apply (opMap (@PrefixSeq.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@PrefixSeq.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@PrefixSeq.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@PrefixSeq.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@PrefixSeq.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@PrefixSeq.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@PrefixSeq.leftIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@PrefixSeq.leftIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opInit (@PrefixSeq.rightIncreasing a)).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@PrefixSeq.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@PrefixSeq.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opInit (@PrefixSeq.isRightTimesMapToIdConstantPlus a)).
   apply None.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opInit (@PrefixSeq.isLeftTimesMapToIdConstantPlus a)).
   apply None.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@PrefixSeq.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@PrefixSeq.plusIdentityIsTimesRightAnnihilator a)).
   apply None.
Defined.
