Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.MultiSetsUnion.
Require Import Metarouting.Inference.Semigroups.MultiSetsIntersection.
Require Import Metarouting.Constructions.Bisemigroups.MultiSets.

Definition multisetBisemigroup_props {a} (ap : dsProp a) : bsProp (multisetBisemigroup a).
   intros.
   apply (Build_bsProp (multisetBisemigroup a)
         (projPlusBSmgIso _ _ _ (multisetIntersectionSemigroup_props ap))
         (projTimesBSmgIso _ _ _ (multisetUnionSemigroup_props ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opInit (@MultiSets.isLeftDistributive a)).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@MultiSets.isRightDistributive a)).
   apply None.

   (* PlusIdentityIsTimesAnnihilator *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* PlusAnnihilatorIsTimesIdentity *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsRightStrictStable *)
   apply (opInit (@MultiSets.isRightStrictStable a)).
   apply None.

   (* IsLeftStrictStable *)
   apply (opInit (@MultiSets.isLeftStrictStable a)).
   apply None.

   (* IsRightCompEqCancel *)
   apply (opInit (@MultiSets.isRightCompEqCancel a)).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opInit (@MultiSets.isLeftCompEqCancel a)).
   apply None.

   (* IsRightCompCancel *)
   apply (opMap (@MultiSets.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSets.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@MultiSets.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSets.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@MultiSets.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@MultiSets.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@MultiSets.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSets.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@MultiSets.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@MultiSets.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opInit (@MultiSets.leftIncreasing a)).
   apply None.

   (* RightIncreasing *)
   apply (opInit (@MultiSets.rightIncreasing a)).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@MultiSets.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@MultiSets.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opInit (@MultiSets.isRightTimesMapToIdConstantPlus a)).
   apply None.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opInit (@MultiSets.isLeftTimesMapToIdConstantPlus a)).
   apply None.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@MultiSets.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@MultiSets.plusIdentityIsTimesRightAnnihilator a)).
   apply None.
Defined.
