Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Left.
Require Import Metarouting.Constructions.Bisemigroups.Left.


Definition leftBisemigroup_props {a} (ap : sgProp a) : bsProp (leftBisemigroup a).
   intros.
   apply (Build_bsProp (leftBisemigroup a)
         (projPlusBSmgIso _ _ _ ap)
         (projTimesBSmgIso _ _ _ (leftSemigroup_props ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@Left.isLeftDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isLeftDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opInit (@Left.isRightDistributive a)).
   apply None.

(*
   (* IsLeftCoDistributive *)
   apply (opInit (@Left.isLeftCoDistributive a)).
   apply None.

   (* IsRightCoDistributive *)
   apply (opInit (@Left.isRightCoDistributive a)).
   apply None.
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@Left.plusIdentityIsTimesAnnihilator a)); opUnfoldBoolFormula; fail.
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opInit (@Left.plusAnnihilatorIsTimesIdentity a)); opUnfoldBoolFormula; fail.
   apply None.

   (* IsRightStrictStable *)
   apply (opInit (@Left.isRightStrictStable a)).
   apply None.

   (* IsLeftStrictStable *)
   apply (opMap (@Left.isLeftStrictStable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isLeftStrictStable_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompEqCancel *)
   apply (opInit (@Left.isRightCompEqCancel a)).
   apply None.

   (* IsLeftCompEqCancel *)
   apply (opMap (@Left.isLeftCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isLeftCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@Left.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opInit (@Left.isLeftCompCancel a)).
   apply None.

   (* LeftDiscrete *)
   apply (opInit (@Left.leftDiscrete a)).
   apply None.

   (* RightDiscrete *)
   apply (opMap (@Left.rightDiscrete a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.rightDiscrete_comp a)); opUnfoldBoolFormula; fail.

   (* LeftComparable *)
   apply (opInit (@Left.leftComparable a)).
   apply None.

   (* RightComparable *)
   apply (opMap (@Left.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@Left.leftIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.leftIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opInit (@Left.rightIncreasing a)).
   apply None.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@Left.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@Left.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply (opMap (@Left.isRightTimesMapToIdConstantPlus a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isRightTimesMapToIdConstantPlus_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftTimesMapToIdConstantPlus *)
   apply (opMap (@Left.isLeftTimesMapToIdConstantPlus a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.isLeftTimesMapToIdConstantPlus_comp a)); opUnfoldBoolFormula; fail.

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@Left.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opMap (@Left.plusIdentityIsTimesRightAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Left.plusIdentityIsTimesRightAnnihilator_comp a)); opUnfoldBoolFormula; fail.
Defined.
