Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.OrderSemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.FMinSetUnion.
Require Import Metarouting.Inference.Semigroups.FMinSetsOp.
Require Import Metarouting.Constructions.Bisemigroups.FMinSets.

Definition minsetBisemigroup_props {a} (ap : osProp a) lmon rmon antisym : bsProp (minsetBisemigroup a lmon rmon antisym).
   intros.
   apply (Build_bsProp (minsetBisemigroup a lmon rmon antisym)
         (projPlusBSmgIso _ _ _ (msetUnionSemigroup_props antisym ap))
         (projTimesBSmgIso _ _ _ (msetOpSemigroup_props lmon rmon antisym ap)));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opInit (@FMinSets.isLeftDistributive a lmon rmon antisym)).
   apply None.

   (* IsRightDistributive *)
   apply (opInit (@FMinSets.isRightDistributive a lmon rmon antisym)).
   apply None.

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@FMinSets.plusIdentityIsTimesAnnihilator a lmon rmon antisym)).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@FMinSets.isRightStrictStable_comp a lmon rmon antisym)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@FMinSets.isLeftStrictStable_comp a lmon rmon antisym)).

   (* IsRightCompEqCancel *)
   apply (opMap (@FMinSets.isRightCompEqCancel a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSets.isRightCompEqCancel_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@FMinSets.isLeftCompEqCancel a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSets.isLeftCompEqCancel_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsLeftCompCancel *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@FMinSets.leftDiscrete_comp a lmon rmon antisym)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@FMinSets.rightDiscrete_comp a lmon rmon antisym)).

   (* LeftComparable *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* RightComparable *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

  (* LeftIncreasing *)
   apply (opMap (@FMinSets.leftIncreasing a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSets.leftIncreasing_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@FMinSets.rightIncreasing a lmon rmon antisym)); opUnfoldBoolFormula; fail.
   apply (opMap (@FMinSets.rightIncreasing_comp a lmon rmon antisym)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@FMinSets.leftStrictIncreasing_comp a lmon rmon antisym)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@FMinSets.rightStrictIncreasing_comp a lmon rmon antisym)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply None. (* Unknown *)
   apply None. (* Unknown *)
Defined.
