Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupPropRecord.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.Semigroups.Union.
Require Import Metarouting.Inference.Semigroups.UnionSwap.
Require Import Metarouting.Inference.Semigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.AddZero.

Definition addZeroBisemigroup_props {a} (ap : bsProp a) : bsProp (addZeroBisemigroup a).
   intros.
   apply (Build_bsProp (addZeroBisemigroup a)
         (projPlusBSmgIso _ _ _ (unionSemigroup_props (bs_plus_sgprop _ ap) unitSemigroup_props ))
         (projTimesBSmgIso _ _ _ (unionSwapSemigroup_props unitSemigroup_props (bs_times_sgprop _ ap))));
   hypPropSplit.

   (* IsLeftDistributive *)
   apply (opMap (@AddZero.isLeftDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isLeftDistributive_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightDistributive *)
   apply (opMap (@AddZero.isRightDistributive a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isRightDistributive_comp a)); opUnfoldBoolFormula; fail.

(*
   (* IsLeftCoDistributive *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)

   (* IsRightCoDistributive *)
   apply None. (* UNKNOWN *)
   apply None. (* UNKNOWN *)
*)

   (* PlusIdentityIsTimesAnnihilator *)
   apply (opInit (@AddZero.plusIdentityIsTimesAnnihilator a)).
   apply None.

   (* PlusAnnihilatorIsTimesIdentity *)
   apply (opMap (@AddZero.plusAnnihilatorIsTimesIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.plusAnnihilatorIsTimesIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightStrictStable *)
   apply None.
   apply (opInit (@AddZero.isRightStrictStable_comp a)).

   (* IsLeftStrictStable *)
   apply None.
   apply (opInit (@AddZero.isLeftStrictStable_comp a)).

   (* IsRightCompEqCancel *)
   apply (opMap (@AddZero.isRightCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isRightCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompEqCancel *)
   apply (opMap (@AddZero.isLeftCompEqCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isLeftCompEqCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsRightCompCancel *)
   apply (opMap (@AddZero.isRightCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isRightCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeftCompCancel *)
   apply (opMap (@AddZero.isLeftCompCancel a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.isLeftCompCancel_comp a)); opUnfoldBoolFormula; fail.

   (* LeftDiscrete *)
   apply None.
   apply (opInit (@AddZero.leftDiscrete_comp a)).

   (* RightDiscrete *)
   apply None.
   apply (opInit (@AddZero.rightDiscrete_comp a)).

   (* LeftComparable *)
   apply (opMap (@AddZero.leftComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.leftComparable_comp a)); opUnfoldBoolFormula; fail.

   (* RightComparable *)
   apply (opMap (@AddZero.rightComparable a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.rightComparable_comp a)); opUnfoldBoolFormula; fail.

   (* LeftIncreasing *)
   apply (opMap (@AddZero.leftIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.leftIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* RightIncreasing *)
   apply (opMap (@AddZero.rightIncreasing a)); opUnfoldBoolFormula; fail.
   apply (opMap (@AddZero.rightIncreasing_comp a)); opUnfoldBoolFormula; fail.

   (* LeftStrictIncreasing *)
   apply None.
   apply (opInit (@AddZero.leftStrictIncreasing_comp a)).

   (* RightStrictIncreasing *)
   apply None.
   apply (opInit (@AddZero.rightStrictIncreasing_comp a)).

   (* IsRightTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@AddZero.isRightTimesMapToIdConstantPlus_comp a)).

   (* IsLeftTimesMapToIdConstantPlus *)
   apply None.
   apply (opInit (@AddZero.isLeftTimesMapToIdConstantPlus_comp a)).

   (* PlusIdentityIsTimesLeftAnnihilator *)
   apply (opInit (@AddZero.plusIdentityIsTimesLeftAnnihilator a)).
   apply None.

   (* PlusIdentityIsTimesRightAnnihilator *)
   apply (opInit (@AddZero.plusIdentityIsTimesRightAnnihilator a)).
   apply None.
Defined.
