Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.DecSetoid.


Section Product.

   Variable A : DecSetoid.

   Open Scope Transform_scope.
   
   Definition replace_app (f : A) (x : A) : A := f.
   
   Lemma replace_app_pres_eq : AppPreserve replace_app.
   Proof. intros x y f g _ h; apply h. Defined.
   
   Definition replaceTransform : Transform :=
      Build_Transform replace_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : IsSingleton A -> Cancelative replaceTransform.
   Proof. intros [a sg] x y f _. rewrite (sg x), (sg y); auto. Defined.

   Lemma cancelative_comp : IsSingleton_comp A -> Cancelative_comp replaceTransform.
   Proof. intros sg; destruct (sg (choose A)) as [b p]; 
      exists b; exists (choose A); exists b; auto.
   Defined.

   Lemma condensed : Condensed replaceTransform.
   Proof. intros x y f; auto. Defined.
   
   Lemma identity : IsSingleton A -> Identity replaceTransform.
   Proof. intros [a sg] x y. simpl. unfold replace_app.
      rewrite (sg x), (sg y); auto.
   Qed.

   Lemma identity_comp : IsSingleton_comp A -> Identity_comp replaceTransform.
   Proof. intros sg. set (a := choose A); destruct (sg a) as [b pb].
      exists a; exists b. simpl. unfold replace_app; auto.
   Defined.

   Close Scope Transform_scope.
   
End Product.