Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Constructions.DecSetoids.Unit.


Section Product.

   Variable A : DecSetoid.

   Open Scope Transform_scope.
   
   Definition id_app (f : unitDecSetoid) (x : A) : A := x.
   
   Lemma id_app_pres_eq : AppPreserve id_app.
   Proof. intros x y [] [] h _; apply h. Defined.
   
   Definition idTransform : Transform :=
      Build_Transform id_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : Cancelative idTransform.
   Proof. intros x y []; dseq_u; simpl in *; unfold id_app; destruct ((x == y)%bool); auto. Defined.

   Lemma condensed : IsSingleton A -> Condensed idTransform.
   Proof. intros [a sg] x y []; rewrite (sg x), (sg y); auto. Defined.
   
   Lemma condensed_comp : IsSingleton_comp A -> Condensed_comp idTransform.
   Proof. intros sg; destruct (sg (choose A)) as [b p]; exists b; exists (choose A); exists tt. apply p. Defined.
   
   Lemma identity : Identity idTransform.
   Proof. intros x []; auto. Qed.

   Close Scope Transform_scope.
   
End Product.
