Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section FSets.

   Variable A : Transform.

   Open Scope Transform_scope.
   
   Definition fmap_app (f : fn A) (x : fsetDecSetoid A) : fsetDecSetoid A :=
      nodub A (map (fun y => f |> y) x).
      
   Lemma fmap_app_pres_eq : AppPreserve fmap_app.
   Proof. intros x y f g p q.
      toSet_u. unfold fmap_app; simpl.
      repeat rewrite nodub_mem.
      rewrite bool_eq; split; intros h.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists b; split. dseq_f; rewrite <- q; auto. rewrite <- p; auto.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists b; split. dseq_f; rewrite q; auto. rewrite p; auto.
   Qed.
   
   Lemma mem_fmap_intro : forall a f x, mem a x -> mem (f |> a) (fmap_app f x).
   Proof. intros a f x p. unfold fmap_app; rewrite nodub_mem.
      apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists a; auto.
   Qed.
   
   Lemma mem_fmap_elim : forall a f x, mem a (fmap_app f x) -> Exists b, mem b x /\ f |> b == a.
   Proof. intros a f x p. unfold fmap_app in p; rewrite nodub_mem in p.
      destruct (mem_map_elim _ _ _ p) as [b [p1 p2]].
      exists b; split; auto. rewrite <- p1; auto.
   Defined.
   
   Definition fsetsTransform : Transform :=
      Build_Transform fmap_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative : Cancelative A -> Cancelative fsetsTransform.
   Proof. intros ca x y f h. toSet_u.
      rewrite bool_eq; split; intros p.
      assert (mem (f |> a) (fmap_app f x)) as h1.
         unfold fmap_app. rewrite nodub_mem. apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists a; auto.
      rewrite h in h1.
      unfold fmap_app in h1; rewrite nodub_mem in h1.
      destruct (mem_map_elim _ _ _ h1) as [b [p1 p2]].
      assert (p3 := ca _ _ _ p1).
      rewrite (mem_pres_eq y p3). auto.

      assert (mem (f |> a) (fmap_app f y)) as h1.
         unfold fmap_app. rewrite nodub_mem. apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists a; auto.
      rewrite <- h in h1.
      unfold fmap_app in h1; rewrite nodub_mem in h1.
      destruct (mem_map_elim _ _ _ h1) as [b [p1 p2]].
      assert (p3 := ca _ _ _ p1).
      rewrite (mem_pres_eq x p3). auto.
   Qed.
   
   Lemma cancelative_comp : Cancelative_comp A -> Cancelative_comp fsetsTransform.
   Proof. intros [x [y [f [ca1 ca2]]]].
      exists (x :: nil); exists (y :: nil); exists f.
      split. toSet_u. simpl.
      repeat rewrite orb_false_r.
      rewrite bool_eq; split; intros h; dseq_f; rewrite h; clear h; rewrite ca1; auto.
      toProp; intros h; apply ca2. toSet_u.
      assert (p := h y); simpl in p.
      rewrite orb_false_r, refl in p; simpl in p. dseq_f; rewrite p; auto.
   Defined.

   Lemma condensed_comp : Condensed_comp fsetsTransform.
   Proof. set (a := choose A); set (f := choose (fn A)).
      exists (a :: nil); exists nil; exists f.
      toProp; intros h; dseq_f; toSet_u.
      assert (p := h (f |> a)); clear h.
      simpl in p. rewrite refl in p; discriminate p.
   Defined.
   
   Lemma identity : Identity A -> Identity fsetsTransform.
   Proof. intros iid x f. toSet_u. unfold fmap_app; rewrite nodub_mem.
      rewrite bool_eq; split; intros h.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      rewrite (iid b f) in p1.
      rewrite (mem_pres_eq x p1); auto.
      apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists a; split; auto; rewrite (iid a f); auto.
   Qed.
   
   Lemma identity_comp : Identity_comp A -> Identity_comp fsetsTransform.
   Proof. intros [x [f iid]].
      exists (x :: nil); exists f. toProp; intros h; apply iid; clear iid.
      dseq_f; toSet_u.
      assert (p := h x); clear h.
      unfold fmap_app in p; rewrite nodub_mem in p; simpl in p.
      rewrite orb_false_r, refl in p; dseq_f; rewrite <- p; auto.
   Defined.

End FSets.
