Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Constructions.DecSetoids.Unit.
Require Import Metarouting.Constructions.DecSetoids.Union.

Section AddZero.

   Variable A : Transform.

   Open Scope Transform_scope.
   
   Definition add_zero_app (f : unionDecSetoid (fn A) unitDecSetoid) (x : unionDecSetoid A unitDecSetoid) : unionDecSetoid A unitDecSetoid :=
      match x, f with
      | inl x, inl f => inl _ (f |> x)
      | inr tt, _ 
      | _, inr tt => inr _ tt
      end.
      
   Lemma add_zero_app_pres_eq : AppPreserve add_zero_app.
   Proof. intros [x|[]] [y|[]] [f|[]] [g|[]]; dseq_u; simpl; toProp; dseq_f; auto.
      intros p q; rewrite p, q; auto.
   Defined.
   
   Definition addZeroTransform : Transform :=
      Build_Transform add_zero_app_pres_eq.

   (******************************************************)
   (*                    Properties                      *)
   (******************************************************)

   Lemma cancelative_comp : Cancelative_comp addZeroTransform.
   Proof. exists (inl _ (choose A)); exists (inr _ tt); exists (inr _ tt); dseq_u; simpl; auto. Defined.
   
   Lemma condensed_comp : Condensed_comp addZeroTransform.
   Proof. exists (inl _ (choose A)); exists (inr _ tt); exists (inl _ (choose (fn A))). auto. Defined.
   
   Lemma identity_comp : Identity_comp addZeroTransform.
   Proof. exists (inl _ (choose A)); exists (inr _ tt); dseq_u; simpl; auto. Defined.

End AddZero.