Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.Unit.

(*********************************************************************)
(* unit semigroup *)

Section Unit.

   Definition unit_op (x y : unitDecSetoid) : unitDecSetoid := tt.

   Lemma unit_assoc : Associative unit_op.
   Proof. intros [] [] []; auto. Defined.

   Lemma unit_op_pres_eq : Preserves unit_op.
   Proof. intros [] [] [] []; auto. Defined.

   Definition unitSemigroup : Semigroup :=
      Build_Semigroup
         unit_assoc (* assoc *)
         unit_op_pres_eq (* op_pres_eq *). 

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma unitSmgIso_isIso : forall (A : Semigroup) (sg : IsSingleton A), 
                               IsSmgIso A unitSemigroup (unitDsIso sg).
   Proof. intros A [a sg]; simpl; split.
      intros; auto.
      intros; rewrite (sg (a + a)); auto.
   Qed.
   
   Definition unitSmgIso (A : Semigroup) (sg : IsSingleton A) : SmgIso A unitSemigroup :=
      Build_SmgIso (unitSmgIso_isIso A sg).

   Lemma isIdempotent : IsIdempotent unitSemigroup.
   Proof. red; intros; compute; trivial. Defined.

   Lemma isSelective : IsSelective unitSemigroup.
   Proof. red; intros; compute; auto. Defined.

   Lemma isCommutative : IsCommutative unitSemigroup.
   Proof. red; intros; compute; trivial. Defined.

   Lemma hasIdentity : HasIdentity unitSemigroup.
   Proof. exists tt; compute; split; trivial. Defined.

   Lemma hasAnnihilator : HasAnnihilator unitSemigroup.
   Proof. exists tt; compute; split; trivial. Defined.

   Lemma isLeft : IsLeft unitSemigroup.
   Proof. intros [] []; split; compute. Defined.

   Lemma isRight : IsRight unitSemigroup.
   Proof. intros [] []; split; compute. Defined.

   Lemma leftCondensed : LeftCondensed unitSemigroup.
   Proof. intros [] [] []; compute; trivial. Defined.

   Lemma rightCondensed : RightCondensed unitSemigroup.
   Proof. intros [] [] []; compute; trivial. Defined.

   Lemma leftCancelative : LeftCancelative unitSemigroup.
   Proof. intros [] [] []; compute; trivial. Defined.

   Lemma rightCancelative : RightCancelative unitSemigroup.
   Proof. intros [] [] []; compute; trivial. Defined.

   Lemma antiLeft_comp : AntiLeft_comp unitSemigroup.
   Proof. exists tt; exists tt; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp unitSemigroup.
   Proof. exists tt; exists tt; auto. Defined.

   Lemma treeGlb : TreeGlb unitSemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

End Unit.