(*
 * Isomorphic: Union
 * Ignore: true
 *)

Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.Semigroups.Union.

(* this is a symmetric vertion of disjoint union with a proof that it is isomorphic 
   to definition in Union.v *)

Section DisjointUnionSwap.

   Open Scope Semigroup_scope.

   Variables A B : Semigroup.

   Definition ver_union_op (x y : unionDecSetoid B A) : unionDecSetoid B A :=
      match x, y with
         | (inl a), (inl b) => inl _ (a + b)
         | (inl _), (inr _) => y
         | (inr _), (inl _) => x
         | (inr a), (inr b) => inr _ (a + b)
      end.

   Lemma ver_union_swap_assoc : Associative ver_union_op.
   Proof. intros [x|x] [y|y] [z|z]; dseq_u; simpl; dseq_f; auto; apply assoc. Defined.

   Lemma ver_union_swap_op_pres_eq : Preserves ver_union_op.
   Proof. intros [x|x] [y|y] [u|u] [v|v] p q; dseq_u; simpl in *; auto; dseq_f;
      try discriminate; rewrite p, q; auto.
   Defined.


   Definition unionSwapSemigroup : Semigroup :=
      Build_Semigroup
         ver_union_swap_assoc
         ver_union_swap_op_pres_eq.

   Lemma unionDsIso_isIso : IsDsIso unionSwapSemigroup (unionSemigroup A B) 
               (fun x : unionSwapSemigroup => match x return unionSemigroup A B with 
                                                | inl a => inr A a 
                                                | inr a => inl B a 
                                              end)
               (fun x => match x with inl a => inr _ a | inr a => inl _ a end).
   Proof. split.
         intros [x|x] [y|y]; auto.
         intros [x|x] [y|y]; auto.
         intros [x|x]; auto.
         intros [x|x]; auto.
   Qed.

   Definition unionDsIso : DsIso unionSwapSemigroup (unionSemigroup A B) :=
      Build_DsIso unionDsIso_isIso.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma unionSmgIso_isIso : IsSmgIso unionSwapSemigroup (unionSemigroup A B) unionDsIso.
   Proof. split.
      intros [x|x] [y|y]; auto.
      intros [x|x] [y|y]; auto. 
   Qed.

   Definition unionSmgIso : SmgIso unionSwapSemigroup (unionSemigroup A B) :=
      Build_SmgIso unionSmgIso_isIso.

End DisjointUnionSwap.
