Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.DecSetoids.SimpleSeq.
Require Import Metarouting.Constructions.DecSetoids.Unit.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section Seq.

   Open Scope Semigroup_scope.

   Variable A : DecSetoid.
   
   Definition disjoint (x y : list A) : bool :=
      forallb (fun a => negb (mem a y)) x.
   
   Lemma disjoint_pres_eq : forall x y u v : list A, seq_eq A x u -> seq_eq A y v -> disjoint x y = disjoint u v.
   Proof. refine (fix disjoint_pres_eq x y u v (e1 : seq_eq A x u) (e2 : seq_eq A y v) {struct x} : disjoint x y = disjoint u v := _).
      destruct x; destruct u; simpl in *; trivial; try discriminate.
      copy_destruct (c == c0); rewrite ew in e1; [simpl in e1 | discriminate e1].
      dseq_f; rewrite (mem_pres_eq _ ew); rewrite (mem_seq_eq A _ _ e2).
      rewrite (disjoint_pres_eq x y u v); auto.
   Qed.
      
   Lemma simple_app : forall x y : list A, simple A (x ++ y) = simple A x && simple A y && disjoint x y.
   Proof. intros x y.
      induction x. simpl. rewrite andb_true_r; auto.
      simpl. rewrite mem_app. rewrite IHx.
      destruct (mem a x); destruct (mem a y); simpl; auto.
      repeat rewrite andb_false_r; auto.
   Qed.
   
   Lemma simple_seq_eq : forall x y : list A, seq_eq A x y -> simple A x = simple A y.
   Proof. refine (fix simple_seq_eq x y (e : seq_eq A x y) {struct x} : simple A x = simple A y := _).
      destruct x; destruct y; simpl in *; auto; try discriminate e.
      copy_destruct (c == c0); rewrite ew in e; [simpl in e|discriminate e].
      dseq_f; rewrite (mem_pres_eq _ ew).
      rewrite (mem_seq_eq A _ _ e). destruct (mem c0 y); auto.
   Qed.

   Lemma simple_app_assoc : @Associative (simpleSeqDecSetoid A) (@app A).
   Proof. intros x y z.
      dseq_u; simpl. unfold sseq_eq.
      rewrite (app_ass).
      destruct (simple A (x ++ y ++ z)); auto.
      simpl; apply seq_eq_refl.
   Qed.
   
   Lemma simple_app_pres_eq : @Preserves (simpleSeqDecSetoid A) (@app A).
   Proof. intros x y u v.
      dseq_u; simpl; unfold sseq_eq.
      repeat rewrite simple_app.
      destruct (simple A x); destruct (simple A y); 
      destruct (simple A u); destruct (simple A v); 
      simpl; intros p q; try discriminate; auto.
      rewrite (disjoint_pres_eq x y u v); auto.
      destruct (disjoint u v); auto.
      simpl; apply (app_pres_eq A); auto.
   Qed.
   
   Definition simpleSeqSemigroup : Semigroup :=
      Build_Semigroup
         simple_app_assoc (* assoc *)
         simple_app_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Ltac sseq_u :=
      dseq_u; unfold sseq_eq in *.
   
   Lemma isIdempotent_comp : IsIdempotent_comp simpleSeqSemigroup.
   Proof. set (a := choose A); exists (a :: nil).
      simpl; unfold sseq_eq. simpl. rewrite refl; simpl. auto.
   Defined.
   
   Lemma isCommutative : IsSingleton A -> IsCommutative simpleSeqSemigroup.
   Proof. intros sg x y. dseq_u; simpl; apply seq_eq_sseq_eq; apply (Seq.isCommutative A); auto.
   Qed.
   
   Lemma isCommutative_comp : IsSingleton_comp A -> IsCommutative_comp simpleSeqSemigroup.
   Proof. intros sg. set(a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); simpl.
      unfold sseq_eq. simpl.
      assert (a == b = false) as q1.
         toProp; bool_p; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q2.
         toProp; bool_p; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1, q2. simpl. auto.
   Defined.
   
   Lemma isSelective_comp : IsSelective_comp simpleSeqSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); dseq_u; simpl. 
      unfold sseq_eq; negb_p. simpl.
      rewrite refl; simpl. auto. 
   Defined.
   
   Lemma hasIdentity : HasIdentity simpleSeqSemigroup.
   Proof. exists nil; simpl. intros x.
      split; auto. rewrite <- app_nil_end; auto.
   Qed.
   
   Lemma hasAnnihilator : HasAnnihilator simpleSeqSemigroup.
   Proof. exists (err A); intros x; dseq_u; simpl.
      sseq_u; negb_p. rewrite simple_app.
      rewrite simple_err; simpl. rewrite refl; simpl. split; auto.
      repeat rewrite andb_false_r; simpl. auto.
   Defined.
   
   Lemma isLeft_comp : IsLeft_comp simpleSeqSemigroup.
   Proof. exists nil; exists (err A); dseq_u; simpl.
      sseq_u; rewrite simple_err; trivial.
   Defined.

   Lemma isRight_comp : IsRight_comp simpleSeqSemigroup.
   Proof. exists (err A); exists nil; dseq_u; simpl.
      sseq_u; rewrite simple_err; trivial.
   Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp simpleSeqSemigroup.
   Proof. exists nil; exists (err A); exists nil; dseq_u; simpl.
      sseq_u. negb_p; rewrite simple_err; auto.
   Defined.
   
   Lemma rightCondensed_comp : RightCondensed_comp simpleSeqSemigroup.
   Proof. exists nil; exists nil; exists (err A); dseq_u; simpl.
      sseq_u. negb_p; rewrite simple_err; auto.
   Defined.
   
   Lemma leftCancelative_comp : LeftCancelative_comp simpleSeqSemigroup.
   Proof. exists (err A); exists nil; exists (err A); dseq_u; simpl; sseq_u; negb_p; 
      repeat rewrite simple_err; auto. simpl.
      rewrite refl; simpl. auto.
   Defined.
     
   Lemma rightCancelative_comp : RightCancelative_comp simpleSeqSemigroup.
   Proof. exists nil; exists (err A); exists (err A); dseq_u; simpl; sseq_u; negb_p; 
      repeat rewrite simple_err; auto. simpl.
      rewrite refl; simpl. auto.
   Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp simpleSeqSemigroup.
   Proof. exists nil; exists nil; dseq_u; compute; auto. Defined.
   
   Lemma antiRight_comp : AntiRight_comp simpleSeqSemigroup.
   Proof. exists nil; exists nil; dseq_u; compute; auto. Defined.
   
   (* always irrelevant *)
   Lemma treeGlb : TreeGlb simpleSeqSemigroup.
   Proof. intros _ idem.
      destruct (isIdempotent_comp) as [x p1].
      assert (p2 := idem x). toProp; tauto.
   Qed.

End Seq.