Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Coq.Lists.List.

Section Seq.

   Open Scope Semigroup_scope.

   Variable A : DecSetoid.
   
   Lemma app_assoc : @Associative (seqDecSetoid A) (@app A).
   Proof. intros x y z. rewrite app_ass; auto. Qed.
   
   Lemma app_pres_l : forall a b : seqDecSetoid A, a == b -> 
                      forall x y : seqDecSetoid A, x == y -> @dseq (seqDecSetoid A) (x ++ a) (y ++ b).
   Proof. intros a b q x; induction x.
      intros [|y ys] p; auto. discriminate p.
      intros [|y ys] h. discriminate h.
      dseq_u; simpl in *.
      destruct (a0 != y); auto.
   Qed.
   
   Lemma app_pres_eq : @Preserves (seqDecSetoid A) (@app A).
   Proof. intros x y u v p h. apply app_pres_l; auto. Qed.
   
   Definition seqSemigroup : Semigroup :=
      Build_Semigroup
         app_assoc (* assoc *)
         app_pres_eq (* op_pres_eq *).
         
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   (* If A is singleton the (seq, app) is the same as (nat, +) *)

   Lemma seqnatSmgIso_isIso : forall (sg : IsSingleton A), IsSmgIso seqSemigroup natPlusSemigroup (seqnatDsIso sg).
   Proof. intros [a sg]; split; simpl in *; intros x y.
      rewrite app_length; auto.
      induction x; auto.
      unfold dseq; simpl. rewrite refl; auto.
   Qed.
   
   Definition seqnatSmgIso (sg : IsSingleton A) : SmgIso seqSemigroup natPlusSemigroup :=
      Build_SmgIso (seqnatSmgIso_isIso sg).

   Lemma isIdempotent_comp : IsIdempotent_comp seqSemigroup.
   Proof. exists (choose A :: nil). simpl. rewrite refl; auto. Defined.
   
   Lemma isSelective_comp : IsSelective_comp seqSemigroup.
   Proof. exists (choose A :: nil); exists (choose A :: nil); simpl; rewrite refl; auto. Defined.
   
   Lemma isCommutative : IsSingleton A -> IsCommutative seqSemigroup.
   Proof. intros sg.
      apply (Iso_IsCommutative (SmgIso_sym (seqnatSmgIso sg))).
      apply NatPlus.isCommutative.
   Defined.
   
   Lemma isCommutative_comp : IsSingleton_comp A -> IsCommutative_comp seqSemigroup.
   Proof. intros sg. destruct (sg (choose A)) as [b pb].
      exists (b :: nil); exists (choose A :: nil); simpl.
      rewrite pb; auto.
   Defined.
   
   Lemma hasIdentity : HasIdentity seqSemigroup.
   Proof. exists nil; intros x; simpl. rewrite <- app_nil_end; auto. Defined.
   
   Lemma cons_noteq : forall y a, negb (@equal seqSemigroup (a :: y) y).
   Proof. induction y. intros a; auto.
         intros b; simpl.
         destruct (b != a); auto.
         assert (p := IHy a); simpl in p. auto.
   Qed.
   
   Lemma eq_length : forall x y : seqSemigroup, x == y -> length x = length y.
   Proof. induction x.
      intros [|y ys] p; auto. discriminate p.
      intros [|y ys] p; dseq_u; simpl in *. discriminate p.
      destruct (a != y). discriminate p.
      rewrite (IHx ys); auto.
   Defined.
   
   Lemma hasAnnihilator_comp : HasAnnihilator_comp seqSemigroup.
   Proof. intros x. exists (choose A :: nil); apply or_intror. simpl.
      assert (p := cons_noteq x); simpl in p; auto.
   Defined.
   
   Lemma isLeft_comp : IsLeft_comp seqSemigroup.
   Proof. exists nil; exists (choose A :: nil); auto. Defined.
   
   Lemma isRight_comp : IsRight_comp seqSemigroup.
   Proof. exists (choose A :: nil); exists nil; auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp seqSemigroup.
   Proof. exists (choose A :: nil); exists (choose A :: nil); exists nil; simpl.
      rewrite refl; simpl. auto.
   Defined.

   Lemma rightCondensed_comp : RightCondensed_comp seqSemigroup.
   Proof. exists (choose A :: nil); exists (choose A :: nil); exists nil; simpl.
      rewrite refl; simpl. auto.
   Defined.
   
   Lemma leftCancelative : LeftCancelative seqSemigroup.
   Proof. intros x y z. simpl in *. induction z. auto.
      dseq_u; simpl in *; rewrite refl; simpl; auto.
   Defined.
   
   Lemma rightCancelative : RightCancelative seqSemigroup.
   Proof. intros x y z; generalize y; clear y.
      induction x.
      intros [|y ys]; auto.
      simpl. intros h; assert (q := eq_length _ _ h).
      simpl in q. rewrite app_length in q.
      assert (length ys + length z < length z).
      unfold lt. rewrite <- q. auto.
      elim (Lt.lt_not_le _ _ H).
      apply Plus.le_plus_r.
      
      intros [|y ys]. simpl. intros h.
      assert (q := eq_length _ _ h).
      simpl in q. rewrite app_length in q.
      assert (length x + length z < length z).
      unfold lt. rewrite q. auto.
      elim (Lt.lt_not_le _ _ H).
      apply Plus.le_plus_r.
      
      dseq_u; simpl in *; auto.
      destruct (a != y); auto.
   Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp seqSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma antiRight_comp : AntiRight_comp seqSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   (* Always irrelevant *)
   Lemma treeGlb : TreeGlb seqSemigroup.
   Proof. intros _ idem. destruct isIdempotent_comp as [x px].
      assert (h := idem x). rewrite h in px; discriminate px.
   Qed.
End Seq.