(*
 * Skip: true
 *)
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Product.

(*********************************************************************)
(* cartesian product of decidable semigroups *)

Section SemiDirect.

   Open Scope Semigroup_scope.

   Variable A B : Semigroup.
   Variable f : B -> (A -> A).
   Variable composition : forall a b1 b2, f (b1 + b2) a == f b1 (f b2 a).
   Variable distribution : forall a1 a2 b, f b (a1 + a2) == f b a1 + f b a2.
   Variable eq_pres : forall a1 a2 b1 b2, (a1 == a2) -> (b1 == b2) -> f b1 a1 == f b2 a2.

   Definition semi_direct_op (x y : A * B ) :=
      match x, y with
         | (x1, x2), (y1, y2) => (x1 + f(x2)(y1), x2 + y2)
      end.

   Lemma semi_direct_assoc : @Associative (prodDecSetoid A B) semi_direct_op.
   Proof.
      red.
      intros [x1 x2] [y1 y2] [z1 z2].
      unfold semi_direct_op.
      unfold dseq. 
      simpl.
      toProp.
      apply conj.
      dseq_f.
      rewrite composition.
      rewrite distribution.
      apply (assoc A).
      dseq_f.
      apply (assoc B).
   Defined.

   Lemma semi_direct_pres_eq : @Preserves (prodDecSetoid A B) semi_direct_op.
   Proof.
      red.
      intros [x1 x2] [y1 y2] [u1 u2] [v1 v2].
      simpl.
      unfold dseq.
      simpl.
      toProp.
      intros [H1 H2] [Q1 Q2].
      apply conj; dseq_f.
      rewrite (eq_pres y1 v1 x2 u2); trivial.
      rewrite H1.
      setoid_reflexivity.
      rewrite H2,Q2.
      setoid_reflexivity.
   Defined.

   Definition semi_directSemigroup : Semigroup :=
      Build_Semigroup
            semi_direct_assoc    (* assoc *)
            semi_direct_pres_eq. (* op_pres_eq *)

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Definition functional_idempotence (g : B -> (A -> A)) := 
       forall a b, a + g b a == a. 

   Definition functional_idempotence_comp (g : B -> (A -> A)) := 
       Exists a b, a + g b a != a. 

   Lemma isIdempotent : (functional_idempotence f) * (IsIdempotent B) -> IsIdempotent semi_directSemigroup.
   Proof.
     intros [H1 H2]. 
     intros [x1 x2].
     unfold dseq.
     simpl.
     toProp.
     dseq_f.
     apply conj.
     apply H1.
     apply H2.
   Defined.


   Lemma isIdempotent_comp : (functional_idempotence_comp f + IsIdempotent_comp B) -> IsIdempotent_comp semi_directSemigroup.
   Proof.
      intros [H3 | H3].
      unfold IsIdempotent_comp.
      destruct H3 as [x [y P]].      
      exists (x, y).
      simpl.
      negb_p.
      rewrite P.
      trivial.
      unfold IsIdempotent_comp.
      destruct H3 as [x P].
      exists (choose A, x).
      simpl.
      negb_p.
      rewrite P.
      rewrite orb_true_r.
      trivial.
   Defined.


   Definition functional_commutativity (g : B -> (A -> A)) := 
       forall a b c d, a + g(b)(c) == c + g(d)(a).

   Definition functional_commutativity_comp (g : B -> (A -> A)) := 
       Exists a c, Exists b d, a + g(b)(c) != c + g(d)(a).


   Lemma isCommutative : 
      (functional_commutativity f * IsCommutative B) -> IsCommutative semi_directSemigroup.
   Proof. 
      intros [cA cB] [x1 x2] [y1 y2].
      unfold dseq. 
      simpl.
      toProp.
      dseq_f.
      split.
      apply cA.
      apply cB.
   Defined.

   Lemma isCommutative_comp : 
      (functional_commutativity_comp f  + IsCommutative_comp B) -> IsCommutative_comp semi_directSemigroup.
   Proof.
      intros [H | H]. 
      destruct H as [a [c [b [d P]]]].      
      unfold IsCommutative_comp.
      exists (a, b). 
      exists (c, d).
      simpl.
      negb_p.
      rewrite P.
      simpl.
      trivial.
      destruct H as [x [y P]].
      unfold IsCommutative_comp.
      exists (choose A, x).
      exists (choose A, y).
      simpl.
      negb_p.
      rewrite P.
      rewrite orb_true_r.
      trivial.
   Defined.



   Lemma isLeft : IsLeft A * IsLeft B  -> IsLeft semi_directSemigroup.
   Proof. 
      intros [H1 H2].
      unfold IsLeft.
      intros (a1, a2) (b1, b2).
      simpl.
      unfold dseq.
      simpl.
      toProp.
      dseq_f.
      split.
      apply H1.
      apply H2.
   Defined.


   Definition functional_right (g : B -> (A -> A)) := 
       forall a b, g(b)(a) == a. 



   Lemma isRight : IsRight A * functional_right f * IsRight B  -> IsRight semi_directSemigroup.
   Proof.
      intros [[aR fR] bR].
      unfold IsRight.
      intros (a1, b1) (a2, b2).
      simpl.
      unfold dseq.
      simpl.
      toProp.
      dseq_f.
      split.
      assert (f b1 a2 == a2) as P.
      apply fR.
      rewrite P.
      apply aR.
      apply bR.
   Defined.

Print isRight.


(* 
identity ?  exists (x1, x2)

(x1, x2) * (y1, y2) => (x1 + f(x2)(y1), x2 + y2) = (y1, y2) 
(y1, y2) * (x1, x2) => (y1 + f(y2)(x1), y2 + x2) = (y1, y2) 

x2 is id for B and 

(I) exists e in A, forall a in A, forall b in B,
     e + f(b)(a) = a
          and 
     a + f(b)(e) = a


composition : forall a b1 b2, f (b1 + b2) a == f b1 (f b2 a).
distribution : forall a1 a2 b, f b (a1 + a2) == f b a1 + f b a2.

a1 + e           == 
e + f b (a1 + e) == e + f b a1 + f b e.
                 == e + f b a1 
                 == a1 

e + a1           == 
e + f b (e + a1) == e + f b e + f b a1.
                 == e + f b a1 
                 == a1 


so e must be identity for A, so we have

(I') forall a in A, forall b in B,
     f(b)(a) = a

*) 


   Lemma hasIdentity : 
         HasIdentity A * functional_right f * HasIdentity B  -> HasIdentity semi_directSemigroup.
   Proof.
      intros [[aI fR] bI].
      unfold HasIdentity.
      destruct aI as [a P].
      destruct bI as [b Q].
      exists (a, b).
      intros (xa, xb).
      simpl.
      split.
      unfold dseq.
      simpl.
      toProp.
      split.
      assert (f b xa == xa) as H.
      apply fR.
      rewrite H.
      dseq_f.
      elim P with xa.
      trivial.
      dseq_f.
      elim Q with xb.
      trivial.
      unfold dseq.
      simpl.
      toProp.
      split.
      assert (f xb a == a) as H.
      apply fR.
      rewrite H.
      dseq_f.
      elim P with xa.
      trivial.
      dseq_f.
      elim Q with xb.
      trivial.
   Defined.



(* 

   Lemma isSelective : IsSelective semi_directSemigroup.      
   Proof. 
    unfold IsSelective.
    intros (a1, b1) (a2, b2).
    simpl.
   Defined.


   Lemma isSelective :       
      (IsLeft A * IsLeft B) +
      (IsRight A * IsRight B) +
      (IsSelective A * IsSingleton B) \/
      (IsSelective B /\ IsSingleton A) -> IsSelective semi_directSemigroup.
   Proof. 
   Defined.

   Definition functional_right_comp (g : B -> (A -> A)) := 
       Exists a b, g(b)(a) != a. 

   Lemma hasIdentity_comp : 
         HasIdentity_comp A + functional_right_comp f + HasIdentity_comp B  -> HasIdentity_comp semi_directSemigroup.
   Proof.
        intros [[H | H] | H].
        unfold HasIdentity_comp.
        intros (a, b).
        elim H with a.
        intros P.
        WORK-IN-PROGRESs 
   Defined.



   Lemma isSelective :       
      (IsLeft A /\ IsLeft B) \/ 
      (IsRight A /\ IsRight B) \/ 
      (IsSelective A /\ IsSingleton B) \/
      (IsSelective B /\ IsSingleton A) -> IsSelective semi_directSemigroup.
   Proof. 
   Defined.
   
   Lemma isLeft_comp : IsLeft_comp A + IsLeft_comp B  -> IsLeft_comp semi_directSemigroup.
   Proof. intros [ H | H ]. 
          destruct H as [a [b P]].
          unfold IsLeft_comp.
          exists (a, choose B).
          exists (b, choose B).
          simpl.
          negb_p.
          rewrite P.

          WORK-IN-PROGRESS 
   Defined.


   Lemma isRight_comp : (IsRight_comp A /\ IsEmpty_comp B) \/ (IsRight_comp B /\ IsEmpty_comp A) -> IsRight_comp prodSemigroup.
   Proof.
   Defined.
   
ann 

exists (x1, x2)

(x1, x2), (y1, y2) => (x1 + f(x2)(y1), x2 + y2) = (x1, x2) 
(y1, y2), (x1, x2) => (y1 + f(y2)(x1), y2 + x2) = (x1, x2) 

x2 is ann for B 

x1 + f(x2)(y1) = x1
y1 + f(y2)(x1) = x1

composition : forall a b1 b2, f (b1 + b2) a == f b1 (f b2 a).
distribution : forall a1 a2 b, f b (a1 + a2) == f b a1 + f b a2.

Conj: this means that (1) x1 is ann for A and (2) f b x1 = x1 

*) 


   Close Scope Semigroup_scope.

End SemiDirect.
