Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.Semigroups.Unit.

Section Right.

   Variable A : DecSetoid.

   Definition right_op (x y : A) : A := y.

   Lemma right_op_assoc : Associative right_op.
   Proof. intros x y z; simpl; auto. Qed.
   
   Lemma right_op_pres_eq : Preserves right_op.
   Proof. intros x y u v p q. apply q. Qed.
   
   Definition rightSemigroup : Semigroup :=
      Build_Semigroup
         right_op_assoc (* assoc *)
         right_op_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)	
   
   Lemma isIdempotent : IsIdempotent rightSemigroup.
   Proof. intros x; auto. Defined.
   
   Lemma isSelective : IsSelective rightSemigroup.
   Proof. intros x y; auto. Defined.
   
   Lemma isCommutative : IsSingleton A -> IsCommutative rightSemigroup.
   Proof. intros sg; apply (Iso_IsCommutative (SmgIso_sym (unitSmgIso rightSemigroup sg))); apply Unit.isCommutative.
   Defined.
   
   Lemma isCommutative_comp : IsSingleton_comp A -> IsCommutative_comp rightSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb]; 
      exists (choose A); exists b; apply pb.
   Defined.
   
   Lemma hasIdentity : IsSingleton A -> HasIdentity rightSemigroup.
   Proof. intros [a sg]; exists a; intros x; simpl; unfold right_op.
      rewrite (sg x); auto.
   Defined.
   
   Lemma hasIdentity_comp : IsSingleton_comp A -> HasIdentity_comp rightSemigroup.
   Proof. 
      intros sg x; 
      destruct (sg x) as [b pb];
      exists b; 
      simpl. unfold right_op; 
      toProp; 
      apply or_intror; 
      intros h; 
      elim pb; 
      dseq_f; 
      rewrite h; 
      auto.
   Defined.
   
   Lemma hasAnnihilator : IsSingleton A -> HasAnnihilator rightSemigroup.
   Proof. intros [a sg]; exists a; intros x; simpl; unfold right_op.
      rewrite (sg x); auto.
   Defined.
   
   Lemma hasAnnihilator_comp : IsSingleton_comp A -> HasAnnihilator_comp rightSemigroup.
   Proof. intros sg x; destruct (sg x) as [b pb];
      exists b; simpl. unfold right_op; toProp; apply or_introl; intros h; elim pb; dseq_f; 
      rewrite h; auto.
   Defined.
   
   
   Lemma isLeft : IsSingleton A -> IsLeft rightSemigroup.
   Proof. intros [a sg] x y; simpl; unfold right_op; rewrite (sg x), (sg y); auto. Defined.
   
   Lemma isLeft_comp : IsSingleton_comp A -> IsLeft_comp rightSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb]; 
      exists (choose A); exists b; simpl; unfold right_op; auto.
   Defined.

   Lemma isRight : IsRight rightSemigroup.
   Proof. intros x y; auto. Defined.

   Lemma leftCondensed : IsSingleton A -> LeftCondensed rightSemigroup.
   Proof. intros [a sg] x y z; simpl; unfold right_op; rewrite (sg y), (sg z); auto. Defined.
   
   Lemma leftCondensed_comp : IsSingleton_comp A -> LeftCondensed_comp rightSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb];
      exists b; exists b; exists (choose A); simpl; unfold right_op; auto.
   Defined.

   Lemma rightCondensed : RightCondensed rightSemigroup.
   Proof. intros x y z; auto. Defined.

   Lemma leftCancelative : LeftCancelative rightSemigroup.
   Proof. intros x y z h. apply h. Defined.
     
   Lemma rightCancelative : IsSingleton A -> RightCancelative rightSemigroup.
   Proof. intros [a sg] x y z _; simpl. rewrite (sg x), (sg y); auto. Defined.
   
   Lemma rightCancelative_comp : IsSingleton_comp A -> RightCancelative_comp rightSemigroup.
   Proof. intros sg; destruct (sg (choose A)) as [b pb];
      exists b; exists (choose A); exists b; simpl; unfold right_op; auto.
   Defined.
   
   Lemma antiRight_comp : AntiRight_comp rightSemigroup.
   Proof. exists (choose A); exists (choose A); auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp rightSemigroup.
   Proof. exists (choose A); exists (choose A); auto. Defined.
   
   Lemma treeGlb : TreeGlb rightSemigroup.
   Proof. intros comm idem x y z; simpl. unfold right_op; simpl. auto. Qed.

End Right.