Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.

Section RevOp.

   Variable A : Semigroup.

   Definition rev_op (x y : A) : A := y + x.
   
   Lemma rev_op_assoc : Associative rev_op.
   Proof. intros x y z. unfold rev_op. rewrite (assoc A z y x); auto. Qed.
   
   Lemma rev_op_pres_eq : Preserves rev_op.
   Proof. intros x y u v p q. unfold rev_op; rewrite p, q; auto. Qed.
   
   Definition revOpSemigroup :=
      Build_Semigroup
         rev_op_assoc
         rev_op_pres_eq.
   
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)	
   
   Lemma isIdempotent : IsIdempotent A -> IsIdempotent revOpSemigroup.
   Proof. intros idem x; simpl; unfold rev_op. simpl; auto. Qed.
   
   Lemma isIdempotent_comp : IsIdempotent_comp A -> IsIdempotent_comp revOpSemigroup.
   Proof. intros [x idem]; exists x; simpl. auto. Defined.
   
   Lemma isSelective : IsSelective A -> IsSelective revOpSemigroup.
   Proof. intros sel x y; simpl; unfold rev_op. destruct (sel y x); auto. Qed.
   
   Lemma isSelective_comp : IsSelective_comp A -> IsSelective_comp revOpSemigroup.
   Proof. intros [x [y sel]].
      exists y; exists x. simpl. unfold rev_op; simpl.
      tauto.
   Defined.
   
   Lemma isCommutative : IsCommutative A -> IsCommutative revOpSemigroup.
   Proof. intros comm x y; simpl; unfold rev_op; simpl. auto. Qed.
   
   Lemma isCommutative_comp : IsCommutative_comp A -> IsCommutative_comp revOpSemigroup.
   Proof. intros [x [y comm]]; exists x; exists y; simpl; unfold rev_op; simpl.
      toProp; intros h; apply comm; dseq_f; rewrite h; auto.
   Defined.
   
   Lemma hasIdentity : HasIdentity A -> HasIdentity revOpSemigroup.
   Proof. intros [id hid]. exists id; intros x; assert (h := hid x); simpl; unfold rev_op. tauto. Qed.
   
   Lemma hasIdentity_comp : HasIdentity_comp A -> HasIdentity_comp revOpSemigroup.
   Proof. intros hid x; assert (h := hid x); simpl; unfold rev_op; simpl.
      destruct h as [y p]; exists y. tauto.
   Defined.
   
   Lemma hasAnnihilator : HasAnnihilator A -> HasAnnihilator revOpSemigroup.
   Proof. intros [id hid]. exists id; intros x; assert (h := hid x); simpl; unfold rev_op. tauto. Qed.
   
   Lemma hasAnnihilator_comp : HasAnnihilator_comp A -> HasAnnihilator_comp revOpSemigroup.
   Proof. intros hid x; assert (h := hid x); simpl; unfold rev_op; simpl.
      destruct h as [y p]; exists y. tauto.
   Defined.
   
   Lemma isLeft : IsRight A -> IsLeft revOpSemigroup.
   Proof. intros ra x y; simpl; unfold rev_op; auto. Qed.
   
   Lemma isLeft_comp : IsRight_comp A -> IsLeft_comp revOpSemigroup.
   Proof. intros [x [y ra]]; exists y; exists x; simpl; unfold rev_op; auto. Defined.
   
   Lemma isRight : IsLeft A -> IsRight revOpSemigroup.
   Proof. intros ra x y; simpl; unfold rev_op; auto. Qed.
   
   Lemma isRight_comp : IsLeft_comp A -> IsRight_comp revOpSemigroup.
   Proof. intros [x [y ra]]; exists y; exists x; simpl; unfold rev_op; auto. Defined.
   
   Lemma leftCondensed : RightCondensed A -> LeftCondensed revOpSemigroup.
   Proof. intros rc x y z; simpl; unfold rev_op; simpl. auto. Qed.
   
   Lemma leftCondensed_comp : RightCondensed_comp A -> LeftCondensed_comp revOpSemigroup.
   Proof. intros [x [y [z rc]]]; exists x; exists y; exists z; simpl; unfold rev_op; simpl. auto. Defined.
   
   Lemma rightCondensed : LeftCondensed A -> RightCondensed revOpSemigroup.
   Proof. intros rc x y z; simpl; unfold rev_op; simpl. auto. Qed.
   
   Lemma rightCondensed_comp : LeftCondensed_comp A -> RightCondensed_comp revOpSemigroup.
   Proof. intros [x [y [z rc]]]; exists x; exists y; exists z; simpl; unfold rev_op; simpl. auto. Defined.
   
   Lemma leftCancelative : RightCancelative A -> LeftCancelative revOpSemigroup.
   Proof. intros rc x y z; simpl; unfold rev_op; simpl; auto. apply rc. Qed.
   
   Lemma leftCancelative_comp : RightCancelative_comp A -> LeftCancelative_comp revOpSemigroup.
   Proof. intros [x [y [z rc]]]. exists x; exists y; exists z; simpl; unfold rev_op; simpl. auto. Defined.
   
   Lemma rightCancelative : LeftCancelative A -> RightCancelative revOpSemigroup.
   Proof. intros rc x y z; simpl; unfold rev_op; simpl; auto. apply rc. Qed.
   
   Lemma rightCancelative_comp : LeftCancelative_comp A -> RightCancelative_comp revOpSemigroup.
   Proof. intros [x [y [z rc]]]. exists x; exists y; exists z; simpl; unfold rev_op; simpl. auto. Defined.
   
   Lemma antiLeft : AntiRight A -> AntiLeft revOpSemigroup.
   Proof. intros ar x y; simpl; unfold rev_op; auto. Qed.

   Lemma antiLeft_comp : AntiRight_comp A -> AntiLeft_comp revOpSemigroup.
   Proof. intros [x [y ar]]; exists y; exists x; simpl; unfold rev_op; simpl; auto. Qed.
   
   Lemma antiRight : AntiLeft A -> AntiRight revOpSemigroup.
   Proof. intros ar x y; simpl; unfold rev_op; auto. Qed.

   Lemma antiRight_comp : AntiLeft_comp A -> AntiRight_comp revOpSemigroup.
   Proof. intros [x [y ar]]; exists y; exists x; simpl; unfold rev_op; simpl; auto. Qed.
   
   Lemma comm_back : IsCommutative revOpSemigroup -> IsCommutative A.
   Proof. intros comm x y. assert (h := comm y x); auto. Qed.
   
   Lemma idem_back : IsIdempotent revOpSemigroup -> IsIdempotent A.
   Proof. intros idem x; apply (idem x). Qed.
   
   Lemma treeGlb : TreeGlb A -> TreeGlb revOpSemigroup.
   Proof. intros tg comm idem x y z. simpl; unfold rev_op.
      assert (h := tg (comm_back comm) (idem_back idem) x y z).
      repeat rewrite (comm_back comm z).
      rewrite (comm_back comm y x).
      auto.
   Qed.
   
   Lemma treeGlb_comp : TreeGlb_comp A -> TreeGlb_comp revOpSemigroup.
   Proof. intros tg comm idem.
      destruct (tg (comm_back comm) (idem_back idem)) as [x [y [z p]]].
      exists y; exists x; exists z.
      simpl; unfold rev_op.
      toProp; dseq_f.
      repeat rewrite (comm_back comm z).
      tauto.
   Qed.

End RevOp.
