Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Coq.Bool.Bool.
Require Import Coq.Arith.Plus.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Coq.Arith.Lt.
Require Import Coq.Arith.Compare_dec.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Semigroups.BoolOr.

Section RangePlus.

   Variable n : nat.

   Lemma range_plus_assoc : @Associative (rangeDecSetoid n) plus.
   Proof. intros x y z; rewrite plus_assoc; auto. Defined.
  
   Lemma range_plus_pres_eq : @Preserves (rangeDecSetoid n) plus.
   Proof. intros x y u v p q.
      copy_destruct (leb n x); copy_destruct (leb n y); dseq_u; simpl in *.
      rewrite eq_range_over_l; rewrite eq_range_over_l in p;
      [ apply leb_correct; apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto
      | apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto ].
      rewrite eq_range_over_l; rewrite eq_range_over_l in p;
      [ apply leb_correct; apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto
      | apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto ].
      rewrite eq_range_over_l; rewrite eq_range_over_l in q;
      [ apply leb_correct; rewrite plus_comm; apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto
      | rewrite plus_comm; apply le_plus_trans; apply leb_complete; auto
      | apply leb_complete; auto ].
      rewrite eq_range_l in p, q;
      [ rewrite p, q; apply eq_range_refl
      | apply leb_complete_conv; auto
      | apply leb_complete_conv; auto ].
   Defined.
   
   Definition rangePlusSemigroup : Semigroup :=
      Build_Semigroup
         range_plus_assoc (* assoc *)
         range_plus_pres_eq (* op_pres_eq *).

End RangePlus.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   (* NOTE:
    * Only prove properties for n >= 2, since n = 0 gives unit semigroup
    * and n = 1 gives bool semigroup with disjunction
    *)

   Lemma rplus0SmgIso_isIso : IsSmgIso (rangePlusSemigroup 0) unitSemigroup range0DsIso.
   Proof. split.
      intros x y; auto.
      intros [] []; auto.
   Qed.

   Definition rplus0SmgIso : SmgIso (rangePlusSemigroup 0) unitSemigroup := 
      Build_SmgIso rplus0SmgIso_isIso.
   
   Lemma rplus1SmgIso_isIso : IsSmgIso (rangePlusSemigroup 1) boolOrSemigroup range1DsIso.
   Proof. split.
      intros [|x] [|y]; dseq_u; simpl; auto.
      intros [|] [|]; dseq_u; simpl; auto.
   Qed.
   
   Definition rplus1SmgIso : SmgIso (rangePlusSemigroup 1) boolOrSemigroup :=
      Build_SmgIso rplus1SmgIso_isIso.

   Lemma isIdempotent_comp : forall n, IsIdempotent_comp (rangePlusSemigroup (S (S n))).
   Proof. intros n; exists 1; compute; fold leb; destruct (leb n 0); auto. Defined.

   Lemma isSelective_comp : forall n, IsSelective_comp (rangePlusSemigroup (S (S n))).
   Proof. intros n; exists 1; exists 1; split; simpl; unfold eq_range; simpl; destruct (leb n 0); auto. Defined.

   Lemma isCommutative : forall n, IsCommutative (rangePlusSemigroup n).
   Proof. intros n x y; simpl; rewrite plus_comm; auto. Defined.

   Lemma hasIdentity : forall n, HasIdentity (rangePlusSemigroup n).
   Proof. intros n; exists 0; intros x; split; [| rewrite plus_comm]; auto. Defined.

   Lemma hasAnnihilator : forall n, HasAnnihilator (rangePlusSemigroup n).
   Proof. intros n; exists n; intros x; split; dseq_u; simpl; rewrite eq_range_over_l;
      [ apply leb_correct; auto
      | apply le_plus_trans; auto
      | apply leb_correct; auto
      | rewrite plus_comm; apply le_plus_trans; auto].
   Defined.

   Lemma isLeft_comp : forall n, IsLeft_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; compute; fold leb; destruct (leb n 0); auto. Defined.

   Lemma isRight_comp : forall n, IsRight_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 1; exists 0; compute; fold leb; destruct (leb n 0); auto. Defined.

   Lemma leftCondensed_comp : forall n, LeftCondensed_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 0; exists 0; exists 1; auto. Defined.

   Lemma rightCondensed_comp : forall n, RightCondensed_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 0; exists 0; exists 1; auto. Defined.
   
   Lemma leftCancelative_comp : forall n, LeftCancelative_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; exists (S n); auto. intuition. dseq_u; simpl.
      rewrite eq_range_over_l; simpl. rewrite plus_comm. apply leb_correct; apply le_n_Sn.
      rewrite plus_comm; auto.
   Defined.

   Lemma rightCancelative_comp : forall n, RightCancelative_comp (rangePlusSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; exists (S n); auto. intuition. dseq_u; simpl.
      rewrite eq_range_over_l; simpl. apply leb_correct; apply le_n_Sn.
      auto.
   Defined.

   Lemma antiLeft_comp : forall n, AntiLeft_comp (rangePlusSemigroup n).
   Proof. intros n; exists 0; exists 0; auto. Defined.

   Lemma antiRight_comp : forall n, AntiRight_comp (rangePlusSemigroup n).
   Proof. intros n; exists 0; exists 0; auto. Defined.
   
   Lemma treeGlb_comp : forall n, TreeGlb_comp (rangePlusSemigroup (S (S n))).
   Proof. intros [|n] _ _; exists 1; exists 1; exists 0; simpl; auto. Defined.
