Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Coq.Bool.Bool.
Require Import Coq.Arith.Plus.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Coq.Arith.Lt.
Require Import Coq.Arith.Compare_dec.
Require Import Coq.Arith.Min.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Semigroups.BoolAnd.

Section RangeMin.

   Variable n : nat.

   Lemma leb_min : forall x y, leb n (min x y) = leb n x && leb n y.
   Proof. intros x y. destruct (le_ge_dec x y).
      rewrite min_l; [|auto]; copy_destruct (leb n x); rewrite ew; [|auto]; simpl; apply sym_equal;
      apply leb_correct; apply (le_trans n x y); [apply leb_complete|]; auto.
      rewrite min_r; [|auto]; copy_destruct (leb n y); rewrite ew; [rewrite andb_true_r |rewrite andb_false_r; auto]; simpl;
      apply sym_equal; apply leb_correct; apply (le_trans n y x); [apply leb_complete|]; auto.
   Defined.

   Lemma range_min_assoc : @Associative (rangeDecSetoid n) min.
   Proof. intros x y z; hnf; rewrite min_assoc; dseq_f; auto. Defined.

   Lemma range_min_pres_eq : @Preserves (rangeDecSetoid n) min.
   Proof. red. intros x y u v h h'. dseq_u; simpl in *. unfold eq_range in *.
      rewrite leb_min, leb_min;
      copy_destruct (leb n x); copy_destruct (leb n y);
      copy_destruct (leb n v); copy_destruct (leb n u);
      rewrite ?ew, ?ew0, ?ew1, ?ew2 in *; simpl; 
      rewrite ?beq_nat_eq in *; auto.
      rewrite h in ew; rewrite ew in ew2; discriminate ew2.
      rewrite h' in ew0; rewrite ew0 in ew1; discriminate ew1.
      rewrite h' in ew0; rewrite ew0 in ew1; discriminate ew1.
      rewrite h'; rewrite min_r, min_r; auto;
      (apply (le_trans _ n);
      [ apply lt_le_weak; apply leb_complete_conv; auto
      | apply leb_complete; auto ]).
      rewrite h in ew; rewrite ew in ew2; discriminate ew2.
      rewrite h; rewrite min_l, min_l; auto;
      (apply (le_trans _ n);
      [ apply lt_le_weak; apply leb_complete_conv; auto
      | apply leb_complete; auto ]).
   Defined.


   Definition rangeMinSemigroup : Semigroup :=
      Build_Semigroup
         range_min_assoc (* assoc *)
         range_min_pres_eq (* op_pres_eq *).

End RangeMin.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma rmin0SmgIso_isIso : IsSmgIso (rangeMinSemigroup 0) unitSemigroup range0DsIso.
   Proof. split.
      intros x y; auto.
      intros [] []; auto.
   Qed.

   Definition rmin0SmgIso : SmgIso (rangeMinSemigroup 0) unitSemigroup :=
      Build_SmgIso rmin0SmgIso_isIso.
   
   Lemma rmin1SmgIso_isIso : IsSmgIso (rangeMinSemigroup 1) boolAndSemigroup range1DsIso.
   Proof. split.
      intros [|x] [|y]; dseq_u; simpl; auto.
      intros [|] [|]; dseq_u; simpl; auto.
   Qed.
   
   Definition rmin1SmgIso : SmgIso (rangeMinSemigroup 1) boolAndSemigroup :=
      Build_SmgIso rmin1SmgIso_isIso.

   (* move to logic.v *)
   Lemma min_idemp : forall x, min x x = x.
   Proof. induction x. trivial.
      simpl; rewrite IHx; trivial.
   Defined.

   Lemma isIdempotent : forall n, IsIdempotent (rangeMinSemigroup n).
   Proof. intros n x. simpl. rewrite min_idemp; auto. Defined.
   
   Lemma isSelective : forall n, IsSelective (rangeMinSemigroup n).
   Proof. intros n x y; simpl; destruct (min_dec x y) as [h|h]; rewrite h; auto. Defined.
   
   Lemma isCommutative : forall n, IsCommutative (rangeMinSemigroup n).
   Proof. intros n x y; simpl; rewrite min_comm; auto. Defined.
   
   Lemma hasIdentity : forall n, HasIdentity (rangeMinSemigroup n).
   Proof. intros n; exists n; intros x; split; simpl; dseq_u; simpl; unfold eq_range;
      rewrite leb_min; rewrite (leb_correct _ _ (le_refl n)), ?andb_true_r; simpl;
      (copy_destruct (leb n x); rewrite ew; [ auto | ]); rewrite beq_nat_eq.
      rewrite min_r; [ auto | apply lt_le_weak; apply leb_complete_conv; auto ].
      rewrite min_l; [ auto | apply lt_le_weak; apply leb_complete_conv; auto ].
   Defined.

   Lemma hasAnnihilator : forall n, HasAnnihilator (rangeMinSemigroup n).
   Proof. intros n; red; exists 0; intros x; split; [|simpl; rewrite min_comm];
      compute; fold leb; destruct (leb n 0); trivial.
   Defined.
   
   Lemma isLeft_comp : forall n, IsLeft_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 1; exists 0; auto. Defined.
   
   Lemma isRight_comp : forall n, IsRight_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; auto. Defined.
   
   Lemma leftCondensed_comp : forall n, LeftCondensed_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 1; exists 1; exists 0; dseq_u; simpl; unfold eq_range; simpl; destruct (leb n 0); auto. Defined.

   Lemma rightCondensed_comp : forall n, RightCondensed_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 1; exists 1; exists 0; dseq_u; simpl; unfold eq_range; simpl; destruct (leb n 0); auto. Defined.
   
   Lemma leftCancelative_comp : forall n, LeftCancelative_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; exists 0; auto. Defined.

   Lemma rightCancelative_comp : forall n, RightCancelative_comp (rangeMinSemigroup (S n)).
   Proof. intros n; exists 0; exists 1; exists 0; auto. Defined.
   
   Lemma antiLeft_comp : forall n, AntiLeft_comp (rangeMinSemigroup n).
   Proof. intros n; exists 0; exists 0; auto. Defined.

   Lemma antiRight_comp : forall n, AntiRight_comp (rangeMinSemigroup n).
   Proof. intros n; exists 0; exists 0; auto. Defined.
   
   Lemma treeGlb : forall n, TreeGlb (rangeMinSemigroup n).
   Proof. intros n _ _ x y z. simpl.
      destruct (min_dec x y) as [e|e]; rewrite e; auto.
   Qed.