(*
 * Isomorphic: RangeMin
 * Ignore: true
 *)

Require Import Coq.Bool.Bool.
Require Import Coq.Arith.Plus.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Coq.Arith.Lt.
Require Import Coq.Arith.Compare_dec.
Require Import Coq.Arith.Min.
Require Import Coq.Arith.Max.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Semigroups.BoolOr.
Require Import Metarouting.Constructions.Semigroups.RangeMin.

Section RangeMax.

   Variable n : nat.

   Lemma leb_max : forall x y, leb n (max x y) = leb n x || leb n y.
   Proof. intros x y. destruct (le_ge_dec x y).
      rewrite max_r; [|auto]; copy_destruct (leb n x); rewrite ew; [|auto]; simpl;
      apply leb_correct; apply (le_trans n x y); [apply leb_complete|]; auto.
      rewrite max_l; [|auto]; copy_destruct (leb n y); rewrite ew; [rewrite orb_true_r |rewrite orb_false_r; auto]; simpl;
      apply leb_correct; apply (le_trans n y x); [apply leb_complete|]; auto.
   Defined.

   Lemma range_max_assoc : @Associative (rangeDecSetoid n) max.
   Proof. intros x y z; hnf; rewrite max_assoc; dseq_f; auto. Defined.

   Lemma range_max_pres_eq : @Preserves (rangeDecSetoid n) max.
   Proof. red. intros x y u v h h'. dseq_u; simpl in *. unfold eq_range in *.
      rewrite leb_max, leb_max;
      copy_destruct (leb n x); copy_destruct (leb n y);
      copy_destruct (leb n v); copy_destruct (leb n u);
      rewrite ?ew, ?ew0, ?ew1, ?ew2 in *; simpl; 
      rewrite ?beq_nat_eq in *; auto.
   Defined.

   Definition rangeMaxSemigroup : Semigroup :=
      Build_Semigroup
         range_max_assoc (* assoc *)
         range_max_pres_eq (* op_pres_eq *).

End RangeMax.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma rmaxSmgIso_isIso : forall n, IsSmgIso (rangeMaxSemigroup n) (rangeMinSemigroup n) (reverseRangeDsIso n).
   Proof. intros n; split.

      intros x y; simpl;
      (destruct (le_lt_dec n x) as [p|p]; [rewrite (le_minus_O _ _ p)|]);
      (destruct (le_lt_dec n y) as [q|q]; [rewrite (le_minus_O _ _ q)|]);
      [ rewrite le_minus_O; auto; apply leb_complete; rewrite leb_max, (leb_correct _ _ p); auto
      | rewrite le_minus_O; auto; apply leb_complete; rewrite leb_max, (leb_correct _ _ p); auto
      | rewrite min_comm, le_minus_O; auto; apply leb_complete; rewrite leb_max, (leb_correct _ _ q), orb_comm; auto
      | destruct (le_ge_dec x y) as [h|h];
        [ rewrite (max_r _ _ h), min_r; auto; apply minus_le_compat_l; auto
        | rewrite (max_l _ _ h), min_l; auto; apply minus_le_compat_l; auto ]
      ].

      intros x y; simpl;
      (destruct (le_lt_dec n x) as [p|p]; [rewrite (le_minus_O _ _ p)|]);
      (destruct (le_lt_dec n y) as [q|q]; [rewrite (le_minus_O _ _ q)|]);
      [ rewrite le_minus_O; auto; apply leb_complete; rewrite leb_min, (leb_correct _ _ p), (leb_correct _ _ q); auto
      | rewrite min_r; auto; apply lt_le_weak; apply (lt_le_trans _ n); auto
      | rewrite min_l, max_comm; auto; apply lt_le_weak; apply (lt_le_trans _ n); auto
      | destruct (le_ge_dec x y) as [h|h];
        [ rewrite (min_l _ _ h), max_l; auto; apply minus_le_compat_l; auto
        | rewrite (min_r _ _ h), max_r; auto; apply minus_le_compat_l; auto]
      ].
   Qed.

   Definition rmaxSmgIso n : SmgIso (rangeMaxSemigroup n) (rangeMinSemigroup n) :=
      Build_SmgIso (rmaxSmgIso_isIso n).