Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Coq.Lists.List.
Require Import Coq.Arith.Min.

Section Prefix.

   Open Scope Semigroup_scope.

   Variable A : DecSetoid.
   
   Fixpoint prefix (x y : seqDecSetoid A) : seqDecSetoid A :=
      match x, y with
      | nil, _ => nil
      | _, nil => nil
      | a :: x', b :: y' => if (a == b)%bool then a :: (prefix x' y') else nil
      end.
   
   Lemma prefix_assoc : Associative prefix.
   Proof. intros x. induction x.
      trivial.
      induction y. trivial.
      intros [|b z]; simpl. destruct ((a == a0)%bool); simpl; trivial.
      copy_destruct ((a == a0)%bool); rewrite ew; simpl.
      dseq_f. copy_destruct ((a == b)%bool); rewrite ew0; simpl.
      assert ((a0 == b)%bool) as q1; [dseq_f; rewrite <- ew; auto|rewrite q1; simpl; rewrite ew; simpl].
      dseq_u; simpl. rewrite refl; simpl. apply IHx.
      assert ((a0 == b)%bool = false) as q1; [|rewrite q1; simpl; auto].
         bool_p; intros h; apply ew0; dseq_f; rewrite <-h; auto.
      copy_destruct ((a0 == b)%bool); rewrite ew0; simpl; auto.
      rewrite ew; simpl. auto.
   Qed.
   
   Lemma prefix_pres_eq : Preserves prefix.
   Proof. intros x; induction x.
      intros y [|a u] v p q; auto. dseq_u; simpl in p. discriminate p.
      intros [|b y] u v p q; auto.
      destruct v as [|c v]; auto. destruct u; auto. dseq_u; discriminate q.
      destruct v as [|c v]; [dseq_u; simpl in q; discriminate q|].
      destruct u as [|d u]; [dseq_u; simpl in p; discriminate p|].
      dseq_u; simpl in *. 
      copy_destruct ((a == d)%bool); rewrite ew in p; simpl in p; [| discriminate p].
      copy_destruct ((b == c)%bool); rewrite ew0 in q; simpl in q; [| discriminate q].
      dseq_f.
      assert ((a == b)%bool = (d == c)%bool) as q1; [|rewrite q1; destruct ((d == c)%bool); simpl; auto].
         rewrite bool_eq; split; dseq_f; rewrite ew, ew0; auto.
      rewrite ew; simpl; auto.
   Qed.
   
   Lemma prefix_nil : forall x, prefix x nil = nil.
   Proof. intros x; destruct x; auto. Qed.

   Lemma sing_length : IsSingleton A -> 
      forall x y : (seqDecSetoid A), (x == y) <-> length x = length y.
   Proof. intros [i sg] x; induction x.
      intros [|a y]; simpl. split; auto.
      split; intros h; discriminate h.
      intros [|b y]; simpl.
      split; intros h; discriminate h.
      unfold dseq; simpl.
      assert ((a == b)%bool = true) as q1; [dseq_f; rewrite (sg a), (sg b); auto| rewrite q1; simpl].
      split; intros h.
      destruct (IHx y) as [h1 h2]. rewrite h1; auto.
      injection h; intros w.
      destruct (IHx y) as [h1 h2]. apply h2; auto.
   Qed.
   
   Lemma sing_length_prefix : IsSingleton A ->
      forall x y : (seqDecSetoid A), length (prefix x y) = min (length x) (length y).
   Proof. intros [i sg] x; induction x; intros y.
      trivial. destruct y as [|b y]; simpl; trivial.
      assert ((a == b)%bool = true) as q.
         dseq_f. rewrite (sg a), (sg b); auto.
      rewrite q; simpl.
      rewrite IHx; auto.
   Qed.
      
   Definition prefixSemigroup : Semigroup :=
      Build_Semigroup
         prefix_assoc (* assoc *)
         prefix_pres_eq (* op_pres_eq *).
         
   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isIdempotent : IsIdempotent prefixSemigroup.
   Proof. intros x; induction x; auto.
      simpl. rewrite refl; simpl. dseq_u; simpl in *. rewrite refl; simpl.
      trivial.
   Qed.

   Lemma isSelective : IsSingleton A -> IsSelective prefixSemigroup.
   Proof. intros sg x y. simpl.
      repeat rewrite (sing_length sg).
      repeat rewrite (sing_length_prefix sg).
      destruct (min_dec (length x) (length y)); auto.
   Qed.
   
   Lemma isSelective_comp : IsSingleton_comp A -> IsSelective_comp prefixSemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); simpl.
      assert ((a == b)%bool = false) as q1; [|rewrite q1; simpl; auto].
      bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
   Defined.
   
   Lemma isCommutative : IsCommutative prefixSemigroup.
   Proof. intros x. induction x; intros y.
      destruct y; auto.
      destruct y; simpl. auto.
      assert ((a == c)%bool = (c == a)%bool) as q1; [|rewrite q1; simpl; auto].
         rewrite bool_eq; dseq_f; split; intros h; rewrite h; auto.
      copy_destruct ((c == a)%bool); rewrite ew; simpl; auto.
      dseq_u; simpl. rewrite q1, ew; simpl; apply IHx.
   Qed.
   
   Lemma hasIdentity_comp : HasIdentity_comp prefixSemigroup.
   Proof. intros x. set (a := choose A). exists (x ++ (a :: nil)).
      apply or_introl. toProp; intros h; simpl in h.
      induction x.
      simpl in h. discriminate h.
      simpl in h. rewrite refl in h. simpl in h. rewrite refl in h; simpl in h. auto.
   Qed.
   
   Lemma hasAnnihilator : HasAnnihilator prefixSemigroup.
   Proof. exists nil. intros x; destruct x; auto. Defined.
   
   Lemma isLeft_comp : IsLeft_comp prefixSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists nil; simpl. auto. Defined.
   
   Lemma isRight_comp : IsRight_comp prefixSemigroup.
   Proof. set (a := choose A);  exists nil; exists (a :: nil); simpl. auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp prefixSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists nil; exists (a :: nil); simpl; auto.
      rewrite refl; simpl; auto.
   Defined.
   
   Lemma rightCondensed_comp : RightCondensed_comp prefixSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists nil; exists (a :: nil); simpl; auto.
      rewrite refl; simpl; auto.
   Defined.
   
   Lemma leftCancelative_comp : LeftCancelative_comp prefixSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; simpl; auto. Defined.
   
   Lemma rightCancelative_comp : RightCancelative_comp prefixSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; simpl; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp prefixSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma antiRight_comp : AntiRight_comp prefixSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma treeGlb : TreeGlb prefixSemigroup.
   Proof. intros _ _ x; induction x as [|a x].
      intros y z; auto.
      induction y as [|b y]. intros z; auto.
      intros [|c z]; simpl.
      destruct ((a == b)%bool); simpl; auto.
      copy_destruct ((a == b)%bool); rewrite ew; simpl.
      copy_destruct ((a == c)%bool); rewrite ew0; simpl; auto.
      assert ((b == c)%bool = true) as q1; [|rewrite q1; simpl].
         dseq_f; rewrite <- ew; auto.
      dseq_f. dseq_u; simpl. rewrite refl, ew; simpl. apply IHx.
      copy_destruct ((a == c)%bool); rewrite ew0; simpl; auto.
      assert ((b == c)%bool = false) as q1; [|rewrite q1; simpl; auto].
         bool_p; intros h; apply ew; dseq_f; rewrite ew0, h; auto.
   Qed.

End Prefix.