Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Coq.Arith.Plus.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Metarouting.Constructions.DecSetoids.Nat.

(*********************************************************************)
(* decidable semigroups of natural numbers with plus function *)

Section NatPlus.
   Set Implicit Arguments.

   Lemma plus_assoc : @Associative natDecSetoid plus.
   Proof. intros x y z; rewrite plus_assoc; auto. Defined.

   Lemma plus_pres_eq : @Preserves natDecSetoid plus.
   Proof. intros x y u v p q; rewrite nat_eq in *; rewrite p, q; auto. Defined.

   Definition natPlusSemigroup : Semigroup :=
      Build_Semigroup
         plus_assoc (* assoc *)
         plus_pres_eq (* op_pres_eq *). 

   Lemma plus_cancel_l : forall x y z, (x + y)%nat = (x + z)%nat <-> y = z.
   Proof. intros x y z; induction x; simpl; intuition. Defined.

   Lemma plus_cancel_r : forall x y z, (x + z)%nat = (y + z)%nat <-> x = y.
   Proof. intros x y z. rewrite (plus_comm x), (plus_comm y); intuition. rewrite plus_cancel_l in H; auto. Defined.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma isIdempotent_comp : IsIdempotent_comp natPlusSemigroup.
   Proof. exists 1; compute; auto. Defined.

   Lemma isSelective_comp : IsSelective_comp natPlusSemigroup.
   Proof. exists 1; exists 1; compute; split; auto. Defined.

   Lemma isCommutative : IsCommutative natPlusSemigroup.
   Proof. intros x y; rewrite plus_comm; auto. Defined.

   Lemma hasIdentity : HasIdentity natPlusSemigroup.
   Proof. exists 0. intros x; simpl; rewrite plus_comm; auto. Defined.

   Lemma hasAnnihilator_comp : HasAnnihilator_comp natPlusSemigroup.
   Proof. intros x; exists 1; simpl; apply or_introl; toProp; rewrite beq_nat_eq;
      induction x; [discriminate | auto].
   Defined.

   Lemma isLeft_comp : IsLeft_comp natPlusSemigroup.
   Proof. exists 0; exists 1; compute; auto. Defined.

   Lemma isRight_comp : IsRight_comp natPlusSemigroup.
   Proof. exists 1; exists 0; compute; auto. Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp natPlusSemigroup.
   Proof. exists 1; exists 1; exists 0; compute; trivial. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp natPlusSemigroup.
   Proof. exists 1; exists 1; exists 0; compute; trivial. Defined.

   Lemma leftCancelative : LeftCancelative natPlusSemigroup.
   Proof. intros x y z. dseq_u; simpl. rewrite beq_nat_eq, beq_nat_eq, plus_cancel_l; auto. Defined.

   Lemma rightCancelative : RightCancelative natPlusSemigroup.
   Proof. intros x y z. dseq_u; simpl. rewrite beq_nat_eq, beq_nat_eq, plus_cancel_r; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp natPlusSemigroup.
   Proof. exists 0; exists 0; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp natPlusSemigroup.
   Proof. exists 0; exists 0; auto. Defined.
   
   Lemma treeGlb_comp : TreeGlb_comp natPlusSemigroup.
   Proof. intros _ _; exists 1; exists 1; exists 0; compute; auto. Defined.

End NatPlus.