Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Coq.Arith.Min.
Require Import Coq.Arith.EqNat.
Require Import Coq.Arith.Le.
Require Import Metarouting.Constructions.DecSetoids.Nat.

(*********************************************************************)
(* decidable semigroups of natural numbers with min function *)

Section NatMax.
(*   Set Implicit Parameters. *) 

   Lemma min_assoc : @Associative natDecSetoid min.
   Proof. intros x y z; rewrite min_assoc; auto. Defined.

   Lemma min_op_pres_eq : @Preserves natDecSetoid min.
   Proof. intros x y u v p q; rewrite nat_eq in *; rewrite p, q; auto. Defined.

   Definition natMinSemigroup : Semigroup :=
      Build_Semigroup
         min_assoc (* assoc *)
         min_op_pres_eq (* op_pres_eq *).

   Lemma min_idemp : forall n, min n n = n.
   Proof. induction n; simpl; auto. Qed.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

   Lemma isIdempotent : IsIdempotent natMinSemigroup.
   Proof. intros x; simpl; rewrite min_l; auto. Defined.

   Lemma isSelective : IsSelective natMinSemigroup.
   Proof. intros x y; simpl; destruct (min_dec x y) as [e|e]; rewrite e; auto. Defined.

   Lemma isCommutative : IsCommutative natMinSemigroup.
   Proof. intros x y; rewrite min_comm; auto. Defined.

   Lemma hasIdentity_comp : HasIdentity_comp natMinSemigroup.
   Proof. intros c; exists (S c); simpl; apply or_introl; rewrite min_l;
      [ toProp; rewrite beq_nat_eq; intros; induction c; [ discriminate | auto ]
      | auto ].
   Defined.

   Lemma hasAnnihilator : HasAnnihilator natMinSemigroup.
   Proof. exists 0; intros x; simpl; rewrite min_r; [ auto | apply le_O_n]. Defined.

   Lemma isLeft_comp : IsLeft_comp natMinSemigroup.
   Proof. exists 1; exists 0; compute; auto. Defined.

   Lemma isRight_comp : IsRight_comp natMinSemigroup.
   Proof. exists 0; exists 1; compute; auto. Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp natMinSemigroup.
   Proof. exists 1; exists 1; exists 0; compute; trivial. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp natMinSemigroup.
   Proof. exists 1; exists 1; exists 0; compute; trivial. Defined.

   Lemma leftCancelative_comp : LeftCancelative_comp natMinSemigroup.
   Proof. exists 1; exists 0; exists 0; compute; auto. Defined.

   Lemma rightCancelative_comp : RightCancelative_comp natMinSemigroup.
   Proof. exists 1; exists 0; exists 0; compute; auto. Defined.

   Lemma antiLeft_comp : AntiLeft_comp natMinSemigroup.
   Proof. exists 0; exists 0; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp natMinSemigroup.
   Proof. exists 0; exists 0; auto. Defined.

   Lemma treeGlb : TreeGlb natMinSemigroup.
   Proof. intros _ _ x y z. simpl.
      destruct (min_dec x y) as [e|e]; rewrite e; auto.
   Qed.

End NatMax.