Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Coq.Setoids.Setoid.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Min.
Require Import Metarouting.Logic.Logic.

Section MultiSets.
   Set Implicit Arguments.
   
   Variable A : DecSetoid.
   
   Close Scope Semigroup_scope. (* Want to use + on nats, not semigroups *)
   
   Definition multi_intersection (x y : multisetDecSetoid A) : multisetDecSetoid A :=
      fold_right (fun a res => (same A a (min (count A a x) (count A a y))) ++ res) nil (nodub A x).
   
   Lemma multi_intersection_count_helper : forall a x f,
      (forall w1 w2 : A, w1 == w2 -> f w1 = f w2) ->
      count A a (fold_right (fun a res => (same A a (f a)) ++ res) nil x) = (count A a x) * (f a).
   Proof. intros a x f peq.
      induction x. simpl. trivial.
      simpl in *.
      rewrite app_count.
      rewrite IHx.
      copy_destruct (a == a0); rewrite ew; simpl. 
      dseq_f. rewrite (count_pres_eq _ ew).
      rewrite same_count.
      rewrite (peq a a0); auto.
      rewrite (same_count_zero A a a0); auto.
      rewrite ew; auto.
   Qed.
   
   Lemma multi_intersection_count : forall a x y, count A a (multi_intersection x y) = min (count A a x) (count A a y).
   Proof. intros a x y.
      unfold multi_intersection.
      rewrite multi_intersection_count_helper.
      copy_destruct (mem a x).
         dseq_f; rewrite nodub_count in ew.
         rewrite ew; simpl. rewrite <- plus_n_O; auto.
         rewrite (mem_count_zero A _ _ ew); auto.
      intros w1 w2 e; repeat rewrite (count_pres_eq _ e); auto.
   Qed.

   Ltac multiset_u :=
      simpl; unfold multieq, multisubset, multi_intersection; simpl; repeat rewrite refl; simpl.
   
   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite app_count in *;
      repeat rewrite multi_intersection_count in *.

   Ltac toCount_u :=
      dseq_u; simpl; toCount.
   
   Lemma multi_intersection_assoc : Associative multi_intersection.
   Proof. intros x y z; toCount_u. intros a; toCount. rewrite min_assoc; auto. Qed.
   
   Lemma multi_intersection_pres_eq : Preserves multi_intersection.
   Proof. intros x y u v. toCount_u.
      intros p q a; toCount. rewrite p, q; auto.
   Qed.
   
   Definition multisetIntersectionSemigroup :=
      Build_Semigroup
         multi_intersection_assoc
         multi_intersection_pres_eq.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Definition sg_multiset_intersection_nat_min_smgIso : 
      IsSingleton A -> SmgIso multisetIntersectionSemigroup natMinSemigroup.
   Proof. intros sg.
      split with (sg_multiset_nat_dsIso sg).
      destruct sg as [a sg].
      split.
      
      intros x y; simpl. toCount. auto.
      intros x y; simpl. toCount_u. intros b; toCount.
      repeat rewrite (count_pres_eq _ (sg b)).
      repeat rewrite (same_count A a). auto.
   Defined.
   
   Lemma isIdempotent : IsIdempotent multisetIntersectionSemigroup.
   Proof. intros x; toCount_u; intros a; toCount.
      destruct (min_dec (count A a x) (count A a x)) as [e|e]; auto.
   Qed.
   
   Lemma isSelective : IsSingleton A -> IsSelective multisetIntersectionSemigroup.
   Proof. intros sg.
      apply (Iso_IsSelective (SmgIso_sym (sg_multiset_intersection_nat_min_smgIso sg))).
      apply NatMin.isSelective.
   Qed.
   
   Lemma isSelective_comp : IsSingleton_comp A -> IsSelective_comp multisetIntersectionSemigroup.
   Proof. intros sg; set(a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil). multiset_u.
      assert (a == b = false) as q; [|rewrite q; simpl; auto].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
   Defined.
   
   Lemma isCommutative : IsCommutative multisetIntersectionSemigroup.
   Proof. intros x y; toCount_u; intros a; toCount; rewrite min_comm; auto. Qed.
   
   Lemma hasIdentity_comp : HasIdentity_comp multisetIntersectionSemigroup.
   Proof. intros x; set (a := choose A); exists (a :: x); toProp; toCount_u.
      apply or_introl; intros p; assert (h := p a); clear p.
      toCount. simpl in h. rewrite refl in h; simpl in h.
      rewrite min_l in h.
      elim (le_Sn_n (count A a x)). rewrite h at 2; auto.
      apply le_n_Sn.
   Defined.
   
   Lemma hasAnnihilator : HasAnnihilator multisetIntersectionSemigroup.
   Proof. exists nil; intros x; toCount_u. split; intros a; toCount.
      trivial. rewrite min_comm; trivial.
   Defined.
   
   Lemma isLeft_comp : IsLeft_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists nil; multiset_u. auto. Defined.

   Lemma isRight_comp : IsRight_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); multiset_u. auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); exists nil; multiset_u; auto.
      rewrite refl; auto.
   Defined.
   
   Lemma rightCondensed_comp : RightCondensed_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists (a :: nil); exists (a :: nil); exists nil; multiset_u; auto. 
      rewrite refl; auto.
   Defined.
   
   Lemma leftCancelative_comp : LeftCancelative_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; multiset_u; auto. 
   Defined.

   Lemma rightCancelative_comp : RightCancelative_comp multisetIntersectionSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; multiset_u; auto. 
   Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp multisetIntersectionSemigroup.
   Proof. exists nil; exists nil; multiset_u; auto. Defined.
   
   Lemma antiRight_comp : AntiRight_comp multisetIntersectionSemigroup.
   Proof. exists nil; exists nil; multiset_u; auto. Defined.
   
   Lemma treeGlb : IsSingleton A -> TreeGlb multisetIntersectionSemigroup.
   Proof. intros sg.
      apply (Iso_TreeGlb (SmgIso_sym (sg_multiset_intersection_nat_min_smgIso sg))).
      apply NatMin.treeGlb.
   Qed.

   Lemma treeGlb_comp : IsSingleton_comp A -> TreeGlb_comp multisetIntersectionSemigroup.
   Proof. intros sg _ _. set (a := choose A); destruct (sg a) as[b pb].
      exists (a :: nil); exists (b :: nil); exists (a :: b :: nil); multiset_u. simpl.
      assert (a == b = false) as q; [|rewrite q; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q1; [|rewrite q1; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      repeat rewrite refl; auto.
   Defined.

End MultiSets.