Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.DecSetoids.FMinSets.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Coq.Setoids.Setoid.

(************************************************************************)
(*           minimal finite sets with union as operation                *)
(************************************************************************)

Section FSetsMinUnion.

   Variable A : Preorder.
   Variable antisym : Antisym A.

   Definition mset_union (x y : msetDecSetoid A) : msetDecSetoid A :=
      min A (union A x y).

   Lemma min_union_subset : forall (a b : msetDecSetoid A), subset (min A (union A a b)) (union A (min A a) (min A b)).
   Proof. intros x y. 
      rewrite subset_mem; intros a p. rewrite union_mem. toProp. do 2 rewrite min_mem in *.
      destruct p as [p1 p2]; rewrite union_mem in p1; toProp; destruct p1 as [p1 | p1].
      apply or_introl; split; [ auto | intros b q; apply p2; rewrite union_mem; rewrite q; auto ].
      apply or_intror; split; [ auto | intros b q; apply p2; rewrite union_mem, q, orb_true_r; auto ].
   Defined.

   Lemma min_union_l : forall (a b : fsetDecSetoid A), min A (union A a b) == min A (union A (min A a) b).
   Proof. intros x y; apply min_intro;
       rewrite subset_mem; intros a p;
       rewrite min_mem in p; destruct p as [p1 p2]; rewrite union_mem in *; 
       toProp; destruct p1 as [p1 | p1]; auto;
       [ apply or_introl; rewrite min_mem; split; auto;
         intros b c; apply p2; rewrite union_mem; toProp; auto
       | apply or_introl; rewrite min_mem in p1; destruct p1; auto ].
    Defined.
          
   Lemma min_union_r : forall (a b : fsetDecSetoid A), min A (union A a b) == min A (union A a (min A b)).
   Proof. intros x y; apply min_intro;
       rewrite subset_mem; intros a p;
       rewrite min_mem in p; destruct p as [p1 p2]; rewrite union_mem in *;
       toProp; destruct p1 as [p1 | p1]; auto;
       [ apply or_intror; rewrite min_mem; split; auto;
         intros b c; apply p2; rewrite union_mem; toProp; auto
       | apply or_intror; rewrite min_mem in p1; destruct p1; auto ].
   Defined.  

   Lemma min_union : forall (a b : fsetDecSetoid A), min A (union A a b) == min A (union A (min A a) (min A b)).
   Proof. intros x y; rewrite <- min_union_l, <- min_union_r; auto. Defined.

   Ltac toMSet :=
      unfold eq_mset in *;
      unfold mset_union in *.
      
   Ltac toMSet_u :=
      dseq_u; simpl in *;
      toMSet.

   Ltac mred :=
      repeat rewrite (min_min A);
      repeat rewrite <- min_union_l;
      repeat rewrite <- min_union_r.

   Ltac mred_at h :=
      repeat rewrite (min_min A) in h;
      repeat rewrite <- min_union_l in h;
      repeat rewrite <- min_union_r in h.

   Tactic Notation "mred" := mred.
   Tactic Notation "mred in" ident(h) := mred_at h.

   Lemma mset_union_assoc : Associative mset_union.
   Proof. intros x y z; toMSet_u; dseq_f; mred; apply min_pres_eq; apply union_assoc. Defined.

   Lemma mset_union_pres_eq : Preserves mset_union.
   Proof. intros x y u v p q. toMSet_u. dseq_f; mred. 
       rewrite (min_union x y), (min_union u v). 
       apply min_pres_eq; apply union_pres_eq; auto.
   Defined.
      
   Definition msetUnionSemigroup :=
      Build_Semigroup
         mset_union_assoc (* assoc *)
         mset_union_pres_eq (* op_pres_eq *).  

   (****************************************************************)
   (*                 Reflection into upper sets                   *)
   (****************************************************************)

   Lemma upper_union : forall a x y, upper_mem A a (union A x y) = upper_mem A a x || upper_mem A a y.
   Proof. intros a x y. rewrite bool_eq; split; intros h.
      destruct (upper_mem_elim A _ _ h) as [b [p1 p2]].
      rewrite min_mem in p1; destruct p1 as [p1 p3].
      rewrite union_mem in p1; toProp; destruct p1 as [p1|p1].
      apply or_introl. apply (upper_mem_intro antisym _ _ b); auto;
      rewrite min_mem; split; auto; intros w r; apply p3; toSet; rewrite r; auto.
      apply or_intror. apply (upper_mem_intro antisym _ _ b); auto;
      rewrite min_mem; split; auto; intros w r; apply p3; toSet; rewrite r, orb_true_r; auto.
      toProp; destruct h as [h|h].
      destruct (upper_mem_elim A _ _ h) as [b [p1 p2]].
      rewrite min_mem in p1; destruct p1 as [p1 p3].
      assert (mem b (union A x y)) as q; [toSet; toProp; tauto|].
      destruct (min_exists_mem A _ _ q) as [b' [q1 q2]].
      apply (upper_mem_intro antisym _ _ b'); [ auto | apply (@le_trans A _ b); auto ].
      destruct (upper_mem_elim A _ _ h) as [b [p1 p2]].
      rewrite min_mem in p1; destruct p1 as [p1 p3].
      assert (mem b (union A x y)) as q; [toSet; toProp; tauto|].
      destruct (min_exists_mem A _ _ q) as [b' [q1 q2]].
      apply (upper_mem_intro antisym _ _ b'); [ auto | apply (@le_trans A _ b); auto ].
   Qed.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isIdempotent : IsIdempotent msetUnionSemigroup.
   Proof. intros x; toMSet_u; dseq_f; mred; apply min_pres_eq; apply (FSetsUnion.isIdempotent _ x). Defined.

   (* helper lemma *)
   Lemma total_antisym_sing : Total A -> 
      forall (x : msetDecSetoid A), (x == nil) + (Exists a, mem a x /\ x == (a :: nil)).
   Proof. intros ta [|x xs].
      apply inl; auto.
      apply inr.
      destruct (min_exists_mem _ (x :: xs) x) as [a [p1 p2]].
      simpl; rewrite refl; auto.
      exists a; split.
      rewrite min_mem in p1; destruct p1; auto.
      toMSet_u. toSet. rewrite bool_eq; split; intros h.
      rewrite min_mem in *; destruct p1 as [p1 p3]; destruct h as [h1 h2]; split;
      [ simpl; destruct (ta a a0) as [h|h]; rewrite orb_false_r; apply antisym; auto;
        [ copy_destruct (a0 <= a) as a0a; auto;
         assert (h3 := h2 _ p1); toProp; elim h3; split; [ auto | rewrite a0a; intros w; discriminate w ]
        | copy_destruct (a <= a0) as a0a; auto;
         assert (h3 := p3 _ h1); toProp; elim h3; split; [ auto | rewrite a0a; intros w; discriminate w ] ]
      | intros b q; apply h2; simpl in q; rewrite orb_false_r in q; rewrite (mem_pres_eq _ q); auto
      ].

      rewrite min_mem in *; destruct p1 as [p1 p3]; destruct h as [h1 h2]; split;
      simpl in h1; rewrite orb_false_r in h1;
      [ rewrite (mem_pres_eq _ h1); auto 
      | intros b q; dseq_f; rewrite h1; apply p3; auto ].
   Defined.
      
   Lemma isSelective : Total A -> IsSelective msetUnionSemigroup.
   Proof. intros ta x y;
      destruct (total_antisym_sing ta x) as [p | [a [p1 p]]];
      destruct (total_antisym_sing ta y) as [q | [b [q1 q]]]; rewrite p, q; clear p q.
      apply or_introl; auto.
      apply or_intror; toMSet_u; dseq_f; mred; toSet; auto.
      apply or_introl; toMSet_u; dseq_f; mred; toSet; auto.
      destruct (ta a b) as [h|h].
        apply or_introl; toMSet_u; dseq_f; mred; apply min_intro;
        rewrite subset_mem; intros c p; rewrite min_mem in p; destruct p as [p q];
        [ simpl; rewrite orb_false_r;
          rewrite union_mem in p; toProp; destruct p as [p|p]; simpl in p; rewrite orb_false_r in p; auto;
          dseq_f; rewrite <- p in h; assert (q' := q a); rewrite union_mem in q'; simpl in q';
          rewrite refl in q'; simpl in q'; toProp;
          apply antisym; split; auto; copy_destruct (c <= a) as ca; rewrite ca in *; auto;
          elim q'; auto; split; auto; intros g; discriminate g
        | rewrite union_mem; toProp; auto ].
        apply or_intror; toMSet_u; dseq_f; mred; apply min_intro;
        rewrite subset_mem; intros c p; rewrite min_mem in p; destruct p as [p q];
        [ simpl; rewrite orb_false_r;
          rewrite union_mem in p; toProp; destruct p as [p|p]; simpl in p; rewrite orb_false_r in p; auto;
          dseq_f; rewrite <- p in h; assert (q' := q b); rewrite union_mem in q'; simpl in q';
          rewrite refl in q'; simpl in q'; toProp;
          apply antisym; split; auto; copy_destruct (c <= b) as cb; rewrite cb in *; auto;
          elim q'; auto; split; auto; intros g; discriminate g
        | rewrite union_mem; toProp; auto ].
     Defined.

   Lemma isSelective_comp : Total_comp A -> IsSelective_comp msetUnionSemigroup.
   Proof. intros [a [b [ta ta']]].
      exists (a :: nil);
      exists (b :: nil); simpl.
      toProp; toMSet_u. dseq_f; mred. toSet_u. split; intros h.
      assert (p := h b); copy_destruct (mem b (min A (a :: nil))) as minb; rewrite minb in p;
      [ dseq_f; rewrite min_mem in minb; simpl in minb; rewrite orb_false_r in minb; destruct minb as [p1 _];
        apply ta; dseq_f; rewrite <- p1; auto
      | let pt := type of p in match pt with ?X = false => assert X as p'; [| rewrite p' in p; discriminate p] end;
        rewrite min_mem; split;
        [ rewrite union_mem; simpl; toProp; dseq_f; auto
        | intros c q; rewrite union_mem in q; toProp; intros [p1 p2]; simpl in q; do 2 rewrite orb_false_r in q;
          destruct q as [q|q]; dseq_f; [ rewrite <- q in ta | rewrite <- q in p2]; auto
        ]
      ].
      assert (p := h a); copy_destruct (mem a (min A (b :: nil))) as minb; rewrite minb in p;
      [ dseq_f; rewrite min_mem in minb; simpl in minb; rewrite orb_false_r in minb; destruct minb as [p1 _];
        apply ta; dseq_f; rewrite <- p1; auto
      | let pt := type of p in match pt with ?X = false => assert X as p'; [| rewrite p' in p; discriminate p] end;
        rewrite min_mem; split;
        [ rewrite union_mem; simpl; toProp; dseq_f; auto
        | intros c q; rewrite union_mem in q; toProp; intros [p1 p2]; simpl in q; do 2 rewrite orb_false_r in q;
          destruct q as [q|q]; dseq_f; [ rewrite <- q in p2 | rewrite <- q in ta']; auto
        ]
      ].
   Defined.
   
   Lemma isCommutative : IsCommutative msetUnionSemigroup.
   Proof. intros x y; toMSet_u; dseq_f; mred; apply min_pres_eq; apply (FSetsUnion.isCommutative _ x y). Defined.
   
   Lemma hasIdentity : HasIdentity msetUnionSemigroup.
   Proof. exists nil; intros x; split; toMSet_u; dseq_f; mred; apply min_pres_eq; toSet_u; auto.
      simpl; rewrite orb_false_r; auto.
   Defined.

(*
   Lemma hasAnnihilator : FiniteLeastElms A -> HasAnnihilator msetUnionSemigroup.
   Proof. intros [l fle]; red.
      assert (forall x : A, least A x <-> mem A x l = true).
         intros. rewrite (fle x). clear fle. split; intros.
         induction l. discriminate H.
         simpl; simpl in H. destruct (eqdec x a); auto.
         induction l. discriminate H.
         simpl; simpl in H. destruct (eqdec x a); auto.
      clear fle.
      assert (minimal A l).
         red. apply eqdec_true_intro; split; apply subset_intro; intros.
         apply (mem_min_intro A); split; trivial.
         rewrite <- H in H0. red in H0.
         intros; apply H0; trivial.
         destruct (mem_min_elim A _ _ H0). trivial.
      exists (sigma _ _ l H0).
      split; intros [x mx]; simpl;
      split; apply subset_intro; intros.
         destruct (mem_min_elim A _ _ H1); clear H1.
         destruct (mem_union_elim A _ _ _ e) as [[a p]|[a p]]; andb_destruct; clear e.
         apply (mem_eqdec A _ _ _ (eqdec_sym _ _ H2) H1).
         rewrite <- H. red. intros. apply e0; trivial. rewrite mem_union.
         apply (mem_eqdec A _ _ _ (eqdec_sym _ _ H2) H1).
*)

   (* NOT AN IFF-RULE *)
   Lemma hasAnnihilator : Finite A -> HasAnnihilator msetUnionSemigroup.
   Proof. intros [l fl]; exists l; intros x; split;
      toMSet_u; dseq_f; mred; apply min_pres_eq; toSet_u;
      (assert (mem a l) as mema;
      [ assert (h := fl a); clear - h; induction l; 
        [ discriminate h 
        | simpl in *; toProp; destruct h as [h|h]; auto ]
      | rewrite mema, ?orb_true_r; auto
      ]).
   Defined.
   
   Lemma isLeft_comp : IsLeft_comp msetUnionSemigroup.
   Proof. exists nil; exists (choose A :: nil); toProp; toMSet_u; dseq_f; mred;
      unfold union; simpl; rewrite (singleton_min A); intros h; toSet_u;
      assert (q := h (choose A)); simpl in q; rewrite refl in q; discriminate q.
   Defined.

   Lemma isRight_comp : IsRight_comp msetUnionSemigroup.
   Proof. exists (choose A :: nil);  exists nil; toProp; toMSet_u; dseq_f; mred;
      unfold union; simpl; rewrite (singleton_min A); intros h; toSet_u;
      assert (q := h (choose A)); simpl in q; rewrite refl in q; discriminate q.
   Defined.

   Lemma leftCondensed_comp : LeftCondensed_comp msetUnionSemigroup.
   Proof. exists nil; exists nil; exists (choose A :: nil);
      toProp; toMSet_u; dseq_f; mred;
      intros h; toSet_u; assert (q := h (choose A)); simpl in q;
      unfold min in q; simpl in q;
      rewrite le_refl in q; simpl in q;
      rewrite le_refl in q; simpl in q;
      rewrite refl in q; discriminate q.
   Defined.

   Lemma rightCondensed_comp : RightCondensed_comp msetUnionSemigroup.
   Proof. exists nil; exists nil; exists (choose A :: nil);
      toProp; toMSet_u; dseq_f; mred;
      intros h; toSet_u; assert (q := h (choose A)); simpl in q;
      unfold min in q; simpl in q;
      rewrite le_refl in q; simpl in q;
      rewrite le_refl in q; simpl in q;
      rewrite refl in q; discriminate q.
   Defined.

   Lemma leftCancelative_comp : LeftCancelative_comp msetUnionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl. toMSet_u.
      dseq_f; mred; dseq_u; simpl; unfold eq_fset, subset, min, union; simpl;
      repeat progress (rewrite ?refl, ?le_refl, ?orb_false_r, ?orb_true_r, ?andb_false_r, ?andb_true_r; simpl; auto).
   Defined.

   Lemma rightCancelative_comp : RightCancelative_comp msetUnionSemigroup.
   Proof. exists (choose A :: nil); exists nil; exists (choose A :: nil); simpl. toMSet_u.
      dseq_f; mred; dseq_u; simpl; unfold eq_fset, subset, min, union; simpl;
      repeat progress (rewrite ?refl, ?le_refl, ?orb_false_r, ?orb_true_r, ?andb_false_r, ?andb_true_r; simpl; auto).
   Defined.

   Lemma antiRight_comp : AntiRight_comp msetUnionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp msetUnionSemigroup.
   Proof. exists nil; exists nil; auto. Defined.

End FSetsMinUnion.
