Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Constructions.DecSetoids.Bool.
Require Import Coq.Bool.Bool.

Section BoolAnd.

   Lemma bool_and_assoc : @Associative boolDecSetoid andb.
   Proof. intros x y z; rewrite andb_assoc; auto. Defined.
   
   Lemma bool_and_pres_eq : @Preserves boolDecSetoid andb.
   Proof. intros [|] [|] [|] [|]; auto. Defined.
  
   Definition boolAndSemigroup : Semigroup :=
      Build_Semigroup
         bool_and_assoc (* assoc *)
         bool_and_pres_eq (* op_pres_eq *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   Lemma isIdempotent : IsIdempotent boolAndSemigroup.
   Proof. intros [|]; auto. Defined.
   
   Lemma isSelective : IsSelective boolAndSemigroup.
   Proof. intros [|] [|]; auto. Defined.
   
   Lemma isCommutative : IsCommutative boolAndSemigroup.
   Proof. intros [|] [|]; auto. Defined.
   
   Lemma hasIdentity : HasIdentity boolAndSemigroup.
   Proof. exists true; intros [|]; auto. Defined.

   Lemma hasAnnihilator : HasAnnihilator boolAndSemigroup.
   Proof. exists false; intros [|]; auto. Defined.
   
   Lemma isLeft_comp : IsLeft_comp boolAndSemigroup.
   Proof. exists true; exists false; auto. Defined.

   Lemma isRight_comp : IsRight_comp boolAndSemigroup.
   Proof. exists false; exists true; auto. Defined.
   
   Lemma leftCondensed_comp : LeftCondensed_comp boolAndSemigroup.
   Proof. exists true; exists false; exists true; auto. Defined.

   Lemma rightCondensed_comp : RightCondensed_comp boolAndSemigroup.
   Proof. exists true; exists false; exists true; auto. Defined.
   
   Lemma leftCancelative_comp : LeftCancelative_comp boolAndSemigroup.
   Proof. exists true; exists false; exists false; auto. Defined.

   Lemma rightCancelative_comp : RightCancelative_comp boolAndSemigroup.
   Proof. exists true; exists false; exists false; auto. Defined.

   Lemma antiRight_comp : AntiRight_comp boolAndSemigroup.
   Proof. exists true; exists true; auto. Defined.
   
   Lemma antiLeft_comp : AntiLeft_comp boolAndSemigroup.
   Proof. exists true; exists true; auto. Defined.

   Lemma treeGlb : TreeGlb boolAndSemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

End BoolAnd.
