Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Semigroups.SelLex.
Require Import Metarouting.Constructions.Bisemigroups.SelLex.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Lex.

   Variable A B : SemigroupTransform.
   Variable A_comm   : IsCommutative A.
   Variable A_sel    : IsSelective A.
   Variable B_comm   : IsCommutative B.

   Lemma c_idem : forall x : A, op A x x == x.
   Proof. intros x; destruct (A_sel x x); auto. Qed.
   
   Definition selLexSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (selLexSemigroup A B A_comm A_sel) (prodTransform A B) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope Transform_scope.
   Open Scope Semigroup_scope.
   Open Scope SemigroupTransform_scope.

   Ltac lex_destruct x y h :=
      destruct (lex_case A A_comm A_sel x y) as [[h|h]|h];
      rewrite ?h;
      rewrite ?(lexComp_equiv A A_comm)
      , ?(lexComp_less  A A_comm)
      , ?(lexComp_more  A A_comm) in h.
   
   Lemma distributive : 
      Distributive A * Distributive B * (Cancelative A + Condensed B) -> Distributive selLexSemigroupTransform.
   Proof. intros [[da db] [ca | cb]] [x1 x2] [y1 y2] [f1 f2]; dseq_u; simpl;
      toProp; (split; [ apply da |]); dseq_f.

      lex_destruct (f1 |> x1) (f1 |> y1) h; rewrite <- (da x1 y1 f1), <- (da y1 x1 f1) in h; dseq_f.
      (* 1 *) assert (lexComp A x1 y1 = equiv); [| rewrite H; apply db];
         rewrite (lexComp_equiv A A_comm); split; eapply (ca _ _ f1); destruct h; auto.
      (* 2 *) assert (lexComp A x1 y1 = less); [| rewrite H; auto];
         rewrite (lexComp_less A A_comm); split; destruct h as [h1 h2]; [ eapply (ca _ _ f1); auto | ];
         intros p; elim h2; dseq_f; rewrite p; auto.
      (* 3 *) assert (lexComp A x1 y1 = more); [| rewrite H; auto];
         rewrite (lexComp_more A A_comm); split; destruct h as [h1 h2]; [ | eapply (ca _ _ f1); auto ];
         intros p; elim h1; dseq_f; rewrite p; auto.

      lex_destruct (f1 |> x1) (f1 |> y1) h;
      [rewrite <- (db x2 y2 f2) | | ]; apply cb.
   Defined.

   Lemma distributive_comp : 
         Distributive_comp A + Distributive_comp B + (Cancelative_comp A * Condensed_comp B) 
      -> Distributive_comp selLexSemigroupTransform.
   Proof. intros [[[a [b [f da]]] | [x [y [g db]]]] | [[a [b [f [ca1 ca2]]]] [x [y [g db]]]]].
      exists (a, choose B); exists (b, choose B); exists (f, choose (fn B)); simpl.
      negb_p; rewrite da; auto.
      exists (choose A, x); exists (choose A, y); exists (choose (fn A), g); simpl.
      negb_p. rewrite lexComp_refl, lexComp_refl, db, orb_true_r; auto.
      

      assert (lexComp A (f |> a) (f |> b) = equiv) as fh.
         rewrite (lexComp_equiv _ A_comm); dseq_f; rewrite ca1; simpl; rewrite c_idem; auto.
      lex_destruct a b h.
      (* 3.1 *) exists (a, x); exists (b, y); exists (f, g); simpl;
      destruct h as [h1 h2]; toProp; elim ca2; dseq_f;
      rewrite <- h2, (A_comm b a), h1; auto.
      (* 3,2 *)
      rewrite <- (lexComp_less _ A_comm) in h;
      copy_destruct ((g |> x == g |> x + g |> y)%bool).
      exists (a, y); exists (b, x); exists (f, g); simpl; rewrite h, fh;
      toProp; dseq_f; intros [_ p]; elim db; simpl; dseq_f;
      rewrite ew, (B_comm (g |> x) (g |> y)), <- p; auto.
      exists (a, x); exists (b, y); exists (f, g); simpl; rewrite h, fh;
      rewrite ew; toProp; bool_p; tauto.
      (* 3.3 *)
      rewrite <- (lexComp_more _ A_comm) in h;
      copy_destruct ((g |> x == g |> x + g |> y)%bool).
      exists (a, x); exists (b, y); exists (f, g); simpl; rewrite h, fh.
      toProp; dseq_f; intros [_ p]; elim db; simpl; dseq_f; rewrite ew, <- p; auto.
      exists (a, y); exists (b, x); exists (f, g); simpl; rewrite h, fh.
      dseq_f; rewrite (B_comm (g |> x) (g |> y)) in ew. simpl in ew. rewrite ew; toProp; bool_p; tauto.
   Defined.

   (**************************************************************)
   (*             Commutative Idempotent properties              *)
   (**************************************************************)
  
   Lemma isIdempotent_back : IsIdempotent selLexSemigroupTransform -> IsIdempotent B.
   Proof.
         intros idem a. simpl.
         assert (p := idem (choose A, a)); dseq_u; simpl in p; toProp;
         rewrite lexComp_refl in p; trivial; simpl in p; tauto.
   Defined.
   
   Ltac lex_idem idem :=
      assert (B_idem := isIdempotent_back idem).

   Lemma inflationary : Inflationary A * (StrictInflationary A + Inflationary B) 
      -> Inflationary selLexSemigroupTransform.
   Proof. intros [ia [sia | ib]] comm idem [x1 x2] [f1 f2]; lex_idem idem; dseq_u; simpl; toProp; 
      (split; [ apply (ia A_comm c_idem); auto |]).
      (* 1 *) assert (lexComp A x1 (f1 |> x1) = less) as h; [| rewrite h; dseq_f; auto].
      rewrite lexComp_less; auto; assert (q := sia A_comm c_idem x1 f1); toProp; apply q.
      (* 2 *)
      lex_destruct x1 (f1 |> x1) h.
      apply ib; auto.
      dseq_f; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h1. apply ia; auto. intros x; apply c_idem.
   Defined.
      
   Lemma inflationary_comp :
      Inflationary_comp A + (StrictInflationary_comp A * Inflationary_comp B)
      -> Inflationary_comp selLexSemigroupTransform.
   Proof. intros [ia | [sia ib]] comm idem; lex_idem idem.
      destruct (ia A_comm c_idem) as [x [f p]];
      exists (x, choose B); exists (f, choose (fn B)); simpl in *; negb_p; toProp; dseq_f; auto.
      destruct (sia A_comm c_idem) as [a [g q]];
      destruct (ib B_comm B_idem) as [x [f p]];
      exists (a, x); exists (g, f). simpl in *.
      negb_p; toProp. intuition. apply or_intror.
      lex_destruct a (g |> a) h; negb_p; toProp;
      [ auto
      | tauto
      | intros q; elim p; dseq_f; rewrite q, (B_idem x); auto].
   Defined.

   Lemma deflationary : Deflationary A * (StrictDeflationary A + Deflationary B) 
      -> Deflationary selLexSemigroupTransform.
   Proof. intros [ia [sia | ib]] comm idem [x1 x2] [f1 f2]; lex_idem idem; dseq_u; simpl; toProp; 
      (split; [ apply (ia A_comm c_idem); auto |]).
      (* 1 *) assert (lexComp A (f1 |> x1) x1 = less) as h; [| rewrite h; dseq_f; auto].
      rewrite lexComp_less; auto; assert (q := sia A_comm c_idem x1 f1); toProp; apply q.
      (* 2 *)
      lex_destruct (f1 |> x1) x1 h.
      apply ib; auto.
      dseq_f; auto.
      negb_p; toProp; destruct h as [h1 h2]; elim h1. apply ia; auto. intros x; apply c_idem.
   Defined.
      
   Lemma deflationary_comp :
      Deflationary_comp A + (StrictDeflationary_comp A * Deflationary_comp B)
      -> Deflationary_comp selLexSemigroupTransform.
   Proof. intros [ia | [sia ib]] comm idem; lex_idem idem.
      destruct (ia A_comm c_idem) as [x [f p]];
      exists (x, choose B); exists (f, choose (fn B)); simpl in *; negb_p; toProp; dseq_f; auto.
      destruct (sia A_comm c_idem) as [a [g q]];
      destruct (ib B_comm B_idem) as [x [f p]];
      exists (a, x); exists (g, f). simpl in *.
      negb_p; toProp. intuition. apply or_intror.
      lex_destruct (g |> a) a h; negb_p; toProp;
      [ auto
      | tauto
      | intros q; elim p; dseq_f; rewrite <- q, (B_idem x); auto].
   Defined.
   
   Lemma strictInflationary :
      StrictInflationary A + Inflationary A * StrictInflationary B
      -> StrictInflationary selLexSemigroupTransform.
   Proof. intros [sia | [ia sib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; negb_p; toProp; lex_idem idem.
      (* 1 *) assert (x1 < f1 |> x1) as h; [ apply sia; auto; intros x; apply c_idem |].
      assert (lexComp A x1 (f1 |> x1) = less) as p.
         rewrite lexComp_less; toProp; [ apply h | auto ].
      rewrite p; toProp; destruct h; dseq_f; auto.
      (* 2 *) rewrite (lexComp_swap _ A_comm A_sel (f1 |> x1) x1).
      lex_destruct x1 (f1 |> x1) h; simpl;
      [ assert (q := sib B_comm B_idem x2 f2); negb_p; toProp; intuition
      | negb_p; toProp; intuition; dseq_f; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto; intros x; apply c_idem ].
   Defined.

   Lemma strictInflationary_comp :
      StrictInflationary_comp A * (Inflationary_comp A + StrictInflationary_comp B)
      -> StrictInflationary_comp selLexSemigroupTransform.
   Proof. intros [sia [ia | sib]] comm idem; lex_idem idem.
      (* 1 *) destruct (ia A_comm c_idem) as [b [k p2]].
      exists (b, choose B); exists (k, choose (fn B)).
      simpl; negb_p; toProp. rewrite (lexComp_swap _ A_comm A_sel (k |> b) b).
      lex_destruct b (k |> b) h; simpl; auto.
      (* 2 *) destruct (sia A_comm c_idem) as [a [g p1]].
      destruct (sib B_comm B_idem) as [b [k p2]].
      exists (a, b); exists (g, k); simpl; negb_p; toProp.
      rewrite (lexComp_swap _ A_comm A_sel (g |> a) a);
      lex_destruct a (g |> a) h; simpl; negb_p; toProp; try tauto.
   Defined.

   Lemma strictDeflationary :
      StrictDeflationary A + Deflationary A * StrictDeflationary B
      -> StrictDeflationary selLexSemigroupTransform.
   Proof. intros [sia | [ia sib]] comm idem [x1 x2] [f1 f2]; dseq_u; simpl; negb_p; toProp; lex_idem idem.
      (* 1 *) assert (f1 |> x1 < x1) as h; [ apply sia; auto; intros x; apply c_idem |].
      assert (lexComp A (f1 |> x1) x1 = less) as p.
         rewrite lexComp_less; toProp; [ apply h | auto ].
      rewrite p; toProp; destruct h; dseq_f; auto.
      (* 2 *) rewrite (lexComp_swap _ A_comm A_sel x1 (f1 |> x1)).
      lex_destruct (f1 |> x1) x1 h; simpl;
      [ assert (q := sib B_comm B_idem x2 f2); negb_p; toProp; intuition
      | negb_p; toProp; intuition; dseq_f; auto
      | negb_p; toProp; destruct h as [h1 h2]; elim h1; apply ia; auto; intros x; apply c_idem ].
   Defined.

   Lemma strictDeflationary_comp :
      StrictDeflationary_comp A * (Deflationary_comp A + StrictDeflationary_comp B)
      -> StrictDeflationary_comp selLexSemigroupTransform.
   Proof. intros [sia [ia | sib]] comm idem; lex_idem idem.
      (* 1 *) destruct (ia A_comm c_idem) as [b [k p2]].
      exists (b, choose B); exists (k, choose (fn B)).
      simpl; negb_p; toProp. rewrite (lexComp_swap _ A_comm A_sel (k |> b) b).
      lex_destruct b (k |> b) h; simpl; auto.
      (* 2 *) destruct (sia A_comm c_idem) as [a [g p1]].
      destruct (sib B_comm B_idem) as [b [k p2]].
      exists (a, b); exists (g, k); simpl; negb_p; toProp.
      rewrite (lexComp_swap _ A_comm A_sel (g |> a) a);
      lex_destruct a (g |> a) h; simpl; negb_p; toProp; try tauto.
   Defined.

   (**************************************************************)
   (*                    Identity properties                     *)
   (**************************************************************)

   Lemma hasId_back_a : HasIdentity selLexSemigroupTransform -> HasIdentity A.
   Proof. intros [[ida idb] p].
      exists ida. intros x; split; simpl.
      destruct (p (x, choose B)) as [q _]; dseq_u; simpl in *; toProp; tauto.
      destruct (p (x, choose B)) as [_ q]; dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasId_back_b : HasIdentity selLexSemigroupTransform -> HasIdentity B.
   Proof. intros [[ida idb] p].
      exists idb. intros x; destruct (p (ida, x)) as [p1 p2]; dseq_u; simpl in *.
      rewrite lexComp_refl in p1, p2; auto; toProp; tauto.
   Defined.

   Lemma hasId_back_eq : forall hasId : HasIdentity selLexSemigroupTransform,
      projT1 hasId == (projT1 (hasId_back_a hasId), projT1 (hasId_back_b hasId)).
   Proof. intros [[id1 id2] p]. destruct (p (id1, id2)); simpl. auto. Defined.

   Lemma strict : Strict A * Strict B -> Strict selLexSemigroupTransform.
   Proof. intros [sta stb] hasId [f1 f2]; red in sta, stb; simpl in sta, stb.
      assert (p1 := hasId_back_eq hasId);
      rewrite p1; simpl. dseq_u; simpl; toProp; split; [apply sta | apply stb]; auto.
   Defined.

   Lemma strict_comp : Strict_comp A + Strict_comp B
      -> Strict_comp selLexSemigroupTransform.
   Proof. intros [sta | stb] hasId.
      destruct (sta (hasId_back_a hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (f, choose (fn B)). simpl. negb_p; toProp; tauto.
      destruct (stb (hasId_back_b hasId)) as [f p].
      destruct hasId as [[ida idb] q]. simpl in *.
      exists (choose (fn A), f). simpl. negb_p; toProp; tauto.
   Defined.
      
   Close Scope SemigroupTransform_scope.

End Lex.