Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Transforms.Id.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Right.

   Variable A : Semigroup.

   Definition rightSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq A (idTransform A) (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _).*)

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope SemigroupTransform_scope.
   
   Lemma distributive : Distributive rightSemigroupTransform.
   Proof. intros x y f; simpl. unfold id_app; simpl; auto. Defined.
   
   Lemma inflationary : Inflationary rightSemigroupTransform.
   Proof. intros comm idem x f; simpl; unfold id_app; simpl; apply idem. Defined.

   Lemma deflationary : Deflationary rightSemigroupTransform.
   Proof. intros comm idem x f; simpl; unfold id_app; simpl; apply idem. Defined.
      
   Lemma strictInflationary_comp : StrictInflationary_comp rightSemigroupTransform.
   Proof. intros comm idem. exists (choose A); exists tt.
      simpl; unfold id_app; simpl. 
      destruct ((Semigroup.op A (choose A) (choose A) == choose A)%bool); auto.
   Defined.

   Lemma strictDeflationary_comp : StrictDeflationary_comp rightSemigroupTransform.
   Proof. intros comm idem. exists (choose A); exists tt.
      simpl; unfold id_app; simpl. 
      destruct ((Semigroup.op A (choose A) (choose A) == choose A)%bool); auto.
   Defined.
   
   Lemma strict : Strict rightSemigroupTransform.
   Proof. intros hasId f; simpl; unfold id_app; auto. Defined.

   Close Scope SemigroupTransform_scope.

End Right.