Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Constructions.Transforms.Replace.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.Transforms.Replace.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Left.

   Variable A : Semigroup.

   Definition leftSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq A (replaceTransform A) (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _).*)

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)
   
   Open Scope SemigroupTransform_scope.
   Open Scope Semigroup_scope.
   
   Lemma distributive : IsIdempotent A -> Distributive leftSemigroupTransform.
   Proof. intros idem x y f; simpl. unfold replace_app. rewrite (idem f). auto. Defined.
   
   Lemma distributive_comp : IsIdempotent_comp A -> Distributive_comp leftSemigroupTransform.
   Proof. intros [f idem]; exists f; exists f; exists f. simpl; unfold replace_app.
      toProp; intros h; elim idem; dseq_f; rewrite <- h; auto.
   Defined.
   
   Lemma inflationary : IsSingleton A -> Inflationary leftSemigroupTransform.
   Proof. intros [a sg] comm idem x f; simpl; unfold replace_app;
      simpl; rewrite (sg x), (sg f); apply idem.
   Defined.
   
   Lemma inflationary_comp : IsSingleton_comp A -> Inflationary_comp leftSemigroupTransform.
   Proof. intros sg comm idem; destruct (sg (choose A)) as [b p].
      simpl; unfold replace_app; simpl.
      copy_destruct (((choose A) + b == choose A)%bool) as q.
      exists b; exists (choose A); toProp; intros h; elim p; dseq_f; rewrite <- q, (comm (choose A) b), h; auto.
      exists (choose A); exists b. rewrite q; auto.
   Defined.

   Lemma deflationary : IsSingleton A -> Deflationary leftSemigroupTransform.
   Proof. intros [a sg] comm idem x f. simpl in *; dseq_f. unfold replace_app; simpl.
      rewrite (sg x), (sg f), (idem a); auto.
   Qed.
   
   Lemma deflationary_comp : IsSingleton_comp A -> Deflationary_comp leftSemigroupTransform.
   Proof. intros sg comm idem. set (a := choose A); destruct (sg a) as [b pb].
      copy_destruct ((b + a == b)%bool).
         exists b; exists a; simpl; unfold replace_app; simpl; dseq_f.
         rewrite (comm a b), ew; auto.
         exists a; exists b; simpl; unfold replace_app; simpl; dseq_f.
         rewrite ew; auto.
   Defined.
   
   Lemma strictInflationary_comp : StrictInflationary_comp leftSemigroupTransform.
   Proof. intros comm idem. exists (choose A); exists (choose A).
      simpl. unfold replace_app; simpl.
      negb_p. destruct ((choose A + choose A == choose A)%bool); auto.
   Defined.

   Lemma strictDeflationary_comp : StrictDeflationary_comp leftSemigroupTransform.
   Proof. intros comm idem. exists (choose A); exists (choose A).
      simpl. unfold replace_app; simpl.
      negb_p. destruct ((choose A + choose A == choose A)%bool); auto.
   Defined.
   
   Lemma strict : IsSingleton A -> Strict leftSemigroupTransform.
   Proof. intros [a sg] hasId f; simpl; unfold replace_app.
      rewrite (sg f), (sg (projT1 hasId)); auto.
   Defined.

   Lemma strict_comp : IsSingleton_comp A -> Strict_comp leftSemigroupTransform.
   Proof. intros sg [id q]. simpl. destruct (sg id) as [b p]; exists b; apply p. Defined.

   Close Scope SemigroupTransform_scope.

End Left.