Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetsUnion.
Require Import Metarouting.Constructions.Transforms.FSets.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section FSets.

   Variable A : Transform.
   
   Definition fsetsSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (fsetsUnionSemigroup A) (fsetsTransform A) (dsEq_refl _) (*(ds_eq_refl _ _ _ _ _ _)*).

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)

   Open Scope SemigroupTransform_scope.
   Open Scope Transform_scope.
   Open Scope Semigroup_scope.
   
   Ltac fmap_u :=
      unfold fmap_app; repeat rewrite nodub_mem.

   Lemma distributive : Distributive fsetsSemigroupTransform.
   Proof. intros x y f. toSet_u. fmap_u.
      rewrite bool_eq; split; intros h.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      toSet_u. toProp. destruct p2 as [p2|p2].
      apply or_introl. apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists b; auto.
      apply or_intror. apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists b; auto.
      toProp; destruct h as [h|h].
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      apply mem_map_intro. intros w1 w2 q1; rewrite q1; auto. exists b; toSet_u; toProp; auto.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      apply mem_map_intro. intros w1 w2 q1; rewrite q1; auto. exists b; toSet_u; toProp; auto.
   Qed.
   
   Lemma inflationary : Identity A -> Inflationary fsetsSemigroupTransform.
   Proof. intros iid _ _ x f. dseq_f. toSet_u. fmap_u.
      copy_destruct (mem a x); rewrite ew; auto.
      simpl; bool_p. intros h; apply ew; clear ew.
      destruct (mem_map_elim _ _ _ h) as [b [p1 p2]].
      rewrite (iid b f) in p1.
      rewrite (mem_pres_eq x p1); auto.
   Qed.

   Lemma inflationary_comp : Identity_comp A -> Inflationary_comp fsetsSemigroupTransform.
   Proof. intros [x [f iid]] _ _.
      exists (x :: nil); exists f. toProp; intros h. apply iid; clear iid.
      dseq_f; simpl in *. toSet_u.
      assert (p := h (f |> x)); clear h.
      toSet. unfold fmap_app in p; rewrite nodub_mem in p; simpl in p.
      repeat rewrite orb_false_r in p; rewrite refl, orb_true_r in p.
      rewrite <- p; auto.
   Defined.
   
   Lemma deflationary : Identity A -> Deflationary fsetsSemigroupTransform.
   Proof. intros iid _ _ x f. dseq_f. toSet_u. fmap_u.
      rewrite bool_eq; split; intros h. toProp; destruct h as [h|h]; auto.
      apply mem_map_intro.
         intros w1 w2 q1; rewrite q1; auto.
         exists a; split; auto. rewrite (iid a f). auto.
      toProp; tauto.
   Qed.

   Lemma deflationary_comp : Identity_comp A -> Deflationary_comp fsetsSemigroupTransform.
   Proof. intros [x [f iid]] _ _.
      exists (x :: nil); exists f. toProp; intros h. apply iid; clear iid.
      dseq_f; simpl in *. toSet_u.
      assert (p := h x); clear h.
      toSet. unfold fmap_app in p; rewrite nodub_mem in p; simpl in p.
      repeat rewrite orb_false_r in p; rewrite refl, orb_true_r in p.
      apply sym;
      rewrite <- p; auto.
   Defined.
   
   Lemma strictInflationary_comp : StrictInflationary_comp fsetsSemigroupTransform.
   Proof. intros _ _. exists nil; exists (choose (Transform.fn A)).
      negb_p; compute. auto.
   Defined.

   Lemma strictDeflationary_comp : StrictInflationary_comp fsetsSemigroupTransform.
   Proof. intros _ _. exists nil; exists (choose (Transform.fn A)).
      negb_p; compute. auto.
   Defined.

   Lemma strict : Strict fsetsSemigroupTransform.
   Proof. intros hasId f.
      assert ((projT1 hasId) == nil) as h.
         set (p := Semigroups.FSetsUnion.hasIdentity A).
         apply (uniqueId (fsetsUnionSemigroup A) hasId p).
      rewrite h. simpl. fmap_u. auto.
   Qed.

End FSets.