Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Constructions.Transforms.Cayley.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.SemigroupTransformGlue.

Section Cayley.

   Variable A : Bisemigroup.

   Definition cayleyMapSemigroupTransform : SemigroupTransform :=
      glueSTf_DsEq (plusSmg A) (cayleyMapTransform (timesSmg A)) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (**************************************************************)
   (*                       Properties                           *)
   (**************************************************************)

   Open Scope SemigroupTransform_scope.
   Open Scope Bisemigroup_scope.
   
   Lemma distributive : IsLeftDistributive A -> Distributive cayleyMapSemigroupTransform.
   Proof. intros ld x y f; simpl. apply ld. Defined.

   Lemma distributive_comp : IsLeftDistributive_comp A -> Distributive_comp cayleyMapSemigroupTransform.
   Proof. intros [a [b [c ld]]]; exists a; exists b; exists c. apply ld. Defined.
   
   (**************************************************************)
   (*             Commutative Idempotent properties              *)
   (**************************************************************)
         
   Lemma inflationary : LeftIncreasing A -> Inflationary cayleyMapSemigroupTransform.
   Proof. intros lc comm idem x f. simpl; dseq_f. rewrite (lc comm idem x f); auto. Defined.

   Lemma inflationary_comp : LeftIncreasing_comp A -> Inflationary_comp cayleyMapSemigroupTransform.
   Proof. intros lc comm idem. 
      destruct (lc comm idem) as [a [b p]].
      exists a; exists b; simpl; dseq_f; auto. 
   Defined.
   
(*
   Lemma deflationary : Deflationary cayleyMapSemigroupTransform.
   Proof. intros comm idem x f. Defined.
*)

   Lemma strictInflationary : LeftStrictIncreasing A -> StrictInflationary cayleyMapSemigroupTransform.
   Proof. intros lsc comm idem x f. simpl. apply (lsc comm idem). Defined.

   Lemma strictInflationary_comp : LeftStrictIncreasing_comp A -> StrictInflationary_comp cayleyMapSemigroupTransform.
   Proof. intros lsc comm idem. destruct (lsc comm idem) as [a [b p]].
      exists a; exists b; auto.
   Defined.

   (**************************************************************)
   (*                    Identity properties                     *)
   (**************************************************************)
   
   Lemma strict : PlusIdentityIsTimesRightAnnihilator A -> Strict cayleyMapSemigroupTransform.
   Proof. intros p hasId f; simpl. apply (p hasId). Defined.

   Lemma strict_comp : PlusIdentityIsTimesRightAnnihilator_comp A -> Strict_comp cayleyMapSemigroupTransform.
   Proof. intros p hasId; destruct (p hasId) as [f q]; exists f; auto. Defined.

   Close Scope SemigroupTransform_scope.

End Cayley.