(*
 * Isomorphic: LeftNaturalOrder
 * Ignore: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.Preorders.Dual.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section RightNaturalOrder.

   Variable S : Semigroup.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.

   Open Scope Semigroup_scope.

   Definition rle (x y : S) := x + y == y.
   
   Lemma rle_refl : Reflexive rle.
   Proof. apply idem. Defined.

   Lemma rle_trans : Transitive rle.
   Proof. intros x y z p q; unfold rle in *; dseq_f.
     rewrite <- q at 1; rewrite <- (assoc _ x y z), p; auto.
   Defined.
   
   Lemma rle_pres_eq : RelPreserves rle.
   Proof. intros x y u v p q h; unfold rle in *; dseq_f; rewrite <- p, <- q; auto. Defined.

   Definition rightNaturalOrder :=
      Build_Preorder
         rle_refl
         rle_trans
         rle_pres_eq.

   Lemma naturalOrderProIso_isIso : IsProIso rightNaturalOrder (dualPreorder (leftNaturalOrder S idem)) (DsIso_refl S).
   Proof. split.
      intros x y; simpl; unfold le, rle; rewrite (comm x y); auto.
      intros x y; simpl; unfold le, rle; rewrite (comm x y); auto.
   Qed.

   Definition naturalOrderProIso : ProIso rightNaturalOrder (dualPreorder (leftNaturalOrder S idem)) :=
      Build_ProIso naturalOrderProIso_isIso.

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   (* no need to prove properties, since its all done by isomorphism *)

End RightNaturalOrder.
