Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Coq.Arith.Arith.

(* natural number with the usual order *)

Section NatLe.
   
   (* TO BE REMOVED *)
   (*
   Lemma nat_le_antisym : @Antisymmetric natDecSetoid leb.
   Proof. intros x y z. ; apply eq_eq_nat; apply le_antisym; trivial. Defined.
   

   Lemma nat_le_dec : Decidable natDecSetoid Peano.le.
   Proof. red; intros; destruct (le_gt_dec x y).
      apply yes; trivial.
      apply no; apply gt_not_le; trivial.
   Defined.
   *)
   
   Lemma nat_le_refl : @Reflexive natDecSetoid leb.
   Proof. intros x; apply leb_correct; auto. Defined.
   
   Lemma nat_le_trans : @Transitive natDecSetoid leb.
   Proof. intros x y z p q; apply leb_correct; apply (le_trans _ y); apply leb_complete; auto. Defined.
   
   Lemma nat_le_pres_eq : @RelPreserves natDecSetoid leb.
   Proof. intros x y u v p q; rewrite nat_eq in *; rewrite p, q; auto. Defined.
   
   Definition natPreorder :=
      Build_Preorder
         nat_le_refl
         nat_le_trans
         nat_le_pres_eq.

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma hasTop_comp : HasTop_comp natPreorder.
   Proof. intros x; exists (S x); toProp; intros h; apply (le_Sn_n x); 
      apply leb_complete; auto. 
   Defined.
   
   Lemma hasBottom : HasBottom natPreorder.
   Proof. exists 0; intros x; auto. Defined.
   
   Lemma total : Total natPreorder.
   Proof. intros x y. destruct (le_lt_dec x y). 
      apply or_introl; apply leb_correct; auto.
      apply or_intror; apply leb_correct; apply lt_le_weak; auto.
   Defined.
   
   Lemma antisym : Antisym natPreorder.
   Proof. intros x y [p q]; rewrite nat_eq; apply le_antisym; apply leb_complete; auto. Defined.

(*   
   Lemma finiteLeastElms : FiniteLeastElms natPreorder.
   Proof. red. exists (0 :: nil). intros x. simpl. unfold least. rewrite orb_false_r.
      split. intros. destruct x.
      apply eqdec_refl.
      elim (H 0 (le_O_n _)).
      intros. rewrite (eq_nat_eq _ _ (eqdec_true H)) in *.
      destruct x0. apply eq_nat_refl.
      elim (le_Sn_O _ H0).
   Defined.
   
   Lemma finiteGreatestElms : FiniteGreatestElms natPreorder.
   Proof. red. exists (@nil nat). intros; simpl; unfold greatest.
      split; intros.
      assert (p := (H (S x) (le_n_Sn _))).
      assert (p' := lt_not_le _ _ (lt_n_Sn x)).
      elim p'. do 4 (red in p).
      rewrite (eq_nat_eq _ _ p). apply le_refl.
      discriminate H.
   Defined.
*)
   
End NatLe.

