Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.OrderTransformProperties.
Require Import Metarouting.Signatures.OrderTransformGlue.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Coq.Bool.Bool.

Section LeftNaturalOrder.

   Variable S : SemigroupTransform.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.
   Variable dist : Distributive S.

   Open Scope SemigroupTransform_scope.

   Definition leftNaturalOrder :=
      glueOTf (leftNaturalOrder S idem) S (dsEq_refl _). 

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Ltac le_u := simpl in *; unfold le; simpl in *.
   
   Lemma monotone : Monotone leftNaturalOrder.
   Proof. intros x y f; le_u. dseq_f. intros h; rewrite <- (dist x y f), h; auto. Qed.
   
   Lemma embedding : Cancelative S -> Embedding leftNaturalOrder.
   Proof. intros ca _ x y f. le_u.
      dseq_f; rewrite <- (dist x y f). intros h; auto.
      apply ca with f. auto.
   Qed.
   
   Lemma embedding_comp : Cancelative_comp S -> Embedding_comp leftNaturalOrder.
   Proof. intros [x [y [f [p1 p2]]]]. simpl in *.
      copy_destruct (x + y == x).
      assert (y + x == y = false) as p.
         bool_p; intro h; toProp; apply p2. dseq_f.
         rewrite <- ew, (comm x y), h; auto.
      exists y; exists x; exists f; le_u. dseq_f.
      rewrite p1, p, (idem (f |> y)); split; auto.
      exists x; exists y; exists f; le_u. dseq_f.
      rewrite p1, ew, (idem (f |> y)); split; auto.
   Defined.
   
   Lemma increasing : Inflationary S -> Increasing leftNaturalOrder.
   Proof. intros inf x f. le_u. dseq_f. auto. apply inf; auto. Qed.
   
   Lemma increasing_comp : Inflationary_comp S -> Increasing_comp leftNaturalOrder.
   Proof. intros inf; destruct (inf comm idem) as [x [f p]].
      exists x; exists f; le_u. auto.
   Defined.

   Lemma decreasing : Deflationary S -> Decreasing leftNaturalOrder.
   Proof. intros inf x f. le_u. dseq_f. auto. apply inf; auto. Qed.
      
   Lemma decreasing_comp : Deflationary_comp S -> Decreasing_comp leftNaturalOrder.
   Proof. intros inf; destruct (inf comm idem) as [x [f p]].
      exists x; exists f; le_u. auto.
   Defined.

End LeftNaturalOrder.