Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.SimpleSeq. 
Require Import Metarouting.Constructions.Semigroups.SimpleSeq.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.Preorders.AnnTop.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section SimpleSeq.

   Variable A : DecSetoid.
   
   Definition simpleSeqOrderSemigroup : OrderSemigroup :=
      glueOSmg (simpleSeqSemigroup A) (annTopPreorder (simpleSeqSemigroup A) (SimpleSeq.hasAnnihilator A)) (dsEq_refl _).

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma leftMonotonic : LeftMonotonic simpleSeqOrderSemigroup.
   Proof. intros z x y. simpl; unfold ann_le. simpl.
      toProp; intros [p1 | p1].
      unfold sseq_eq in p1.
      assert (h := orb_prop _ _ p1); clear p1.
      destruct h as [h|h].
         apply or_intror.
         unfold sseq_eq.
         repeat rewrite simple_app.
         negb_p. dseq_f; toProp. 
         apply or_introl. rewrite simple_err; bool_p; tauto.
         
         apply or_introl.
         unfold sseq_eq; repeat rewrite simple_app; repeat rewrite simple_err.
         destruct(andb_prop _ _ h) as [h1 h2].
         destruct(andb_prop _ _ h1) as [h3 h4]; clear h h1.
         rewrite h3, h4; simpl.
         repeat rewrite andb_true_r.
         destruct (simple A z); simpl; auto.
         copy_destruct (disjoint A z x); rewrite ew; simpl;
         copy_destruct (disjoint A z y); rewrite ew0; simpl; auto.
         apply (Seq.app_pres_eq A); auto.
         rewrite (disjoint_pres_eq A z x z y) in ew; auto.
            rewrite ew in ew0; discriminate ew0. apply Seq.seq_eq_refl.
         rewrite (disjoint_pres_eq A z x z y) in ew; auto.
            rewrite ew in ew0; discriminate ew0. apply Seq.seq_eq_refl.
         
      apply or_intror.
      unfold sseq_eq in *. repeat rewrite simple_app; negb_p.
      rewrite simple_err in *; simpl in *.
      rewrite andb_false_r in p1. simpl in *.
      rewrite orb_false_r, andb_true_r in p1.
      rewrite p1. toProp; bool_p; tauto.
   Qed.
      
   Lemma rightMonotonic : RightMonotonic simpleSeqOrderSemigroup.
   Proof. intros x y z; simpl; unfold ann_le; simpl.
      toProp; intros [p1 | p1].
      unfold sseq_eq in p1.
      assert (h := orb_prop _ _ p1); clear p1.
      destruct h as [h|h].
         apply or_intror.
         unfold sseq_eq.
         repeat rewrite simple_app.
         negb_p. dseq_f; toProp. 
         apply or_introl. rewrite simple_err; bool_p; tauto.
         
         apply or_introl.
         unfold sseq_eq; repeat rewrite simple_app; repeat rewrite simple_err.
         destruct(andb_prop _ _ h) as [h1 h2].
         destruct(andb_prop _ _ h1) as [h3 h4]; clear h h1.
         rewrite h3, h4; simpl.
         repeat rewrite andb_true_r.
         destruct (simple A z); simpl; auto.
         copy_destruct (disjoint A x z); rewrite ew; simpl;
         copy_destruct (disjoint A y z); rewrite ew0; simpl; auto.
         apply (Seq.app_pres_eq A); auto.
         rewrite (disjoint_pres_eq A x z y z) in ew; auto.
            rewrite ew in ew0; discriminate ew0. apply Seq.seq_eq_refl.
         rewrite (disjoint_pres_eq A x z y z) in ew; auto.
            rewrite ew in ew0; discriminate ew0. apply Seq.seq_eq_refl.
         
      apply or_intror.
      unfold sseq_eq in *. repeat rewrite simple_app; negb_p.
      rewrite simple_err in *; simpl in *.
      rewrite andb_false_r in p1. simpl in *.
      rewrite orb_false_r, andb_true_r in p1.
      rewrite p1. toProp; bool_p; tauto.
   Qed.
   
   Lemma rightOpNonDecreasing_comp : RightOpNonDecreasing_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil).
      simpl; unfold ann_le; simpl; negb_p. unfold sseq_eq; negb_p.
      rewrite simple_err; simpl. auto.
   Defined.
   
   Lemma leftOpNonDecreasing_comp : LeftOpNonDecreasing_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil).
      simpl; unfold ann_le; simpl; negb_p. unfold sseq_eq; negb_p.
      rewrite simple_err; simpl. auto.
   Defined.
   
   (* always irrelevant *)
   Lemma selectiveOpNonDecreasing : SelectiveOpNonDecreasing simpleSeqOrderSemigroup.
   Proof. intros idem.
      destruct (SimpleSeq.isIdempotent_comp A) as [x p].
      assert (h := idem x). toProp; tauto.
   Qed.
   
   Lemma leftOpIncreasing_comp : LeftOpIncreasing_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil).
      simpl; unfold ann_le; simpl; negb_p. unfold sseq_eq; negb_p.
      rewrite simple_err; simpl. auto.
   Defined.
   
   Lemma rightOpIncreasing_comp : RightOpIncreasing_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil).
      simpl; unfold ann_le; simpl; negb_p. unfold sseq_eq; negb_p.
      rewrite simple_err; simpl. auto.
   Defined.
   
   Lemma leftEquivCancelative_comp : LeftEquivCancelative_comp simpleSeqOrderSemigroup.
   Proof. exists nil; exists (err A); exists (err A); simpl; unfold ann_le; simpl.
      unfold sseq_eq; negb_p; simpl. repeat rewrite refl; simpl; auto.
   Defined.
   
   Lemma rightEquivCancelative_comp : RightEquivCancelative_comp simpleSeqOrderSemigroup.
   Proof. exists nil; exists (err A); exists (err A); simpl; unfold ann_le; simpl.
      unfold sseq_eq; negb_p; simpl. repeat rewrite refl; simpl; auto.
   Defined.
   
   Lemma leftEquivCondensed_comp : LeftEquivCondensed_comp simpleSeqOrderSemigroup.
   Proof. exists nil; exists nil; exists (err A); simpl; unfold ann_le; simpl.
      unfold sseq_eq; negb_p; simpl. rewrite refl; simpl; auto.
   Defined.
   
   Lemma rightEquivCondensed_comp : RightEquivCondensed_comp simpleSeqOrderSemigroup.
   Proof. exists nil; exists nil; exists (err A); simpl; unfold ann_le; simpl.
      unfold sseq_eq; negb_p; simpl. rewrite refl; simpl; auto.
   Defined.
   
   (* always irrelevant *)
   Lemma incompArrowUniqueSrc : IncompArrowUniqueSrc simpleSeqOrderSemigroup.
   Proof. intros _ _ _ sel.
      destruct (SimpleSeq.isSelective_comp A) as [x [y p]].
      assert (h := sel x y); toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma incompArrowFactor : IncompArrowFactor simpleSeqOrderSemigroup.
   Proof. intros _ _ _ sel.
      destruct (SimpleSeq.isSelective_comp A) as [x [y p]].
      assert (h := sel x y); toProp; tauto.
   Qed.
   
   (* always irrelevant *)
   Lemma rightChoiceIncrease : RightChoiceIncrease simpleSeqOrderSemigroup.
   Proof. intros idem.
      destruct (SimpleSeq.isIdempotent_comp A) as [x p].
      assert (h := idem x); toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftChoiceIncrease : LeftChoiceIncrease simpleSeqOrderSemigroup.
   Proof. intros idem.
      destruct (SimpleSeq.isIdempotent_comp A) as [x p].
      assert (h := idem x); toProp; tauto.
   Qed.
   
   Lemma rightTotal_comp : RightTotal_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; simpl; unfold ann_le; simpl;
      unfold sseq_eq; simpl. rewrite refl; simpl; auto.
   Defined.
   
   Lemma leftTotal_comp : LeftTotal_comp simpleSeqOrderSemigroup.
   Proof. set (a := choose A); exists nil; exists (a :: nil); exists nil; simpl; unfold ann_le; simpl;
      unfold sseq_eq; simpl. rewrite refl; simpl; auto.
   Defined.
   
   (* always irrelevant *)
   Lemma rightMultChoiseComp : RightMultChoiseComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftMultChoiseComp : LeftMultChoiseComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightLtSwapEquiv : RightLtSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftLtSwapEquiv : LeftLtSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightMultComp : RightMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftMultComp : LeftMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightMultSplitComp : RightMultSplitComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftMultSplitComp : LeftMultSplitComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightLtLeSwapEquiv : RightLtLeSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftLtLeSwapEquiv : LeftLtLeSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.
   
   (* always irrelevant *)
   Lemma rightLtMultComp : RightLtMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftLtMultComp : LeftLtMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.
   
   (* always irrelevant *)
   Lemma rightLeSwapEquiv : RightLeSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftLeSwapEquiv : LeftLeSwapEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightMultPresLtLe : RightMultPresLtLe simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftMultPresLtLe : LeftMultPresLtLe simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.
   
   (* always irrelevant *)
   Lemma rightStrictEquiv : RightStrictEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftStrictEquiv : LeftStrictEquiv simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma rightLeMultComp : RightLeMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct rightTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

   (* always irrelevant *)
   Lemma leftLeMultComp : LeftLeMultComp simpleSeqOrderSemigroup.
   Proof. intros rt.
      destruct leftTotal_comp as [x [y [z p]]].
      assert (h := rt x y z); toProp. tauto.
   Qed.

End SimpleSeq.