Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.Preorders.RightNaturalOrder.

Section RightNaturalOrder.

   Variable S : Semigroup.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.

   Definition rightNaturalOrder :=
      glueOSmg S (rightNaturalOrder S idem) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

   Open Scope Semigroup_scope.
   
   Ltac le_u :=
      simpl in *; unfold rle in *.

   Lemma leftMonotonic : LeftMonotonic rightNaturalOrder.
   Proof. intros a x y; le_u;
      intros h; dseq_f. 
      rewrite (comm a y).
      rewrite (Semigroup.assoc S a x (y + a)).
      rewrite <- (Semigroup.assoc S x y a).
      rewrite h.
      rewrite (comm y a), <- (Semigroup.assoc S a a y), (idem a); auto.
   Defined.
   
   Lemma rightMonotonic : RightMonotonic rightNaturalOrder.
   Proof. intros a x y; le_u;
      intros h; dseq_f; 
      rewrite (comm a y).
      rewrite (Semigroup.assoc S y a (x + y)).
      rewrite <- (Semigroup.assoc S a x y).
      rewrite h.
      rewrite (comm x y).
      rewrite <- (Semigroup.assoc S y y x).
      rewrite (idem y); auto.
   Defined.

   Lemma topIsAnnihilator : TopIsAnnihilator rightNaturalOrder.
   Proof. intros [top p] [ann q]; toProp; simpl in *; le_u; dseq_f.
      split; destruct (q top); auto. apply p.
   Defined.

   Lemma topIsIdentity : IsSingleton S -> TopIsIdentity rightNaturalOrder.
   Proof. intros [a sg] [top p] [id q]; toProp; simpl in *; le_u; dseq_f.
      destruct (q top); split; auto. rewrite (sg (top + id)), (sg id); auto.
   Defined.

   Lemma topIsIdentity_comp : IsSingleton_comp S -> TopIsIdentity_comp rightNaturalOrder.
   Proof. intros sg [top p] [id q]; toProp; simpl in *; le_u; dseq_f. intros [h1 h2].
      destruct (sg top). toProp; elim b. dseq_f. clear b.
      destruct (q top) as [_ h3].
      rewrite h3 in h1.
      destruct (q x) as [h4 h5].
      rewrite <- h5.
      rewrite <- h1.
      apply p.
   Defined.

   Lemma bottomIsIdentity : BottomIsIdentity rightNaturalOrder.
   Proof. intros [bot p] [id q]; toProp; split; le_u; destruct (q bot); dseq_f; auto. apply p. Defined.
   
   Lemma bottomIsAnnihilator : IsSingleton S -> BottomIsAnnihilator rightNaturalOrder.
   Proof. intros [a sa] [bot p] [ann q]; toProp; le_u; dseq_f; simpl in *.
      rewrite (sa bot), (sa ann), (idem a); auto.
   Defined.

   Lemma bottomIsAnnihilator_comp : IsSingleton_comp S -> BottomIsAnnihilator_comp rightNaturalOrder.
   Proof. intros sg [bot p] [ann q]; toProp; simpl in *; le_u; dseq_f. intros [h1 h2].
      destruct (sg bot). toProp; elim b. dseq_f. clear b.
      destruct (q bot) as [h3 _].
      rewrite h3 in h2.
      assert (h4 := p x); dseq_f.
      rewrite <- h4.
      rewrite <- h2.
      destruct (q x); auto.
   Defined.

   Lemma rightOpNonDecreasing : RightOpNonDecreasing rightNaturalOrder.
   Proof. intros x y; simpl in *; le_u. dseq_f. rewrite (comm y x), <- (Semigroup.assoc S x x y), (idem x).
     auto.
   Defined.

   Lemma leftOpNonDecreasing : LeftOpNonDecreasing rightNaturalOrder.
   Proof. intros x y; simpl in *; le_u; dseq_f. rewrite <- (Semigroup.assoc S x x y), (idem x); auto. Defined.

   Lemma selectiveOpNonDecreasing : SelectiveOpNonDecreasing rightNaturalOrder.
   Proof. intros _ _ x y; simpl in *; le_u; dseq_f. apply or_introl. rewrite <- (Semigroup.assoc S x x y), (idem x); auto. Defined.

   Lemma leftOpIncreasing_comp : LeftOpIncreasing_comp rightNaturalOrder.
   Proof. exists (choose S); exists (choose S); le_u; negb_p; toProp;
      dseq_f; repeat rewrite (idem (choose S)); auto.
   Defined.
      
   Lemma rightOpIncreasing_comp : RightOpIncreasing_comp rightNaturalOrder.
   Proof. exists (choose S); exists (choose S); le_u; negb_p; toProp;
      dseq_f; repeat rewrite (idem (choose S)); auto.
   Defined.

   Lemma leftEquivCancelative : IsSingleton S -> LeftEquivCancelative rightNaturalOrder.
   Proof. intros [u sng] a b c _; le_u; negb_p; toProp; dseq_f;
      rewrite (sng a), (sng b), (idem u); auto.
   Defined.
      
   Lemma leftEquivCancelative_comp : IsSingleton_comp S -> LeftEquivCancelative_comp rightNaturalOrder.
   Proof. intros sng; destruct (sng (choose S)) as [b abe]. 
      copy_destruct (@equal S b (choose S + b)).
      exists (choose S); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      rewrite <- ew, <- ew, (idem b), (comm b _), <- ew, (idem b); auto.
      
      exists (b); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f;
      rewrite (idem (choose S + b)), (Semigroup.assoc S (choose S)), (idem b), (idem (choose S + b));
      rewrite (comm _ b), <- (Semigroup.assoc S b), (idem b), (comm b); bool_p;
      rewrite dseq_fold  in abe, ew; rewrite equal_sym in ew; auto. 
   Defined.
   
   Lemma rightEquivCancelative : IsSingleton S -> RightEquivCancelative rightNaturalOrder.
   Proof. intros [u sng] a b c _; le_u; negb_p; toProp; dseq_f;
      rewrite (sng a), (sng b), (idem u); auto.
   Defined.
      
   Lemma rightEquivCancelative_comp : IsSingleton_comp S -> RightEquivCancelative_comp rightNaturalOrder.
   Proof. intros sng; destruct (sng (choose S)) as [b abe]. 
      copy_destruct (@equal S b (choose S + b)).
      exists (choose S); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      rewrite <- ew, <- ew, (idem b), (idem b), (comm b _), <- ew; auto.
      
      exists (b); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      repeat (progress (
      try rewrite (comm b);
      try rewrite (Semigroup.assoc S (choose S));
      try rewrite (Semigroup.assoc S b);
      try rewrite (idem b);
      try rewrite (idem (choose S))
      )).

      repeat (progress (
      try rewrite (comm b);
      try rewrite <- (Semigroup.assoc S (choose S));
      try rewrite <- (Semigroup.assoc S b);
      try rewrite (idem b);
      try rewrite (idem (choose S))
      )).
      
      rewrite equal_sym_b in ew; bool_p; toProp. auto.
   Defined.
   
   Lemma leftEquivCondensed : LeftCondensed S -> LeftEquivCondensed rightNaturalOrder.
   Proof. intros lc a b c; le_u; rewrite (lc a b c), (idem (a + c)); auto. Defined.
   
   Lemma leftEquivCondensed_comp : LeftCondensed_comp S -> LeftEquivCondensed_comp rightNaturalOrder.
   Proof. intros [a [b [c lc]]]; 
      exists a; exists b; exists c; le_u; negb_p; toProp;
      copy_destruct (@equal S (a + b + (a + c)) (a + b));
      [ dseq_f; rewrite (comm (a + c)), ew; auto
      | bool_p; auto ].
      apply or_intror; intros h; elim ew; dseq_f. rewrite (comm (a + b) (a + c)); auto.
   Defined.

   Lemma rightEquivCondensed : RightCondensed S -> RightEquivCondensed rightNaturalOrder.
   Proof. intros lc a b c; le_u; rewrite (lc a b c), (idem (c + a)); auto. Defined.

   Lemma rightEquivCondensed_comp : RightCondensed_comp S -> RightEquivCondensed_comp rightNaturalOrder.
   Proof. intros [a [b [c lc]]]; 
      exists a; exists b; exists c; le_u; negb_p; toProp.
      copy_destruct (@equal S (b + a + (c + a)) (b + a));
      [ dseq_f; rewrite (comm (c + a)), ew; auto
      | bool_p; auto ].
      apply or_intror; intros h; elim ew; dseq_f. rewrite (comm (b + a) (c + a)); auto.
   Defined.

   (* Always irrelevant *)
   Lemma incompArrowUniqueSrc : IncompArrowUniqueSrc rightNaturalOrder.
   Proof. intros lmon rmon antisym sel x y z. toProp; simpl. unfold rle; dseq_f.
      intros [p1 p2] p3 p4 [p5 p6].
      assert (False) as e1; [|elim e1]. auto.
   Qed.
   
   (* Always irrelevant *)
   Lemma incompArrowFactor : IncompArrowFactor rightNaturalOrder.
   Proof. intros lmon rmon antisym sel x y z. toProp; simpl. unfold le; dseq_f.
      intros [p1 p2] p3 p4 [p5 p6].
      assert (False) as e1; [|elim e1]. auto.
   Qed.

   Lemma rightChoiceIncrease : RightChoiceIncrease rightNaturalOrder.
   Proof. intros _ x y. auto. Qed.

   Lemma leftChoiceIncrease : LeftChoiceIncrease rightNaturalOrder.
   Proof. intros _ x y. auto. simpl; unfold rle; simpl. dseq_f; intros h; rewrite (comm y x), h; auto. Qed.

   Lemma rightTotal : TreeGlb S -> RightTotal rightNaturalOrder.
   Proof. intros tg z x y; simpl; unfold rle; simpl; dseq_f.
      rewrite (Semigroup.assoc S x z (y + z)).
      rewrite <- (Semigroup.assoc S z y z).
      rewrite (comm z y).
      rewrite (Semigroup.assoc S y z z).
      rewrite (idem z).
      rewrite (Semigroup.assoc S y z (x + z)).
      rewrite <- (Semigroup.assoc S z x z).
      rewrite (comm z x).
      rewrite (Semigroup.assoc S x z z).
      rewrite (idem z).
      rewrite <- (Semigroup.assoc S x y z).
      rewrite <- (Semigroup.assoc S y x z).
      rewrite (comm y x).
      destruct (tg comm idem x y z); auto.
   Qed.
   
   Lemma rightTotal_comp : TreeGlb_comp S -> RightTotal_comp rightNaturalOrder.
   Proof. intros [x [y [z [p1 p2]]]]; auto.
      exists z; exists x; exists y; simpl. unfold rle; simpl.
      rewrite (Semigroup.assoc S x z (y + z)).
      rewrite <- (Semigroup.assoc S z y z).
      rewrite (comm z y).
      rewrite (Semigroup.assoc S y z z).
      rewrite (idem z).
      rewrite (Semigroup.assoc S y z (x + z)).
      rewrite <- (Semigroup.assoc S z x z).
      rewrite (comm z x).
      rewrite (Semigroup.assoc S x z z).
      rewrite (idem z).
      rewrite <- (Semigroup.assoc S x y z).
      rewrite <- (Semigroup.assoc S y x z).
      rewrite (comm y x); auto.
   Defined.

   Lemma leftTotal : TreeGlb S -> LeftTotal rightNaturalOrder.
   Proof. intros tg z x y; simpl; unfold rle; simpl; dseq_f.
      rewrite (Semigroup.assoc S z x (z + y)).
      rewrite <- (Semigroup.assoc S x z y).
      rewrite (comm x z).
      rewrite (Semigroup.assoc S z x y).
      rewrite <- (Semigroup.assoc S z z (x + y)).
      rewrite (idem z).

      rewrite (Semigroup.assoc S z y (z + x)).
      rewrite <- (Semigroup.assoc S y z x).
      rewrite (comm y z).
      rewrite (Semigroup.assoc S z y x).
      rewrite <- (Semigroup.assoc S z z (y + x)).
      rewrite (idem z).

      rewrite (comm y x).
      rewrite (comm z x), (comm z y), (comm z (x + y)).
      destruct (tg comm idem x y z); auto.
   Qed.

   Lemma leftTotal_comp : TreeGlb_comp S -> LeftTotal_comp rightNaturalOrder.
   Proof. intros [x [y [z [p1 p2]]]]; auto.
      exists z; exists x; exists y; simpl. unfold rle; simpl.
      rewrite (Semigroup.assoc S z x (z + y)).
      rewrite <- (Semigroup.assoc S x z y).
      rewrite (comm x z).
      rewrite (Semigroup.assoc S z x y).
      rewrite <- (Semigroup.assoc S z z (x + y)).
      rewrite (idem z).

      rewrite (Semigroup.assoc S z y (z + x)).
      rewrite <- (Semigroup.assoc S y z x).
      rewrite (comm y z).
      rewrite (Semigroup.assoc S z y x).
      rewrite <- (Semigroup.assoc S z z (y + x)).
      rewrite (idem z).

      rewrite (comm y x).
      toProp; dseq_f.
      rewrite (comm z x), (comm z y), (comm z (x + y)).
      auto.
   Defined.
   
   Lemma rightMultChoiseComp : IsSelective S -> RightMultChoiseComp rightNaturalOrder.
   Proof. intros sel _ x y z w; simpl in *; unfold rle in *; simpl in *.
      toProp; intros _ _; dseq_f.
      destruct (sel (y + w) (x + z)) as [p|p]; auto.
      rewrite (comm (y + w) (x + z)) in p; auto.
   Qed.

   Lemma rightMultChoiseComp_comp : IsSelective_comp S -> RightMultChoiseComp_comp rightNaturalOrder.
   Proof. intros [x [y p]] rt.
      exists x; exists y; exists x; exists y; simpl; unfold rle; simpl.
      toProp; dseq_f. split.
      
      rewrite (idem x).
      rewrite (Semigroup.assoc S y x x). rewrite (idem x).
      rewrite (comm y x). 
      rewrite <- (Semigroup.assoc S x x y).
      rewrite (idem x).
      destruct p; auto.
      
      split.
      rewrite (idem y).
      rewrite (Semigroup.assoc S x y y). rewrite (idem y).
      rewrite (comm x y). 
      rewrite <- (Semigroup.assoc S y y x).
      rewrite (idem y).
      rewrite (comm y x). 
      destruct p; auto.
      
      rewrite (idem x), (idem y), (comm y x).
      tauto.
   Defined.

   Lemma leftMultChoiseComp : IsSelective S -> LeftMultChoiseComp rightNaturalOrder.
   Proof. intros sel _ x y z w; simpl in *; unfold rle in *; simpl in *.
      toProp; intros _ _; dseq_f.
      destruct (sel (w + y) (z + x)) as [p|p]; auto.
      rewrite (comm (w + y) (z + x)) in p; auto.
   Qed.

   Lemma leftMultChoiseComp_comp : IsSelective_comp S -> LeftMultChoiseComp_comp rightNaturalOrder.
   Proof. intros [x [y p]] rt.
      exists x; exists y; exists x; exists y; simpl; unfold rle; simpl.
      toProp; dseq_f. split.
      
      rewrite (idem x).
      rewrite (comm x y).
      rewrite (Semigroup.assoc S y x x). rewrite (idem x).
      rewrite (comm y x). 
      rewrite <- (Semigroup.assoc S x x y).
      rewrite (idem x).
      destruct p; auto.
      
      split.
      rewrite (idem y).
      rewrite (comm y x).
      rewrite (Semigroup.assoc S x y y). rewrite (idem y).
      rewrite (comm x y). 
      rewrite <- (Semigroup.assoc S y y x).
      rewrite (idem y).
      rewrite (comm y x). 
      destruct p; auto.
      
      rewrite (idem x), (idem y), (comm y x).
      tauto.
   Defined.

End RightNaturalOrder.
