Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.Semigroups.Product.
Require Import Metarouting.Constructions.Preorders.Lex.
Require Import Coq.Bool.Bool.

Section Lex.

   Variable A B : OrderSemigroup.
   
   Definition lexOrderSemigroup :=
      glueOSmg (prodSemigroup A B) (lexPreorder A B) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************)
   (*                     Properties                        *)
   (*********************************************************)
   
   Lemma singA_OSmgIso : IsSingleton A -> OSmgIso lexOrderSemigroup B.
   Proof. intros sgA; split with (singA_DsIso B sgA). 
      destruct sgA as [a sg]; split; simpl.
      intros [x1 x2] [y1 y2]; dseq_u; simpl; dseq_f; auto.
      intros x y; unfold dseq; simpl; rewrite (sg (op A a a)); toProp; dseq_f. auto.
      intros [x1 x2] [y1 y2]; simpl. rewrite (sg x1), (sg y1), le_refl; simpl; auto.
      intros x y; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma singB_OSmgIso : IsSingleton B -> OSmgIso lexOrderSemigroup A.
   Proof. intros sgB; split with (singB_DsIso A sgB). 
      destruct sgB as [b sg]; split; simpl.
      intros [x1 x2] [y1 y2]; dseq_u; simpl; dseq_f; auto.
      intros x y; unfold dseq; simpl; rewrite (sg (op B b b)); toProp; dseq_f. auto.
      intros [x1 x2] [y1 y2]; simpl. rewrite (sg x2), (sg y2), le_refl, orb_true_r, andb_true_r; auto.
      intros x y; rewrite le_refl, orb_true_r, andb_true_r; simpl; auto.
   Defined.

   Open Scope OrderSemigroup_scope.
   
   Lemma leftMonotonic : 
       LeftMonotonic A * LeftMonotonic B * (LeftEquivCancelative A + LeftEquivCondensed B) 
       -> LeftMonotonic lexOrderSemigroup.
   Proof. intros [[la lb] [lca |lcb]] [x1 x2] [y1 y2] [z1 z2]; simpl; toProp;
      intros [p [q|q]]; split.
      apply la; auto.
      apply or_introl; intros h; apply q. red in lca.
      destruct (lca z1 y1 x1) as [w|w]; toProp.
         split; auto; apply la; auto.
         destruct w; auto. tauto.
      apply la; auto.
      apply or_intror; apply lb; auto.
      
      apply la; auto.
      apply or_intror; assert (h := lcb x2 y2 z2); toProp; destruct h; auto.
      apply la; auto.
      apply or_intror; assert (h := lcb x2 y2 z2); toProp; destruct h; auto.
   Defined.

   Lemma leftMonotonic_comp : 
      LeftMonotonic_comp A + LeftMonotonic_comp B + (LeftEquivCancelative_comp A * LeftEquivCondensed_comp B)
       -> LeftMonotonic_comp lexOrderSemigroup.
   Proof. intros [[[x1 [y1 [z1 [p1 p2]]]] | [x2 [y2 [z2 [p1 p2]]]]] 
                  | [[x1 [y1 [z1 [p1 [p2 p3]]]]] [x2 [y2 [z2 q]]]]].

      exists (x1, choose B); exists (y1, choose B); exists (z1, choose B);
      simpl; toProp; do 2 rewrite le_refl; split; [ auto | intros [h _]; auto ].

      exists (choose A, x2); exists (choose A, y2); exists (choose A, z2);
      simpl; toProp; do 2 rewrite le_refl; split; [ auto | intros [h [h' | h']]; auto ].

      rewrite negb_andb in *; do 2 rewrite negb_involutive in *; toProp; destruct p1 as [p1 p1'];
      copy_destruct (x1 <= y1) as xy1; rewrite xy1 in p2;
      copy_destruct (x2 + y2 <= x2 + z2) as xyz2; rewrite xyz2 in q;
      [ exists (z1, x2); exists (x1, z2); exists (y1, y2)
      | exists (z1, x2); exists (x1, y2); exists (y1, z2)
      | exists (z1, x2); exists (y1, z2); exists (x1, y2)
      | exists (z1, x2); exists (y1, y2); exists (x1, z2) ];
      simpl; toProp; dseq_f; destruct p2; destruct q; bool_p; try tauto.
   Defined.

   Lemma rightMonotonic : 
       RightMonotonic A * RightMonotonic B * (RightEquivCancelative A + RightEquivCondensed B) 
       -> RightMonotonic lexOrderSemigroup.
   Proof. intros [[la lb] [lca |lcb]] [x1 x2] [y1 y2] [z1 z2]; simpl; toProp;
      intros [p [q|q]]; split.
      apply la; auto.
      apply or_introl; intros h; apply q. red in lca.
      destruct (lca y1 x1 z1) as [w|w]; toProp.
         split; auto; apply la; auto.
         destruct w; auto. tauto.
      apply la; auto.
      apply or_intror; apply lb; auto.
      
      apply la; auto.
      apply or_intror; assert (h := lcb z2 y2 x2); toProp; destruct h; auto.
      apply la; auto.
      apply or_intror; assert (h := lcb z2 y2 x2); toProp; destruct h; auto.
   Defined.

   Lemma rightMonotonic_comp : 
      RightMonotonic_comp A + RightMonotonic_comp B + (RightEquivCancelative_comp A * RightEquivCondensed_comp B)
       -> RightMonotonic_comp lexOrderSemigroup.
   Proof.
      intros [[[x1 [y1 [z1 [p1 p2]]]] | [x2 [y2 [z2 [p1 p2]]]]] 
                  | [[x1 [y1 [z1 [p1 [p2 p3]]]]] [x2 [y2 [z2 q]]]]].

      exists (x1, choose B); exists (y1, choose B); exists (z1, choose B);
      simpl; toProp; do 2 rewrite le_refl; split; [ auto | intros [h _]; auto ].

      exists (choose A, x2); exists (choose A, y2); exists (choose A, z2);
      simpl; toProp; do 2 rewrite le_refl; split; [ auto | intros [h [h' | h']]; auto ].

      rewrite negb_andb in *; do 2 rewrite negb_involutive in *; toProp; destruct p1 as [p1 p1'];
      copy_destruct (x1 <= y1) as xy1; rewrite xy1 in p2;
      copy_destruct (y2 + x2 <= z2 + x2) as xyz2; rewrite xyz2 in q;
      [ exists (x1, z2); exists (y1, y2); exists (z1, x2)
      | exists (x1, y2); exists (y1, z2); exists (z1, x2)
      | exists (y1, z2); exists (x1, y2); exists (z1, x2)
      | exists (y1, y2); exists (x1, z2); exists (z1, x2) ];
      simpl; toProp; dseq_f; destruct p2; destruct q; bool_p; try tauto.
   Defined.

   Lemma hasIdentity_back_a : HasIdentity lexOrderSemigroup -> HasIdentity A.
   Proof. intros [[a b] p]; exists a; intros x; assert (h := p (x, choose B)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.
   
   Lemma hasIdentity_back_b : HasIdentity lexOrderSemigroup -> HasIdentity B.
   Proof. intros [[a b] p]; exists b; intros x; assert (h := p (choose A, x)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.

   Lemma hasAnnihilator_back_a : HasAnnihilator lexOrderSemigroup -> HasAnnihilator A.
   Proof. intros [[a b] p]; exists a; intros x; assert (h := p (x, choose B)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.
   
   Lemma hasAnnihilator_back_b : HasAnnihilator lexOrderSemigroup -> HasAnnihilator B.
   Proof. intros [[a b] p]; exists b; intros x; assert (h := p (choose A, x)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.

   Lemma hasTop_back_a : HasTop lexOrderSemigroup -> HasTop A.
   Proof. intros [[a b] p]; exists a; intros x; assert (h := p (x, choose B)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.

   Lemma hasTop_back_b : HasTop lexOrderSemigroup -> HasTop B.
   Proof. intros [[a b] p]; exists b; intros x; assert (h := p (a, x)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. rewrite le_refl in h. bool_p; tauto.
   Defined.

   Lemma hasBottom_back_a : HasBottom lexOrderSemigroup -> HasBottom A.
   Proof. intros [[a b] p]; exists a; intros x; assert (h := p (x, choose B)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. tauto.
   Defined.

   Lemma hasBottom_back_b : HasBottom lexOrderSemigroup -> HasBottom B.
   Proof. intros [[a b] p]; exists b; intros x; assert (h := p (a, x)); simpl in *.
      dseq_u; simpl in *; toProp; dseq_f. rewrite le_refl in h. bool_p; tauto.
   Defined.

   Lemma topIsIdentity : TopIsIdentity A * TopIsIdentity B -> TopIsIdentity lexOrderSemigroup.
   Proof. intros [tia tib] hTop hId.
      set (hTopA := hasTop_back_a hTop).
      set (hTopB := hasTop_back_b hTop).
      set (hIdA := hasIdentity_back_a hId).
      set (hIdB := hasIdentity_back_b hId).
      assert (p := tia hTopA hIdA).
      assert (q := tib hTopB hIdB).
      destruct hTop as [[a b] p1];
      destruct hId as [[c d] p2];
      simpl in *. clear hTopA hTopB hIdA hIdB.
      toProp; tauto.
   Defined.

   Lemma topIsIdentity_comp : TopIsIdentity_comp A + TopIsIdentity_comp B -> TopIsIdentity_comp lexOrderSemigroup.
   Proof. intros [tia | tib] hTop hId;
      set (hTopA := hasTop_back_a hTop);
      set (hTopB := hasTop_back_b hTop);
      set (hIdA := hasIdentity_back_a hId);
      set (hIdB := hasIdentity_back_b hId).

      assert (p := tia hTopA hIdA); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp; tauto.

      assert (p := tib hTopB hIdB); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp.
      destruct (c <= a); destruct (a <= c); simpl in *; bool_p; tauto.
   Defined.

   Lemma topIsAnnihilator : TopIsAnnihilator A * TopIsAnnihilator B -> TopIsAnnihilator lexOrderSemigroup.
   Proof. intros [tia tib] hTop hId.
      set (hTopA := hasTop_back_a hTop).
      set (hTopB := hasTop_back_b hTop).
      set (hIdA := hasAnnihilator_back_a hId).
      set (hIdB := hasAnnihilator_back_b hId).
      assert (p := tia hTopA hIdA).
      assert (q := tib hTopB hIdB).
      destruct hTop as [[a b] p1];
      destruct hId as [[c d] p2];
      simpl in *. clear hTopA hTopB hIdA hIdB.
      toProp; tauto.
   Defined.

   Lemma topIsAnnihilator_comp : TopIsAnnihilator_comp A + TopIsAnnihilator_comp B -> TopIsAnnihilator_comp lexOrderSemigroup.
   Proof. intros [tia | tib] hTop hId;
      set (hTopA := hasTop_back_a hTop);
      set (hTopB := hasTop_back_b hTop);
      set (hIdA := hasAnnihilator_back_a hId);
      set (hIdB := hasAnnihilator_back_b hId).

      assert (p := tia hTopA hIdA); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp; tauto.

      assert (p := tib hTopB hIdB); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp.
      destruct (c <= a); destruct (a <= c); simpl in *; bool_p; tauto.
   Defined.

   Lemma bottomIsIdentity : BottomIsIdentity A * BottomIsIdentity B -> BottomIsIdentity lexOrderSemigroup.
   Proof. intros [tia tib] hTop hId.
      set (hTopA := hasBottom_back_a hTop).
      set (hTopB := hasBottom_back_b hTop).
      set (hIdA := hasIdentity_back_a hId).
      set (hIdB := hasIdentity_back_b hId).
      assert (p := tia hTopA hIdA).
      assert (q := tib hTopB hIdB).
      destruct hTop as [[a b] p1];
      destruct hId as [[c d] p2];
      simpl in *. clear hTopA hTopB hIdA hIdB.
      toProp; tauto.
   Defined.

   Lemma bottomIsIdentity_comp : BottomIsIdentity_comp A + BottomIsIdentity_comp B -> BottomIsIdentity_comp lexOrderSemigroup.
   Proof. intros [tia | tib] hTop hId;
      set (hTopA := hasBottom_back_a hTop);
      set (hTopB := hasBottom_back_b hTop);
      set (hIdA := hasIdentity_back_a hId);
      set (hIdB := hasIdentity_back_b hId).

      assert (p := tia hTopA hIdA); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp; tauto.

      assert (p := tib hTopB hIdB); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp.
      destruct (c <= a); destruct (a <= c); simpl in *; bool_p; tauto.
   Defined.

   Lemma bottomIsAnnihilator : BottomIsAnnihilator A * BottomIsAnnihilator B -> BottomIsAnnihilator lexOrderSemigroup.
   Proof. intros [tia tib] hTop hId.
      set (hTopA := hasBottom_back_a hTop).
      set (hTopB := hasBottom_back_b hTop).
      set (hIdA := hasAnnihilator_back_a hId).
      set (hIdB := hasAnnihilator_back_b hId).
      assert (p := tia hTopA hIdA).
      assert (q := tib hTopB hIdB).
      destruct hTop as [[a b] p1];
      destruct hId as [[c d] p2];
      simpl in *. clear hTopA hTopB hIdA hIdB.
      toProp; tauto.
   Defined.

   Lemma bottomIsAnnihilator_comp : BottomIsAnnihilator_comp A + BottomIsAnnihilator_comp B -> BottomIsAnnihilator_comp lexOrderSemigroup.
   Proof. intros [tia | tib] hTop hId;
      set (hTopA := hasBottom_back_a hTop);
      set (hTopB := hasBottom_back_b hTop);
      set (hIdA := hasAnnihilator_back_a hId);
      set (hIdB := hasAnnihilator_back_b hId).

      assert (p := tia hTopA hIdA); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp; tauto.

      assert (p := tib hTopB hIdB); negb_p.
      destruct hTop as [[a b] p1]; destruct hId as [[c d] p2]; simpl in *;
      clear hTopA hTopB hIdA hIdB; toProp.
      destruct (c <= a); destruct (a <= c); simpl in *; bool_p; tauto.
   Defined.
   
   Lemma leftOpNonDecreasing : LeftOpIncreasing A + LeftOpNonDecreasing A * LeftOpNonDecreasing B -> LeftOpNonDecreasing lexOrderSemigroup.
   Proof. intros [lia | [lnda lndb]] [x1 x2] [y1 y2]; simpl; toProp;
      [ assert (q := lia x1 y1); toProp; destruct q; intuition
      | auto ].
   Defined.
   
   Lemma leftOpNonDecreasing_comp : LeftOpIncreasing_comp A * (LeftOpNonDecreasing_comp A + LeftOpNonDecreasing_comp B) -> LeftOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros [[a [b lia]] [[x [y q]]|[x [y q]]]];
      [ exists (x, choose B); exists (y, choose B)
      | exists (a, x); exists (b, y) ];
      simpl; negb_p; toProp; tauto.
   Defined.

   Lemma rightOpNonDecreasing : RightOpIncreasing A + (RightOpNonDecreasing A * RightOpNonDecreasing B) -> RightOpNonDecreasing lexOrderSemigroup.
   Proof. intros [lia | [lnda lndb]] [x1 x2] [y1 y2]; simpl; toProp;
      [ assert (q := lia x1 y1); toProp; destruct q; intuition
      | auto ].
   Defined.
   
   Lemma rightOpNonDecreasing_comp : RightOpIncreasing_comp A * (RightOpNonDecreasing_comp A + RightOpNonDecreasing_comp B) -> RightOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros [[a [b lia]] [[x [y q]]|[x [y q]]]];
      [ exists (x, choose B); exists (y, choose B)
      | exists (a, x); exists (b, y) ];
      simpl; negb_p; toProp; tauto.
   Defined.

   Lemma lmon_back_a : LeftMonotonic lexOrderSemigroup -> LeftMonotonic A.
   Proof. intros lmon x y z p.
      set (b := choose B).
      assert (h := lmon (x, b) (y, b) (z, b)). simpl in h.
      repeat rewrite le_refl in h; simpl in h.
      repeat rewrite orb_true_r in h; simpl in h.
      repeat rewrite andb_true_r in h; simpl in h.
      auto.
   Qed.

   Lemma lmon_back_b : LeftMonotonic lexOrderSemigroup -> LeftMonotonic B.
   Proof. intros lmon x y z p.
      set (a := choose A).
      assert (h := lmon (a, x) (a, y) (a, z)). simpl in h.
      repeat rewrite le_refl in h; simpl in h. auto.
   Qed.
   
   Lemma rmon_back_a : RightMonotonic lexOrderSemigroup -> RightMonotonic A.
   Proof. intros lmon x y z p.
      set (b := choose B).
      assert (h := lmon (x, b) (y, b) (z, b)). simpl in h.
      repeat rewrite le_refl in h; simpl in h.
      repeat rewrite orb_true_r in h; simpl in h.
      repeat rewrite andb_true_r in h; simpl in h.
      auto.
   Qed.

   Lemma rmon_back_b : RightMonotonic lexOrderSemigroup -> RightMonotonic B.
   Proof. intros lmon x y z p.
      set (a := choose A).
      assert (h := lmon (a, x) (a, y) (a, z)). simpl in h.
      repeat rewrite le_refl in h; simpl in h. auto.
   Qed.
   
   Lemma antisym_back_a : Antisym lexOrderSemigroup -> Antisym A.
   Proof. intros antisym x y [p1 p2].
      set (b := choose B).
      assert (h := antisym (x, b) (y, b)); simpl in h.
      repeat rewrite le_refl in h; simpl in h.
      repeat rewrite orb_true_r in h; simpl in h.
      repeat rewrite andb_true_r in h; simpl in h.
      dseq_u; simpl in *. rewrite refl in h; rewrite andb_true_r in h; dseq_f.
      apply h; auto.
   Qed.

   Lemma antisym_back_b : Antisym lexOrderSemigroup -> Antisym B.
   Proof. intros antisym x y [p1 p2].
      set (a := choose A).
      assert (h := antisym (a, x) (a, y)); simpl in h.
      repeat rewrite le_refl in h; simpl in h.
      dseq_u; simpl in *; toProp; tauto.
   Qed.
   
   Lemma sel_back_a : IsSelective lexOrderSemigroup -> IsSelective A.
   Proof. intros sel x y.
      set (b := choose B).
      assert (h := sel (x, b) (y, b)); simpl in h.
      destruct h as [h|h]; dseq_u; simpl in h; toProp; simpl; dseq_f; tauto.
   Qed.

   Lemma sel_back_b : IsSelective lexOrderSemigroup -> IsSelective B.
   Proof. intros sel x y.
      set (a := choose A).
      assert (h := sel (a, x) (a, y)); simpl in h.
      destruct h as [h|h]; dseq_u; simpl in h; toProp; simpl; dseq_f; tauto.
   Qed.

   Lemma idem_back_a : IsIdempotent lexOrderSemigroup -> IsIdempotent A.
   Proof. intros idem x.
      set (b := choose B).
      assert (h := idem (x, b)); simpl in h. dseq_u; simpl in *; toProp; tauto.
   Qed.

   Lemma idem_back_b : IsIdempotent lexOrderSemigroup -> IsIdempotent B.
   Proof. intros idem x.
      set (a := choose A).
      assert (h := idem (a, x)); simpl in h. dseq_u; simpl in *; toProp; tauto.
   Qed.
   
   Lemma rightChoiceIncrease : RightChoiceIncrease A * RightChoiceIncrease B -> RightChoiceIncrease lexOrderSemigroup.
   Proof. intros [rcia rcib] idem [x1 x2] [y1 y2]; dseq_u; simpl; toProp; dseq_f.
      intros [p1 p2]. 
      assert (r1 := rcia (idem_back_a idem));
      assert (r2 := rcib (idem_back_b idem)).
      split; auto.
   Qed.

   Lemma rightChoiceIncrease_comp : RightChoiceIncrease_comp A + RightChoiceIncrease_comp B -> RightChoiceIncrease_comp lexOrderSemigroup.
   Proof. intros [rci|rci] idem.
      destruct (rci (idem_back_a idem)) as [x [y p]].
      set (b := choose B).
      exists (x, b); exists (y, b); simpl. dseq_u; negb_p; simpl; toProp; dseq_f.
      assert (b + b == b) as e1.
         rewrite (idem_back_b idem b); auto.
      tauto.

      destruct (rci (idem_back_b idem)) as [x [y p]].
      set (a := choose A).
      exists (a, x); exists (a, y); simpl. dseq_u; negb_p; simpl; toProp; dseq_f.
      assert (a + a == a) as e1.
         rewrite (idem_back_a idem a); auto.
      rewrite le_refl; bool_p.
      tauto.
   Defined.

   Lemma leftChoiceIncrease : LeftChoiceIncrease A * LeftChoiceIncrease B -> LeftChoiceIncrease lexOrderSemigroup.
   Proof. intros [rcia rcib] idem [x1 x2] [y1 y2]; dseq_u; simpl; toProp; dseq_f.
      intros [p1 p2]. 
      assert (r1 := rcia (idem_back_a idem));
      assert (r2 := rcib (idem_back_b idem)).
      split; auto.
   Qed.

   Lemma leftChoiceIncrease_comp : LeftChoiceIncrease_comp A + LeftChoiceIncrease_comp B -> LeftChoiceIncrease_comp lexOrderSemigroup.
   Proof. intros [rci|rci] idem.
      destruct (rci (idem_back_a idem)) as [x [y p]].
      set (b := choose B).
      exists (x, b); exists (y, b); simpl. dseq_u; negb_p; simpl; toProp; dseq_f.
      assert (b + b == b) as e1.
         rewrite (idem_back_b idem b); auto.
      tauto.

      destruct (rci (idem_back_b idem)) as [x [y p]].
      set (a := choose A).
      exists (a, x); exists (a, y); simpl. dseq_u; negb_p; simpl; toProp; dseq_f.
      assert (a + a == a) as e1.
         rewrite (idem_back_a idem a); auto.
      rewrite le_refl; bool_p.
      tauto.
   Defined.

   Lemma sond_CE_1 : SelectiveOpNonDecreasing_comp A ->
                     SelectiveOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros sond idem antisym; destruct (sond (idem_back_a idem) (antisym_back_a antisym)) as [x [y p]].
      set (b := choose B).
      exists (x, b); exists (y, b); simpl.
      assert (b <= b + b) as e1.
         rewrite (idem_back_b idem b), le_refl; auto.
      rewrite e1; negb_p; toProp; dseq_f; bool_p. tauto.
   Defined.
   
   Lemma sond_CE_2 : SelectiveOpNonDecreasing_comp B -> 
                     SelectiveOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros sond idem antisym; destruct (sond (idem_back_b idem) (antisym_back_b antisym)) as [x [y p]].
      set (a := choose A).
      exists (a, x); exists (a, y); simpl.
      assert (a <= a + a) as e1.
         rewrite (idem_back_a idem a), le_refl; auto.
      assert (a + a <= a) as e2.
         rewrite (idem_back_a idem a), le_refl; auto.
      rewrite e1, e2; simpl; toProp. tauto.
   Defined.
   
   Lemma sond_CE_3 : SelectiveOpNonDecreasing A -> SelectiveOpNonDecreasing B ->
                     RightChoiceIncrease_comp A ->
                     RightOpNonDecreasing_comp B -> 
                     SelectiveOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros sonda sondb rci [x2 [y2 p]] idem antisym;
      destruct (rci (idem_back_a idem)) as [x1 [y1 [ar1 ar2]]].
      exists (x1, y2); exists (y1, x2); simpl. negb_p. toBool.
      assert (forall a b c d e f, (a || b && c) && (d || e && f) =
                 a && d || a && e && f || b && c && d || b && c && e && f) as e1.
         intros [|] [|] [|] [|] [|] [|]; auto.
      rewrite e1; clear e1.
      rewrite p; simpl.
      toProp. apply or_introl. apply or_introl. apply or_intror.
      split; auto; split; rewrite ar1; auto.
   Defined.
   
   Lemma sond_CE_4 : SelectiveOpNonDecreasing A -> SelectiveOpNonDecreasing B ->
                     LeftChoiceIncrease_comp A ->
                     LeftOpNonDecreasing_comp B -> 
                     SelectiveOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros sonda sondb lci [x2 [y2 p]] idem antisym;
      destruct (lci (idem_back_a idem)) as [x1 [y1 [ar1 ar2]]].
      exists (x1, x2); exists (y1, y2); simpl. negb_p. toBool.
      assert (forall a b c d e f, (a || b && c) && (d || e && f) =
                 a && d || a && e && f || b && c && d || b && c && e && f) as e1.
         intros [|] [|] [|] [|] [|] [|]; auto.
      rewrite e1; clear e1.
      rewrite p; simpl.
      toProp. apply or_introl. apply or_intror.
      split; auto. split; auto. rewrite ar1; auto. rewrite ar1; auto.
   Defined.

   Lemma selectiveOpNonDecreasing :
         SelectiveOpNonDecreasing A * SelectiveOpNonDecreasing B *
         (SelectiveOpNonDecreasing_comp A + SelectiveOpNonDecreasing_comp B +
           ((RightChoiceIncrease A + RightOpNonDecreasing B) *
            (LeftChoiceIncrease A + LeftOpNonDecreasing B)))
         -> SelectiveOpNonDecreasing lexOrderSemigroup.
   Proof. intros [[sonda sondb] [[ce | ce] | [RCI_ROND LCI_LOND]]] idem antisym [x1 x2] [y1 y2].
      destruct (ce (idem_back_a idem) (antisym_back_a antisym)) as [x [y p]]; 
      assert (q := sonda (idem_back_a idem) (antisym_back_a antisym) x y); toProp; tauto.

      destruct (ce (idem_back_b idem) (antisym_back_b antisym)) as [x [y p]]; 
      assert (q := sondb (idem_back_b idem) (antisym_back_b antisym) x y); toProp; tauto.

      simpl. toBool.
      assert (forall a b c d e f, (a && (b || c)) || (d && (e || f)) =
                 (a || d) && (a || (e || f)) && (b || (c || d)) && (b || (c || (e || f)))) as h.
         intros [|] [|] [|] [|] [|] [|]; simpl; auto.
      rewrite h; clear h; toProp.
      split. split. split.
      (* SOND *)
      apply (sonda (idem_back_a idem) (antisym_back_a antisym)).
      (* RCI ROND *)
      destruct RCI_ROND as [rci | rond]; [|apply or_intror; apply or_intror; auto].
      assert (h := rci (idem_back_a idem) x1 y1).
      destruct (sonda (idem_back_a idem) (antisym_back_a antisym) x1 y1) as [p|p]; auto.
      copy_destruct (x1 + y1 <= y1); [ dseq_f | bool_p; tauto].
      assert (x1 + y1 == y1) as e1; [apply (antisym_back_a antisym); auto|].
      apply or_introl; rewrite e1; auto.
      (* LCI ROND *)
      destruct LCI_LOND as [lci | lond]; [|apply or_intror; apply or_introl; auto].
      assert (h := lci (idem_back_a idem) x1 y1).
      destruct (sonda (idem_back_a idem) (antisym_back_a antisym) x1 y1) as [p|p]; auto.
      copy_destruct (x1 + y1 <= x1); [ dseq_f | bool_p; tauto].
      assert (x1 + y1 == x1) as e1; [apply (antisym_back_a antisym); auto|].
      apply or_intror; apply or_intror; rewrite e1; auto.
      (* SOND *)
      assert (h := sondb (idem_back_b idem) (antisym_back_b antisym) x2 y2); tauto.
   Qed.

   Lemma selectiveOpNonDecreasing_comp :
         SelectiveOpNonDecreasing_comp A + SelectiveOpNonDecreasing_comp B +
         (SelectiveOpNonDecreasing A * SelectiveOpNonDecreasing B *
           ((RightChoiceIncrease_comp A * RightOpNonDecreasing_comp B) +
            (LeftChoiceIncrease_comp A * LeftOpNonDecreasing_comp B)))
         -> SelectiveOpNonDecreasing_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [[p3 p4] [[p5 p6]|[p7 p8]]]].
      apply sond_CE_1; auto.
      apply sond_CE_2; auto.
      apply sond_CE_3; auto.
      apply sond_CE_4; auto.
   Defined.
      
   Lemma leftOpIncreasing : LeftOpNonDecreasing A * (LeftOpIncreasing A + LeftOpIncreasing B) -> LeftOpIncreasing lexOrderSemigroup.
   Proof. intros [lnda [lia | lib]] [x1 x2] [y1 y2];
      [ assert (p := lia x1 y1) | assert (p := lib x2 y2) ];
      negb_p; toProp; simpl; negb_p; toProp; intuition.
   Defined.
   
   Lemma leftOpIncreasing_comp : LeftOpNonDecreasing_comp A + (LeftOpIncreasing_comp A * LeftOpIncreasing_comp B) -> LeftOpIncreasing_comp lexOrderSemigroup.
   Proof. intros [[a3[a4 lnda]] | [[a1 [a2 lia]] [b1[b2 lib]]]].
      exists (a3, choose B); exists (a4, choose B); simpl; negb_p; toProp; tauto.
      exists (a1, b1); exists (a2, b2); simpl; negb_p; toProp; tauto.
   Defined.

   Lemma rightOpIncreasing : RightOpNonDecreasing A * (RightOpIncreasing A + RightOpIncreasing B) -> RightOpIncreasing lexOrderSemigroup.
   Proof. intros [lnda [lia | lib]] [x1 x2] [y1 y2];
      [ assert (p := lia x1 y1) | assert (p := lib x2 y2) ];
      negb_p; toProp; simpl; negb_p; toProp; intuition.
   Defined.
   
   Lemma rightOpIncreasing_comp : (RightOpNonDecreasing_comp A + (RightOpIncreasing_comp A * RightOpIncreasing_comp B)) -> RightOpIncreasing_comp lexOrderSemigroup.
   Proof. intros [[a3[a4 lnda]] | [[a1 [a2 lia]] [b1[b2 lib]]]].
      exists (a3, choose B); exists (a4, choose B); simpl; negb_p; toProp; tauto.
      exists (a1, b1); exists (a2, b2); simpl; negb_p; toProp; tauto.
   Defined.

   Lemma leftEquivCancelative : LeftEquivCancelative A * LeftEquivCancelative B -> LeftEquivCancelative lexOrderSemigroup.
   Proof. intros [lca lcb] [a1 a2] [b1 b2] [c1 c2] h;
      assert (p := lca a1 b1 c1);
      assert (q := lcb a2 b2 c2);
      simpl in *; negb_p; toProp; tauto.
   Defined.
   
   Lemma leftEquivCancelative_comp : LeftEquivCancelative_comp A + LeftEquivCancelative_comp B -> LeftEquivCancelative_comp lexOrderSemigroup.
   Proof. intros [[a [b [c [q1 q2]]]]| [a [b [c [q1 q2]]]]].
      exists (a, choose B); exists (b, choose B); exists (c, choose B);
      simpl; do 2 rewrite le_refl; negb_p; toProp; bool_p; tauto.
      exists (choose A, a); exists (choose A, b); exists (choose A, c);
      simpl; do 2 rewrite le_refl; negb_p; toProp; bool_p; tauto.
   Defined.

   Lemma rightEquivCancelative : RightEquivCancelative A * RightEquivCancelative B -> RightEquivCancelative lexOrderSemigroup.
   Proof. intros [lca lcb] [a1 a2] [b1 b2] [c1 c2] h;
      assert (p := lca a1 b1 c1);
      assert (q := lcb a2 b2 c2);
      simpl in *; negb_p; toProp; tauto.
   Defined.
   
   Lemma rightEquivCancelative_comp : RightEquivCancelative_comp A + RightEquivCancelative_comp B -> RightEquivCancelative_comp lexOrderSemigroup.
   Proof. intros [[a [b [c [q1 q2]]]]| [a [b [c [q1 q2]]]]].
      exists (a, choose B); exists (b, choose B); exists (c, choose B);
      simpl; do 2 rewrite le_refl; negb_p; toProp; bool_p; tauto.
      exists (choose A, a); exists (choose A, b); exists (choose A, c);
      simpl; do 2 rewrite le_refl; negb_p; toProp; bool_p; tauto.
   Defined.

   Lemma leftEquivCondensed : LeftEquivCondensed A * LeftEquivCondensed B -> LeftEquivCondensed lexOrderSemigroup.
   Proof. intros [lca lcb] [a1 a2] [b1 b2] [c1 c2].
      assert (p := lca a1 b1 c1);
      assert (q := lcb a2 b2 c2);
      simpl in *; negb_p; toProp; tauto.
   Defined.
   
   Lemma leftEquivCondensed_comp : LeftEquivCondensed_comp A + LeftEquivCondensed_comp B -> LeftEquivCondensed_comp lexOrderSemigroup.
   Proof. intros [[a [b [c p]]]|[a [b [c p]]]];
      copy_destruct (a + b <= a + c).
      exists (a, choose B); exists (c, choose B); exists (b, choose B); simpl; negb_p; toProp; tauto.
      exists (a, choose B); exists (b, choose B); exists (c, choose B); simpl; negb_p; toProp; tauto.
      exists (choose A, a); exists (choose A, c); exists (choose A, b); simpl; negb_p; toProp; rewrite le_refl; bool_p; tauto.
      exists (choose A, a); exists (choose A, b); exists (choose A, c); simpl; negb_p; toProp; rewrite le_refl; bool_p; tauto.
   Defined.      

   Lemma rightEquivCondensed : RightEquivCondensed A * RightEquivCondensed B -> RightEquivCondensed lexOrderSemigroup.
   Proof. intros [lca lcb] [a1 a2] [b1 b2] [c1 c2].
      assert (p := lca a1 b1 c1);
      assert (q := lcb a2 b2 c2);
      simpl in *; negb_p; toProp; tauto.
   Defined.
   
   Lemma rightEquivCondensed_comp : RightEquivCondensed_comp A + RightEquivCondensed_comp B -> RightEquivCondensed_comp lexOrderSemigroup.
   Proof. intros [[a [b [c p]]]|[a [b [c p]]]];
      copy_destruct (a + b <= a + c).
      exists (a, choose B); exists (c, choose B); exists (b, choose B); simpl; negb_p; toProp; tauto.
      exists (a, choose B); exists (b, choose B); exists (c, choose B); simpl; negb_p; toProp; tauto.
      exists (choose A, a); exists (choose A, c); exists (choose A, b); simpl; negb_p; toProp; rewrite le_refl; bool_p; tauto.
      exists (choose A, a); exists (choose A, b); exists (choose A, c); simpl; negb_p; toProp; rewrite le_refl; bool_p; tauto.
   Defined.

   Lemma sel_back : IsSelective lexOrderSemigroup ->
                    (IsLeft A + IsLeft_comp A) ->
                    (IsRight A + IsRight_comp A) ->
                    (IsSelective A + IsSelective_comp A) ->
                    (IsSingleton A + IsSingleton_comp A) ->
                    (IsLeft B + IsLeft_comp B) ->
                    (IsRight B + IsRight_comp B) ->
                    (IsSelective B + IsSelective_comp B) ->
                    (IsSingleton B + IsSingleton_comp B) ->
                    (IsLeft A * IsLeft B) +
                    (IsRight A * IsRight B) +
                    (IsSelective A * IsSingleton B) +
                    (IsSingleton A * IsSelective B).
   Proof. intros.
      match goal with |- ?G => set(g := G) end.
      assert (IsSelective_comp lexOrderSemigroup -> g) as h.
         intros [x [y [p1 p2]]]; assert (False) as f; [|elim f]; destruct (H x y) as [q | q]; toProp; dseq_u; tauto.
      assert (p1 := Semigroups.Product.isSelective_comp A B).
      assert (IsSelective_comp (prodSemigroup A B) -> g) as p2.
         intros q; apply h; apply q.
      assert (p3 := fun x => p2 (p1 x)). clear h p1 p2.
      unfold g in *; clear g.
      destruct X; destruct X0; destruct X1; destruct X2;
      destruct X3; destruct X4; destruct X5; destruct X6;
      auto; try (apply p3; auto; fail).
   Defined.
   
   Lemma lexIncomp : Antisym A -> forall (a b : A) (c d : B), 
                              (((a <= b -> False) \/ b <= a /\ (c <= d -> False)) /\ 
                               ((b <= a -> False) \/ a <= b /\ (d <= c -> False))) 
                               <->
                               (a # b \/ (a == b /\ c # d))
                              .
   Proof. intros antisym a b c d. assert (h := antisym a b). toProp. split.
         intros [[p1|p1] [p2|p2]]; try tauto.
         intros [[p1 p2] | [p1 p2]]; try tauto.
         split; apply or_intror; (split; [| tauto]); rewrite p1; auto.
   Qed.

   Lemma incompArrowUniqueSrc : IncompArrowUniqueSrc A * IncompArrowUniqueSrc B
                             * (IsLeft A + IsLeft_comp A)
                             * (IsRight A + IsRight_comp A)
                             * (IsSelective A + IsSelective_comp A)
                             * (IsSingleton A + IsSingleton_comp A)
                             * (IsLeft B + IsLeft_comp B)
                             * (IsRight B + IsRight_comp B)
                             * (IsSelective B + IsSelective_comp B)
                             * (IsSingleton B + IsSingleton_comp B)
                             -> IncompArrowUniqueSrc lexOrderSemigroup.
   Proof. intros [[[[[[[[[iausa iausb] pa1] pa2] pa3] pa4] pb1] pb2] pb3] pb4] lmon rmon antisym sel.
      destruct (sel_back sel) as [[[w|w]|w]|w]; auto.
      (* Left *)
      assert (h := Semigroups.Product.isLeft A B w).
      intros x y z p1 p2. rewrite (h x y) in p2; rewrite p2 in p1. rewrite le_refl in p1; discriminate p1.
      (* Right *)
      assert (h := Semigroups.Product.isRight A B w).
      intros x y z p1 _ p2. rewrite (h y x) in p2; rewrite p2 in p1. rewrite le_refl in p1; discriminate p1.
      (* Singleton B *)
      destruct w as [selA sgB].
      apply (Iso_IncompArrowUniqueSrc (OSmgIso_sym (singB_OSmgIso sgB)) iausa); auto.
      (* Singleton A *)
      destruct w as [sgA selB].
      apply (Iso_IncompArrowUniqueSrc (OSmgIso_sym (singA_OSmgIso sgA)) iausb); auto.
   Defined.

   Lemma iaus_CE_1 : IncompArrowUniqueSrc_comp A -> IncompArrowUniqueSrc_comp lexOrderSemigroup.
   Proof. intros iaus lmon rmon antisym sel.
      set (b := choose B).
      destruct (iaus (lmon_back_a lmon) (rmon_back_a rmon) (antisym_back_a antisym) (sel_back_a sel)) 
      as [x1 [y1 [z1 [p1 [p2 [p3 [p4 p5]]]]]]].
      exists (x1, b); exists (y1, b); exists (z1, b); unfold dseq; simpl.
      rewrite le_refl, refl; simpl.
      repeat rewrite orb_true_r; simpl.
      repeat rewrite andb_true_r; simpl.
      assert (b + b == b) as e1.
         destruct (sel_back_b sel b b); auto.
      rewrite e1; toProp; bool_p; tauto.
   Defined.

   Lemma iaus_CE_2 : IncompArrowUniqueSrc_comp B -> IncompArrowUniqueSrc_comp lexOrderSemigroup.
   Proof. intros iaus lmon rmon antisym sel.
      set (a := choose A).
      destruct (iaus (lmon_back_b lmon) (rmon_back_b rmon) (antisym_back_b antisym) (sel_back_b sel)) 
      as [x [y [z [p1 [p2 [p3 [p4 p5]]]]]]].
      exists (a, x); exists (a, y); exists (a, z); unfold dseq; simpl.
      rewrite le_refl, refl; simpl.
      assert (a + a == a) as e1.
         destruct (sel_back_a sel a a); auto.
      rewrite e1; simpl. tauto.
   Defined.

   Lemma incompArrowUniqueSrc_comp : IncompArrowUniqueSrc_comp A + IncompArrowUniqueSrc_comp B
                             + (IsLeft_comp A * IsLeft A)
                             + (IsRight_comp A * IsRight A)
                             + (IsSelective_comp A * IsSelective A)
                             + (IsSingleton_comp A * IsSingleton A)
                             + (IsLeft_comp B * IsLeft B)
                             + (IsRight_comp B * IsRight B)
                             + (IsSelective_comp B * IsSelective B)
                             + (IsSingleton_comp B * IsSingleton B)
                             -> IncompArrowUniqueSrc_comp lexOrderSemigroup.
   Proof. intros [[[[[[[[[iausa | iausb] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] lmon rmon antisym sel.
      apply iaus_CE_1; auto.
      apply iaus_CE_2; auto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; assert (False) as f; [|elim f]; tauto.
      destruct q as [x q]; destruct (p x) as [y p']; toProp; assert (q' := q y); tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; assert (False) as f; [|elim f]; tauto.
      destruct q as [x q]; destruct (p x) as [y p']; toProp; assert (q' := q y); tauto.
   Defined.
   
   Lemma iaf_CE_1 : IncompArrowFactor_comp A -> IncompArrowFactor_comp lexOrderSemigroup.
   Proof. intros iaf lmon rmon antisym sel.
      destruct (iaf (lmon_back_a lmon) (rmon_back_a rmon) (antisym_back_a antisym) (sel_back_a sel))
      as [x [y [z p]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); unfold dseq; simpl; toProp; dseq_f.
      assert (b <= b) as e1. auto.
      assert (b + b == b) as e2. destruct (sel_back_b sel b b); auto.
      assert (b == b) as e3. auto.
      tauto.
   Defined.

   Lemma iaf_CE_2 : IncompArrowFactor_comp B -> IncompArrowFactor_comp lexOrderSemigroup.
   Proof. intros iaf lmon rmon antisym sel.
      destruct (iaf (lmon_back_b lmon) (rmon_back_b rmon) (antisym_back_b antisym) (sel_back_b sel))
      as [x [y [z p]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); unfold dseq; simpl; toProp; dseq_f.
      assert (a <= a) as e1. auto.
      assert (a + a == a) as e2. destruct (sel_back_a sel a a); auto.
      assert (a == a) as e3. auto.
      tauto.
   Defined.
   
   Lemma incompArrowFactor : IncompArrowFactor A * IncompArrowFactor B 
                             * (IsLeft A + IsLeft_comp A)
                             * (IsRight A + IsRight_comp A)
                             * (IsSelective A + IsSelective_comp A)
                             * (IsSingleton A + IsSingleton_comp A)
                             * (IsLeft B + IsLeft_comp B)
                             * (IsRight B + IsRight_comp B)
                             * (IsSelective B + IsSelective_comp B)
                             * (IsSingleton B + IsSingleton_comp B)
                             -> IncompArrowFactor lexOrderSemigroup.
   Proof. intros [[[[[[[[[iafa iafb] pa1] pa2] pa3] pa4] pb1] pb2] pb3] pb4] lmon rmon antisym sel. 
      destruct (sel_back sel) as [[[w|w]|w]|w]; auto.
      (* Left *)
      assert (h := Semigroups.Product.isLeft A B w).
      intros x y z p1 p2. rewrite (h x y) in p2; rewrite p2 in p1. rewrite le_refl in p1; discriminate p1.
      (* Right *)
      assert (h := Semigroups.Product.isRight A B w).
      intros x y z p1 _ p2. rewrite (h y x) in p2; rewrite p2 in p1. rewrite le_refl in p1; discriminate p1.
      (* Singleton B *)
      destruct w as [selA sgB].
      apply (Iso_IncompArrowFactor (OSmgIso_sym (singB_OSmgIso sgB)) iafa); auto.
      (* Singleton A *)
      destruct w as [sgA selB].
      apply (Iso_IncompArrowFactor (OSmgIso_sym (singA_OSmgIso sgA)) iafb); auto.
   Defined.

   Lemma incompArrowFactor_comp : IncompArrowFactor_comp A + IncompArrowFactor_comp B 
                             + (IsLeft_comp A * IsLeft A)
                             + (IsRight_comp A * IsRight A)
                             + (IsSelective_comp A * IsSelective A)
                             + (IsSingleton_comp A * IsSingleton A)
                             + (IsLeft_comp B * IsLeft B)
                             + (IsRight_comp B * IsRight B)
                             + (IsSelective_comp B * IsSelective B)
                             + (IsSingleton_comp B * IsSingleton B)
                             -> IncompArrowFactor_comp lexOrderSemigroup.
   Proof. intros [[[[[[[[[iafa | iafb] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] | [p q]] lmon rmon antisym sel.
      apply iaf_CE_1; auto.
      apply iaf_CE_2; auto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; assert (False) as f; [|elim f]; tauto.
      destruct q as [x q]; destruct (p x) as [y p']; toProp; assert (q' := q y); tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; tauto.
      destruct p as [x [y p]]; assert (q' := q x y); toProp; assert (False) as f; [|elim f]; tauto.
      destruct q as [x q]; destruct (p x) as [y p']; toProp; assert (q' := q y); tauto.
   Defined.
   
   Lemma rightTotal : RightTotal A * RightTotal B -> RightTotal lexOrderSemigroup.
   Proof. intros [rta rtb] [z1 z2] [x1 x2] [y1 y2]. simpl.
      toBool.
      assert (forall a b c d, a && b || c && d = (a || c) && (a || d) && (b || c) && (b || d)) as e1.
         intros [|] [|] [|] [|]; auto.
      rewrite e1; toProp; clear e1.
      split. split. split.
         auto.
         destruct (x1 + z1 <= y1 + z1); bool_p; tauto.
         destruct (y1 + z1 <= x1 + z1); bool_p; tauto.
         destruct (rtb z2 x2 y2); tauto.
   Qed.

   Lemma rightTotal_comp : RightTotal_comp A + RightTotal_comp B -> RightTotal_comp lexOrderSemigroup.
   Proof. intros [[z [x [y p]]] | [z [x [y p]]]].
      set (b := choose B).
      exists (z, b); exists (x, b); exists (y, b); simpl.
      rewrite le_refl; simpl. repeat rewrite orb_true_r.
      repeat rewrite andb_true_r; auto.

      set (a := choose A).
      exists (a, z); exists (a, x); exists (a, y); simpl.
      rewrite le_refl; simpl. auto.
   Defined.

   Lemma leftTotal : LeftTotal A * LeftTotal B -> LeftTotal lexOrderSemigroup.
   Proof. intros [rta rtb] [z1 z2] [x1 x2] [y1 y2]. simpl.
      toBool.
      assert (forall a b c d, a && b || c && d = (a || c) && (a || d) && (b || c) && (b || d)) as e1.
         intros [|] [|] [|] [|]; auto.
      rewrite e1; toProp; clear e1.
      split. split. split.
         auto.
         destruct (z1 + x1 <= z1 + y1); bool_p; tauto.
         destruct (z1 + y1 <= z1 + x1); bool_p; tauto.
         destruct (rtb z2 x2 y2); tauto.
   Qed.

   Lemma leftTotal_comp : LeftTotal_comp A + LeftTotal_comp B -> LeftTotal_comp lexOrderSemigroup.
   Proof. intros [[z [x [y p]]] | [z [x [y p]]]].
      set (b := choose B).
      exists (z, b); exists (x, b); exists (y, b); simpl.
      rewrite le_refl; simpl. repeat rewrite orb_true_r.
      repeat rewrite andb_true_r; auto.

      set (a := choose A).
      exists (a, z); exists (a, x); exists (a, y); simpl.
      rewrite le_refl; simpl. auto.
   Defined.
   
   Lemma rightTotal_back_a : RightTotal lexOrderSemigroup -> RightTotal A.
   Proof. intros rt z x y.
      set (b := choose B).
      assert (h := rt (z, b) (x, b) (y, b)).
      simpl in h.
      rewrite le_refl in h.
      repeat rewrite orb_true_r in h.
      repeat rewrite andb_true_r in h.
      auto.
   Qed.
   
   Lemma rightTotal_back_b : RightTotal lexOrderSemigroup -> RightTotal B.
   Proof. intros rt z x y.
      set (a := choose A).
      assert (h := rt (a, z) (a, x) (a, y)).
      simpl in h.
      rewrite le_refl in h. simpl in h. auto.
   Qed.
   
   Lemma rmcc_CE_1 : RightMultChoiseComp_comp A -> RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcc rt.
      destruct (rmcc (rightTotal_back_a rt)) as [x [y [z [w [p1 [p2 [p3 p4]]]]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      rewrite le_refl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma rmcc_CE_2 : RightMultChoiseComp_comp B -> RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcc rt.
      destruct (rmcc (rightTotal_back_b rt)) as [x [y [z [w [p1 [p2 [p3 p4]]]]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      rewrite le_refl. simpl. auto.
   Defined.
      
   Lemma rmcc_CE_3 : RightMultChoiseComp A ->
                     RightMultChoiseComp B ->
                     RightLtSwapEquiv_comp A ->
                     RightMultComp_comp B ->
                     RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb lse mc rt.
      assert (rta := rightTotal_back_a rt).
      assert (rtb := rightTotal_back_b rt).
      destruct (lse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (mc rtb rmccb) as [x2 [y2 [z2 [w2 p4]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp. tauto.
      split.
      toProp. tauto.
      toProp. tauto.
   Defined.
   
   Lemma rmcc_CE_4 : RightMultChoiseComp A ->
                     RightMultSplitComp_comp A ->
                     RightEquivCondensed_comp B ->
                     RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmsc rec rt.
      assert (rta := rightTotal_back_a rt).
      assert (rtb := rightTotal_back_b rt).
      destruct (rmsc rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rec) as [x2 [y2 [z2 p4]]].
      assert (Exists a b c : B, a + c < b + c) as e1.
         negb_p.
         copy_destruct (y2 + x2 <= z2 + x2).
            exists y2; exists z2; exists x2; simpl.
            rewrite ew in p4; simpl in p4.
            dseq_f; toProp; tauto.
         
            rewrite ew in p4; simpl in p4.
            exists z2; exists y2; exists x2; simpl.
            rewrite ew; simpl.
            rewrite andb_true_r.
            destruct (rtb x2 y2 z2) as [h|h].
               rewrite ew in h; discriminate h.
               auto.
      clear x2 y2 z2 p4.
      destruct e1 as [y2 [x2 [w2 p5]]].
      set (b := choose B).
      exists (x1, x2); exists (y1, y2); exists (z1, b); exists (w1, w2); simpl.
      negb_p.
      split. toProp. tauto.
      split. toProp. tauto.
      split. toProp. tauto.
      toProp. tauto.
   Defined.
   
   Lemma rmcc_CE_5 : RightMultChoiseComp A ->
                     RightMultChoiseComp B ->
                     RightLtLeSwapEquiv_comp A ->
                     RightLtMultComp_comp B ->
                     RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb llse lmc rt.
      assert (rta := rightTotal_back_a rt).
      assert (rtb := rightTotal_back_b rt).
      destruct (llse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (lmc rtb rmccb) as [x2 [y2 [z2 [w2 [p4 p5]]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      split. toProp; tauto.
      split. toProp; tauto.
      split. toProp; tauto.
      toProp; tauto.
   Defined.
  
      
   Lemma rmcc_CE_6 : RightMultChoiseComp A ->
                     RightMultChoiseComp B ->
                     RightLeSwapEquiv_comp A ->
                     RightMultPresLtLe_comp B ->
                     RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb lse mpll rt.
      assert (rta := rightTotal_back_a rt).
      assert (rtb := rightTotal_back_b rt).
      destruct (lse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (mpll rtb rmccb) as [x2 [y2 [z2 [w2 [p4 p5]]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      split. toProp; tauto.
      split. toProp; tauto.
      split. negb_p; toProp. tauto.
      toProp; tauto.
   Defined.

   Lemma rightMultChoiseComp : 
      RightMultChoiseComp A *
      RightMultChoiseComp B *
      ( RightMultChoiseComp_comp A +
        RightMultChoiseComp_comp B +
        ( (RightLtSwapEquiv A + RightMultComp B) *
          (RightMultSplitComp A + RightEquivCondensed B) *
          (RightLtLeSwapEquiv A + RightLtMultComp B) *
          (RightLeSwapEquiv A + RightMultPresLtLe B)
        )
      )
      -> RightMultChoiseComp lexOrderSemigroup.
   Proof. intros [[rmcca rmccb] [[RMCCA | RMCCB] | [[[LSE_MC RMSC_REC] LLSE_LMC] LSE_MPLL]]] rt [x1 x2] [y1 y2] [z1 z2] [w1 w2]; simpl;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt).
      
      destruct (RMCCA rta) as [x [y [z [w p]]]].
      assert (h := rmcca rta x y z w).
      toProp; tauto.

      destruct (RMCCB rtb) as [x [y [z [w p]]]].
      assert (h := rmccb rtb x y z w).
      toProp; tauto.      
      
      negb_p.
      toBool. negb_p.
      set (a := x1 + z1 <= y1 + z1).
      set (b := y1 + z1 <= x1 + z1).
      set (c := x2 + z2 <= y2 + z2).
      set (d := y2 + z2 <= x2 + z2).
      set (e := y1 + w1 <= x1 + w1).
      set (f := x1 + w1 <= y1 + w1).
      set (g := y2 + w2 <= x2 + w2).
      set (h := x2 + w2 <= y2 + w2).
      set (i := x1 + z1 <= y1 + w1).
      set (j := y1 + w1 <= x1 + z1).
      set (k := x2 + z2 <= y2 + w2).
      set (l := y2 + w2 <= x2 + z2).
      repeat rewrite orb_assoc.
      assert (
         (negb a || b           || negb e || f           || i || j) &&
         (negb a || b           || negb e || f           || negb j || k || negb i || l) &&
         (negb a || b           || negb e || negb g || h || i || j) &&
         (negb a || b           || negb e || negb g || h || negb j || k || negb i || l) &&
         (negb a || negb c || d || negb e || f           || i || j) &&
         (negb a || negb c || d || negb e || f           || negb j || k || negb i || l) &&
         (negb a || negb c || d || negb e || negb g || h || i || j) &&
         (negb a || negb c || d || negb e || negb g || h || negb j || k || negb i || l)
      ) as e1;
      [|
      copy_destruct a; rewrite ew in *; simpl in *; try discriminate e1; auto;
      copy_destruct b; rewrite ew0 in *; simpl in *; try discriminate e1; auto;
      copy_destruct c; rewrite ew1 in *; simpl in *; try discriminate e1; auto;
      copy_destruct d; rewrite ?ew2 in *; simpl in *; try discriminate e1; auto;
      copy_destruct e; rewrite ?ew3 in *; simpl in *; try discriminate e1; auto;
      copy_destruct f; rewrite ?ew4 in *; simpl in *; try discriminate e1; auto;
      copy_destruct g; rewrite ?ew5 in *; simpl in *; try discriminate e1; auto;
      copy_destruct h; rewrite ?ew6 in *; simpl in *; try discriminate e1; auto;
      copy_destruct i; rewrite ?ew7 in *; simpl in *; try discriminate e1; auto;
      copy_destruct j; rewrite ?ew8 in *; simpl in *; try discriminate e1; auto;
      copy_destruct k; rewrite ?ew9 in *; simpl in *; try discriminate e1; auto;
      copy_destruct l; rewrite ?ew10 in *; simpl in *; try discriminate e1; auto].
      assert (forall b1 b2 : bool, b1 -> b2 -> b1 && b2) as e2.
         intros b1 b2 p q; rewrite p, q; auto.
      repeat (apply e2); clear e2;
      unfold a, b, c, d, e, f, g, h, i, j, k, l;
      clear a b c d e f g h i j k l.
      (* 1 *)
      assert (h := rmcca rta x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      (* 2 *)
      destruct (LSE_MC) as [lse | mc].
      assert (h := lse rta rmcca x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      assert (h := mc rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct (RMSC_REC) as [rmsc | rec].
      assert (h := rmsc rta rmcca x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      assert (h := rec w2 x2 y2).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      destruct (LLSE_LMC) as [llse | lmc].
      assert (h := llse rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      assert (h := lmc rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.      
      (* 5 *)
      destruct (RMSC_REC) as [rmsc | rec].
      assert (h := rmsc rta rmcca y1 x1 w1 z1).
      toBool. negb_p. toProp. tauto.
      assert (h := rec z2 x2 y2).
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      destruct (LLSE_LMC) as [llse | lmc].
      assert (h := llse rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      assert (h := lmc rtb rmccb y2 x2 w2 z2).
      toBool; negb_p; toProp; tauto.
      (* 7 *)
      destruct (LSE_MPLL) as [lse | mpll].
      assert (h := lse rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      assert (h := mpll rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto. 
      (* 8 *)
      assert (h := rmccb rtb x2 y2 z2 w2).
      toBool. negb_p. toProp. tauto.
   Qed.

   Lemma rightMultChoiseComp_comp : 
      RightMultChoiseComp_comp A +
      RightMultChoiseComp_comp B +
      (RightMultChoiseComp A *
       RightMultChoiseComp B *
       ( (RightLtSwapEquiv_comp A * RightMultComp_comp B) +
         (RightMultSplitComp_comp A * RightEquivCondensed_comp B) +
         (RightLtLeSwapEquiv_comp A * RightLtMultComp_comp B) +
         (RightLeSwapEquiv_comp A * RightMultPresLtLe_comp B)
      ))
      -> RightMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros [[rmcca | rmccb] | [[rmcca rmccb] X]].
      apply rmcc_CE_1; auto.
      apply rmcc_CE_2; auto.
      destruct X as [[[u|u]|u]|u]; destruct u as [u1 u2].
      apply rmcc_CE_3; auto.
      apply rmcc_CE_4; auto.
      apply rmcc_CE_5; auto.
      apply rmcc_CE_6; auto.
   Defined.

   Lemma leftTotal_back_a : LeftTotal lexOrderSemigroup -> LeftTotal A.
   Proof. intros rt z x y.
      set (b := choose B).
      assert (h := rt (z, b) (x, b) (y, b)).
      simpl in h.
      rewrite le_refl in h.
      repeat rewrite orb_true_r in h.
      repeat rewrite andb_true_r in h.
      auto.
   Qed.
   
   Lemma leftTotal_back_b : LeftTotal lexOrderSemigroup -> LeftTotal B.
   Proof. intros rt z x y.
      set (a := choose A).
      assert (h := rt (a, z) (a, x) (a, y)).
      simpl in h.
      rewrite le_refl in h. simpl in h. auto.
   Qed.
   
   Lemma lmcc_CE_1 : LeftMultChoiseComp_comp A -> LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcc rt.
      destruct (rmcc (leftTotal_back_a rt)) as [x [y [z [w [p1 [p2 [p3 p4]]]]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      rewrite le_refl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma lmcc_CE_2 : LeftMultChoiseComp_comp B -> LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcc rt.
      destruct (rmcc (leftTotal_back_b rt)) as [x [y [z [w [p1 [p2 [p3 p4]]]]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      rewrite le_refl. simpl. auto.
   Defined.
      
   Lemma lmcc_CE_3 : LeftMultChoiseComp A ->
                     LeftMultChoiseComp B ->
                     LeftLtSwapEquiv_comp A ->
                     LeftMultComp_comp B ->
                     LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb lse mc rt.
      assert (rta := leftTotal_back_a rt).
      assert (rtb := leftTotal_back_b rt).
      destruct (lse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (mc rtb rmccb) as [x2 [y2 [z2 [w2 p4]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp. tauto.
      split.
      toProp. tauto.
      toProp. tauto.
   Defined.
   
   Lemma lmcc_CE_4 : LeftMultChoiseComp A ->
                     LeftMultSplitComp_comp A ->
                     LeftEquivCondensed_comp B ->
                     LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmsc rec rt.
      assert (rta := leftTotal_back_a rt).
      assert (rtb := leftTotal_back_b rt).
      destruct (rmsc rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rec) as [x2 [y2 [z2 p4]]].
      assert (Exists a b c : B, c + a < c + b) as e1.
         negb_p.
         copy_destruct (x2 + y2 <= x2 + z2).
            exists y2; exists z2; exists x2; simpl.
            rewrite ew in p4; simpl in p4.
            dseq_f; toProp; tauto.
         
            rewrite ew in p4; simpl in p4.
            exists z2; exists y2; exists x2; simpl.
            rewrite ew; simpl.
            rewrite andb_true_r.
            destruct (rtb x2 y2 z2) as [h|h].
               rewrite ew in h; discriminate h.
               auto.
      clear x2 y2 z2 p4.
      destruct e1 as [y2 [x2 [w2 p5]]].
      set (b := choose B).
      exists (x1, x2); exists (y1, y2); exists (z1, b); exists (w1, w2); simpl.
      negb_p.
      split. toProp. tauto.
      split. toProp. tauto.
      split. toProp. tauto.
      toProp. tauto.
   Defined.
   
   Lemma lmcc_CE_5 : LeftMultChoiseComp A ->
                     LeftMultChoiseComp B ->
                     LeftLtLeSwapEquiv_comp A ->
                     LeftLtMultComp_comp B ->
                     LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb llse lmc rt.
      assert (rta := leftTotal_back_a rt).
      assert (rtb := leftTotal_back_b rt).
      destruct (llse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (lmc rtb rmccb) as [x2 [y2 [z2 [w2 [p4 p5]]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      split. toProp; tauto.
      split. toProp; tauto.
      split. toProp; tauto.
      toProp; tauto.
   Defined.
      
   Lemma lmcc_CE_6 : LeftMultChoiseComp A ->
                     LeftMultChoiseComp B ->
                     LeftLeSwapEquiv_comp A ->
                     LeftMultPresLtLe_comp B ->
                     LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros rmcca rmccb lse mpll rt.
      assert (rta := leftTotal_back_a rt).
      assert (rtb := leftTotal_back_b rt).
      destruct (lse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (mpll rtb rmccb) as [x2 [y2 [z2 [w2 [p4 p5]]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      split. toProp; tauto.
      split. toProp; tauto.
      split. negb_p; toProp. tauto.
      toProp; tauto.
   Defined.

   Lemma leftMultChoiseComp : 
      LeftMultChoiseComp A *
      LeftMultChoiseComp B *
      ( LeftMultChoiseComp_comp A +
        LeftMultChoiseComp_comp B +
        ( (LeftLtSwapEquiv A + LeftMultComp B) *
          (LeftMultSplitComp A + LeftEquivCondensed B) *
          (LeftLtLeSwapEquiv A + LeftLtMultComp B) *
          (LeftLeSwapEquiv A + LeftMultPresLtLe B)
        )
      )
      -> LeftMultChoiseComp lexOrderSemigroup.
   Proof. intros [[rmcca rmccb] [[RMCCA | RMCCB] | [[[LSE_MC RMSC_REC] LLSE_LMC] LSE_MPLL]]] rt [x1 x2] [y1 y2] [z1 z2] [w1 w2]; simpl;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt).
      
      destruct (RMCCA rta) as [x [y [z [w p]]]].
      assert (h := rmcca rta x y z w).
      toProp; tauto.

      destruct (RMCCB rtb) as [x [y [z [w p]]]].
      assert (h := rmccb rtb x y z w).
      toProp; tauto.      
      
      negb_p.
      toBool. negb_p.
      set (a := z1 + x1 <= z1 + y1).
      set (b := z1 + y1 <= z1 + x1).
      set (c := z2 + x2 <= z2 + y2).
      set (d := z2 + y2 <= z2 + x2).
      set (e := w1 + y1 <= w1 + x1).
      set (f := w1 + x1 <= w1 + y1).
      set (g := w2 + y2 <= w2 + x2).
      set (h := w2 + x2 <= w2 + y2).
      set (i := z1 + x1 <= w1 + y1).
      set (j := w1 + y1 <= z1 + x1).
      set (k := z2 + x2 <= w2 + y2).
      set (l := w2 + y2 <= z2 + x2).
      repeat rewrite orb_assoc.
      assert (
         (negb a || b           || negb e || f           || i || j) &&
         (negb a || b           || negb e || f           || negb j || k || negb i || l) &&
         (negb a || b           || negb e || negb g || h || i || j) &&
         (negb a || b           || negb e || negb g || h || negb j || k || negb i || l) &&
         (negb a || negb c || d || negb e || f           || i || j) &&
         (negb a || negb c || d || negb e || f           || negb j || k || negb i || l) &&
         (negb a || negb c || d || negb e || negb g || h || i || j) &&
         (negb a || negb c || d || negb e || negb g || h || negb j || k || negb i || l)
      ) as e1;
      [|
      copy_destruct a; rewrite ew in *; simpl in *; try discriminate e1; auto;
      copy_destruct b; rewrite ew0 in *; simpl in *; try discriminate e1; auto;
      copy_destruct c; rewrite ew1 in *; simpl in *; try discriminate e1; auto;
      copy_destruct d; rewrite ?ew2 in *; simpl in *; try discriminate e1; auto;
      copy_destruct e; rewrite ?ew3 in *; simpl in *; try discriminate e1; auto;
      copy_destruct f; rewrite ?ew4 in *; simpl in *; try discriminate e1; auto;
      copy_destruct g; rewrite ?ew5 in *; simpl in *; try discriminate e1; auto;
      copy_destruct h; rewrite ?ew6 in *; simpl in *; try discriminate e1; auto;
      copy_destruct i; rewrite ?ew7 in *; simpl in *; try discriminate e1; auto;
      copy_destruct j; rewrite ?ew8 in *; simpl in *; try discriminate e1; auto;
      copy_destruct k; rewrite ?ew9 in *; simpl in *; try discriminate e1; auto;
      copy_destruct l; rewrite ?ew10 in *; simpl in *; try discriminate e1; auto].
      assert (forall b1 b2 : bool, b1 -> b2 -> b1 && b2) as e2.
         intros b1 b2 p q; rewrite p, q; auto.
      repeat (apply e2); clear e2;
      unfold a, b, c, d, e, f, g, h, i, j, k, l;
      clear a b c d e f g h i j k l.
      (* 1 *)
      assert (h := rmcca rta x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      (* 2 *)
      destruct (LSE_MC) as [lse | mc].
      assert (h := lse rta rmcca x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      assert (h := mc rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct (RMSC_REC) as [rmsc | rec].
      assert (h := rmsc rta rmcca x1 y1 z1 w1).
      toBool. negb_p. toProp. tauto.
      assert (h := rec w2 x2 y2).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      destruct (LLSE_LMC) as [llse | lmc].
      assert (h := llse rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      assert (h := lmc rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.      
      (* 5 *)
      destruct (RMSC_REC) as [rmsc | rec].
      assert (h := rmsc rta rmcca y1 x1 w1 z1).
      toBool. negb_p. toProp. tauto.
      assert (h := rec z2 x2 y2).
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      destruct (LLSE_LMC) as [llse | lmc].
      assert (h := llse rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      assert (h := lmc rtb rmccb y2 x2 w2 z2).
      toBool; negb_p; toProp; tauto.
      (* 7 *)
      destruct (LSE_MPLL) as [lse | mpll].
      assert (h := lse rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      assert (h := mpll rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto. 
      (* 8 *)
      assert (h := rmccb rtb x2 y2 z2 w2).
      toBool. negb_p. toProp. tauto.
   Qed.

   Lemma leftMultChoiseComp_comp : 
      LeftMultChoiseComp_comp A +
      LeftMultChoiseComp_comp B +
      (LeftMultChoiseComp A *
       LeftMultChoiseComp B *
       ( (LeftLtSwapEquiv_comp A * LeftMultComp_comp B) +
         (LeftMultSplitComp_comp A * LeftEquivCondensed_comp B) +
         (LeftLtLeSwapEquiv_comp A * LeftLtMultComp_comp B) +
         (LeftLeSwapEquiv_comp A * LeftMultPresLtLe_comp B)
      ))
      -> LeftMultChoiseComp_comp lexOrderSemigroup.
   Proof. intros [[rmcca | rmccb] | [[rmcca rmccb] X]].
      apply lmcc_CE_1; auto.
      apply lmcc_CE_2; auto.
      destruct X as [[[u|u]|u]|u]; destruct u as [u1 u2].
      apply lmcc_CE_3; auto.
      apply lmcc_CE_4; auto.
      apply lmcc_CE_5; auto.
      apply lmcc_CE_6; auto.
   Defined.
   
   Lemma rightMultChoiseComp_back_a : RightTotal lexOrderSemigroup -> RightMultChoiseComp lexOrderSemigroup -> RightMultChoiseComp A.
   Proof. intros rt rmcc _ x y z w.
      set (b := choose B).
      assert (h := rmcc rt (x, b) (y, b) (z, b) (w, b)).
      simpl in h. rewrite le_refl in h.
      repeat rewrite orb_true_r in h.
      repeat rewrite andb_true_r in h.
      auto.
   Qed.

   Lemma rightMultChoiseComp_back_b : RightTotal lexOrderSemigroup -> RightMultChoiseComp lexOrderSemigroup -> RightMultChoiseComp B.
   Proof. intros rt rmcc _ x y z w.
      set (a := choose A).
      assert (h := rmcc rt (a, x) (a, y) (a, z) (a, w)).
      simpl in h. rewrite le_refl in h; simpl in h; auto.
   Qed.
   
   Lemma rlse_CE_1 : RightLtSwapEquiv_comp A -> RightLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlsea rt rmcc.
      destruct (rlsea (rightTotal_back_a rt) (rightMultChoiseComp_back_a rt rmcc)) as [x [y [z [w p]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma rlse_CE_2 : RightLtSwapEquiv_comp B -> RightLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlsea rt rmcc.
      destruct (rlsea (rightTotal_back_b rt) (rightMultChoiseComp_back_b rt rmcc)) as [x [y [z [w p]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma rlse_CE_3 :
      RightLtLeSwapEquiv_comp A ->
      RightStrictEquiv_comp B ->
      RightLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rllsea rseb rt rmcc.
      destruct (rllsea (rightTotal_back_a rt) (rightMultChoiseComp_back_a rt rmcc)) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rseb (rightTotal_back_b rt) (rightMultChoiseComp_back_b rt rmcc)) as [x2 [y2 [z2 [w2 [p4 p5]]]]].         
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      toBool. negb_p.
      toProp. tauto.
   Defined.

   Lemma rightLtSwapEquiv : 
      RightLtSwapEquiv A * 
      RightLtSwapEquiv B *
      ( RightLtLeSwapEquiv A + RightStrictEquiv B )
      -> RightLtSwapEquiv lexOrderSemigroup.
   Proof. intros [[rlsea rlseb] rllsea_rseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      
      assert (p1 := rlsea rta rmcca x1 y1 z1 w1).
      assert (p2 := rlseb rtb rmccb x2 y2 z2 w2).
      simpl. toBool. negb_p.
      set (a1 := x1 + z1 <= y1 + z1) in *.
      set (b1 := y1 + z1 <= x1 + z1) in *.
      set (a2 := x2 + z2 <= y2 + z2) in *.
      set (b2 := y2 + z2 <= x2 + z2) in *.
      set (c1 := y1 + w1 <= x1 + w1) in *.
      set (d1 := x1 + w1 <= y1 + w1) in *.
      set (c2 := y2 + w2 <= x2 + w2) in *.
      set (d2 := x2 + w2 <= y2 + w2) in *.
      set (e1 := x1 + z1 <= y1 + w1) in *.
      set (f1 := y1 + w1 <= x1 + z1) in *.
      set (e2 := x2 + z2 <= y2 + w2) in *.
      set (f2 := y2 + w2 <= x2 + z2) in *.
      repeat rewrite (orb_assoc).
      assert (
         (negb a1 || b1      || negb c1 || d1            || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || b1      || negb c1 || negb c2 || d2 || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || negb a2 || b2 || negb c1 || d1            || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || negb a2 || b2 || negb c1 || negb c2 || d2 || negb e1 || negb e2 || negb f1 || negb f2)
      ) as q1;
      [|
         destruct a1 as [|]; simpl; auto;
         destruct b1 as [|]; simpl; auto;
         destruct a2 as [|]; simpl; auto;
         destruct b2 as [|]; simpl; auto;
         destruct c1 as [|]; simpl; auto;
         destruct d1 as [|]; simpl; auto;
         destruct c2 as [|]; simpl; auto;
         destruct d2 as [|]; simpl; auto;
         destruct e1 as [|]; simpl; auto;
         destruct e2 as [|]; simpl; auto;
         destruct f1 as [|]; simpl; auto;
         destruct f2 as [|]; simpl; auto
      ].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      (* 1 *)
      toProp; tauto.
      (* 2 *)
      destruct rllsea_rseb as [rllsea | rseb].
         assert (h := rllsea rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
         
         assert (h := rseb rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
      (* 3 *)
      destruct rllsea_rseb as [rllsea | rseb].
         assert (h := rllsea rta rmcca y1 x1 w1 z1).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
         
         assert (h := rseb rtb rmccb y2 x2 w2 z2).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
      (* 4 *)
      toProp; tauto.
   Qed.

   Lemma rightLtSwapEquiv_comp : 
      RightLtSwapEquiv_comp A +
      RightLtSwapEquiv_comp B +
      ( RightLtLeSwapEquiv_comp A * RightStrictEquiv_comp B )
      -> RightLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p4 p5]].
      apply rlse_CE_1; auto.
      apply rlse_CE_2; auto.
      apply rlse_CE_3; auto.
   Defined.
   
   Lemma rightMultComp : RightMultComp A * RightMultComp B -> RightMultComp lexOrderSemigroup.
   Proof. intros [rmca rmcb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      negb_p; simpl.
      set (a1 := x1 + z1 <= y1 + w1).
      set (b1 := y1 + w1 <= x1 + z1).
      set (a2 := x2 + z2 <= y2 + w2).
      set (b2 := y2 + w2 <= x2 + z2).
      assert ((a1 || b1) && (negb b1 || negb a1 || a2 || b2)) as e1;
      [|
         destruct a1 as [|]; simpl; auto;
         destruct b1 as [|]; simpl; auto;
         destruct a2 as [|]; simpl; auto;
         destruct b2 as [|]; simpl; auto
      ].
      toProp; split.
      unfold a1, b1; assert (h := rmca rta rmcca x1 y1 z1 w1); negb_p; toProp; auto.
      unfold a2, b2; assert (h := rmcb rtb rmccb x2 y2 z2 w2); negb_p; toProp; tauto.
   Qed.
   
   Lemma rightMultComp_comp : RightMultComp_comp A + RightMultComp_comp B -> RightMultComp_comp lexOrderSemigroup.
   Proof. intros [rmca | rmcb] rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      
      assert (b := choose B).
      destruct (rmca rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl;
      repeat rewrite orb_true_r; simpl;
      repeat rewrite andb_false_r;
      repeat rewrite orb_false_r.
      auto.

      assert (a := choose A).
      destruct (rmcb rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl;
      repeat rewrite orb_true_r; simpl. auto.
   Defined.
   
   Lemma rmsc_CE_1 : RightMultSplitComp_comp A -> RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rmsc rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      set (b := choose B).
      destruct (rmsc rta rmcca) as [x [y [z [w [p1 [p2 p3]]]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p. rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.

   Lemma rmsc_CE_2 : RightMultSplitComp_comp B -> RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rmsc rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      set (a := choose A).
      destruct (rmsc rtb rmccb) as [x [y [z [w [p1 [p2 p3]]]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p. rewrite le_refl; simpl. auto.
   Defined.
   
   Lemma rmsc_CE_3 : RightLtSwapEquiv_comp A -> RightMultComp_comp B -> RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rlse rmc rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p4]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma rmsc_CE_4 : 
      RightLtLeSwapEquiv_comp A -> 
      RightLeMultComp_comp B -> 
      RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rllse rlmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      destruct (rllse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rlmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.

   Lemma rmsc_CE_5 :
      RightLeSwapEquiv_comp A ->
      RightLtLeMulpCoh_comp B ->
      RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rlse rllse rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rllse rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma rightMultSplitComp : 
      RightMultSplitComp A *
      RightMultSplitComp B *
      (RightLtSwapEquiv A + RightMultComp B) *
      (RightLtLeSwapEquiv A + RightLeMultComp B) *
      (RightLeSwapEquiv A + RightLtLeMulpCoh B)
      -> RightMultSplitComp lexOrderSemigroup.
   Proof. intros [[[[rmsca rmscb] rlse_rmc] rllse_rlmc] rlse_rllmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      simpl; toBool; negb_p; simpl.
      set (a1 := x1 + z1 <= y1 + z1).
      set (b1 := y1 + z1 <= x1 + z1).
      set (c2 := x2 + z2 <= y2 + z2).
      set (d2 := y2 + z2 <= x2 + z2).
      set (e1 := x1 + w1 <= y1 + w1).
      set (f1 := y1 + w1 <= x1 + w1).
      set (g2 := y2 + w2 <= x2 + w2).
      set (h1 := x1 + z1 <= y1 + w1).
      set (i1 := y1 + w1 <= x1 + z1).
      set (j2 := x2 + z2 <= y2 + w2).
      set (k2 := y2 + w2 <= x2 + z2).
      
      repeat rewrite orb_assoc.
      assert (
         (negb a1 || b1            || negb f1 || e1      || h1 || i1) &&
         (negb a1 || b1            || negb f1 || e1      || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || b1            || negb f1 || negb g2 || h1 || i1) &&
         (negb a1 || b1            || negb f1 || negb g2 || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || negb c2 || d2 || negb f1 || e1      || h1 || i1) &&
         (negb a1 || negb c2 || d2 || negb f1 || e1      || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || negb c2 || d2 || negb f1 || negb g2 || h1 || i1) &&
         (negb a1 || negb c2 || d2 || negb f1 || negb g2 || negb i1 || j2 || negb h1 || k2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h1; simpl; auto;
      destruct i1; simpl; auto;
      destruct j2; simpl; auto;
      destruct k2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      (* 1 *)
      unfold a1, b1, f1, e1, h1, i1.
      assert (h := rmcca rta x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      unfold a1, b1, f1, e1, i1, j2, h1, k2.
      destruct (rlse_rmc) as [rlse | rmc].
         assert (h := rlse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. tauto.
      (* 3 *)
      unfold a1, b1, f1, g2, i1, h1.
      assert (h := rmsca rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      unfold a1, b1, f1, g2, i1, j2, h1, k2.
      destruct (rllse_rlmc) as [rllse | rlmc].
         assert (h := rllse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. tauto.
         assert (h := rlmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. tauto.      
      (* 5 *)
      unfold a1, c2, d2, f1, e1, i1, h1.
      assert (h := rmsca rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      unfold a1, b1, f1, g2, i1, j2, h1, k2.
      destruct (rllse_rlmc) as [rllse | rlmc].
         assert (h := rllse rta rmcca y1 x1 w1 z1).
         toBool; negb_p; toProp. tauto.
         assert (h := rlmc rtb rmccb y2 x2 w2 z2).
         toBool; negb_p; toProp. tauto.            
      (* 7 *)
      unfold a1, c2, d2, f1, g2, i1, h1.
      destruct (rlse_rllmc) as [rlse | rllmc].
         assert (h := rlse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp; tauto.
         assert (h := rllmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp; tauto.      
      (* 8 *)
      unfold a1, c2, d2, f1, g2, i1, j2, h1, k2.
      assert (h := rmscb rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma rightMultSplitComp_comp : 
      RightMultSplitComp_comp A +
      RightMultSplitComp_comp B +
      (RightLtSwapEquiv_comp A * RightMultComp_comp B) +
      (RightLtLeSwapEquiv_comp A * RightLeMultComp_comp B) +
      (RightLeSwapEquiv_comp A * RightLtLeMulpCoh_comp B)
      -> RightMultSplitComp_comp lexOrderSemigroup.
   Proof. intros [[[[p1 | p2] | [p3 p4]] | [p5 p6]] | [p7 p8]].
      apply rmsc_CE_1; auto.
      apply rmsc_CE_2; auto.
      apply rmsc_CE_3; auto.
      apply rmsc_CE_4; auto.
      apply rmsc_CE_5; auto.
   Defined.
   
   Lemma rightLtLeSwapEquiv : RightLtLeSwapEquiv A * RightLtLeSwapEquiv B -> RightLtLeSwapEquiv lexOrderSemigroup.
   Proof. intros [rllsea rllseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := x1 + z1 <= y1 + z1).
      set (b1 := y1 + z1 <= x1 + z1).
      set (c2 := x2 + z2 <= y2 + z2).
      set (d2 := y2 + z2 <= x2 + z2).
      set (e1 := y1 + w1 <= x1 + w1).
      set (f1 := x1 + w1 <= y1 + w1).
      set (g2 := y2 + w2 <= x2 + w2).
      set (h1 := x1 + z1 <= y1 + w1).
      set (i1 := y1 + w1 <= x1 + z1).
      set (j2 := x2 + z2 <= y2 + w2).
      set (k2 := y2 + w2 <= x2 + z2).
      
      assert (
         (negb a1 || b1            || negb e1 || f1      || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || b1            || negb e1 || negb g2 || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1      || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || negb h1 || negb j2 || negb i1 || negb k2)
      ) as q2;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h1; simpl; auto;
      destruct i1; simpl; auto;
      destruct j2; simpl; auto;
      destruct k2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h1, i1, j2, k2.
      (* 1 *)
      assert (h := rllsea rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rllsea rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rllsea rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rllseb rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma rightLtLeSwapEquiv_comp : 
      RightLtLeSwapEquiv_comp A + RightLtLeSwapEquiv_comp B -> 
      RightLtLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [rllse | rllse] rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      
      set (b := choose B).
      destruct (rllse rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rllse rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl. auto.
   Defined.
   
   Lemma rlmc_CE_1 : RightLtMultComp_comp A -> RightLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlmc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma rlmc_CE_2 : RightLtMultComp_comp B -> RightLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlmc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma rlmc_CE_3 : RightStrictEquiv_comp A -> RightMultComp_comp B -> RightLtMultComp_comp lexOrderSemigroup.
   Proof. intros rse rmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      destruct (rse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined.
   
   Lemma rlmc_CE_4 : RightLeMultComp_comp A -> RightEquivCondensed_comp B -> RightLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rec rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      assert (Exists x y w : B, y + w < x + w) as p2.
         destruct (rec) as [w [x [y p2]]].
         negb_p.
         copy_destruct (x + w <= y + w); rewrite ew in p2; simpl in p2.
            exists y; exists x; exists w; simpl; dseq_f; toProp. tauto.
            exists x; exists y; exists w; simpl; dseq_f; toProp; bool_p.
            assert (h := rtb w x y).
            tauto.
      destruct p2 as [x2 [y2 [w2 p2]]].
      destruct (rlmc rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].

      exists (x1, x2); exists (y1, y2); exists (z1, w2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined.
   
   Lemma rightLtMultComp : 
      RightLtMultComp A *
      RightLtMultComp B *
      (RightStrictEquiv A + RightMultComp B) *
      (RightLeMultComp A + RightEquivCondensed B) ->
      RightLtMultComp lexOrderSemigroup.
   Proof. intros [[[rlmca rlmcb] rse_rmc] rlmc_rec] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := y1 + w1 <= x1 + w1).
      set (b1 := x1 + w1 <= y1 + w1).
      set (c2 := y2 + w2 <= x2 + w2).
      set (d2 := x2 + w2 <= y2 + w2).
      set (e1 := x1 + z1 <= y1 + w1).
      set (f1 := y1 + w1 <= x1 + z1).
      set (g2 := x2 + z2 <= y2 + w2).
      set (h2 := y2 + w2 <= x2 + z2).

      assert (
         (negb a1 || b1            || e1 || f1) &&
         (negb a1 || b1            || negb f1 || g2 || negb e1 || h2) &&
         (negb a1 || negb c2 || d2 || e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb f1 || g2 || negb e1 || h2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
      (* 1 *)
      assert (h := rlmca rta rmcca x1 y1 z1 w1); 
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct (rse_rmc) as [rse | rmc].
         assert (h := rse rta rmcca x1 y1 z1 w1);
         toBool; negb_p; toProp; tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2);
         toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct (rlmc_rec) as [rlmc | rec].
         assert (h := rlmc rta rmcca x1 y1 z1 w1);
         toBool; negb_p; toProp; tauto.
         assert (h := rec w2 x2 y2).
         toBool; negb_p; toProp. tauto.      
      (* 4 *)
      assert (h := rlmcb rtb rmccb x2 y2 z2 w2); 
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma rightLtMultComp_comp : 
      RightLtMultComp_comp A +
      RightLtMultComp_comp B +
      (RightStrictEquiv_comp A * RightMultComp_comp B) +
      (RightLeMultComp_comp A * RightEquivCondensed_comp B) ->
      RightLtMultComp_comp lexOrderSemigroup.
   Proof. intros [[[p1 | p2] | [p3 p4]] | [p5 p6]].
      apply rlmc_CE_1; auto.
      apply rlmc_CE_2; auto.
      apply rlmc_CE_3; auto.
      apply rlmc_CE_4; auto.
   Defined.
   
   Lemma rlese_CE_1 : RightLeSwapEquiv_comp A -> RightLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlese rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlese rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma rlese_CE_2 : RightLeSwapEquiv_comp B -> RightLeSwapEquiv_comp lexOrderSemigroup. 
   Proof. intros rlese rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlese rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma rlese_CE_3 : RightLtLeSwapEquiv_comp A -> RightLeMultComp_comp B -> RightLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rllse rlmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      destruct (rllse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rlmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma rlese_CE_4 : RightLtSwapEquiv_comp A -> RightMultComp_comp B -> RightLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlse rmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      split; toProp; tauto.
   Defined.

   Lemma rightLeSwapEquiv : 
      RightLeSwapEquiv A * 
      RightLeSwapEquiv B *
      (RightLtLeSwapEquiv A + RightLeMultComp B) *
      (RightLtSwapEquiv A + RightMultComp B)
      -> RightLeSwapEquiv lexOrderSemigroup.
   Proof. intros [[[rlesea rleseb] rllse_rlmc] rlse_rmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := x1 + z1 <= y1 + z1).
      set (b1 := y1 + z1 <= x1 + z1).
      set (c2 := x2 + z2 <= y2 + z2).
      set (d1 := y1 + w1 <= x1 + w1).
      set (e1 := x1 + w1 <= y1 + w1).
      set (f2 := y2 + w2 <= x2 + w2).
      set (g1 := x1 + z1 <= y1 + w1).
      set (h1 := y1 + w1 <= x1 + z1).
      set (i2 := x2 + z2 <= y2 + w2).
      set (j2 := y2 + w2 <= x2 + z2).
      
      assert (
         (negb a1 || b1      || negb d1 || e1      || g1 || h1) &&
         (negb a1 || b1      || negb d1 || e1      || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || b1      || negb d1 || negb f2 || g1 || h1) &&
         (negb a1 || b1      || negb d1 || negb f2 || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || negb c2 || negb d1 || e1      || g1 || h1) &&
         (negb a1 || negb c2 || negb d1 || e1      || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || negb c2 || negb d1 || negb f2 || g1 || h1) &&
         (negb a1 || negb c2 || negb d1 || negb f2 || negb h1 || i2 || negb g1 || j2)         
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d1; simpl; auto;
      destruct e1; simpl; auto;
      destruct f2; simpl; auto;
      destruct g1; simpl; auto;
      destruct h1; simpl; auto;
      destruct i2; simpl; auto;
      destruct j2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      unfold a1, b1, c2, d1, e1, f2, g1, h1, i2, j2.
      
      (* 1 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rlse_rmc as [rlse | rmc].
        assert (h := rlse rta rmcca x1 y1 z1 w1);
        toBool; negb_p; toProp; tauto.
        assert (h := rmc rtb rmccb x2 y2 z2 w2);
        toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      destruct rllse_rlmc as [rllse | rlmc].
        assert (h := rllse rta rmcca x1 y1 z1 w1);
        toBool; negb_p; toProp; tauto.
        assert (h := rlmc rtb rmccb x2 y2 z2 w2);
        toBool; negb_p; toProp; tauto.
      (* 5 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      destruct rllse_rlmc as [rllse | rlmc].
        assert (h := rllse rta rmcca y1 x1 w1 z1);
        toBool; negb_p; toProp; tauto.
        assert (h := rlmc rtb rmccb y2 x2 w2 z2);
        toBool; negb_p; toProp; tauto.
      (* 7 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 8 *)
      assert (h := rleseb rtb rmccb x2 y2 z2 w2);
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma rightLeSwapEquiv_comp : 
      RightLeSwapEquiv_comp A +
      RightLeSwapEquiv_comp B +
      (RightLtLeSwapEquiv_comp A * RightLeMultComp_comp B) +
      (RightLtSwapEquiv_comp A * RightMultComp_comp B)
      -> RightLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [[[p1 | p2] | [p3 p4]] | [p5 p6]].
      apply rlese_CE_1; auto.
      apply rlese_CE_2; auto.
      apply rlese_CE_3; auto.
      apply rlese_CE_4; auto.
   Defined.
   
   Lemma rmpll_CE_1 : RightMultPresLtLe_comp A -> RightMultPresLtLe_comp lexOrderSemigroup.
   Proof. intros rmpll rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rmpll rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma rmpll_CE_2 : RightMultPresLtLe_comp B -> RightMultPresLtLe_comp lexOrderSemigroup. 
   Proof. intros rmpll rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rmpll rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma rmpll_CE_3 : RightLtLeMulpCoh_comp A -> RightEquivCondensed_comp B -> RightMultPresLtLe_comp lexOrderSemigroup. 
   Proof. intros rllmc rec rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      assert (Exists x y w : B, y + w < x + w) as p2.
         destruct (rec) as [w [x [y p2]]].
         negb_p.
         copy_destruct (x + w <= y + w); rewrite ew in p2; simpl in p2.
            exists y; exists x; exists w; simpl; dseq_f; toProp. tauto.
            exists x; exists y; exists w; simpl; dseq_f; toProp; bool_p.
            assert (h := rtb w x y).
            tauto.
      destruct p2 as [x2 [y2 [w2 p2]]].
      destruct (rllmc rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].

      exists (x1, x2); exists (y1, y2); exists (z1, w2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined. 
   
   Lemma rightMultPresLtLe : 
      RightMultPresLtLe A * 
      RightMultPresLtLe B *
      (RightLtLeMulpCoh A + RightEquivCondensed B)
      -> RightMultPresLtLe lexOrderSemigroup.
   Proof. intros [[rmplla rmpllb] rllmc_rec]rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := x1 + z1 <= y1 + z1).
      set (b1 := y1 + z1 <= x1 + z1).
      set (c2 := x2 + z2 <= y2 + z2).
      set (d2 := y2 + z2 <= x2 + z2).
      set (e1 := y1 + w1 <= x1 + w1).
      set (f1 := x1 + w1 <= y1 + w1).
      set (g2 := y2 + w2 <= x2 + w2).
      set (h2 := x2 + w2 <= y2 + w2).
      
      assert (
         (negb a1 || b1      || negb e1 || f1) &&
         (negb a1 || b1      || negb e1 || negb g2 || h2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
      
      (* 1 *)
      assert (h := rmplla rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rllmc_rec as [rllca | rec].
         assert (h := rllca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
         assert (h := rec w2 x2 y2); toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct rllmc_rec as [rllca | rec].
         assert (h := rllca rta rmcca y1 x1 w1 z1); toBool; negb_p; toProp; tauto.
         assert (h := rec z2 x2 y2); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rmpllb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
      
   Lemma rightMultPresLtLe_comp : 
      RightMultPresLtLe_comp A +
      RightMultPresLtLe_comp B +
      (RightLtLeMulpCoh_comp A * RightEquivCondensed_comp B)
      -> RightMultPresLtLe_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p3 p4]].
      apply rmpll_CE_1; auto.
      apply rmpll_CE_2; auto.
      apply rmpll_CE_3; auto.
   Defined.
   
   Lemma rightStrictEquiv : RightStrictEquiv A * RightStrictEquiv B -> RightStrictEquiv lexOrderSemigroup.
   Proof. intros [rsea rseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := y1 + w1 <= x1 + w1).
      set (b1 := x1 + w1 <= y1 + w1).
      set (c2 := y2 + w2 <= x2 + w2).
      set (d2 := x2 + w2 <= y2 + w2).
      set (e1 := x1 + z1 <= y1 + w1).
      set (f1 := y1 + w1 <= x1 + z1).
      set (g2 := x2 + z2 <= y2 + w2).
      set (h2 := y2 + w2 <= x2 + z2).
      
      assert (
         (negb a1 || b1 || negb e1 || negb g2 || negb f1 || negb h2) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || negb f1 || negb h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
   
      (* 1 *)
      assert (h := rsea rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rseb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma rightStrictEquiv_comp : RightStrictEquiv_comp A + RightStrictEquiv_comp B -> RightStrictEquiv_comp lexOrderSemigroup.
   Proof. intros [rse | rse] rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rse rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rse rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma rlemc_CE_1 : RightLeMultComp_comp A -> RightLeMultComp_comp lexOrderSemigroup.
   Proof. intros rlemc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlemc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma rlemc_CE_2 : RightLeMultComp_comp B -> RightLeMultComp_comp lexOrderSemigroup. 
   Proof. intros rlemc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlemc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma rlemc_CE_3 : RightStrictEquiv_comp A -> RightMultComp_comp B -> RightLeMultComp_comp lexOrderSemigroup. 
   Proof. intros rlse rmc rt rmcc.
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      toProp; tauto.
   Defined.
   
   Lemma rightLeMultComp : 
      RightLeMultComp A *
      RightLeMultComp B *
      (RightStrictEquiv A + RightMultComp B)
      -> RightLeMultComp lexOrderSemigroup.
   Proof. intros [[rlemca rlemcb] rse_rmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := y1 + w1 <= x1 + w1).
      set (b1 := x1 + w1 <= y1 + w1).
      set (c2 := y2 + w2 <= x2 + w2).
      set (e1 := x1 + z1 <= y1 + w1).
      set (f1 := y1 + w1 <= x1 + z1).
      set (g2 := x2 + z2 <= y2 + w2).
      set (h2 := y2 + w2 <= x2 + z2).
      
      assert (
         (negb a1 || b1 || e1 || f1) &&
         (negb a1 || b1 || negb f1 || g2 || negb e1 || h2) &&
         (negb a1 || negb c2 || e1 || f1) &&
         (negb a1 || negb c2 || negb f1 || g2 || negb e1 || h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, e1, f1, g2, h2.
      
      (* 1 *)
      assert (h := rlemca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rse_rmc as [rse | rmc].
         assert (h := rse rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rlemca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rlemcb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma rightLeMultComp_comp : 
      RightLeMultComp_comp A +
      RightLeMultComp_comp B +
      (RightStrictEquiv_comp A * RightMultComp_comp B)
      -> RightLeMultComp_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p3 p4]].
      apply rlemc_CE_1; auto.
      apply rlemc_CE_2; auto.
      apply rlemc_CE_3; auto.
   Defined.
   
   Lemma rightLtLeMulpCoh : RightLtLeMulpCoh A * RightLtLeMulpCoh B -> RightLtLeMulpCoh lexOrderSemigroup.
   Proof. intros [rllmca rllmcb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := x1 + z1 <= y1 + z1) in *.
      set (b1 := y1 + z1 <= x1 + z1) in *.
      set (c2 := x2 + z2 <= y2 + z2) in *.
      set (d2 := y2 + z2 <= x2 + z2) in *.
      set (e1 := y1 + w1 <= x1 + w1) in *.
      set (f1 := x1 + w1 <= y1 + w1) in *.
      set (g2 := y2 + w2 <= x2 + w2) in *.
      
      assert (
         (negb a1 || b1 || negb e1 || f1) &&
         (negb a1 || b1 || negb e1 || negb g2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2.
      
      (* 1 *)
      assert (h := rllmca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rllmca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rllmca rta rmcca y1 x1 w1 z1); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rllmcb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma rightLtLeMulpCoh_comp : RightLtLeMulpCoh_comp A + RightLtLeMulpCoh_comp B -> RightLtLeMulpCoh_comp lexOrderSemigroup.
   Proof. intros [rllmc | rllmc] rt rmcc;
      assert (rta := rightTotal_back_a rt);
      assert (rtb := rightTotal_back_b rt);
      assert (rmcca := (rightMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (rightMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rllmc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rllmc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
      
   Lemma leftMultChoiseComp_back_a : LeftTotal lexOrderSemigroup -> LeftMultChoiseComp lexOrderSemigroup -> LeftMultChoiseComp A.
   Proof. intros rt rmcc _ x y z w.
      set (b := choose B).
      assert (h := rmcc rt (x, b) (y, b) (z, b) (w, b)).
      simpl in h. rewrite le_refl in h.
      repeat rewrite orb_true_r in h.
      repeat rewrite andb_true_r in h.
      auto.
   Qed.

   Lemma leftMultChoiseComp_back_b : LeftTotal lexOrderSemigroup -> LeftMultChoiseComp lexOrderSemigroup -> LeftMultChoiseComp B.
   Proof. intros rt rmcc _ x y z w.
      set (a := choose A).
      assert (h := rmcc rt (a, x) (a, y) (a, z) (a, w)).
      simpl in h. rewrite le_refl in h; simpl in h; auto.
   Qed.
   
   Lemma llse_CE_1 : LeftLtSwapEquiv_comp A -> LeftLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlsea rt rmcc.
      destruct (rlsea (leftTotal_back_a rt) (leftMultChoiseComp_back_a rt rmcc)) as [x [y [z [w p]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma llse_CE_2 : LeftLtSwapEquiv_comp B -> LeftLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlsea rt rmcc.
      destruct (rlsea (leftTotal_back_b rt) (leftMultChoiseComp_back_b rt rmcc)) as [x [y [z [w p]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      auto.
   Defined.

   Lemma llse_CE_3 :
      LeftLtLeSwapEquiv_comp A ->
      LeftStrictEquiv_comp B ->
      LeftLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rllsea rseb rt rmcc.
      destruct (rllsea (leftTotal_back_a rt) (leftMultChoiseComp_back_a rt rmcc)) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rseb (leftTotal_back_b rt) (leftMultChoiseComp_back_b rt rmcc)) as [x2 [y2 [z2 [w2 [p4 p5]]]]].         
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      toBool. negb_p.
      toProp. tauto.
   Defined.

   Lemma leftLtSwapEquiv : 
      LeftLtSwapEquiv A * 
      LeftLtSwapEquiv B *
      ( LeftLtLeSwapEquiv A + LeftStrictEquiv B )
      -> LeftLtSwapEquiv lexOrderSemigroup.
   Proof. intros [[rlsea rlseb] rllsea_rseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      
      assert (p1 := rlsea rta rmcca x1 y1 z1 w1).
      assert (p2 := rlseb rtb rmccb x2 y2 z2 w2).
      simpl. toBool. negb_p.
      set (a1 := z1 + x1 <= z1 + y1) in *.
      set (b1 := z1 + y1 <= z1 + x1) in *.
      set (a2 := z2 + x2 <= z2 + y2) in *.
      set (b2 := z2 + y2 <= z2 + x2) in *.
      set (c1 := w1 + y1 <= w1 + x1) in *.
      set (d1 := w1 + x1 <= w1 + y1) in *.
      set (c2 := w2 + y2 <= w2 + x2) in *.
      set (d2 := w2 + x2 <= w2 + y2) in *.
      set (e1 := z1 + x1 <= w1 + y1) in *.
      set (f1 := w1 + y1 <= z1 + x1) in *.
      set (e2 := z2 + x2 <= w2 + y2) in *.
      set (f2 := w2 + y2 <= z2 + x2) in *.
      repeat rewrite (orb_assoc).
      assert (
         (negb a1 || b1      || negb c1 || d1            || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || b1      || negb c1 || negb c2 || d2 || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || negb a2 || b2 || negb c1 || d1            || negb e1 || negb e2 || negb f1 || negb f2) &&
         (negb a1 || negb a2 || b2 || negb c1 || negb c2 || d2 || negb e1 || negb e2 || negb f1 || negb f2)
      ) as q1;
      [|
         destruct a1 as [|]; simpl; auto;
         destruct b1 as [|]; simpl; auto;
         destruct a2 as [|]; simpl; auto;
         destruct b2 as [|]; simpl; auto;
         destruct c1 as [|]; simpl; auto;
         destruct d1 as [|]; simpl; auto;
         destruct c2 as [|]; simpl; auto;
         destruct d2 as [|]; simpl; auto;
         destruct e1 as [|]; simpl; auto;
         destruct e2 as [|]; simpl; auto;
         destruct f1 as [|]; simpl; auto;
         destruct f2 as [|]; simpl; auto
      ].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      (* 1 *)
      toProp; tauto.
      (* 2 *)
      destruct rllsea_rseb as [rllsea | rseb].
         assert (h := rllsea rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
         
         assert (h := rseb rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
      (* 3 *)
      destruct rllsea_rseb as [rllsea | rseb].
         assert (h := rllsea rta rmcca y1 x1 w1 z1).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
         
         assert (h := rseb rtb rmccb y2 x2 w2 z2).
         toBool; negb_p; toProp. unfold a1, b1, c1, d1, e1, f1, a2, b2, c2, d2, e2, f2.
         clear p1 p2; tauto.
      (* 4 *)
      toProp; tauto.
   Qed.

   Lemma leftLtSwapEquiv_comp : 
      LeftLtSwapEquiv_comp A +
      LeftLtSwapEquiv_comp B +
      ( LeftLtLeSwapEquiv_comp A * LeftStrictEquiv_comp B )
      -> LeftLtSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p4 p5]].
      apply llse_CE_1; auto.
      apply llse_CE_2; auto.
      apply llse_CE_3; auto.
   Defined.
   
   Lemma leftMultComp : LeftMultComp A * LeftMultComp B -> LeftMultComp lexOrderSemigroup.
   Proof. intros [rmca rmcb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      negb_p; simpl.
      set (a1 := z1 + x1 <= w1 + y1).
      set (b1 := w1 + y1 <= z1 + x1).
      set (a2 := z2 + x2 <= w2 + y2).
      set (b2 := w2 + y2 <= z2 + x2).
      assert ((a1 || b1) && (negb b1 || negb a1 || a2 || b2)) as e1;
      [|
         destruct a1 as [|]; simpl; auto;
         destruct b1 as [|]; simpl; auto;
         destruct a2 as [|]; simpl; auto;
         destruct b2 as [|]; simpl; auto
      ].
      toProp; split.
      unfold a1, b1; assert (h := rmca rta rmcca x1 y1 z1 w1); negb_p; toProp; auto.
      unfold a2, b2; assert (h := rmcb rtb rmccb x2 y2 z2 w2); negb_p; toProp; tauto.
   Qed.
   
   Lemma leftMultComp_comp : LeftMultComp_comp A + LeftMultComp_comp B -> LeftMultComp_comp lexOrderSemigroup.
   Proof. intros [rmca | rmcb] rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      
      assert (b := choose B).
      destruct (rmca rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl;
      repeat rewrite orb_true_r; simpl;
      repeat rewrite andb_false_r;
      repeat rewrite orb_false_r.
      auto.

      assert (a := choose A).
      destruct (rmcb rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl;
      repeat rewrite orb_true_r; simpl. auto.
   Defined.
   
   Lemma lmsc_CE_1 : LeftMultSplitComp_comp A -> LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rmsc rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      set (b := choose B).
      destruct (rmsc rta rmcca) as [x [y [z [w [p1 [p2 p3]]]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p. rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.

   Lemma lmsc_CE_2 : LeftMultSplitComp_comp B -> LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rmsc rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      set (a := choose A).
      destruct (rmsc rtb rmccb) as [x [y [z [w [p1 [p2 p3]]]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p. rewrite le_refl; simpl. auto.
   Defined.
   
   Lemma lmsc_CE_3 : LeftLtSwapEquiv_comp A -> LeftMultComp_comp B -> LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rlse rmc rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 [p1 [p2 p3]]]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p4]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma lmsc_CE_4 : 
      LeftLtLeSwapEquiv_comp A -> 
      LeftLeMultComp_comp B -> 
      LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rllse rlmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      destruct (rllse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rlmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.

   Lemma lmsc_CE_5 :
      LeftLeSwapEquiv_comp A ->
      LeftLtLeMulpCoh_comp B ->
      LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros rlse rllse rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rllse rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split. toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma leftMultSplitComp : 
      LeftMultSplitComp A *
      LeftMultSplitComp B *
      (LeftLtSwapEquiv A + LeftMultComp B) *
      (LeftLtLeSwapEquiv A + LeftLeMultComp B) *
      (LeftLeSwapEquiv A + LeftLtLeMulpCoh B)
      -> LeftMultSplitComp lexOrderSemigroup.
   Proof. intros [[[[rmsca rmscb] rlse_rmc] rllse_rlmc] rlse_rllmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      simpl; toBool; negb_p; simpl.
      set (a1 := z1 + x1 <= z1 + y1).
      set (b1 := z1 + y1 <= z1 + x1).
      set (c2 := z2 + x2 <= z2 + y2).
      set (d2 := z2 + y2 <= z2 + x2).
      set (e1 := w1 + x1 <= w1 + y1).
      set (f1 := w1 + y1 <= w1 + x1).
      set (g2 := w2 + y2 <= w2 + x2).
      set (h1 := z1 + x1 <= w1 + y1).
      set (i1 := w1 + y1 <= z1 + x1).
      set (j2 := z2 + x2 <= w2 + y2).
      set (k2 := w2 + y2 <= z2 + x2).
      
      repeat rewrite orb_assoc.
      assert (
         (negb a1 || b1            || negb f1 || e1      || h1 || i1) &&
         (negb a1 || b1            || negb f1 || e1      || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || b1            || negb f1 || negb g2 || h1 || i1) &&
         (negb a1 || b1            || negb f1 || negb g2 || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || negb c2 || d2 || negb f1 || e1      || h1 || i1) &&
         (negb a1 || negb c2 || d2 || negb f1 || e1      || negb i1 || j2 || negb h1 || k2) &&
         (negb a1 || negb c2 || d2 || negb f1 || negb g2 || h1 || i1) &&
         (negb a1 || negb c2 || d2 || negb f1 || negb g2 || negb i1 || j2 || negb h1 || k2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h1; simpl; auto;
      destruct i1; simpl; auto;
      destruct j2; simpl; auto;
      destruct k2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      (* 1 *)
      unfold a1, b1, f1, e1, h1, i1.
      assert (h := rmcca rta x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      unfold a1, b1, f1, e1, i1, j2, h1, k2.
      destruct (rlse_rmc) as [rlse | rmc].
         assert (h := rlse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. tauto.
      (* 3 *)
      unfold a1, b1, f1, g2, i1, h1.
      assert (h := rmsca rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      unfold a1, b1, f1, g2, i1, j2, h1, k2.
      destruct (rllse_rlmc) as [rllse | rlmc].
         assert (h := rllse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp. tauto.
         assert (h := rlmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp. tauto.      
      (* 5 *)
      unfold a1, c2, d2, f1, e1, i1, h1.
      assert (h := rmsca rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      unfold a1, b1, f1, g2, i1, j2, h1, k2.
      destruct (rllse_rlmc) as [rllse | rlmc].
         assert (h := rllse rta rmcca y1 x1 w1 z1).
         toBool; negb_p; toProp. tauto.
         assert (h := rlmc rtb rmccb y2 x2 w2 z2).
         toBool; negb_p; toProp. tauto.            
      (* 7 *)
      unfold a1, c2, d2, f1, g2, i1, h1.
      destruct (rlse_rllmc) as [rlse | rllmc].
         assert (h := rlse rta rmcca x1 y1 z1 w1).
         toBool; negb_p; toProp; tauto.
         assert (h := rllmc rtb rmccb x2 y2 z2 w2).
         toBool; negb_p; toProp; tauto.      
      (* 8 *)
      unfold a1, c2, d2, f1, g2, i1, j2, h1, k2.
      assert (h := rmscb rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma leftMultSplitComp_comp : 
      LeftMultSplitComp_comp A +
      LeftMultSplitComp_comp B +
      (LeftLtSwapEquiv_comp A * LeftMultComp_comp B) +
      (LeftLtLeSwapEquiv_comp A * LeftLeMultComp_comp B) +
      (LeftLeSwapEquiv_comp A * LeftLtLeMulpCoh_comp B)
      -> LeftMultSplitComp_comp lexOrderSemigroup.
   Proof. intros [[[[p1 | p2] | [p3 p4]] | [p5 p6]] | [p7 p8]].
      apply lmsc_CE_1; auto.
      apply lmsc_CE_2; auto.
      apply lmsc_CE_3; auto.
      apply lmsc_CE_4; auto.
      apply lmsc_CE_5; auto.
   Defined.
   
   Lemma leftLtLeSwapEquiv : LeftLtLeSwapEquiv A * LeftLtLeSwapEquiv B -> LeftLtLeSwapEquiv lexOrderSemigroup.
   Proof. intros [rllsea rllseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := z1 + x1 <= z1 + y1).
      set (b1 := z1 + y1 <= z1 + x1).
      set (c2 := z2 + x2 <= z2 + y2).
      set (d2 := z2 + y2 <= z2 + x2).
      set (e1 := w1 + y1 <= w1 + x1).
      set (f1 := w1 + x1 <= w1 + y1).
      set (g2 := w2 + y2 <= w2 + x2).
      set (h1 := z1 + x1 <= w1 + y1).
      set (i1 := w1 + y1 <= z1 + x1).
      set (j2 := z2 + x2 <= w2 + y2).
      set (k2 := w2 + y2 <= z2 + x2).
      
      assert (
         (negb a1 || b1            || negb e1 || f1      || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || b1            || negb e1 || negb g2 || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1      || negb h1 || negb j2 || negb i1 || negb k2) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || negb h1 || negb j2 || negb i1 || negb k2)
      ) as q2;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h1; simpl; auto;
      destruct i1; simpl; auto;
      destruct j2; simpl; auto;
      destruct k2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h1, i1, j2, k2.
      (* 1 *)
      assert (h := rllsea rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rllsea rta rmcca x1 y1 z1 w1).
      toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rllsea rta rmcca y1 x1 w1 z1).
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rllseb rtb rmccb x2 y2 z2 w2).
      toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma leftLtLeSwapEquiv_comp : 
      LeftLtLeSwapEquiv_comp A + LeftLtLeSwapEquiv_comp B -> 
      LeftLtLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [rllse | rllse] rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      
      set (b := choose B).
      destruct (rllse rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rllse rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl. auto.
   Defined.
   
   Lemma llmc_CE_1 : LeftLtMultComp_comp A -> LeftLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlmc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma llmc_CE_2 : LeftLtMultComp_comp B -> LeftLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlmc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma llmc_CE_3 : LeftStrictEquiv_comp A -> LeftMultComp_comp B -> LeftLtMultComp_comp lexOrderSemigroup.
   Proof. intros rse rmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      destruct (rse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined.
   
   Lemma llmc_CE_4 : LeftLeMultComp_comp A -> LeftEquivCondensed_comp B -> LeftLtMultComp_comp lexOrderSemigroup.
   Proof. intros rlmc rec rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      assert (Exists x y w : B, w + y < w + x) as p2.
         destruct (rec) as [w [x [y p2]]].
         negb_p.
         copy_destruct (w + x <= w + y); rewrite ew in p2; simpl in p2.
            exists y; exists x; exists w; simpl; dseq_f; toProp. tauto.
            exists x; exists y; exists w; simpl; dseq_f; toProp; bool_p.
            assert (h := rtb w x y).
            tauto.
      destruct p2 as [x2 [y2 [w2 p2]]].
      destruct (rlmc rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].

      exists (x1, x2); exists (y1, y2); exists (z1, w2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined.
   
   Lemma leftLtMultComp : 
      LeftLtMultComp A *
      LeftLtMultComp B *
      (LeftStrictEquiv A + LeftMultComp B) *
      (LeftLeMultComp A + LeftEquivCondensed B) ->
      LeftLtMultComp lexOrderSemigroup.
   Proof. intros [[[rlmca rlmcb] rse_rmc] rlmc_rec] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := w1 + y1 <= w1 + x1).
      set (b1 := w1 + x1 <= w1 + y1).
      set (c2 := w2 + y2 <= w2 + x2).
      set (d2 := w2 + x2 <= w2 + y2).
      set (e1 := z1 + x1 <= w1 + y1).
      set (f1 := w1 + y1 <= z1 + x1).
      set (g2 := z2 + x2 <= w2 + y2).
      set (h2 := w2 + y2 <= z2 + x2).

      assert (
         (negb a1 || b1            || e1 || f1) &&
         (negb a1 || b1            || negb f1 || g2 || negb e1 || h2) &&
         (negb a1 || negb c2 || d2 || e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb f1 || g2 || negb e1 || h2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
      (* 1 *)
      assert (h := rlmca rta rmcca x1 y1 z1 w1); 
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct (rse_rmc) as [rse | rmc].
         assert (h := rse rta rmcca x1 y1 z1 w1);
         toBool; negb_p; toProp; tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2);
         toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct (rlmc_rec) as [rlmc | rec].
         assert (h := rlmc rta rmcca x1 y1 z1 w1);
         toBool; negb_p; toProp; tauto.
         assert (h := rec w2 x2 y2).
         toBool; negb_p; toProp. tauto.      
      (* 4 *)
      assert (h := rlmcb rtb rmccb x2 y2 z2 w2); 
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma leftLtMultComp_comp : 
      LeftLtMultComp_comp A +
      LeftLtMultComp_comp B +
      (LeftStrictEquiv_comp A * LeftMultComp_comp B) +
      (LeftLeMultComp_comp A * LeftEquivCondensed_comp B) ->
      LeftLtMultComp_comp lexOrderSemigroup.
   Proof. intros [[[p1 | p2] | [p3 p4]] | [p5 p6]].
      apply llmc_CE_1; auto.
      apply llmc_CE_2; auto.
      apply llmc_CE_3; auto.
      apply llmc_CE_4; auto.
   Defined.
   
   Lemma llese_CE_1 : LeftLeSwapEquiv_comp A -> LeftLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlese rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlese rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma llese_CE_2 : LeftLeSwapEquiv_comp B -> LeftLeSwapEquiv_comp lexOrderSemigroup. 
   Proof. intros rlese rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlese rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma llese_CE_3 : LeftLtLeSwapEquiv_comp A -> LeftLeMultComp_comp B -> LeftLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rllse rlmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      destruct (rllse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rlmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      split; toProp; tauto.
   Defined.
   
   Lemma llese_CE_4 : LeftLtSwapEquiv_comp A -> LeftMultComp_comp B -> LeftLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros rlse rmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      split; toProp; tauto.
   Defined.

   Lemma leftLeSwapEquiv : 
      LeftLeSwapEquiv A * 
      LeftLeSwapEquiv B *
      (LeftLtLeSwapEquiv A + LeftLeMultComp B) *
      (LeftLtSwapEquiv A + LeftMultComp B)
      -> LeftLeSwapEquiv lexOrderSemigroup.
   Proof. intros [[[rlesea rleseb] rllse_rlmc] rlse_rmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := z1 + x1 <= z1 + y1).
      set (b1 := z1 + y1 <= z1 + x1).
      set (c2 := z2 + x2 <= z2 + y2).
      set (d1 := w1 + y1 <= w1 + x1).
      set (e1 := w1 + x1 <= w1 + y1).
      set (f2 := w2 + y2 <= w2 + x2).
      set (g1 := z1 + x1 <= w1 + y1).
      set (h1 := w1 + y1 <= z1 + x1).
      set (i2 := z2 + x2 <= w2 + y2).
      set (j2 := w2 + y2 <= z2 + x2).
      
      assert (
         (negb a1 || b1      || negb d1 || e1      || g1 || h1) &&
         (negb a1 || b1      || negb d1 || e1      || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || b1      || negb d1 || negb f2 || g1 || h1) &&
         (negb a1 || b1      || negb d1 || negb f2 || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || negb c2 || negb d1 || e1      || g1 || h1) &&
         (negb a1 || negb c2 || negb d1 || e1      || negb h1 || i2 || negb g1 || j2) &&
         (negb a1 || negb c2 || negb d1 || negb f2 || g1 || h1) &&
         (negb a1 || negb c2 || negb d1 || negb f2 || negb h1 || i2 || negb g1 || j2)         
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d1; simpl; auto;
      destruct e1; simpl; auto;
      destruct f2; simpl; auto;
      destruct g1; simpl; auto;
      destruct h1; simpl; auto;
      destruct i2; simpl; auto;
      destruct j2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1.
      unfold a1, b1, c2, d1, e1, f2, g1, h1, i2, j2.
      
      (* 1 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rlse_rmc as [rlse | rmc].
        assert (h := rlse rta rmcca x1 y1 z1 w1);
        toBool; negb_p; toProp; tauto.
        assert (h := rmc rtb rmccb x2 y2 z2 w2);
        toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 4 *)
      destruct rllse_rlmc as [rllse | rlmc].
        assert (h := rllse rta rmcca x1 y1 z1 w1);
        toBool; negb_p; toProp; tauto.
        assert (h := rlmc rtb rmccb x2 y2 z2 w2);
        toBool; negb_p; toProp; tauto.
      (* 5 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 6 *)
      destruct rllse_rlmc as [rllse | rlmc].
        assert (h := rllse rta rmcca y1 x1 w1 z1);
        toBool; negb_p; toProp; tauto.
        assert (h := rlmc rtb rmccb y2 x2 w2 z2);
        toBool; negb_p; toProp; tauto.
      (* 7 *)
      assert (h := rlesea rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 8 *)
      assert (h := rleseb rtb rmccb x2 y2 z2 w2);
      toBool; negb_p; toProp; tauto.
   Qed.

   Lemma leftLeSwapEquiv_comp : 
      LeftLeSwapEquiv_comp A +
      LeftLeSwapEquiv_comp B +
      (LeftLtLeSwapEquiv_comp A * LeftLeMultComp_comp B) +
      (LeftLtSwapEquiv_comp A * LeftMultComp_comp B)
      -> LeftLeSwapEquiv_comp lexOrderSemigroup.
   Proof. intros [[[p1 | p2] | [p3 p4]] | [p5 p6]].
      apply llese_CE_1; auto.
      apply llese_CE_2; auto.
      apply llese_CE_3; auto.
      apply llese_CE_4; auto.
   Defined.
   
   Lemma lmpll_CE_1 : LeftMultPresLtLe_comp A -> LeftMultPresLtLe_comp lexOrderSemigroup.
   Proof. intros rmpll rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rmpll rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma lmpll_CE_2 : LeftMultPresLtLe_comp B -> LeftMultPresLtLe_comp lexOrderSemigroup. 
   Proof. intros rmpll rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rmpll rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma lmpll_CE_3 : LeftLtLeMulpCoh_comp A -> LeftEquivCondensed_comp B -> LeftMultPresLtLe_comp lexOrderSemigroup. 
   Proof. intros rllmc rec rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      assert (Exists x y w : B, w + y < w + x) as p2.
         destruct (rec) as [w [x [y p2]]].
         negb_p.
         copy_destruct (w + x <= w + y); rewrite ew in p2; simpl in p2.
            exists y; exists x; exists w; simpl; dseq_f; toProp. tauto.
            exists x; exists y; exists w; simpl; dseq_f; toProp; bool_p.
            assert (h := rtb w x y).
            tauto.
      destruct p2 as [x2 [y2 [w2 p2]]].
      destruct (rllmc rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].

      exists (x1, x2); exists (y1, y2); exists (z1, w2); exists (w1, w2); simpl.
      negb_p; simpl. split; toProp; tauto.
   Defined. 
   
   Lemma leftMultPresLtLe : 
      LeftMultPresLtLe A * 
      LeftMultPresLtLe B *
      (LeftLtLeMulpCoh A + LeftEquivCondensed B)
      -> LeftMultPresLtLe lexOrderSemigroup.
   Proof. intros [[rmplla rmpllb] rllmc_rec]rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := z1 + x1 <= z1 + y1).
      set (b1 := z1 + y1 <= z1 + x1).
      set (c2 := z2 + x2 <= z2 + y2).
      set (d2 := z2 + y2 <= z2 + x2).
      set (e1 := w1 + y1 <= w1 + x1).
      set (f1 := w1 + x1 <= w1 + y1).
      set (g2 := w2 + y2 <= w2 + x2).
      set (h2 := w2 + x2 <= w2 + y2).
      
      assert (
         (negb a1 || b1      || negb e1 || f1) &&
         (negb a1 || b1      || negb e1 || negb g2 || h2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
      
      (* 1 *)
      assert (h := rmplla rta rmcca x1 y1 z1 w1);
      toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rllmc_rec as [rllca | rec].
         assert (h := rllca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
         assert (h := rec w2 x2 y2); toBool; negb_p; toProp; tauto.
      (* 3 *)
      destruct rllmc_rec as [rllca | rec].
         assert (h := rllca rta rmcca y1 x1 w1 z1); toBool; negb_p; toProp; tauto.
         assert (h := rec z2 x2 y2); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rmpllb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
      
   Lemma leftMultPresLtLe_comp : 
      LeftMultPresLtLe_comp A +
      LeftMultPresLtLe_comp B +
      (LeftLtLeMulpCoh_comp A * LeftEquivCondensed_comp B)
      -> LeftMultPresLtLe_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p3 p4]].
      apply lmpll_CE_1; auto.
      apply lmpll_CE_2; auto.
      apply lmpll_CE_3; auto.
   Defined.
   
   Lemma leftStrictEquiv : LeftStrictEquiv A * LeftStrictEquiv B -> LeftStrictEquiv lexOrderSemigroup.
   Proof. intros [rsea rseb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := w1 + y1 <= w1 + x1).
      set (b1 := w1 + x1 <= w1 + y1).
      set (c2 := w2 + y2 <= w2 + x2).
      set (d2 := w2 + x2 <= w2 + y2).
      set (e1 := z1 + x1 <= w1 + y1).
      set (f1 := w1 + y1 <= z1 + x1).
      set (g2 := z2 + x2 <= w2 + y2).
      set (h2 := w2 + y2 <= z2 + x2).
      
      assert (
         (negb a1 || b1 || negb e1 || negb g2 || negb f1 || negb h2) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2 || negb f1 || negb h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2, h2.
   
      (* 1 *)
      assert (h := rsea rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rseb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma leftStrictEquiv_comp : LeftStrictEquiv_comp A + LeftStrictEquiv_comp B -> LeftStrictEquiv_comp lexOrderSemigroup.
   Proof. intros [rse | rse] rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rse rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rse rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma llemc_CE_1 : LeftLeMultComp_comp A -> LeftLeMultComp_comp lexOrderSemigroup.
   Proof. intros rlemc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rlemc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.
   Defined.
   
   Lemma llemc_CE_2 : LeftLeMultComp_comp B -> LeftLeMultComp_comp lexOrderSemigroup. 
   Proof. intros rlemc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (a := choose A).
      destruct (rlemc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
   
   Lemma llemc_CE_3 : LeftStrictEquiv_comp A -> LeftMultComp_comp B -> LeftLeMultComp_comp lexOrderSemigroup. 
   Proof. intros rlse rmc rt rmcc.
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      destruct (rlse rta rmcca) as [x1 [y1 [z1 [w1 p1]]]].
      destruct (rmc rtb rmccb) as [x2 [y2 [z2 [w2 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2); exists (w1, w2); simpl.
      negb_p. split.
      toProp; tauto.
      toProp; tauto.
   Defined.
   
   Lemma leftLeMultComp : 
      LeftLeMultComp A *
      LeftLeMultComp B *
      (LeftStrictEquiv A + LeftMultComp B)
      -> LeftLeMultComp lexOrderSemigroup.
   Proof. intros [[rlemca rlemcb] rse_rmc] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := w1 + y1 <= w1 + x1).
      set (b1 := w1 + x1 <= w1 + y1).
      set (c2 := w2 + y2 <= w2 + x2).
      set (e1 := z1 + x1 <= w1 + y1).
      set (f1 := w1 + y1 <= z1 + x1).
      set (g2 := z2 + x2 <= w2 + y2).
      set (h2 := w2 + y2 <= z2 + x2).
      
      assert (
         (negb a1 || b1 || e1 || f1) &&
         (negb a1 || b1 || negb f1 || g2 || negb e1 || h2) &&
         (negb a1 || negb c2 || e1 || f1) &&
         (negb a1 || negb c2 || negb f1 || g2 || negb e1 || h2)
      ) as p1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto;
      destruct h2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, e1, f1, g2, h2.
      
      (* 1 *)
      assert (h := rlemca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      destruct rse_rmc as [rse | rmc].
         assert (h := rse rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
         assert (h := rmc rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rlemca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rlemcb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma leftLeMultComp_comp : 
      LeftLeMultComp_comp A +
      LeftLeMultComp_comp B +
      (LeftStrictEquiv_comp A * LeftMultComp_comp B)
      -> LeftLeMultComp_comp lexOrderSemigroup.
   Proof. intros [[p1 | p2] | [p3 p4]].
      apply llemc_CE_1; auto.
      apply llemc_CE_2; auto.
      apply llemc_CE_3; auto.
   Defined.
   
   Lemma leftLtLeMulpCoh : LeftLtLeMulpCoh A * LeftLtLeMulpCoh B -> LeftLtLeMulpCoh lexOrderSemigroup.
   Proof. intros [rllmca rllmcb] rt rmcc [x1 x2] [y1 y2] [z1 z2] [w1 w2];
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).
      simpl; toBool; negb_p;
      repeat rewrite orb_assoc.

      set (a1 := z1 + x1 <= z1 + y1) in *.
      set (b1 := z1 + y1 <= z1 + x1) in *.
      set (c2 := z2 + x2 <= z2 + y2) in *.
      set (d2 := z2 + y2 <= z2 + x2) in *.
      set (e1 := w1 + y1 <= w1 + x1) in *.
      set (f1 := w1 + x1 <= w1 + y1) in *.
      set (g2 := w2 + y2 <= w2 + x2) in *.
      
      assert (
         (negb a1 || b1 || negb e1 || f1) &&
         (negb a1 || b1 || negb e1 || negb g2) &&
         (negb a1 || negb c2 || d2 || negb e1 || f1) &&
         (negb a1 || negb c2 || d2 || negb e1 || negb g2)
      ) as q1;
      [|
      destruct a1; simpl; auto;
      destruct b1; simpl; auto;
      destruct c2; simpl; auto;
      destruct d2; simpl; auto;
      destruct e1; simpl; auto;
      destruct f1; simpl; auto;
      destruct g2; simpl; auto].
      assert (forall w1 w2 : bool, w1 -> w2 -> w1 && w2) as q1.
         intros r1 r2 t1 t2; rewrite t1, t2; auto.
      repeat (apply q1); clear q1;
      unfold a1, b1, c2, d2, e1, f1, g2.
      
      (* 1 *)
      assert (h := rllmca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 2 *)
      assert (h := rllmca rta rmcca x1 y1 z1 w1); toBool; negb_p; toProp; tauto.
      (* 3 *)
      assert (h := rllmca rta rmcca y1 x1 w1 z1); toBool; negb_p; toProp; tauto.
      (* 4 *)
      assert (h := rllmcb rtb rmccb x2 y2 z2 w2); toBool; negb_p; toProp; tauto.
   Qed.
   
   Lemma leftLtLeMulpCoh_comp : LeftLtLeMulpCoh_comp A + LeftLtLeMulpCoh_comp B -> LeftLtLeMulpCoh_comp lexOrderSemigroup.
   Proof. intros [rllmc | rllmc] rt rmcc;
      assert (rta := leftTotal_back_a rt);
      assert (rtb := leftTotal_back_b rt);
      assert (rmcca := (leftMultChoiseComp_back_a rt rmcc));
      assert (rmccb := (leftMultChoiseComp_back_b rt rmcc)).

      set (b := choose B).
      destruct (rllmc rta rmcca) as [x [y [z [w p]]]].
      exists (x, b); exists (y, b); exists (z, b); exists (w, b); simpl.
      negb_p; rewrite le_refl; simpl.
      repeat rewrite orb_true_r.
      repeat rewrite andb_true_r.
      repeat rewrite andb_false_r.
      repeat rewrite orb_false_r.
      auto.

      set (a := choose A).
      destruct (rllmc rtb rmccb) as [x [y [z [w p]]]].
      exists (a, x); exists (a, y); exists (a, z); exists (a, w); simpl.
      negb_p; rewrite le_refl; simpl; auto.
   Defined.
      

      
      



End Lex.