Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Coq.Bool.Bool.

Section LeftNaturalOrder.

   Variable S : Semigroup.
   Variable idem : IsIdempotent S.
   Variable comm : IsCommutative S.

   Open Scope Semigroup_scope.

   Definition leftNaturalOrder :=
      glueOSmg S (leftNaturalOrder S idem) (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _). *)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

   Open Scope Semigroup_scope.
   
   Ltac le_u :=
      simpl in *; unfold LeftNaturalOrder.le in *.
   
   Lemma leftMonotonic : LeftMonotonic leftNaturalOrder.
   Proof. intros a x y; le_u;
      intros h; dseq_f; rewrite (comm a y), (Semigroup.assoc S a x (y + a)), 
        <- (Semigroup.assoc S x y a), h, (comm x a), <- (Semigroup.assoc S a a x), (idem a); auto.
   Defined.
   
   Lemma rightMonotonic : RightMonotonic leftNaturalOrder.
   Proof. intros a x y; le_u;
      intros h; dseq_f; rewrite (comm a y), (Semigroup.assoc S y a (x + y)),
         <- (Semigroup.assoc S a x y), h, (comm a y), <- (Semigroup.assoc S y y a), (idem y); auto.
   Defined.

   Lemma topIsIdentity : TopIsIdentity leftNaturalOrder.
   Proof. intros [top p] [id q]; toProp; split; le_u; destruct (q top); dseq_f; auto. apply p. Defined.

   Lemma topIsAnnihilator : IsSingleton S -> TopIsAnnihilator leftNaturalOrder.
   Proof. intros [a sg] [top p] [id q]; toProp; simpl in *; le_u; dseq_f.
      destruct (q top); split; auto. rewrite (sg (top + id)), (sg top); auto. Defined.

   Lemma topIsAnnihilator_comp : IsSingleton_comp S -> TopIsAnnihilator_comp leftNaturalOrder.
   Proof. intros sg [bot p] [ann q]; toProp; simpl in *; le_u; dseq_f. intros [h1 h2].
      destruct (sg bot). toProp; elim b. dseq_f. clear b.
      destruct (q bot) as [_ h3].
      rewrite h3 in h1.
      assert (h4 := p x); dseq_f.
      rewrite <- h4.
      rewrite <- h1.
      destruct (q x); auto.
   Defined.
   
   Lemma bottomIsIdentity : IsSingleton S -> BottomIsIdentity leftNaturalOrder.
   Proof. intros [a sa] [bot p] [ann q]; toProp; le_u; dseq_f; simpl in *.
      rewrite (sa bot), (sa ann), (idem a); auto. Defined.

   Lemma bottomIsIdentity_comp : IsSingleton_comp S -> BottomIsIdentity_comp leftNaturalOrder.
   Proof. intros sg [top p] [id q]; toProp; simpl in *; le_u; dseq_f. intros [h1 h2].
      destruct (sg top). toProp; elim b. dseq_f. clear b.
      destruct (q top) as [h3 _].
      rewrite h3 in h2.
      destruct (q x) as [h4 h5].
      rewrite <- h4.
      rewrite <- h2.
      apply p.
   Defined.

   Lemma bottomIsAnnihilator : BottomIsAnnihilator leftNaturalOrder.
   Proof. intros [bot p] [id q]; toProp; split; le_u; destruct (q bot); dseq_f; auto. apply p. Defined.

   Lemma rightOpNonDecreasing : IsSingleton S -> RightOpNonDecreasing leftNaturalOrder.
   Proof. intros [a s] x y; le_u; dseq_f; rewrite (s x), (s y), (idem a), (idem a); auto. Defined.
   
   Lemma rightOpNonDecreasing_comp : IsSingleton_comp S -> RightOpNonDecreasing_comp leftNaturalOrder.
   Proof. intros s; destruct (s (choose S)) as [x p];
      copy_destruct (@equal S (x + choose S) (choose S));
      [ exists x; exists (choose S); le_u; toProp; dseq_f;
        intros h; apply p; rewrite (comm _ x), ew, ew in h; dseq_f; rewrite h; auto
      | exists (choose S); exists x; le_u; toProp; bool_p; intros h; apply ew; dseq_f;
        rewrite (comm x), <- (Semigroup.assoc S (choose S)), (idem (choose S)), (comm _ x) in h; auto ].
   Defined.

   Lemma leftOpNonDecreasing : IsSingleton S -> LeftOpNonDecreasing leftNaturalOrder.
   Proof. intros [a s] x y; le_u; dseq_f; rewrite (s x), (s y), (idem a), (idem a); auto. Defined.
   
   Lemma leftOpNonDecreasing_comp : IsSingleton_comp S -> LeftOpNonDecreasing_comp leftNaturalOrder.
   Proof. intros s; destruct (s (choose S)) as [x p];
      copy_destruct (@equal S (x + choose S) (choose S));
      [ exists x; exists (choose S); le_u; toProp; dseq_f;
        intros h; apply p; rewrite ew, ew in h; dseq_f; rewrite h; auto
      | exists (choose S); exists x; le_u; toProp; bool_p; intros h; apply ew; dseq_f;
        rewrite <- (Semigroup.assoc S (choose S)), (idem (choose S)), (comm _ x) in h; auto ].
   Defined.
   
   Lemma selectiveOpNonDecreasing : IsSelective S -> SelectiveOpNonDecreasing leftNaturalOrder.
   Proof. intros sel _ _ x y; le_u; destruct (sel x y) as [H|H]; dseq_f; rewrite H; auto. Defined.

   Lemma selectiveOpNonDecreasing_comp : IsSelective_comp S -> SelectiveOpNonDecreasing_comp leftNaturalOrder.
   Proof. intros [a [b [sl1 sl2]]] _ _;
      exists a; exists b; le_u; negb_p; toProp; split; intros h.
         apply sl1; dseq_f; rewrite <- (Semigroup.assoc S a), (idem a) in h; trivial.
         apply sl2; dseq_f; rewrite (comm a b), <- (Semigroup.assoc S b), (idem b) in h; rewrite (comm a b); trivial.
   Defined.

   Lemma leftOpIncreasing_comp : LeftOpIncreasing_comp leftNaturalOrder.
   Proof. exists (choose S); exists (choose S); le_u; negb_p; toProp;
      dseq_f; repeat rewrite (idem (choose S)); auto.
   Defined.
   
   Lemma rightOpIncreasing_comp : RightOpIncreasing_comp leftNaturalOrder.
   Proof. exists (choose S); exists (choose S); le_u; negb_p; toProp;
      dseq_f; repeat rewrite (idem (choose S)); auto.
   Defined.
   
   Lemma leftEquivCancelative : IsSingleton S -> LeftEquivCancelative leftNaturalOrder.
   Proof. intros [u sng] a b c _; le_u; negb_p; toProp; dseq_f;
      rewrite (sng a), (sng b), (idem u); auto.
   Defined.
      
   Lemma leftEquivCancelative_comp : IsSingleton_comp S -> LeftEquivCancelative_comp leftNaturalOrder.
   Proof. intros sng; destruct (sng (choose S)) as [b abe]. 
      copy_destruct (@equal S b (choose S + b)).
      exists (choose S); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      rewrite <- ew, <- ew, (idem b), (comm b _), <- ew, (idem b); auto.
      
      exists (b); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f;
      rewrite (idem (choose S + b)), (Semigroup.assoc S (choose S)), (idem b), (idem (choose S + b));
      rewrite (comm _ b), <- (Semigroup.assoc S b), (idem b), (comm b); bool_p;
      rewrite dseq_fold  in abe, ew; rewrite equal_sym in ew; auto. 
   Defined.
   
   Lemma rightEquivCancelative : IsSingleton S -> RightEquivCancelative leftNaturalOrder.
   Proof. intros [u sng] a b c _; le_u; negb_p; toProp; dseq_f;
      rewrite (sng a), (sng b), (idem u); auto.
   Defined.
      
   Lemma rightEquivCancelative_comp : IsSingleton_comp S -> RightEquivCancelative_comp leftNaturalOrder.
   Proof. intros sng; destruct (sng (choose S)) as [b abe]. 
      copy_destruct (@equal S b (choose S + b)).
      exists (choose S); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      rewrite <- ew, <- ew, (idem b), (idem b), (comm b _), <- ew; auto.
      
      exists (b); exists (choose S + b); exists (choose S + b); le_u; negb_p; toProp; dseq_f.
      repeat (progress (
      try rewrite (comm b);
      try rewrite (Semigroup.assoc S (choose S));
      try rewrite (Semigroup.assoc S b);
      try rewrite (idem b);
      try rewrite (idem (choose S))
      )).

      repeat (progress (
      try rewrite (comm b);
      try rewrite <- (Semigroup.assoc S (choose S));
      try rewrite <- (Semigroup.assoc S b);
      try rewrite (idem b);
      try rewrite (idem (choose S))
      )).
      
      rewrite equal_sym_b in ew; bool_p; toProp. auto.
   Defined.
   
   Lemma leftEquivCondensed : LeftCondensed S -> LeftEquivCondensed leftNaturalOrder.
   Proof. intros lc a b c; le_u; rewrite (lc a b c), (idem (a + c)); auto. Defined.
   
   Lemma leftEquivCondensed_comp : LeftCondensed_comp S -> LeftEquivCondensed_comp leftNaturalOrder.
   Proof. intros [a [b [c lc]]]; 
      exists a; exists b; exists c; le_u; negb_p; toProp;
      copy_destruct (@equal S (a + b + (a + c)) (a + b));
      [ dseq_f; rewrite (comm (a + c)), ew; auto
      | bool_p; auto ].
   Defined.

   Lemma rightEquivCondensed : RightCondensed S -> RightEquivCondensed leftNaturalOrder.
   Proof. intros lc a b c; le_u; rewrite (lc a b c), (idem (c + a)); auto. Defined.

   Lemma rightEquivCondensed_comp : RightCondensed_comp S -> RightEquivCondensed_comp leftNaturalOrder.
   Proof. intros [a [b [c lc]]]; 
      exists a; exists b; exists c; le_u; negb_p; toProp.
      copy_destruct (@equal S (b + a + (c + a)) (b + a));
      [ dseq_f; rewrite (comm (c + a)), ew; auto
      | bool_p; auto ].
   Defined.
   
   (* Always irrelevant *)
   Lemma incompArrowUniqueSrc : IncompArrowUniqueSrc leftNaturalOrder.
   Proof. intros lmon rmon antisym sel x y z. toProp; simpl. unfold le; dseq_f.
      intros [p1 p2] p3 p4 [p5 p6].
      assert (False) as e1; [|elim e1].
      apply p2.
      rewrite (comm y x), p3; auto.
   Qed.
   
   (* Always irrelevant *)
   Lemma incompArrowFactor : IncompArrowFactor leftNaturalOrder.
   Proof. intros lmon rmon antisym sel x y z. toProp; simpl. unfold le; dseq_f.
      intros [p1 p2] p3 p4 [p5 p6].
      assert (False) as e1; [|elim e1].
      apply p2.
      rewrite (comm y x), p3; auto.
   Qed.
   
   Lemma rightChoiceIncrease : IsSingleton S -> RightChoiceIncrease leftNaturalOrder.
   Proof. intros [a sg] _ x y h. rewrite (sg x), (sg y); auto. Qed.

   Lemma rightChoiceIncrease_comp : IsSingleton_comp S -> RightChoiceIncrease_comp leftNaturalOrder.
   Proof. intros sg _; set (a := choose S); destruct (sg a) as [b bp].
      copy_destruct ((a + b == a)%bool).
         exists b; exists (a + b); simpl; unfold le; simpl.
         dseq_f. rewrite ew. rewrite (comm b a), ew; simpl. split; auto; toProp; intros h; apply bp. 
         dseq_f; rewrite h; auto.
         
         exists a; exists (a + b); simpl; unfold le; simpl.
         dseq_f. rewrite <- (Semigroup.assoc S a a b), (idem a). split; auto.
         rewrite ew; auto.
   Defined.

   Lemma leftChoiceIncrease : IsSingleton S -> LeftChoiceIncrease leftNaturalOrder.
   Proof. intros [a sg] _ x y h. rewrite (sg x), (sg y); auto. Qed.

   Lemma leftChoiceIncrease_comp : IsSingleton_comp S -> LeftChoiceIncrease_comp leftNaturalOrder.
   Proof. intros sg _; set (a := choose S); destruct (sg a) as [b bp].
      copy_destruct ((a + b == a)%bool).
         exists (a + b); exists b; simpl; unfold le; simpl.
         dseq_f. rewrite ew. 
         rewrite (comm b a), ew; simpl. split; auto; toProp; intros h; apply bp. 
         dseq_f; rewrite h; auto.
         
         exists (a + b); exists a; simpl; unfold le; simpl.
         dseq_f. rewrite (Semigroup.assoc S a b a), (comm b a), <- (Semigroup.assoc S a a b), (idem a).
         split; auto.
         rewrite ew; auto.
   Defined.
   
   Lemma rightTotal : TreeGlb S -> RightTotal leftNaturalOrder.
   Proof. intros tg z x y; simpl; unfold le; simpl; dseq_f.
      rewrite (Semigroup.assoc S x z (y + z)).
      rewrite <- (Semigroup.assoc S z y z).
      rewrite (comm z y).
      rewrite (Semigroup.assoc S y z z).
      rewrite (idem z).
      rewrite (Semigroup.assoc S y z (x + z)).
      rewrite <- (Semigroup.assoc S z x z).
      rewrite (comm z x).
      rewrite (Semigroup.assoc S x z z).
      rewrite (idem z).
      rewrite <- (Semigroup.assoc S x y z).
      rewrite <- (Semigroup.assoc S y x z).
      rewrite (comm y x); auto.
   Qed.
   
   Lemma rightTotal_comp : TreeGlb_comp S -> RightTotal_comp leftNaturalOrder.
   Proof. intros [x [y [z [p1 p2]]]]; auto.
      exists z; exists x; exists y; simpl. unfold le; simpl.
      rewrite (Semigroup.assoc S x z (y + z)).
      rewrite <- (Semigroup.assoc S z y z).
      rewrite (comm z y).
      rewrite (Semigroup.assoc S y z z).
      rewrite (idem z).
      rewrite (Semigroup.assoc S y z (x + z)).
      rewrite <- (Semigroup.assoc S z x z).
      rewrite (comm z x).
      rewrite (Semigroup.assoc S x z z).
      rewrite (idem z).
      rewrite <- (Semigroup.assoc S x y z).
      rewrite <- (Semigroup.assoc S y x z).
      rewrite (comm y x); auto.
   Defined.

   Lemma leftTotal : TreeGlb S -> LeftTotal leftNaturalOrder.
   Proof. intros tg z x y; simpl; unfold le; simpl; dseq_f.
      rewrite (Semigroup.assoc S z x (z + y)).
      rewrite <- (Semigroup.assoc S x z y).
      rewrite (comm x z).
      rewrite (Semigroup.assoc S z x y).
      rewrite <- (Semigroup.assoc S z z (x + y)).
      rewrite (idem z).

      rewrite (Semigroup.assoc S z y (z + x)).
      rewrite <- (Semigroup.assoc S y z x).
      rewrite (comm y z).
      rewrite (Semigroup.assoc S z y x).
      rewrite <- (Semigroup.assoc S z z (y + x)).
      rewrite (idem z).

      rewrite (comm y x).
      rewrite (comm z x), (comm z y), (comm z (x + y)).
      auto.
   Qed.

   Lemma leftTotal_comp : TreeGlb_comp S -> LeftTotal_comp leftNaturalOrder.
   Proof. intros [x [y [z [p1 p2]]]]; auto.
      exists z; exists x; exists y; simpl. unfold le; simpl.
      rewrite (Semigroup.assoc S z x (z + y)).
      rewrite <- (Semigroup.assoc S x z y).
      rewrite (comm x z).
      rewrite (Semigroup.assoc S z x y).
      rewrite <- (Semigroup.assoc S z z (x + y)).
      rewrite (idem z).

      rewrite (Semigroup.assoc S z y (z + x)).
      rewrite <- (Semigroup.assoc S y z x).
      rewrite (comm y z).
      rewrite (Semigroup.assoc S z y x).
      rewrite <- (Semigroup.assoc S z z (y + x)).
      rewrite (idem z).

      rewrite (comm y x).
      toProp; dseq_f.
      rewrite (comm z x), (comm z y), (comm z (x + y)).
      auto.
   Defined.
   
   Lemma rightMultChoiseComp : RightMultChoiseComp leftNaturalOrder.
   Proof. intros rt x y z w; red in rt; simpl in *; unfold le in *; simpl in *.
      toProp; intros [p1 p2] [p3 p4]; dseq_f.

      assert (x + y + w == x + y) as e1.
         destruct (rt x y w) as [q1|q1]; dseq_f;
         [|rewrite (comm (w + x) (y + x)) in q1];
         rewrite (comm w x) in q1;
         rewrite (Semigroup.assoc S y x (x + w)) in q1;
         rewrite <- (Semigroup.assoc S x x w) in q1;
         rewrite (idem x) in q1;
         rewrite <- (Semigroup.assoc S y x w) in q1;
         rewrite (comm y x) in q1;
         [auto|].
         elim p4; dseq_f.
         rewrite (Semigroup.assoc S x w (y + w)).
         rewrite (comm y w).
         rewrite <- (Semigroup.assoc S w w y).
         rewrite (idem w).
         rewrite (comm w y).
         rewrite <- (Semigroup.assoc S x y w); auto.

      assert (x + y + z == x + y) as e2.
         destruct (rt y x z) as [q1|q1]; dseq_f;
         [|rewrite (comm (z + y) (x + y)) in q1];
         rewrite (comm z y) in q1;
         rewrite (Semigroup.assoc S x y (y + z)) in q1;
         rewrite <- (Semigroup.assoc S y y z) in q1;
         rewrite (idem y) in q1;
         rewrite <- (Semigroup.assoc S x y z) in q1;
         [auto|].
         elim p2; dseq_f.
         rewrite (Semigroup.assoc S y z (x + z)).
         rewrite (comm x z).
         rewrite <- (Semigroup.assoc S z z x).
         rewrite (idem z).
         rewrite (comm z x).
         rewrite <- (Semigroup.assoc S y x z), (comm y x); auto.

      assert (x + y + w == y + w) as e3.
         destruct (rt w x y) as [q1|q1]; dseq_f;
         [|rewrite (comm (y + w) (x + w)) in q1];
         rewrite (Semigroup.assoc S x w (y + w)) in q1;
         rewrite (comm y w) in q1;
         rewrite <- (Semigroup.assoc S w w y) in q1;
         rewrite (idem w) in q1;
         rewrite (comm w y) in q1;
         rewrite <- (Semigroup.assoc S x y w) in q1; auto.
         elim p4; dseq_f.
         rewrite (Semigroup.assoc S x w (y + w)).
         rewrite (comm y w).
         rewrite <- (Semigroup.assoc S w w y).
         rewrite (idem w).
         rewrite (comm w y).
         rewrite <- (Semigroup.assoc S x y w); auto.

      assert (x + y + z == x + z) as e4.
         destruct (rt z x y) as [q1|q1]; dseq_f;
         [|rewrite (comm (y + z) (x + z)) in q1];
         rewrite (Semigroup.assoc S x z (y + z)) in q1;
         rewrite (comm y z) in q1;
         rewrite <- (Semigroup.assoc S z z y) in q1;
         rewrite (idem z) in q1;
         rewrite (comm z y) in q1;
         rewrite <- (Semigroup.assoc S x y z) in q1;
         auto.
         elim p2; dseq_f.
         rewrite (Semigroup.assoc S y z (x + z)).
         rewrite (comm x z).
         rewrite <- (Semigroup.assoc S z z x).
         rewrite (idem z).
         rewrite (comm z x).
         rewrite <- (Semigroup.assoc S y x z), (comm y x); auto.
      
      rewrite e1 in e3; rewrite e2 in e4; rewrite e3 in e4; rewrite e4.
      rewrite (idem (x + z)); auto.
   Qed.

   Lemma leftMultChoiseComp : LeftMultChoiseComp leftNaturalOrder.
   Proof. intros rt x y z w; red in rt; simpl in *; unfold le in *; simpl in *.
      toProp; dseq_f.
      rewrite (comm z x), (comm z y), (comm w x), (comm w y) in *;
      intros [p1 p2] [p3 p4].
      assert (RightTotal leftNaturalOrder) as e1.
         intros a b c. simpl. unfold le. dseq_f;
         rewrite (comm b a), (comm c a).
         apply (rt a b c).
      assert (p := rightMultChoiseComp e1 x y z w).
      simpl in *; unfold le in *; simpl in *; toProp.
      apply p; auto.
   Qed.

   Lemma r_lt_yw_xw_yw_xy : RightTotal leftNaturalOrder ->
      forall {x y w : S}, (y + w + (x + w) == y + w) && (x + w + (y + w) != x + w) -> y + w == x + y.
   Proof. intros rt x y w. toProp. intros [p1 p2]; dseq_f.
      assert (h := rt x y w). simpl in h. unfold le in h; simpl in h.
      assert (y + w + (x + w) == y + x + (w + x)) as e1.
         rewrite (Semigroup.assoc S y w (x + w)).
         rewrite (comm x w).
         rewrite <- (Semigroup.assoc S w w x).
         rewrite (idem w).
         rewrite (Semigroup.assoc S y x (w + x)).
         rewrite (comm w x).
         rewrite <- (Semigroup.assoc S x x w).
         rewrite (idem x).
         auto.
      destruct h as [h|h].
         dseq_f. rewrite <- e1, p1 in h; auto. 
         rewrite (comm y x) in h; auto.
         elim p2; dseq_f.
         rewrite (comm (y + x) (w + x)), (comm (y + w) (x + w)) in e1.
         rewrite e1, h, (comm x w); auto.
   Qed.

   Lemma r_lt_xz_yz_xz_xy : RightTotal leftNaturalOrder ->
      forall {x y z : S}, (x + z + (y + z) == x + z) && (y + z + (x + z) != y + z) -> x + z == x + y.
   Proof. intros rt x y z. toProp. intros [p1 p2]; dseq_f.
      assert (h := rt y x z). simpl in h. unfold le in h; simpl in h.
      assert (x + z + (y + z) == x + y + (z + y)) as e1.
         rewrite (Semigroup.assoc S x z (y + z)).
         rewrite (comm y z).
         rewrite <- (Semigroup.assoc S z z y).
         rewrite (idem z).
         rewrite (Semigroup.assoc S x y (z + y)).
         rewrite (comm z y).
         rewrite <- (Semigroup.assoc S y y z).
         rewrite (idem y).
         auto.
      destruct h as [h|h].
         dseq_f. rewrite <- e1, p1 in h; auto. 
         rewrite (comm x y) in h; auto.
         elim p2; dseq_f.
         rewrite (comm (x + y) (z + y)), (comm (x + z) (y + z)) in e1.
         rewrite e1.
         rewrite (comm x y), (comm y z); auto.
   Qed.
   
   Lemma rightLtSwapEquiv_comp : IsSelective_comp S -> RightLtSwapEquiv_comp leftNaturalOrder.
   Proof. intros [x [y p]] rt rmcc.
      exists x; exists y; exists y; exists x; simpl. unfold le; simpl.
      toProp. dseq_f.
      rewrite (idem x), (idem y).
      rewrite (comm x y).
      rewrite (idem (y + x)).
      rewrite (Semigroup.assoc S y x x), (idem x).
      rewrite <- (Semigroup.assoc S y y x), (idem y).
      rewrite (comm y x).
      rewrite (Semigroup.assoc S x y y), (idem y).
      rewrite <- (Semigroup.assoc S x x y), (idem x).
      intuition.
   Defined.
   
   Lemma rightLtSwapEquiv : IsSelective S -> RightLtSwapEquiv leftNaturalOrder.
   Proof. intros sel rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *.
      intros p1 p2.
      assert (q1 := r_lt_xz_yz_xz_xy rt p1).
      assert (q2 := r_lt_xz_yz_xz_xy rt p2).
      toProp.
      destruct p1 as [p1 p3].
      destruct p2 as [p2 p4]. dseq_f.
      destruct (sel x y) as [h|h].
         elim p4. dseq_f.
         rewrite (Semigroup.assoc S x w (y + w)).
         rewrite <- (Semigroup.assoc S w y w).
         rewrite (comm w y).
         rewrite (Semigroup.assoc S y w w), (idem w).
         rewrite <- (Semigroup.assoc S x y w).
         rewrite h; auto.
         
         elim p3; dseq_f.
         rewrite (Semigroup.assoc S y z (x + z)).
         rewrite <- (Semigroup.assoc S z x z).
         rewrite (comm z x).
         rewrite (Semigroup.assoc S x z z), (idem z).
         rewrite <- (Semigroup.assoc S y x z).
         rewrite (comm y x), h; auto.
   Qed.

   Lemma rightMultComp_comp : IsSelective_comp S -> RightMultComp_comp leftNaturalOrder.
   Proof. intros [x [y p]] rt rmcc.
      exists x; exists y; exists x; exists y; simpl. unfold le; simpl.
      toProp. dseq_f. rewrite (idem x), (idem y), (comm y x); auto.
   Defined.
   
   Lemma rightMultComp : IsSelective S -> RightMultComp leftNaturalOrder.
   Proof. intros sel rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *. negb_p. toProp; dseq_f.
      destruct (sel (x + z) (y + w)); auto.
      rewrite (comm (y + w) (x + z)); auto.
   Qed.
   
   Lemma rightMultSplitComp : RightMultSplitComp leftNaturalOrder.
   Proof. intros rt rmcc x y z w.
      assert (h := rmcc rt x y z w).
      red in rt; simpl in *; unfold le in *; simpl in *.
      intros p1 p2.
      assert (q1 := r_lt_xz_yz_xz_xy rt p1).
      toBool; negb_p. toProp; dseq_f.
      intuition. dseq_f.
      apply or_intror.
      rewrite q1.
      rewrite (Semigroup.assoc S y w (x + y)).
      rewrite <- (Semigroup.assoc S w x y).
      rewrite (comm w x), <- H1, (comm (x + w) (y + w)), p2.
      rewrite (Semigroup.assoc S y w y).
      rewrite (comm w y).
      rewrite <- (Semigroup.assoc S y y w), (idem y).
      rewrite <- (Semigroup.assoc S y y w), (idem y).
      auto.
   Qed.
   
   Lemma rightLtLeSwapEquiv : IsSingleton S -> RightLtLeSwapEquiv leftNaturalOrder.
   Proof. intros [a sg] rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *.
      toBool; negb_p; toProp; dseq_f.
      rewrite (sg x), (sg y), (sg z), (sg w), (idem a), (idem a); auto.
   Qed.
   
   Lemma rightLtLeSwapEquiv_comp : IsSingleton_comp S -> RightLtLeSwapEquiv_comp leftNaturalOrder.
   Proof. intros sg rt rmcc.
      assert (Exists x y : S, x + y == x /\ x + y != y) as h.
         assert (x := choose S).
         destruct (sg x) as [y p].
         copy_destruct (x + y == x).
            exists x; exists y; dseq_f; split; auto.
            rewrite ew; toProp; intros h; apply p; dseq_f; rewrite h; auto.
            exists (x + y); exists x; dseq_f.
            rewrite (comm x y), (Semigroup.assoc S y x x), (idem x); split; auto.
            rewrite (comm y x); bool_p; toProp; tauto.
      destruct h as [x [y [p1 p2]]].
      exists x; exists y; exists y; exists x; simpl. unfold le; simpl.
      toProp; dseq_f.
      rewrite (idem y), (idem x).
      rewrite (comm x y), (idem (y + x)).
      rewrite (Semigroup.assoc S y x x), (idem x).
      rewrite (comm y x), (Semigroup.assoc S x y y), (idem y).
      rewrite (comm x y), <- (Semigroup.assoc S y y x), (idem y).
      rewrite (comm y x); auto.
   Defined.
   

   Lemma rightLtMultComp : RightLtMultComp leftNaturalOrder.
   Proof. intros rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *.
      intros p1.
      assert (q1 := r_lt_xz_yz_xz_xy rt p1).
      toBool; negb_p. toProp; destruct p1 as [p1 p2]; dseq_f.

      assert (z + (x + y) + (w + (x + y)) == x + z + (y + w)) as e1.
         rewrite (comm w (x + y)).
         rewrite (Semigroup.assoc S z (x + y) (x + y + w)).
         rewrite <- (Semigroup.assoc S (x + y) (x + y) w).
         rewrite (idem (x + y)).
         rewrite (Semigroup.assoc S x y w).
         rewrite <- (Semigroup.assoc S z x (y + w)).
         rewrite (comm z x).
         auto.

      assert (x + z + (y + z) == z + (x + y)) as e2.
         rewrite (comm y z).
         rewrite (Semigroup.assoc S x z (z + y)).
         rewrite <- (Semigroup.assoc S z z y), (idem z).
         rewrite <- (Semigroup.assoc S x z y).
         rewrite (comm x z), (Semigroup.assoc S z x y).
         auto.

      destruct (rt (x + y) z w) as [h|h]; dseq_f.
         assert (h1 := rt z x y).
         copy_destruct (x + z + (y + z) == x + z); rewrite ew in h1; simpl; dseq_f.
            clear h1.
            rewrite <- e1, h, <- e2, ew; auto.
            toBool; simpl in *; toProp; dseq_f.
            assert (q2 := @r_lt_xz_yz_xz_xy rt y x z).
            rewrite h1, ew in q2; simpl in q2.
            assert (q3 := q2 (refl_equal _)). clear q2.
            rewrite (comm x z).
            rewrite (Semigroup.assoc S y w (z + x)).
            rewrite <- (Semigroup.assoc S w z x).
            rewrite (comm w z).
            rewrite (Semigroup.assoc S z w x).
            rewrite <- (Semigroup.assoc S y z (w + x)).
            rewrite q3.
            rewrite (comm w x).
            rewrite (Semigroup.assoc S y x (x + w)).
            rewrite <- (Semigroup.assoc S x x w), (idem x).
            rewrite <- (Semigroup.assoc S y x w), <- q1.
            rewrite (Semigroup.assoc S y w w), (idem w).
            auto.
        rewrite (comm (z + (x + y)) (w + (x + y))), (comm (x + z) (y + w)) in e1.
        rewrite <- e1, h.
        rewrite (comm x y), <- q1.
        rewrite (comm y w), <- (Semigroup.assoc S w w y), (idem w); auto.
   Qed.
   
   Lemma rightLeSwapEquiv : RightLeSwapEquiv leftNaturalOrder.
   Proof. intros rt rmcc x y z w.
      assert (q1 := rightMultSplitComp rt rmcc x y z w).
      assert (q2 := rightMultSplitComp rt rmcc y x w z).
      red in rt; simpl in *; unfold le in *; simpl in *; negb_p.
      copy_destruct (y + z + (x + z) == y + z);
         [| rewrite ew in q1; simpl in q1; rewrite andb_true_r in q1; auto].
      copy_destruct (x + w + (y + w) == x + w);
         [| rewrite ew0 in q2; simpl in q2; rewrite andb_true_r in q2; toProp; tauto].
      dseq_f. clear q1 q2.
      intros p1 p2; dseq_f. toProp; dseq_f.
      rewrite (comm (y + w) (x + w)), ew0 in p2.
      rewrite <- p2.
      rewrite (comm x z), (comm x w).
      apply rt.
   Qed.

   Lemma rightMultPresLtLe_comp : IsSelective_comp S -> RightMultPresLtLe_comp leftNaturalOrder.
   Proof. intros [x [y p]] rt rmcc.
      exists x; exists y; exists y; exists x; simpl. unfold le; simpl.
      toProp. dseq_f. rewrite (idem x), (idem y), (comm y x); auto.
      rewrite (Semigroup.assoc S x y y), (idem y).
      rewrite (comm x y), (Semigroup.assoc S y x x), (idem x).
      rewrite <- (Semigroup.assoc S y y x), (idem y).
      rewrite (comm y x), <- (Semigroup.assoc S x x y), (idem x).
      intuition.
   Defined.
   
   Lemma rightMultPresLtLe : IsSelective S -> RightMultPresLtLe leftNaturalOrder.
   Proof. intros sel rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *. negb_p.
      copy_destruct (x + z + (y + z) == x + z); rewrite ew; simpl; auto.
      copy_destruct (y + w + (x + w) == y + w); rewrite ew0; simpl; auto.
      dseq_f.
      destruct (sel x y) as [h|h].
         rewrite (comm y w).
         rewrite (Semigroup.assoc S x w (w + y)).
         rewrite <- (Semigroup.assoc S w w y), (idem w).
         rewrite (comm w y).
         rewrite <- (Semigroup.assoc S x y w), h; auto.
         rewrite (comm x z).
         rewrite (Semigroup.assoc S y z (z + x)).
         rewrite <- (Semigroup.assoc S z z x), (idem z).
         rewrite (comm z x).
         rewrite <- (Semigroup.assoc S y x z), (comm y x), h; auto.
   Qed.
   
   Lemma rightStrictEquiv : IsSingleton S -> RightStrictEquiv leftNaturalOrder.
   Proof. intros [a sg] rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *. negb_p.
      toProp; dseq_f.
      rewrite (sg x), (sg y), (sg z), (sg w), (idem a), (idem a); intuition.
   Qed.
   
   Lemma rightStrictEquiv_comp : IsSingleton_comp S -> RightStrictEquiv_comp leftNaturalOrder.
   Proof. intros sg rt rmcc.
      assert (Exists x y : S, x + y == x /\ x + y != y) as h.
         assert (x := choose S).
         destruct (sg x) as [y p].
         copy_destruct (x + y == x).
            exists x; exists y; dseq_f; split; auto.
            rewrite ew; toProp; intros h; apply p; dseq_f; rewrite h; auto.
            exists (x + y); exists x; dseq_f.
            rewrite (comm x y), (Semigroup.assoc S y x x), (idem x); split; auto.
            rewrite (comm y x); bool_p; toProp; tauto.
      destruct h as [x [y [p1 p2]]].
      exists y; exists x; exists x; exists y; simpl. unfold le; simpl.
      toProp; dseq_f.
      rewrite (idem y).
      rewrite (comm x y), (idem (y + x)).
      rewrite (comm y x), (Semigroup.assoc S x y y), (idem y).
      rewrite (comm x y), <- (Semigroup.assoc S y y x), (idem y).
      rewrite (comm y x); auto.
   Defined.
   
   Lemma rightLeMultComp : RightLeMultComp leftNaturalOrder.
   Proof. intros rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *. negb_p.
      toProp; dseq_f.
      intros p1.
      assert (y + x + (w + x) == y + w + (x + w)) as e1.
         rewrite (Semigroup.assoc S y x (w + x)).
         rewrite (Semigroup.assoc S y w (x + w)).
         rewrite (comm w x).
         rewrite <- (Semigroup.assoc S x x w), (idem x).
         rewrite (comm x w).
         rewrite <- (Semigroup.assoc S w w x), (idem w).
         auto.
      rewrite <- e1 in p1.
      destruct (rt x y w) as [h|h]; dseq_f.
         rewrite p1 in h.
         rewrite h.
         assert (p3 := rt x y z).
         rewrite (comm x z). tauto.
         rewrite (comm (w + x) (y + x)), p1 in h.
         rewrite h.
         assert (p3 := rt x z w).
         rewrite (comm x z). tauto.
   Qed.

(*   
   Lemma rightLtLeMulpCoh : RightLtLeMulpCoh leftNaturalOrder.
   Proof. intros rt rmcc x y z w.
      red in rt; simpl in *; unfold le in *; simpl in *. negb_p.
      toProp; dseq_f.
*)
   
   
End LeftNaturalOrder.
