(*
 * Skip: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.Preorders.Dual.

Section Dual.

   Variable A : OrderSemigroup.
   
   Definition dualOrderSemigroup :=
      glueOSmg A (dualPreorder A) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

   Open Scope OrderSemigroup_scope.
      
   Lemma leftMonotonic : LeftMonotonic A -> LeftMonotonic dualOrderSemigroup.
   Proof. intros lmon x y z; simpl; apply lmon. Defined.
   
   Lemma leftMonotonic_comp : LeftMonotonic_comp A -> LeftMonotonic_comp dualOrderSemigroup.
   Proof. intros [x [y [z lmon]]]; simpl; exists x; exists z; exists y; auto. Defined.

   Lemma rightMonotonic : RightMonotonic A -> RightMonotonic dualOrderSemigroup.
   Proof. intros lmon x y z; simpl; apply lmon. Defined.
   
   Lemma rightMonotonic_comp : RightMonotonic_comp A -> RightMonotonic_comp dualOrderSemigroup.
   Proof. intros [x [y [z lmon]]]; simpl; exists y; exists x; exists z; simpl; auto. Defined.

(* Needs fixing - the properties changed *)
(*
   Lemma topIsIdentity : BottomIsIdentity A -> TopIsIdentity dualOrderSemigroup.
   Proof. intros [b p]; exists b; auto. Defined.

   Lemma topIsIdentity_comp : BottomIsIdentity_comp A -> TopIsIdentity_comp dualOrderSemigroup.
   Proof. intros bid x; destruct (bid x) as [y p]; exists y; auto. Defined.

   Lemma topIsAnnihilator : BottomIsAnnihilator A -> TopIsAnnihilator dualOrderSemigroup.
   Proof. intros [b p]; exists b; auto. Defined.

   Lemma topIsAnnihilator_comp : BottomIsAnnihilator_comp A -> TopIsAnnihilator_comp dualOrderSemigroup.
   Proof. intros bid x; destruct (bid x) as [y p]; exists y; auto. Defined.
   
   Lemma bottomIsIdentity : TopIsIdentity A -> BottomIsIdentity dualOrderSemigroup.
   Proof. intros [b p]; exists b; auto. Defined.

   Lemma bottomIsIdentity_comp : TopIsIdentity_comp A -> BottomIsIdentity_comp dualOrderSemigroup.
   Proof. intros bid x; destruct (bid x) as [y p]; exists y; auto. Defined.

   Lemma bottomIsAnnihilator : TopIsAnnihilator A -> BottomIsAnnihilator dualOrderSemigroup.
   Proof. intros [b p]; exists b; auto. Defined.

   Lemma bottomIsAnnihilator_comp : TopIsAnnihilator_comp A -> BottomIsAnnihilator_comp dualOrderSemigroup.
   Proof. intros bid x; destruct (bid x) as [y p]; exists y; auto. Defined.
*)

(* NEED TO ADD NEW PROPERTIES *)

(*
   Lemma rightNonDecreasing : RightNonDecreasing dualOrderSemigroup.
   Proof. Defined.

   Lemma rightNonDecreasing_comp : RightNonDecreasing_comp dualOrderSemigroup.
   Proof. Defined.

   Lemma leftNonDecreasing : LeftNonDecreasing dualOrderSemigroup.
   Proof. Defined.
   
   Lemma leftNonDecreasing_comp : LeftNonDecreasing_comp dualOrderSemigroup.
   Proof. Defined.

   Lemma selectiveNonDecreasing : SelectiveNonDecreasing dualOrderSemigroup.
   Proof. Defined.

   Lemma selectiveNonDecreasing_comp : IsSelective_comp S -> SelectiveNonDecreasing_comp dualOrderSemigroup.
   Proof. Defined.

   Lemma leftIncreasing : LeftIncreasing dualOrderSemigroup.
   Proof. Defined.

   Lemma leftIncreasing : LeftIncreasing dualOrderSemigroup.
   Proof. Defined.
   
   Lemma rightIncreasing : RightIncreasing dualOrderSemigroup.
   Proof. Defined.
*)
   
   Lemma leftEquivCancelative : LeftEquivCancelative A -> LeftEquivCancelative dualOrderSemigroup.
   Proof. intros lca a b c; simpl; apply lca. Defined.
      
   Lemma leftEquivCancelative_comp : LeftEquivCancelative_comp A -> LeftEquivCancelative_comp dualOrderSemigroup.
   Proof. intros [a [b [c lca]]]; exists b; exists a; exists c; simpl; auto. Defined.
   
   Lemma rightEquivCancelative : RightEquivCancelative A -> RightEquivCancelative dualOrderSemigroup.
   Proof. intros lca a b c; simpl; apply lca. Defined.
      
   Lemma rightEquivCancelative_comp : RightEquivCancelative_comp A -> RightEquivCancelative_comp dualOrderSemigroup.
   Proof. intros [a [b [c lca]]]; exists b; exists a; exists c; simpl; auto. Defined.
   
   Lemma leftEquivCondensed : LeftEquivCondensed A -> LeftEquivCondensed dualOrderSemigroup.
   Proof. intros lca a b c; simpl; apply lca. Defined.
   
   Lemma leftEquivCondensed_comp : LeftEquivCondensed_comp A -> LeftEquivCondensed_comp dualOrderSemigroup.
   Proof. intros [a [b [c lca]]]; exists a; exists c; exists b; simpl; auto. Defined.

   Lemma rightEquivCondensed : RightEquivCondensed A -> RightEquivCondensed dualOrderSemigroup.
   Proof. intros lca a b c; simpl; apply lca. Defined.

   Lemma rightEquivCondensed_comp : RightEquivCondensed_comp A -> RightEquivCondensed_comp dualOrderSemigroup.
   Proof. intros [a [b [c lca]]]; exists a; exists c; exists b; simpl; auto. Defined. 

End Dual.
