Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.OrderSemigroupGlue.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Coq.Bool.Bool.

Section BSLeftNaturalOrder.

   Variable B : Bisemigroup.
   Variable idem : IsIdempotent (plusSmg B).
   Variable comm : IsCommutative (plusSmg B).
   Variable ldist : IsLeftDistributive B.
   Variable rdist : IsRightDistributive B.

   Open Scope Bisemigroup_scope.

   Definition bsLeftNaturalOrder :=
      glueOSmg (timesSmg B) (leftNaturalOrder (plusSmg B) idem) (dsEq_refl _).

   Ltac le_u :=
      simpl in *; unfold LeftNaturalOrder.le in *; simpl in *.
   
   Lemma leftMonotonic : LeftMonotonic bsLeftNaturalOrder.
   Proof.  intros x y z. le_u.
      dseq_f. intros h.
      rewrite <- (ldist y z x).
      rewrite h.
      auto.
   Qed.
   
   Lemma rightMonotonic : RightMonotonic bsLeftNaturalOrder.
   Proof. intros x y z; le_u.
      dseq_f. intros h.
      rewrite <- (rdist x y z).
      rewrite h.
      auto.
   Qed.
   
(*
   Lemma topIsIdentity : TopIsIdentity bsLeftNaturalOrder.
   Proof. intros [t tp] [i ip]. simpl. toProp; le_u; split. dseq_f.
      destruct (ip t); auto.
   Qed.
*)
   Lemma leftOpNonDecreasing : RightIncreasing B -> LeftOpNonDecreasing bsLeftNaturalOrder.
   Proof. intros ri x y. le_u.
      dseq_f; auto.
   Qed.
   
   Lemma leftOpNonDecreasing_comp : RightIncreasing_comp B -> LeftOpNonDecreasing_comp bsLeftNaturalOrder.
   Proof. intros [x [y ri]]; auto. exists x; exists y; auto. Defined.
   
   Lemma rightOpNonDecreasing : LeftIncreasing B -> RightOpNonDecreasing bsLeftNaturalOrder.
   Proof. intros ri x y. le_u.
      dseq_f; auto.
   Qed.
   
   Lemma rightOpNonDecreasing_comp : LeftIncreasing_comp B -> RightOpNonDecreasing_comp bsLeftNaturalOrder.
   Proof. intros [x [y ri]]; auto. exists x; exists y; auto. Defined.
   
   Lemma leftOpIncreasing : RightStrictIncreasing B -> LeftOpIncreasing bsLeftNaturalOrder.
   Proof. intros rsi x y. le_u. auto. Qed.
   
   Lemma leftOpIncreasing_comp : RightStrictIncreasing_comp B -> LeftOpIncreasing_comp bsLeftNaturalOrder.
   Proof. intros [x [y rsi]]; auto. exists x; exists y; auto. Defined.
   
   Lemma rightOpIncreasing : LeftStrictIncreasing B -> RightOpIncreasing bsLeftNaturalOrder.
   Proof. intros rsi x y. le_u. auto. Qed.
   
   Lemma rightOpIncreasing_comp : LeftStrictIncreasing_comp B -> RightOpIncreasing_comp bsLeftNaturalOrder.
   Proof. intros [x [y rsi]]; auto. exists x; exists y; auto. Defined.
   
(*
   Lemma selectiveOpNonDecreasing : SelectiveOpNonDecreasing bsLeftNaturalOrder.
   Proof. intros idm asym x y. le_u.
*)

   Lemma leftEquivCancelative : IsLeftStrictStable B -> LeftEquivCancelative bsLeftNaturalOrder.
   Proof. intros lss x y z; le_u. assert (H := lss comm idem).
      toProp. intros [h1 h2].
      assert (p := H x y z).
      assert (q := H y x z).
      negb_p; toProp.
      intuition.
   Qed.
   
   Lemma rightEquivCancelative : IsRightStrictStable B -> RightEquivCancelative bsLeftNaturalOrder.
   Proof. intros lss x y z; le_u. assert (H := lss comm idem).
      toProp. intros [h1 h2].
      assert (p := H x y z).
      assert (q := H y x z).
      negb_p; toProp.
      intuition.
   Qed.
   
   Lemma leftEquivCondensed : LeftCondensed (timesSmg B) -> LeftEquivCondensed bsLeftNaturalOrder.
   Proof. intros lcd x y z; le_u.
      assert (p := lcd x y z). simpl in p.
      toProp; dseq_f. rewrite p, (idem (x * z)); auto.
   Qed.
   
   Lemma leftEquivCondensed_comp : LeftCondensed_comp (timesSmg B) -> LeftEquivCondensed_comp bsLeftNaturalOrder.
   Proof. intros [x [y [z lcd]]]. simpl in lcd.
      exists x; exists y; exists z; le_u. toProp.
      intros [p1 p2]; apply lcd; dseq_f.
      rewrite <- p2, (comm (x * z) (x * y)), p1; auto.
   Defined.
   
   Lemma rightEquivCondensed : RightCondensed (timesSmg B) -> RightEquivCondensed bsLeftNaturalOrder.
   Proof. intros lcd x y z; le_u.
      assert (p := lcd x y z). simpl in p.
      toProp; dseq_f. rewrite p, (idem (z * x)); auto.
   Qed.
   
   Lemma rightEquivCondensed_comp : RightCondensed_comp (timesSmg B) -> RightEquivCondensed_comp bsLeftNaturalOrder.
   Proof. intros [x [y [z lcd]]]. simpl in lcd.
      exists x; exists y; exists z; le_u. toProp.
      intros [p1 p2]; apply lcd; dseq_f.
      rewrite <- p2, (comm (z * x) (y * x)), p1; auto.
   Defined.

   Lemma rightChoiceIncrease : AntiRight (timesSmg B) + RightIncreasing B -> RightChoiceIncrease bsLeftNaturalOrder.
   Proof. intros [ar | ri] idm x y; le_u; dseq_f;
      intros h; rewrite <- h.
      assert (p := ar x y); simpl in ar; toProp. elim p; dseq_f. auto.
      auto.
   Qed.
   
   Lemma leftChoiceIncrease : AntiLeft (timesSmg B) + LeftIncreasing B -> LeftChoiceIncrease bsLeftNaturalOrder.
   Proof. intros [ar | ri] idm x y; le_u; dseq_f;
      intros h; rewrite <- h.
      assert (p := ar x y); simpl in ar; toProp. elim p; dseq_f. auto.
      auto.
   Qed.
   
   Lemma rightTotal : RightComparable B -> RightTotal bsLeftNaturalOrder.
   Proof. intros rcp x y z. le_u.
      assert (p := rcp comm idem y z x). toProp. auto.
   Qed.
   
   Lemma rightTotal_comp : RightComparable_comp B -> RightTotal_comp bsLeftNaturalOrder.
   Proof. intros [x [y [z rcp]]]; auto.
      exists z; exists x; exists y. le_u; negb_p. toProp. intuition.
   Defined.
   
   Lemma leftTotal : LeftComparable B -> LeftTotal bsLeftNaturalOrder.
   Proof. intros rcp x y z. le_u.
      assert (p := rcp comm idem y z x). toProp. auto.
   Qed.

   Lemma leftTotal_comp : LeftComparable_comp B -> LeftTotal_comp bsLeftNaturalOrder.
   Proof. intros [x [y [z rcp]]]; auto.
      exists z; exists x; exists y. le_u; negb_p. toProp. intuition.
   Defined.
   
End BSLeftNaturalOrder.
