Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Coq.Lists.List.

(*********************************************************************)
(* Disjoint union of decidable setoids  *)

Section Union.
   Set Implicit Arguments.

   Variables A B : DecSetoid.

   Definition eq_union (x y : A + B) : bool :=
      match x, y with
         | (inl a), (inl b) => (a == b)%bool
         | (inl _), (inr _) => false
         | (inr _), (inl _) => false
         | (inr a), (inr b) => (a == b)%bool
      end.

   Lemma eq_union_refl : Reflexive eq_union.
   Proof. intros [x|x]; simpl; dseq_f; auto. Defined.

   Lemma eq_union_sym : Symmetric eq_union.
   Proof. intros [x|x] [y|y]; simpl; dseq_f; intros h; rewrite h; auto. Defined.

   Lemma eq_union_trans : Transitive eq_union.
   Proof. intros [x|x] [y|y] [z|z]; simpl; dseq_f; intros p q; try discriminate; rewrite p, q; auto. Defined.

(* TO BE REMOVED *)
(*
Lemma eq_union_dec : Decidable _ eq_union.
Proof.
   red.
   intros x y.
   destruct x; destruct y; simpl.
      apply (isDec A).
      constructor 2; intro x; elim x.
      constructor 2; intro x; elim x.
      apply (isDec B).
Defined.

Lemma eq_union_emptyness : Emptyness union_carrier.
Proof.
   red.
   destruct (emptyness A) as [ha | [a ap]];
   destruct (emptyness B) as [hb | [b bp]].
      apply inl; intros x; destruct x as [x | x]; [apply ha | apply hb]; trivial.
      apply inr; apply sigma; [constructor 2|]; trivial.
      apply inr; apply sigma; [constructor 1|]; trivial.
      apply inr; apply sigma; [constructor 1|]; trivial.
Defined.
*)

   Definition unionDecSetoid : DecSetoid :=
      Build_DecSetoid
         (inl _ (choose A))
         eq_union (* eq *)
         eq_union_refl  (* refl *)
         eq_union_sym   (* sym *)
         eq_union_trans (* trans *).

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)

(* TO BE REMOVED *)
(*
Lemma union_IsEmpty : IsEmpty A /\ IsEmpty B -> IsEmpty unionDecSetoid.
Proof.
  intros h; destruct h as [eA eB];
  red; red in eA, eB.
  intros x.
  destruct x; intuition.
Defined.

Lemma union_IsEmpty_comp : IsEmpty_comp A \/ IsEmpty_comp B -> IsEmpty_comp unionDecSetoid.
Proof.
  intros h; destruct h as [eA | eB]; red; [red in eA | red in eB].
  destruct eA as [a _]; elimExists (inl B a); split.
  destruct eB as [b _]; elimExists (inr A b); split.
Defined.

   Lemma union_IsSingleton : IsSingleton B \/ IsSingleton A -> IsSingleton unionDecSetoid.
   Proof.
      intro h; destruct h as [[eA sB] | [eB sA]]; red; [red in eA, sB | red in eB, sA].
      destruct sB as [b sb]; elimExists (inr A b); intro x; destruct x.
      elim (eA c).
      simpl; apply sb.
   destruct sA as [a sa]; elimExists (inl B a); intro x; destruct x.
      simpl; apply sa.
      elim (eB c).
Defined.
*)

   Lemma isSingleton_comp : IsSingleton_comp unionDecSetoid.
   Proof. intros [x|x]; [exists (inr _ (choose B)) | exists (inl _ (choose A))]; compute; auto. Defined.

   Lemma twoElements : IsSingleton A * IsSingleton B -> TwoElements unionDecSetoid.
   Proof. intros [[a sa] [b sb]]; exists (inl _ a); exists (inr _ b); intros [x|x]; 
      [ split; [compute; auto | apply or_introl; dseq_u; simpl; auto ]
      | split; [compute; auto | apply or_intror; dseq_u; simpl; auto ] ].
   Defined.

   Lemma twoElements_comp : IsSingleton_comp A + IsSingleton_comp B -> TwoElements_comp unionDecSetoid.
   Proof. intros [sa | sb] [x|x] [y|y];
      [ exists (inr _ (choose B))
      | destruct (sa x) as [c pc]; exists (inl _ c)
      | destruct (sa y) as [c pc]; exists (inl _ c)
      | exists (inl _ (choose A)) 
      | exists (inr _ (choose B))
      | destruct (sb y) as [c pc]; exists (inr _ c) 
      | destruct (sb x) as [c pc]; exists (inr _ c)
      | exists (inl _ (choose A)) 
      ]; 
      apply or_intror; dseq_u; simpl; auto.
   Defined.

   Lemma finite : Finite A * Finite B -> Finite unionDecSetoid.
   Proof. intros [[la fa] [lb fb]]; red.
      exists ((map (@inl A B) la) ++ (map (@inr A B) lb)).
      intros [x|x];
      [ assert (f := fa x); clear - f;
        red in f; red; rewrite existsb_exists in f; rewrite existsb_exists;
        destruct f as [y [ly xy]];
        exists (inl _ y); split; 
        [ apply in_or_app; apply or_introl; apply in_map; trivial
        | simpl; auto ]
      | assert (f := fb x); clear fa fb;
        red in f; red; rewrite existsb_exists in f; rewrite existsb_exists;
        destruct f as [y [ly xy]];
        exists (inr A y); split;
        [ apply in_or_app; apply or_intror; apply in_map; trivial
        | simpl; auto ]
      ].
   Defined.

   Lemma finite_comp : Finite_comp A + Finite_comp B -> Finite_comp unionDecSetoid.
   Proof. intros [fa | fb] l. red in fa.
      assert (Exists la : list A, map (@inl A B) la = (filter (fun x => match x with inl _ => true | inr _ => false end) l)) as h.
         induction l; 
         [ exists nil; trivial
         | destruct IHl; destruct a;
           [ exists (c :: x); simpl; rewrite e; trivial
           | exists x; simpl; trivial ]
         ].
      destruct h as [x e]. destruct (fa x) as [y py]; clear fa.
      exists (inl _ y).
      red in py; red; rewrite forallb_forall in py; rewrite forallb_forall. intros [z|z] zz.
      dseq_u; simpl. apply py. clear py.
      assert ((fun x : A + B => match x with inl _ => true | inr _ => false end) (inl B z) = true) as zz'; trivial.
      assert (pz := conj zz zz').
      rewrite <- filter_In in pz. simpl in pz. simpl in pz.
      rewrite <- e in pz.
      rewrite in_map_iff in pz.
      destruct pz as [z' [pz pz']].
      injection pz. intros. rewrite H in pz'; auto.
      dseq_u; compute; auto.

      assert (Exists la : list B, map (@inr A B) la = (filter (fun x => match x with inl _ => false | inr _ => true end) l)) as h.
         induction l;
         [ exists nil; trivial
         | destruct IHl; destruct a;
            [ exists x; simpl; trivial
            | exists (c :: x); simpl; rewrite e; trivial ]
         ].
      destruct h as [x e]. destruct (fb x) as [y py]; clear fb.
      exists (inr _ y).
      red in py; red; rewrite forallb_forall in py; rewrite forallb_forall. intros [z|z] zz.
      compute; auto.
      assert ((fun x : A + B => match x with inl _ => false | inr _ => true end) (inr A z) = true) as zz'; trivial.
      assert (pz := conj zz zz').
      rewrite <- filter_In in pz. simpl in pz.
      rewrite <- e in pz.
      rewrite in_map_iff in pz.
      destruct pz as [z' [pz pz']].
      injection pz. intros. rewrite H in pz'. clear z' pz H zz zz'.
      assert (p := py z pz').
      assert (true = negb false); trivial.
   Defined.

End Union.
