Require Import Metarouting.Logic.Logic.
(* Require Import Metarouting.Logic.Relation. *)
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

(*********************************************************************)
(* setoid of bool *)

Lemma eqb_refl : Reflexive eqb.
Proof. intros []; auto. Defined.

Lemma eqb_sym : Symmetric eqb.
Proof. intros [] []; compute; auto; intros; try discriminate. Defined.

Lemma eqb_trans : Transitive eqb.
Proof. intros [] [] []; compute; auto; intros; try discriminate. Defined.

Definition boolDecSetoid : DecSetoid :=
   Build_DecSetoid
      true
      eqb
      eqb_refl
      eqb_sym
      eqb_trans.

(*********************************************************************)
(* proved properties *)

(* TO BE REMOVED *)
(*
Lemma isEmpty_comp : IsEmpty_comp boolDecSetoid.
Proof. exists true; auto. Defined.
*)

Lemma isSingleton_comp : IsSingleton_comp boolDecSetoid.
Proof. intros [|]; [exists false| exists true]; auto. Defined.

Lemma twoElements : TwoElements boolDecSetoid.
Proof. exists true; exists false; intros [|]; auto. Defined.

Lemma finite : Finite boolDecSetoid.
Proof. exists (true :: false :: nil); intros []; auto. Defined.

