Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Unit.
Require Import Metarouting.Constructions.Semigroups.Unit.

Section Unit.

   Open Scope Bisemigroup_scope.

   Definition unitBisemigroup : Bisemigroup :=
      glueBSmg unitSemigroup unitSemigroup (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma unitBSmgIso_isIso : forall (A : Bisemigroup) (sg : IsSingleton A),
                                IsBSmgIso A unitBisemigroup (unitDsIso sg).
   Proof. intros A [a sg]; split; simpl in *.
      intros; auto.
      intros; rewrite (sg (a + a)); auto.
      intros; auto.
      intros; rewrite (sg (a * a)); auto.
   Qed.

   Definition unitBSmgIso (A : Bisemigroup) (sg : IsSingleton A) : BSmgIso A unitBisemigroup :=
      Build_BSmgIso (unitBSmgIso_isIso A sg).

   Lemma isLeftDistributive : IsLeftDistributive unitBisemigroup.
   Proof. intros [] [] []; auto. Defined.

   Lemma isRightDistributive : IsRightDistributive unitBisemigroup.
   Proof. intros [] [] []; auto. Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive unitBisemigroup.
   Proof. intros [] [] []; auto. Defined.

   Lemma isRightCoDistributive : IsRightCoDistributive unitBisemigroup.
   Proof. intros [] [] []; auto. Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator unitBisemigroup.
   Proof. intros [[] p] [[] q]; auto. Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity unitBisemigroup.
   Proof. intros [[] p] [[] q]; auto. Defined.

   Lemma isRightStrictStable : IsRightStrictStable unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma isLeftStrictStable : IsLeftStrictStable unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma isRightCompCancel : IsRightCompCancel unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma leftDiscrete : LeftDiscrete unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma rightDiscrete : RightDiscrete unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma leftComparable : LeftComparable unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma rightComparable : RightComparable unitBisemigroup.
   Proof. intros _ _ [] [] []; auto. Defined.

   Lemma leftIncreasing : LeftIncreasing unitBisemigroup.
   Proof. intros _ _ [] []; auto. Defined.

   Lemma rightIncreasing : RightIncreasing unitBisemigroup.
   Proof. intros _ _ [] []; auto. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp unitBisemigroup.
   Proof. intros _ _; exists tt; exists tt; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp unitBisemigroup.
   Proof. intros _ _; exists tt; exists tt; auto. Defined.

   Lemma leftWStrictIncreasing : LeftWStrictIncreasing unitBisemigroup.
   Proof. intros _ _ [[] hid] [] [] h. simpl in *. discriminate h. Qed.

   Lemma rightWStrictIncreasing : RightWStrictIncreasing unitBisemigroup.
   Proof. intros _ _ [[] hid] [] [] h. simpl in *. discriminate h. Qed.

   Lemma isRightTimesMapToIdConstantPlus : IsRightTimesMapToIdConstantPlus unitBisemigroup.
   Proof. intros id []; auto. Defined.

   Lemma isLeftTimesMapToIdConstantPlus : IsLeftTimesMapToIdConstantPlus unitBisemigroup.
   Proof. intros id []; auto. Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator unitBisemigroup.
   Proof. intros id []; compute; auto. Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator unitBisemigroup.
   Proof. intros id []; compute; auto. Defined.

End Unit.
