Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.Postfix.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.Bisemigroups.NatMinPlus.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.
Require Import Coq.Arith.Min.

Section Seq.

   Variable A : DecSetoid.
   
   Definition prefixSeqBisemigroup : Bisemigroup :=
      glueBSmg (prefixSemigroup A) (seqSemigroup A) (dsEq_refl _).

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Fixpoint same (a : A) (n : nat) : seqDecSetoid A :=
      match n with
      | 0 => nil
      | S n' => a :: same a n'
      end.

   Definition sg_ds_isoNatMinPlus (sg : IsSingleton A) : DsIso prefixSeqBisemigroup natMinPlusBisemigroup.
      intros sg.
      split with (@length A) (same (choose A)).
      split.

      intros x y; rewrite (sing_length A sg); intros h; rewrite h; auto.

      induction x. intros [|y] h; simpl in h; auto; discriminate.
      intros [|y] h; simpl in *. discriminate h.
      dseq_u; simpl. rewrite refl; simpl. apply IHx. simpl in *.
      rewrite beq_nat_eq in *; injection h; auto.
      
      intros n. induction n; simpl; trivial.
      
      intros x; induction x; simpl; auto.
      dseq_u; simpl.
      assert ((choose A == a)%bool = true) as q; [|rewrite q; simpl; auto].
         destruct sg as [i sg].
         dseq_f; rewrite (sg (choose A)), (sg a); auto.
   Defined.
   
   
   Definition sg_isoNatMinPlus (sg : IsSingleton A) : BSmgIso prefixSeqBisemigroup natMinPlusBisemigroup.
      intros sg. split with (sg_ds_isoNatMinPlus sg).
      split.
      
      intros x y; simpl. rewrite (sing_length_prefix A sg); auto.
      
      intros x y; simpl. generalize y; clear y; induction x; intros y; auto.
         destruct y as [|b y]. simpl. auto.
         simpl. rewrite refl; simpl.
         unfold dseq; simpl. rewrite refl; simpl. apply IHx.
      
      intros x y; simpl. rewrite app_length; auto.
      
      intros x y; simpl. induction x; simpl; auto.
         dseq_u; simpl; rewrite refl; simpl; auto.
   Defined.
   
   Lemma isLeftDistributive : IsLeftDistributive prefixSeqBisemigroup.
   Proof. intros x y z. simpl.
      induction z. trivial.
      simpl. rewrite refl; simpl; auto.
      dseq_u; simpl. rewrite refl; simpl; auto.
   Qed.

   Lemma isRightDistributive : IsSingleton A -> IsRightDistributive prefixSeqBisemigroup.
   Proof. intros sg.
      apply (Iso_IsRightDistributive (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.isRightDistributive.
   Qed.
   
   Lemma isRightDistributive_comp : IsSingleton_comp A -> IsRightDistributive_comp prefixSeqBisemigroup. 
   Proof. intros sg. set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists (a :: nil).
      simpl. rewrite refl; simpl.
      assert (a == b = false) as q; [|rewrite q; simpl; auto].
      bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
   Qed.

   Lemma isRightStrictStable_comp : IsSingleton_comp A -> IsRightStrictStable_comp prefixSeqBisemigroup.
   Proof. intros sg _ _. set (a := choose A); destruct (sg a) as [b pb].
      exists nil; exists (a :: nil); exists (b :: nil).
      simpl.
      assert (b == a = false) as q1; [|rewrite q1; simpl].
         bool_p; toProp; auto.
      bool_p; tauto.
   Defined.
   
   Lemma isRightStrictStable : IsSingleton A -> IsRightStrictStable prefixSeqBisemigroup.
   Proof.
      intros sg.
      apply (Iso_IsRightStrictStable (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.isRightStrictStable.
   Qed.
   
   Lemma isLeftStrictStable : IsLeftStrictStable prefixSeqBisemigroup.
   Proof.
      intros _ _ x y z; generalize x; generalize y; clear x y.
      induction z.
      simpl; intros x y; toBool; destruct (seq_eq A (prefix A x y) x); destruct (seq_eq A (prefix A y x) y); simpl; auto.
      intros x y.
      assert (h := IHz x y); simpl in h.
      toBool. negb_p; simpl in *.
      rewrite refl; simpl.
      rewrite refl; simpl.
      auto.
   Qed.
   
   Lemma leftDiscrete_comp : LeftDiscrete_comp prefixSeqBisemigroup.
   Proof. intros _ _. set (a := choose A); exists nil; exists (a :: nil); exists nil;
      simpl; negb_p. auto.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp prefixSeqBisemigroup.
   Proof. intros _ _. set (a := choose A); exists nil; exists (a :: nil); exists nil;
      simpl; negb_p. auto.
   Defined.
   
   Lemma leftComparable : IsSingleton A -> LeftComparable prefixSeqBisemigroup.
   Proof. 
      intros sg.
      apply (Iso_LeftComparable (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.leftComparable.
   Qed.
   
   Lemma leftComparable_comp : IsSingleton_comp A -> LeftComparable_comp prefixSeqBisemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil; simpl.
      assert ((a == b)%bool = false) as q1.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert ((b == a)%bool = false) as q2.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1, q2; auto.
   Qed.
   
   Lemma rightComparable : IsSingleton A -> RightComparable prefixSeqBisemigroup.
   Proof. 
      intros sg.
      apply (Iso_RightComparable (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.rightComparable.
   Qed.
   
   Lemma rightComparable_comp : IsSingleton_comp A -> RightComparable_comp prefixSeqBisemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil; simpl.
      assert ((a == b)%bool = false) as q1.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert ((b == a)%bool = false) as q2.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1, q2; auto.
   Qed.
   
   Lemma isRightCompEqCancel : IsRightCompEqCancel prefixSeqBisemigroup.
   Proof. intros _ _ x y z. toProp; dseq_f. simpl. intros h.
      assert (h1 := Semigroups.Seq.rightCancelative A _ _ _ h).
      apply or_introl.
      rewrite (prefix_pres_eq A x y y y); auto.
      rewrite h1.
      apply (Prefix.isIdempotent A).
   Qed.
      
   Lemma isLeftCompEqCancel : IsLeftCompEqCancel prefixSeqBisemigroup.
   Proof. intros _ _ x y z. toProp; dseq_f. simpl. intros h.
      assert (h1 := Semigroups.Seq.leftCancelative A _ _ _ h).
      apply or_introl.
      rewrite (prefix_pres_eq A x y y y); auto.
      rewrite h1.
      apply (Prefix.isIdempotent A).
   Qed.

   Lemma isLeftCompCancel : IsSingleton A -> IsLeftCompCancel prefixSeqBisemigroup.
   Proof.
      intros sg.
      apply (Iso_IsLeftCompCancel (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.isLeftCompCancel.
   Qed.

   Lemma isLeftCompCancel_comp : IsSingleton_comp A -> IsLeftCompCancel_comp prefixSeqBisemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil; simpl.
      assert ((a == b)%bool = false) as q1.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert ((b == a)%bool = false) as q2.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1, q2; simpl.
      auto.
   Defined.

   Lemma isRightCompCancel : IsSingleton A -> IsRightCompCancel prefixSeqBisemigroup.
   Proof.
      intros sg.
      apply (Iso_IsRightCompCancel (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.isRightCompCancel.
   Qed.

   Lemma isRightCompCancel_comp : IsSingleton_comp A -> IsRightCompCancel_comp prefixSeqBisemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil; simpl.
      assert ((a == b)%bool = false) as q1.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert ((b == a)%bool = false) as q2.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1, q2; simpl.
      auto.
   Defined.
   
   Lemma leftIncreasing : IsSingleton A -> LeftIncreasing prefixSeqBisemigroup.
   Proof.
      intros sg.
      apply (Iso_LeftIncreasing (BSmgIso_sym (sg_isoNatMinPlus sg))).
      apply NatMinPlus.leftIncreasing.
   Qed.

   Lemma leftIncreasing_comp : IsSingleton_comp A -> LeftIncreasing_comp prefixSeqBisemigroup.
   Proof. intros sg; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); simpl.
      assert ((a == b)%bool = false) as q1.
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      rewrite q1; simpl; auto.
   Defined.
   
   Lemma rightIncreasing : RightIncreasing prefixSeqBisemigroup.
   Proof. intros _ _ x y. simpl.
      induction x. trivial.
      simpl. rewrite refl. simpl.
      dseq_u; simpl; rewrite refl; simpl; auto.
   Qed.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp prefixSeqBisemigroup.
   Proof. intros _ _.
      exists nil; exists nil; auto.
   Defined.
   
   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp prefixSeqBisemigroup.
   Proof. intros _ _.
      exists nil; exists nil; auto.
   Defined.
   
   (* always irrelevant *)
   Lemma isLeftTimesMapToIdConstantPlus : IsLeftTimesMapToIdConstantPlus prefixSeqBisemigroup.
   Proof. intros [i p].
      destruct (Prefix.hasIdentity_comp A i) as [x q].
      assert (h := p x).
      toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma isRightTimesMapToIdConstantPlus : IsRightTimesMapToIdConstantPlus prefixSeqBisemigroup.
   Proof. intros [i p].
      destruct (Prefix.hasIdentity_comp A i) as [x q].
      assert (h := p x).
      toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator prefixSeqBisemigroup.
   Proof. intros [i p].
      destruct (Prefix.hasIdentity_comp A i) as [x q].
      assert (h := p x).
      toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator prefixSeqBisemigroup.
   Proof. intros [i p].
      destruct (Prefix.hasIdentity_comp A i) as [x q].
      assert (h := p x).
      toProp; tauto.
   Qed.
   
End Seq.