Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.Semigroups.RevOp. 

Section RevTimes.

   Variable A : Bisemigroup.
   
   Definition revTimesBisemigroup : Bisemigroup :=
      glueBSmg (plusSmg A) (revOpSemigroup (timesSmg A)) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)
   
   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Lemma isLeftDistributive : IsRightDistributive A -> IsLeftDistributive revTimesBisemigroup.
   Proof. intros rd x y z. simpl. apply rd. Qed.
   
   Lemma isLeftDistributive_comp : IsRightDistributive_comp A -> IsLeftDistributive_comp revTimesBisemigroup.
   Proof. intros [x [y [z rd]]]. exists x; exists y; exists z; simpl. auto. Defined.
   
   Lemma isRightDistributive : IsLeftDistributive A -> IsRightDistributive revTimesBisemigroup.
   Proof. intros rd x y z. simpl. apply rd. Qed.
   
   Lemma isRightDistributive_comp : IsLeftDistributive_comp A -> IsRightDistributive_comp revTimesBisemigroup.
   Proof. intros [x [y [z rd]]]. exists x; exists y; exists z; simpl. auto. Defined.
   
   Lemma ann_back : HasAnnihilator (timesSmg revTimesBisemigroup) -> HasAnnihilator (timesSmg A).
   Proof. intros [a ann]; exists a; intros x; assert (p := ann x); simpl in *; tauto. Defined.
   
   Lemma id_back : HasIdentity (timesSmg revTimesBisemigroup) -> HasIdentity (timesSmg A).
   Proof. intros [a ann]; exists a; intros x; assert (p := ann x); simpl in *; tauto. Defined.
   
   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator A -> PlusIdentityIsTimesAnnihilator revTimesBisemigroup.
   Proof. intros pita id ann.
      assert (h := pita id (ann_back ann)). simpl in h.
      destruct ann; simpl in *; auto.
   Qed.

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp A -> PlusIdentityIsTimesAnnihilator_comp revTimesBisemigroup.
   Proof. intros pita id ann.
      assert (h := pita id (ann_back ann)). simpl in h.
      destruct ann; simpl in *; auto.
   Qed.
   
   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity A -> PlusAnnihilatorIsTimesIdentity revTimesBisemigroup.
   Proof. intros pita id ann.
      assert (h := pita id (id_back ann)). simpl in h.
      destruct ann; simpl in *; auto.
   Qed.

   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp A -> PlusAnnihilatorIsTimesIdentity_comp revTimesBisemigroup.
   Proof. intros pita id ann.
      assert (h := pita id (id_back ann)). simpl in h.
      destruct ann; simpl in *; auto.
   Qed.
   
   (**************************************************************************)
   (*               A - Commutative & Idempotent properties                  *)
   (**************************************************************************)
   
   Lemma isRightStrictStable : IsLeftStrictStable A -> IsRightStrictStable revTimesBisemigroup.
   Proof. intros lss comm idem x y z.
      simpl. apply (lss comm idem).
   Qed.

   Lemma isRightStrictStable_comp : IsLeftStrictStable_comp A -> IsRightStrictStable_comp revTimesBisemigroup.
   Proof. intros lss comm idem. destruct (lss comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma isLeftStrictStable : IsRightStrictStable A -> IsLeftStrictStable revTimesBisemigroup.
   Proof. intros lss comm idem x y z.
      simpl. apply (lss comm idem).
   Qed.

   Lemma isLeftStrictStable_comp : IsRightStrictStable_comp A -> IsLeftStrictStable_comp revTimesBisemigroup.
   Proof. intros lss comm idem. destruct (lss comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma leftDiscrete : RightDiscrete A -> LeftDiscrete revTimesBisemigroup.
   Proof. intros rd comm idem x y z; simpl; auto. Qed.

   Lemma leftDiscrete_comp : RightDiscrete_comp A -> LeftDiscrete_comp revTimesBisemigroup.
   Proof. intros rd comm idem; destruct (rd comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma rightDiscrete : LeftDiscrete A -> RightDiscrete revTimesBisemigroup.
   Proof. intros rd comm idem x y z; simpl; auto. Qed.
   
   Lemma rightDiscrete_comp : LeftDiscrete_comp A -> RightDiscrete_comp revTimesBisemigroup.
   Proof. intros rd comm idem; destruct (rd comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma leftComparable : RightComparable A -> LeftComparable revTimesBisemigroup.
   Proof. intros rc comm idem x y z; simpl; auto. Qed.
   
   Lemma leftComparable_comp : RightComparable_comp A -> LeftComparable_comp revTimesBisemigroup.
   Proof. intros rc comm idem; destruct (rc comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma rightComparable : LeftComparable A -> RightComparable revTimesBisemigroup.
   Proof. intros rc comm idem x y z; simpl; auto. Qed.
   
   Lemma rightComparable_comp : LeftComparable_comp A -> RightComparable_comp revTimesBisemigroup.
   Proof. intros rc comm idem; destruct (rc comm idem) as [x [y [z p]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma isLeftCompEqCancel : IsRightCompEqCancel A -> IsLeftCompEqCancel revTimesBisemigroup.
   Proof. intros p comm idem x y z; simpl; auto. apply p; auto. Qed.

   Lemma isLeftCompEqCancel_comp : IsRightCompEqCancel_comp A -> IsLeftCompEqCancel_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.

   Lemma isRightCompEqCancel : IsLeftCompEqCancel A -> IsRightCompEqCancel revTimesBisemigroup.
   Proof. intros p comm idem x y z; simpl; auto. apply p; auto. Qed.

   Lemma isRightCompEqCancel_comp : IsLeftCompEqCancel_comp A -> IsRightCompEqCancel_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.

   Lemma isLeftCompCancel : IsRightCompCancel A -> IsLeftCompCancel revTimesBisemigroup.
   Proof. intros p comm idem x y z; simpl; auto. apply p; auto. Qed.

   Lemma isLeftCompCancel_comp : IsRightCompCancel_comp A -> IsLeftCompCancel_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.

   Lemma isRightCompCancel : IsLeftCompCancel A -> IsRightCompCancel revTimesBisemigroup.
   Proof. intros p comm idem x y z; simpl; auto. apply p; auto. Qed.

   Lemma isRightCompCancel_comp : IsLeftCompCancel_comp A -> IsRightCompCancel_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma leftIncreasing : RightIncreasing A -> LeftIncreasing revTimesBisemigroup.
   Proof. intros p comm idem x y; simpl; auto. Qed.

   Lemma leftIncreasing_comp : RightIncreasing_comp A -> LeftIncreasing_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y q]].
      exists x; exists y; simpl; auto.
   Defined.

   Lemma rightIncreasing : LeftIncreasing A -> RightIncreasing revTimesBisemigroup.
   Proof. intros p comm idem x y; simpl; auto. Qed.

   Lemma rightIncreasing_comp : LeftIncreasing_comp A -> RightIncreasing_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y q]].
      exists x; exists y; simpl; auto.
   Defined.
   
   Lemma leftStrictIncreasing : RightStrictIncreasing A -> LeftStrictIncreasing revTimesBisemigroup.
   Proof. intros p comm idem x y; simpl; auto. Qed. 

   Lemma leftStrictIncreasing_comp : RightStrictIncreasing_comp A -> LeftStrictIncreasing_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y q]].
      exists x; exists y; simpl; auto.
   Defined.

   Lemma rightStrictIncreasing : LeftStrictIncreasing A -> RightStrictIncreasing revTimesBisemigroup.
   Proof. intros p comm idem x y; simpl; auto. Qed. 

   Lemma rightStrictIncreasing_comp : LeftStrictIncreasing_comp A -> RightStrictIncreasing_comp revTimesBisemigroup.
   Proof. intros p comm idem; destruct (p comm idem) as [x [y q]].
      exists x; exists y; simpl; auto.
   Defined.
   
   (**************************************************************************)
   (*                         Identity properties                            *)
   (**************************************************************************)
   
   Lemma isLeftTimesMapToIdConstantPlus : IsRightTimesMapToIdConstantPlus A -> IsLeftTimesMapToIdConstantPlus revTimesBisemigroup.
   Proof. intros p hid x y z. simpl; auto. Qed.
   
   Lemma isLeftTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp A -> IsLeftTimesMapToIdConstantPlus_comp revTimesBisemigroup.
   Proof. intros p hid; destruct (p hid) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma isRightTimesMapToIdConstantPlus : IsLeftTimesMapToIdConstantPlus A -> IsRightTimesMapToIdConstantPlus revTimesBisemigroup.
   Proof. intros p hid x y z. simpl; auto. Qed.
   
   Lemma isRightTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp A -> IsRightTimesMapToIdConstantPlus_comp revTimesBisemigroup.
   Proof. intros p hid; destruct (p hid) as [x [y [z q]]].
      exists x; exists y; exists z; simpl; auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesRightAnnihilator A -> PlusIdentityIsTimesLeftAnnihilator revTimesBisemigroup.
   Proof. intros p hid x. simpl; auto. Qed.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp : PlusIdentityIsTimesRightAnnihilator_comp A -> PlusIdentityIsTimesLeftAnnihilator_comp revTimesBisemigroup.
   Proof. intros p hid; destruct (p hid) as [x q].
      exists x; simpl; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesLeftAnnihilator A -> PlusIdentityIsTimesRightAnnihilator revTimesBisemigroup.
   Proof. intros p hid x. simpl; auto. Qed.

   Lemma plusIdentityIsTimesRightAnnihilator_comp : PlusIdentityIsTimesLeftAnnihilator_comp A -> PlusIdentityIsTimesRightAnnihilator_comp revTimesBisemigroup.
   Proof. intros p hid; destruct (p hid) as [x q].
      exists x; simpl; auto.
   Defined.

End RevTimes.