Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.RangePlus.
Require Import Metarouting.Constructions.Semigroups.RangeMin.
Require Import Metarouting.Constructions.Bisemigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.BoolOrAnd.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.
Require Import Coq.Arith.Min.

Section RangeMinPlus.

   Open Scope Bisemigroup_scope.

   Variable n : nat.

   Definition rangeMinPlusBisemigroup : Bisemigroup :=
      glueBSmg (rangeMinSemigroup n) (rangePlusSemigroup n) (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _). *)

End RangeMinPlus.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma rminplus0BSmgIso_isIso : IsBSmgIso (rangeMinPlusBisemigroup 0) unitBisemigroup range0DsIso.
   Proof. split.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
   Qed.

   Definition rminplus0BSmgIso : BSmgIso (rangeMinPlusBisemigroup 0) unitBisemigroup :=
      Build_BSmgIso rminplus0BSmgIso_isIso.

   Lemma rminplus1BSmgIso_isIso : IsBSmgIso (rangeMinPlusBisemigroup 1) boolOrAndBisemigroup (DsIso_trans (reverseRangeDsIso 1) range1DsIso).
   Proof. split.
      intros [|x] [|y]; simpl; auto.
      intros [|] [|]; simpl; auto.
      intros [|x] [|y]; simpl; auto.
      intros [|] [|]; dseq_u; simpl; auto.
   Qed.

   Definition rminplus1BSmgIso : BSmgIso (rangeMinPlusBisemigroup 1) boolOrAndBisemigroup :=
      Build_BSmgIso rminplus1BSmgIso_isIso.

   Lemma plus_dist_min : forall x y z : nat, (x + min y z)%nat = min (x + y)%nat (x + z)%nat.
   Proof. intros. induction x. trivial.
     simpl. rewrite IHx; trivial.
   Defined.
   
   Lemma plus_dist_max : forall x y z : nat, (x + max y z)%nat = max (x + y)%nat (x + z)%nat.
   Proof. intros. induction x. trivial.
     simpl. rewrite IHx; trivial.
   Defined.

   Lemma max_dist_min : forall x y z : nat, max x (min y z) = min (max x y) (max x z).
   Proof. intros.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ); trivial.
      apply le_antisym; trivial; apply (le_trans y z x); trivial.
      apply le_antisym; trivial; apply (le_trans z y x); trivial.
   Defined.

   Lemma min_dist_max : forall x y z : nat, min x (max y z) = max (min x y) (min x z).
   Proof. intros.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ); trivial.      apply le_antisym; trivial. apply (le_trans _ y _); trivial.
      apply le_antisym; trivial. apply (le_trans _ z _); trivial.
   Defined.

   Lemma leb_min : forall w1 w2, (if leb w1 w2 then w1 else w2) = min w1 w2.
   Proof. intros. copy_destruct (leb w1 w2); rewrite ew.
      rewrite min_l; trivial; apply leb_complete; trivial.
      rewrite min_r; trivial. assert (p := leb_complete_conv _ _ ew). apply lt_le_weak; trivial.
   Defined.

   Lemma isLeftDistributive : forall n, IsLeftDistributive (rangeMinPlusBisemigroup n).
   Proof. intros n a b c; simpl; rewrite plus_dist_min; auto. Defined.

   Lemma isRightDistributive : forall n, IsRightDistributive (rangeMinPlusBisemigroup n).
   Proof. intros n; apply comm_distr.
      apply (RangePlus.isCommutative n).
      apply isLeftDistributive.
   Defined.

(*
   Lemma isLeftCoDistributive_comp : forall n, IsLeftCoDistributive_comp (rangeMinPlusBisemigroup (S (S n))).
   Proof. intros n. red. simpl. exists 1; exists 1; exists 1. simpl. auto. Defined.

   Lemma isRightCoDistributive_comp : forall n, IsRightCoDistributive_comp (rangeMinPlusBisemigroup (S (S n))).
   Proof. intros n. apply comm_codistr_comp. apply (RangeMin.isCommutative (S (S n))). apply (isLeftCoDistributive_comp n). Defined.
*)
   
   Lemma plusIdentityIsTimesAnnihilator : forall n, PlusIdentityIsTimesAnnihilator (rangeMinPlusBisemigroup (S n)).
   Proof. intros n pid tann.
      set (pid2 := RangeMin.hasIdentity (S n)).
      set (iso := Iso_PresId (@SmgIso_sym (rangeMinSemigroup (S n)) (plusSmg (rangeMinPlusBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresAnn (@SmgIso_sym (rangePlusSemigroup (S n)) (timesSmg (rangeMinPlusBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tann2 := RangePlus.hasAnnihilator (S n)).
      rewrite <- (iso2 tann tann2).
      simpl. clear. auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : forall n, PlusAnnihilatorIsTimesIdentity (rangeMinPlusBisemigroup (S n)).
   Proof. intros n pann tid.
      set (pann2 := RangeMin.hasAnnihilator (S n)).
      set (iso := Iso_PresAnn (@SmgIso_sym (rangeMinSemigroup (S n)) (plusSmg (rangeMinPlusBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pann pann2).
      set (iso2 := Iso_PresId (@SmgIso_sym (rangePlusSemigroup (S n)) (timesSmg (rangeMinPlusBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tid2 := RangePlus.hasIdentity (S n)).
      rewrite <- (iso2 tid tid2).
      simpl. clear.
      toProp. auto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma isRightStrictStable_comp : forall n, IsRightStrictStable_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n comm idem.
     exists 0; exists (S n); exists (S n); dseq_u; simpl.
     rewrite eq_range_over_r; auto; simpl;
     rewrite min_l, (leb_correct _ _ (le_refl n)); simpl; [| apply le_plus_l];
     rewrite eq_range_over_r; auto; simpl; [| apply le_n_S; apply le_plus_l];
     rewrite min_r, (leb_correct _ _ (le_refl n)); simpl; [| apply le_plus_l]; auto.
   Defined.

   Lemma isLeftStrictStable_comp : forall n, IsLeftStrictStable_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n comm idem.
     exists 0; exists (S n); exists (S n); dseq_u; simpl.
     rewrite plus_comm; simpl.
     rewrite eq_range_over_r; auto; simpl.
     rewrite min_l, (leb_correct _ _ (le_refl n)); simpl; [| apply le_plus_l];
     rewrite eq_range_over_r; auto; simpl; [| apply le_n_S; apply le_plus_l];
     rewrite min_r, (leb_correct _ _ (le_refl n)); simpl; [| apply le_plus_l]; auto.
   Defined.

   Lemma isRightCompEqCancel : forall n, IsRightCompEqCancel (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
      intros h; destruct (le_ge_dec x y); min_max_rewrite;
      destruct (leb n x); destruct (leb n y); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma isLeftCompEqCancel : forall n, IsLeftCompEqCancel (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl;
      intros h; destruct (le_ge_dec x y); min_max_rewrite;
      destruct (leb n x); destruct (leb n y); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma isRightCompCancel : forall n, IsRightCompCancel (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
      intros h; destruct (le_ge_dec x y); min_max_rewrite;
      destruct (leb n x); destruct (leb n y); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma isLeftCompCancel : forall n, IsLeftCompCancel (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
      intros h; destruct (le_ge_dec x y); min_max_rewrite;
      destruct (leb n x); destruct (leb n y); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma leftDiscrete_comp : forall n, LeftDiscrete_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 0; exists 1; exists 0; simpl. auto.
   Defined.

   Lemma rightDiscrete_comp : forall n, RightDiscrete_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 0; exists 1; exists 0; auto.
   Defined.

   Lemma leftComparable : forall n, LeftComparable (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
     destruct (le_ge_dec (z + x) (z + y)); min_max_rewrite;
     destruct (leb n (z + x)); destruct (leb n (z + y)); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma rightComparable : forall n, RightComparable (rangeMinPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
     destruct (le_ge_dec (x + z) (y + z)); min_max_rewrite;
     destruct (leb n (x + z)); destruct (leb n (y + z)); toProp; rewrite ?eq_range_refl; auto.
   Defined.

   Lemma rightIncreasing : forall n, RightIncreasing (rangeMinPlusBisemigroup (S n)).
   Proof. intros n _ _ x y; auto. simpl. rewrite min_l; auto.
      apply le_plus_l.
   Defined.

   Lemma leftIncreasing : forall n, LeftIncreasing (rangeMinPlusBisemigroup (S n)).
   Proof. intros n _ _ x y; auto. simpl. rewrite min_l; auto.
      apply le_plus_r.
   Defined.

   Lemma rightStrictIncreasing_comp : forall n, RightStrictIncreasing_comp (rangeMinPlusBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.

   Lemma leftStrictIncreasing_comp : forall n, LeftStrictIncreasing_comp (rangeMinPlusBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.

(*
   Lemma leftWStrictIncreasing_comp : forall n, LeftWStrictIncreasing_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 0; exists 0.
      rewrite (uniqueId _ hid (RangeMin.hasIdentity (S n))).
      simpl. auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : forall n, RightWStrictIncreasing_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 0; exists 0.
      rewrite (uniqueId _ hid (RangeMin.hasIdentity (S n))).
      simpl. auto.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : forall n, IsRightTimesMapToIdConstantPlus_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n hasId;
      exists 0; exists 0; exists 0.
      assert (p := uniqueId _ hasId (RangeMin.hasIdentity (S n))); rewrite p; simpl. auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : forall n, IsLeftTimesMapToIdConstantPlus_comp (rangeMinPlusBisemigroup (S n)).
   Proof. intros n hasId;
      exists 0; exists 0; exists 0.
      assert (p := uniqueId _ hasId (RangeMin.hasIdentity (S n))); rewrite p; simpl. auto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : forall n, PlusIdentityIsTimesLeftAnnihilator (rangeMinPlusBisemigroup n).
   Proof. intros n hasId x.
      assert (p := uniqueId _ hasId (RangeMin.hasIdentity n)); rewrite p.
      dseq_u; simpl. rewrite eq_range_over_r; auto. apply leb_correct; apply le_plus_l.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : forall n, PlusIdentityIsTimesRightAnnihilator (rangeMinPlusBisemigroup n).
   Proof. intros n hasId x.
      assert (p := uniqueId _ hasId (RangeMin.hasIdentity n)); rewrite p.
      dseq_u; simpl. rewrite eq_range_over_r; auto. apply leb_correct; apply le_plus_r.
   Defined.
