Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.RangePlus.
Require Import Metarouting.Constructions.Semigroups.RangeMax.
Require Import Metarouting.Constructions.Bisemigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.BoolOrAnd.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.
Require Import Coq.Arith.Min.

Section RangeMaxPlus.

   Open Scope Bisemigroup_scope.

   Variable n : nat.

   Definition rangeMaxPlusBisemigroup : Bisemigroup :=
      glueBSmg (rangeMaxSemigroup n) (rangePlusSemigroup n) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

End RangeMaxPlus.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma rmaxplus0BSmgIso_isIso : IsBSmgIso (rangeMaxPlusBisemigroup 0) unitBisemigroup range0DsIso.
   Proof. split.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
   Qed.

   Definition rmaxplus0BSmgIso : BSmgIso (rangeMaxPlusBisemigroup 0) unitBisemigroup :=
      Build_BSmgIso rmaxplus0BSmgIso_isIso.

   Lemma plus_dist_min : forall x y z : nat, (x + min y z)%nat = min (x + y)%nat (x + z)%nat.
   Proof. intros. induction x. trivial.
     simpl. rewrite IHx; trivial.
   Defined.
   
   Lemma plus_dist_max : forall x y z : nat, (x + max y z)%nat = max (x + y)%nat (x + z)%nat.
   Proof. intros. induction x. trivial.
     simpl. rewrite IHx; trivial.
   Defined.

   Lemma max_dist_min : forall x y z : nat, max x (min y z) = min (max x y) (max x z).
   Proof. intros.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ); trivial.
      apply le_antisym; trivial; apply (le_trans y z x); trivial.
      apply le_antisym; trivial; apply (le_trans z y x); trivial.
   Defined.

   Lemma min_dist_max : forall x y z : nat, min x (max y z) = max (min x y) (min x z).
   Proof. intros.
      destruct (le_ge_dec x y);
      destruct (le_ge_dec x z);
      destruct (le_ge_dec y z);
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ); trivial.
      apply le_antisym; trivial. apply (le_trans _ y _); trivial.
      apply le_antisym; trivial. apply (le_trans _ z _); trivial.
   Defined.

   Lemma leb_min : forall w1 w2, (if leb w1 w2 then w1 else w2) = min w1 w2.
   Proof. intros. copy_destruct (leb w1 w2); rewrite ew.
      rewrite min_l; trivial; apply leb_complete; trivial.
      rewrite min_r; trivial. assert (p := leb_complete_conv _ _ ew). apply lt_le_weak; trivial.
   Defined.

   Lemma isLeftDistributive : forall n, IsLeftDistributive (rangeMaxPlusBisemigroup n).
   Proof. intros n a b c. simpl. rewrite plus_dist_max; auto. Defined.

   Lemma isRightDistributive : forall n, IsRightDistributive (rangeMaxPlusBisemigroup n).
   Proof. intros n; apply comm_distr.
      apply (RangePlus.isCommutative n).
      apply isLeftDistributive.
   Defined.

(*
   Lemma isLeftCoDistributive1 : IsLeftCoDistributive (rangeMaxPlusBisemigroup 1).
   Proof. intros [|x] [|y] [|z]; dseq_u; simpl; auto. Defined.

   Lemma isLeftCoDistributive_comp : forall n, IsLeftCoDistributive_comp (rangeMaxPlusBisemigroup (S (S n))).
   Proof. red; exists 0; exists 0; exists 1. simpl. auto. Defined.

   Lemma isRightCoDistributive1 : IsRightCoDistributive (rangeMaxPlusBisemigroup 1).
   Proof. intros [|x] [|y] [|z]; dseq_u; simpl; auto. Defined.

   Lemma isRightCoDistributive_comp : forall n, IsRightCoDistributive_comp (rangeMaxPlusBisemigroup (S (S n))).
   Proof. intros n. apply comm_codistr_comp. 
      apply (Iso_IsCommutative (SmgIso_sym (rmaxSmgIso (S (S n))))).
      apply (RangeMin.isCommutative (S (S n))). apply (isLeftCoDistributive_comp n).
   Defined.
*)   

   Lemma plusIdentityIsTimesAnnihilator_comp : forall n, PlusIdentityIsTimesAnnihilator_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n pid tann.
      set (pid2 := Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n))).
      set (iso := Iso_PresId (@SmgIso_sym (rangeMaxSemigroup (S n)) (plusSmg (rangeMaxPlusBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresAnn (@SmgIso_sym (rangePlusSemigroup (S n)) (timesSmg (rangeMaxPlusBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tann2 := RangePlus.hasAnnihilator (S n)).
      rewrite <- (iso2 tann tann2).
      simpl. clear.
      rewrite minus_diag.
      toProp. rewrite eq_range_l. intros h; discriminate h. apply lt_O_Sn.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity_comp : forall n, PlusAnnihilatorIsTimesIdentity_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n pann tid.
      set (pann2 := Iso_HasAnnihilator (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasAnnihilator (S n))).
      set (iso := Iso_PresAnn (@SmgIso_sym (rangeMaxSemigroup (S n)) (plusSmg (rangeMaxPlusBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pann pann2).
      set (iso2 := Iso_PresId (@SmgIso_sym (rangePlusSemigroup (S n)) (timesSmg (rangeMaxPlusBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tid2 := RangePlus.hasIdentity (S n)).
      rewrite <- (iso2 tid tid2).
      simpl. clear.
      toProp. rewrite eq_range_r. intros h; discriminate h. apply lt_O_Sn.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma isRightStrictStable_comp : forall n, IsRightStrictStable_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n comm idem.
     exists (S n); exists 0; exists (S n); simpl. rewrite eq_range_refl; simpl. negb_p.
     rewrite (max_comm n); rewrite (max_l); simpl; [| apply le_plus_l].
     rewrite (eq_range_over_r _ _ (S n)); auto; simpl.
     rewrite eq_range_refl; simpl.
     toProp; rewrite eq_range_r; [| apply leb_complete; auto].
     rewrite leb_correct; [| apply le_plus_l].
     intuition; apply or_introl; intros h; discriminate h.
   Defined.

   Lemma isLeftStrictStable_comp : forall n, IsLeftStrictStable_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n comm idem.
     exists (S n); exists 0; exists (S n); simpl. rewrite eq_range_refl; simpl. negb_p.
     rewrite (plus_comm _ 0); simpl;
     rewrite (max_comm n); rewrite (max_l); simpl; [| apply le_plus_l].
     rewrite (eq_range_over_r _ _ (S n)); auto; simpl.
     rewrite eq_range_refl; simpl.
     toProp; rewrite eq_range_r; [| apply leb_complete; auto].
     rewrite leb_correct; [| apply le_plus_l].
     intuition; apply or_introl; intros h; discriminate h.
   Defined.

   Lemma isRightCompEqCancel : forall n, IsRightCompEqCancel (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
     intros h; destruct (le_ge_dec x y); min_max_rewrite; auto;
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma isLeftCompEqCancel : forall n, IsLeftCompEqCancel (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
     intros h; destruct (le_ge_dec x y); min_max_rewrite; auto;
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma isRightCompCancel : forall n, IsRightCompCancel (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl.
     destruct (le_ge_dec x y); intros _; min_max_rewrite; auto;
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma isLeftCompCancel : forall n, IsLeftCompCancel (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; simpl;
     destruct (le_ge_dec x y); intros _; min_max_rewrite; auto;
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma leftDiscrete_comp : forall n, LeftDiscrete_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 1; exists 0; exists 0; dseq_u; simpl. unfold eq_range; simpl.
      destruct (leb n 0); auto.
   Defined.

   Lemma rightDiscrete_comp : forall n, RightDiscrete_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 1; exists 0; exists 0; dseq_u; simpl. unfold eq_range; simpl.
      destruct (leb n 0); auto.
   Defined.

   Lemma leftComparable : forall n, LeftComparable (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl;
     destruct (le_ge_dec (z + x) (z + y)); min_max_rewrite;
     destruct (leb n (z + x)); destruct (leb n (z + y)); 
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma rightComparable : forall n, RightComparable (rangeMaxPlusBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl;
     destruct (le_ge_dec (x + z) (y + z)); min_max_rewrite;
     destruct (leb n (x + z)); destruct (leb n (y + z)); 
     toProp; rewrite eq_range_refl; auto.
   Defined.

   Lemma rightIncreasing_comp : forall n, RightIncreasing_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n _ _; exists 0; exists 1; simpl. toProp; intros h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
   Defined.

   Lemma leftIncreasing_comp : forall n, LeftIncreasing_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n _ _; exists 0; exists 1; simpl. toProp; intros h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
   Defined.

   Lemma rightStrictIncreasing_comp : forall n, RightStrictIncreasing_comp (rangeMaxPlusBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.

   Lemma leftStrictIncreasing_comp : forall n, LeftStrictIncreasing_comp (rangeMaxPlusBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.
   
(*
   Lemma leftWStrictIncreasing_comp : forall n, LeftWStrictIncreasing_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 1; exists 1.
      rewrite (uniqueId _ hid (Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n)))).
      simpl. negb_p. split.
      toProp; intros h.
      rewrite minus_diag in h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
      toProp; apply or_intror.
      apply eq_range_refl.
   Defined.

   Lemma rightWStrictIncreasing_comp : forall n, RightWStrictIncreasing_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 1; exists 1.
      rewrite (uniqueId _ hid (Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n)))).
      simpl. negb_p. split.
      toProp; intros h.
      rewrite minus_diag in h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
      toProp; apply or_intror.
      apply eq_range_refl.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : forall n, IsRightTimesMapToIdConstantPlus_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n hasId.
      exists 1; exists 1; exists 0;
      assert (p := uniqueId _ hasId ((Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n)))) (RangeMin.hasIdentity (S n)))); rewrite p.
      simpl. rewrite minus_diag; simpl. unfold eq_range; simpl; destruct (leb n 0); auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : forall n, IsLeftTimesMapToIdConstantPlus_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n hasId.
      exists 1; exists 1; exists 0;
      assert (p := uniqueId _ hasId ((Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n)))) (RangeMin.hasIdentity (S n)))); rewrite p.
      simpl. rewrite minus_diag; simpl. unfold eq_range; simpl; destruct (leb n 0); auto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp : forall n, PlusIdentityIsTimesLeftAnnihilator_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n hasId. exists 1. 
      assert (p := uniqueId _ hasId ((Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n)))) (RangeMin.hasIdentity (S n)))); rewrite p.
      simpl. rewrite minus_diag; simpl. unfold eq_range; simpl; destruct (leb n 0); auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator_comp : forall n, PlusIdentityIsTimesRightAnnihilator_comp (rangeMaxPlusBisemigroup (S n)).
   Proof. intros n hasId. exists 1. 
      assert (p := uniqueId _ hasId ((Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n)))) (RangeMin.hasIdentity (S n)))); rewrite p.
      simpl. rewrite minus_diag; simpl. unfold eq_range; simpl; destruct (leb n 0); auto.
   Defined.
