Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.Range.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.RangeMin.
Require Import Metarouting.Constructions.Semigroups.RangeMax.
Require Import Metarouting.Constructions.Bisemigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.BoolOrAnd.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Min.
Require Import Coq.Arith.Max.

Section RangeMaxMin.

   Open Scope Bisemigroup_scope.

   Variable n : nat.

   Definition rangeMaxMinBisemigroup : Bisemigroup :=
      glueBSmg (rangeMaxSemigroup n) (rangeMinSemigroup n) (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

End RangeMaxMin.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma rmaxmin0BSmgIso_isIso : IsBSmgIso (rangeMaxMinBisemigroup 0) unitBisemigroup range0DsIso.
   Proof. split.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
      intros x y; compute; auto.
   Qed.

   Definition rmaxmin0BSmgIso : BSmgIso (rangeMaxMinBisemigroup 0) unitBisemigroup :=
      Build_BSmgIso rmaxmin0BSmgIso_isIso.

   Lemma rmaxmin1BSmgIso_isIso : IsBSmgIso (rangeMaxMinBisemigroup 1) boolOrAndBisemigroup range1DsIso.
   Proof. split.
      intros [|x] [|y]; simpl; auto.
      intros [|] [|]; simpl; auto.
      intros [|x] [|y]; simpl; auto.
      intros [|] [|]; simpl; auto.
   Qed.

   Definition rmaxmin1BSmgIso : BSmgIso (rangeMaxMinBisemigroup 1) boolOrAndBisemigroup :=
      Build_BSmgIso rmaxmin1BSmgIso_isIso.
   
   Lemma max_min_distr : forall x y z, max x (min y z) = min (max x y) (max x z).
   Proof. intros x y z.
      destruct (le_ge_dec x y) as [p|p];
      destruct (le_ge_dec x z) as [q|q];
      destruct (le_ge_dec y z) as [r|r];
      repeat (progress (
      rewrite ?(min_l _ _ p), ?(min_r _ _ p), ?(max_r _ _ p), ?(max_l _ _ p);
      rewrite ?(min_l _ _ q), ?(min_r _ _ q), ?(max_r _ _ q), ?(max_l _ _ q);
      rewrite ?(min_l _ _ r), ?(min_r _ _ r), ?(max_r _ _ r), ?(max_l _ _ r)
      )); auto.
      apply le_antisym; auto; apply (le_trans _ z); auto.
      apply le_antisym; auto; apply (le_trans _ y); auto.
      rewrite min_idemp; auto.
      rewrite min_idemp; auto.
   Qed.
   
   Lemma min_max_distr : forall x y z, min x (max y z) = max (min x y) (min x z).
   Proof. intros x y z.
      destruct (le_ge_dec x y) as [p|p];
      destruct (le_ge_dec x z) as [q|q];
      destruct (le_ge_dec y z) as [r|r];
      repeat (progress (
      rewrite ?(min_l _ _ p), ?(min_r _ _ p), ?(max_r _ _ p), ?(max_l _ _ p);
      rewrite ?(min_l _ _ q), ?(min_r _ _ q), ?(max_r _ _ q), ?(max_l _ _ q);
      rewrite ?(min_l _ _ r), ?(min_r _ _ r), ?(max_r _ _ r), ?(max_l _ _ r)
      )); auto.
      rewrite max_idemp; auto.
      rewrite max_idemp; auto.
      apply le_antisym; auto; apply (le_trans _ y); auto.
      apply le_antisym; auto; apply (le_trans _ z); auto.
   Qed.

   Lemma isLeftDistributive : forall n, IsLeftDistributive (rangeMaxMinBisemigroup n).
   Proof. intros n a b c; simpl; rewrite <- min_max_distr; auto. Defined.

   Lemma isRightDistributive : forall n, IsRightDistributive (rangeMaxMinBisemigroup n).
   Proof. intros n; apply comm_distr.
      apply (RangeMin.isCommutative n).
      apply isLeftDistributive.
   Defined.
   
(*
   Lemma isLeftCoDistributive : forall n, IsLeftCoDistributive (rangeMaxMinBisemigroup n).
   Proof. intros n a b c; simpl; rewrite <- max_min_distr; auto. Defined.
   
   Lemma isRightCoDistributive : forall n, IsRightCoDistributive (rangeMaxMinBisemigroup n).
   Proof. intros n; apply comm_codistr.
      apply (Iso_IsCommutative (SmgIso_sym (rmaxSmgIso n)) (RangeMin.isCommutative n)).
      apply isLeftCoDistributive.
   Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator : forall n, PlusIdentityIsTimesAnnihilator (rangeMaxMinBisemigroup (S n)).
   Proof. intros n pid tann.
      set (pid2 := Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n))).
      set (iso := Iso_PresId (@SmgIso_sym (rangeMaxSemigroup (S n)) (plusSmg (rangeMaxMinBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pid pid2).
      set (iso2 := Iso_PresAnn (@SmgIso_sym (rangeMinSemigroup (S n)) (timesSmg (rangeMaxMinBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tann2 := RangeMin.hasAnnihilator (S n)).
      rewrite <- (iso2 tann tann2).
      simpl. clear.
      rewrite minus_diag. auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : forall n, PlusAnnihilatorIsTimesIdentity (rangeMaxMinBisemigroup (S n)).
   Proof. intros n pann tid.
      set (pann2 := Iso_HasAnnihilator (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasAnnihilator (S n))).
      set (iso := Iso_PresAnn (@SmgIso_sym (rangeMaxSemigroup (S n)) (plusSmg (rangeMaxMinBisemigroup (S n))) (plusBSmgIso _ _ _))).
      rewrite <- (iso pann pann2).
      set (iso2 := Iso_PresId (@SmgIso_sym (rangeMinSemigroup (S n)) (timesSmg (rangeMaxMinBisemigroup (S n))) (timesBSmgIso _ _ _))).
      set (tid2 := RangeMin.hasIdentity (S n)).
      rewrite <- (iso2 tid tid2).
      simpl. clear. auto.
   Defined.

   (******************************************************************************)
   (*                    Commutative + Idempotent properties                     *)
   (******************************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail]);
         try (rewrite max_idemp)
      ).

   Lemma isRightStrictStable_comp : forall n, IsRightStrictStable_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n comm idem.
     exists (S n); exists 0; exists 0; simpl. unfold eq_range; simpl.
     rewrite (leb_correct _ _ (le_refl n)). auto.
   Defined.
   
   Lemma isLeftStrictStable_comp : forall n, IsLeftStrictStable_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n comm idem.
     exists (S n); exists 0; exists 0; simpl. unfold eq_range; simpl.
     rewrite (leb_correct _ _ (le_refl n)). auto.
   Defined.
   
   Lemma isRightCompEqCancel : forall n, IsRightCompEqCancel (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     do 2 rewrite leb_min, leb_max.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec y z); min_max_rewrite; 
     copy_destruct (leb n x);
     copy_destruct (leb n y);
     copy_destruct (leb n z); rewrite ?ew, ?ew0, ?ew1; simpl;
     auto; toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma isLeftCompEqCancel : forall n, IsLeftCompEqCancel (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     do 2 rewrite leb_min, leb_max.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec y z); min_max_rewrite; 
     copy_destruct (leb n x);
     copy_destruct (leb n y);
     copy_destruct (leb n z); rewrite ?ew, ?ew0, ?ew1; simpl;
     auto; toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma isRightCompCancel : forall n, IsRightCompCancel (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     copy_destruct (leb n (max (min x z) (min y z)));
     rewrite ew;
     destruct (le_ge_dec x y); intros _; min_max_rewrite; auto;
     destruct (leb n x); destruct (leb n y); auto;
     toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma isLeftCompCancel : forall n, IsLeftCompCancel (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     copy_destruct (leb n (max (min z x) (min z y)));
     rewrite ew;
     destruct (le_ge_dec x y); intros _; min_max_rewrite; auto;
     destruct (leb n x); destruct (leb n y); auto;
     toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma leftDiscrete_comp : forall n, LeftDiscrete_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 1; exists 0; exists 1. simpl. unfold eq_range; simpl.
      destruct (leb n 0); split; auto.
   Defined.
  

   Lemma rightDiscrete_comp : forall n, RightDiscrete_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n comm idem.
      exists 1; exists 0; exists 1. simpl. unfold eq_range; simpl.
      destruct (leb n 0); split; auto.
   Defined.
   
   Lemma leftComparable : forall n, LeftComparable (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec z y); 
     min_max_rewrite;
     destruct (leb n x);
     destruct (leb n y);
     destruct (leb n z); auto;
     toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma rightComparable : forall n, RightComparable (rangeMaxMinBisemigroup n).
   Proof. intros n comm idem x y z; dseq_u; simpl; unfold eq_range; simpl.
     destruct (le_ge_dec x y);
     destruct (le_ge_dec x z);
     destruct (le_ge_dec z y); 
     min_max_rewrite;
     destruct (leb n x);
     destruct (leb n y);
     destruct (leb n z); auto;
     toProp; repeat rewrite beq_nat_eq; auto.
   Defined.

   Lemma rightIncreasing : forall n, RightIncreasing (rangeMaxMinBisemigroup n).
   Proof. intros n _ _ x y; auto. simpl. destruct (le_ge_dec x y); min_max_rewrite; auto. Defined.

   Lemma leftIncreasing : forall n, LeftIncreasing (rangeMaxMinBisemigroup n).
   Proof. intros n _ _ x y; auto. simpl. destruct (le_ge_dec x y); min_max_rewrite; auto. Defined.

   Lemma rightStrictIncreasing_comp : forall n, RightStrictIncreasing_comp (rangeMaxMinBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.

   Lemma leftStrictIncreasing_comp : forall n, LeftStrictIncreasing_comp (rangeMaxMinBisemigroup n).
   Proof. intros n _ _. exists 0; exists 0; auto. simpl. destruct (eq_range n 0 0); auto. Defined.

(*
   Lemma leftWStrictIncreasing_comp : forall n, LeftWStrictIncreasing_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 1; exists 1.
      rewrite (uniqueId _ hid (Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n)))).
      simpl. negb_p. split.
      toProp; intros h.
      rewrite minus_diag in h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
      toProp; apply or_intror.
      apply eq_range_refl.
   Defined.
      
   Lemma rightWStrictIncreasing_comp : forall n, RightWStrictIncreasing_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n _ _ hid. exists 1; exists 1.
      rewrite (uniqueId _ hid (Iso_HasIdentity (SmgIso_sym (rmaxSmgIso (S n))) (RangeMin.hasIdentity (S n)))).
      simpl. negb_p. split.
      toProp; intros h.
      rewrite minus_diag in h.
      rewrite eq_range_r in h. discriminate h.
      apply lt_O_Sn.
      toProp; apply or_intror.
      apply eq_range_refl.
   Defined.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma plus_id_0 : forall n (hasId : HasIdentity (plusSmg (rangeMaxMinBisemigroup (S n)))), projT1 hasId = 0.
   Proof. intros n [[|x] p]; auto. assert (q := p 0); clear - q. destruct q as [q _]; dseq_u; simpl in *; auto. compute in q.
      fold leb in *. destruct (leb n x); discriminate q.
   Defined.

   Lemma isRightTimesMapToIdConstantPlus_comp : forall n, IsRightTimesMapToIdConstantPlus_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n hasId.
      exists (S n); exists (S n); exists (S n). rewrite (plus_id_0 n hasId); simpl; auto.
      rewrite min_idemp, max_idemp. unfold eq_range. simpl. destruct (leb n n); auto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : forall n, IsLeftTimesMapToIdConstantPlus_comp (rangeMaxMinBisemigroup (S n)).
   Proof. intros n hasId.
      exists (S n); exists (S n); exists (S n). rewrite (plus_id_0 n hasId); simpl; auto.
      rewrite min_idemp, max_idemp. unfold eq_range. simpl. destruct (leb n n); auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator : forall n, PlusIdentityIsTimesLeftAnnihilator (rangeMaxMinBisemigroup (S n)).
   Proof. intros n hasId x. rewrite (plus_id_0 _ hasId). dseq_u; simpl; unfold eq_range. 
      destruct (leb (S n) 0); rewrite ?beq_nat_eq; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : forall n, PlusIdentityIsTimesRightAnnihilator (rangeMaxMinBisemigroup (S n)).
   Proof. intros n hasId x. rewrite (plus_id_0 _ hasId). dseq_u; simpl; unfold eq_range.
      rewrite min_comm; simpl. auto. 
   Defined.
