Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.Semigroups.Product. 
Require Import Coq.Bool.Bool.

(*********************************************************************)
(* direct product of decidable bisemigroups *)

Section DiretcProduct.

   Open Scope Bisemigroup_scope.

   Variable A B : Bisemigroup.
   
   Definition prodBisemigroup : Bisemigroup :=
      let ps := prodSemigroup (plusSmg A) (plusSmg B) in
      let ts := prodSemigroup (timesSmg A) (timesSmg B) in
      glueBSmg ps ts (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

   Lemma isLeftDistributive : IsLeftDistributive A * IsLeftDistributive B -> IsLeftDistributive prodBisemigroup.
   Proof. intros [lda ldb] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl; toProp; split.
      apply lda.
      apply ldb.
   Defined.

   Lemma isLeftDistributive_comp : IsLeftDistributive_comp A + IsLeftDistributive_comp B
      -> IsLeftDistributive_comp prodBisemigroup.
   Proof. intros [[x [y [z lda]]] | [x [y [z ldb]]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl; toProp; tauto.
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; toProp; tauto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive A * IsRightDistributive B 
      -> IsRightDistributive prodBisemigroup.
   Proof. intros [lda ldb] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl; toProp; split.
      apply lda.
      apply ldb.
   Defined.

   Lemma isRightDistributive_comp : IsRightDistributive_comp A + IsRightDistributive_comp B
      -> IsRightDistributive_comp prodBisemigroup.
   Proof. intros [[x [y [z lda]]] | [x [y [z ldb]]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl; toProp; tauto.
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; toProp; tauto.
   Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive A * IsLeftCoDistributive B 
      -> IsLeftCoDistributive prodBisemigroup.
   Proof. intros [lda ldb] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl; toProp; split.
      apply lda.
      apply ldb.
   Defined.

   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp A + IsLeftCoDistributive_comp B
      -> IsLeftCoDistributive_comp prodBisemigroup.
   Proof. intros [[x [y [z lda]]] | [x [y [z ldb]]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl; toProp; tauto.
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; toProp; tauto.
   Defined.

   Lemma isRightCoDistributive : IsRightCoDistributive A * IsRightCoDistributive B 
      -> IsRightCoDistributive prodBisemigroup.
   Proof. intros [lda ldb] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl; toProp; split.
      apply lda.
      apply ldb.
   Defined.

   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp A + IsRightCoDistributive_comp B
      -> IsRightCoDistributive_comp prodBisemigroup.
   Proof. intros [[x [y [z lda]]] | [x [y [z ldb]]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl; toProp; tauto.
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; toProp; tauto.
   Defined.
*)

   Lemma hasPlusId_back_a : HasIdentity (plusSmg prodBisemigroup) -> HasIdentity (plusSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasPlusId_back_b : HasIdentity (plusSmg prodBisemigroup) -> HasIdentity (plusSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasPlusAnn_back_a : HasAnnihilator (plusSmg prodBisemigroup) -> HasAnnihilator (plusSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasPlusAnn_back_b : HasAnnihilator (plusSmg prodBisemigroup) -> HasAnnihilator (plusSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma hasTimesId_back_a : HasIdentity (timesSmg prodBisemigroup) -> HasIdentity (timesSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesId_back_b : HasIdentity (timesSmg prodBisemigroup) -> HasIdentity (timesSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesAnn_back_a : HasAnnihilator (timesSmg prodBisemigroup) -> HasAnnihilator (timesSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesAnn_back_b : HasAnnihilator (timesSmg prodBisemigroup) -> HasAnnihilator (timesSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator A * PlusIdentityIsTimesAnnihilator B
      -> PlusIdentityIsTimesAnnihilator prodBisemigroup.
   Proof. intros [pa pb] pid tann.
      assert (p1 := pa (hasPlusId_back_a pid) (hasTimesAnn_back_a tann)).
      assert (p2 := pb (hasPlusId_back_b pid) (hasTimesAnn_back_b tann)).
      simpl in *.
      destruct pid as [[ia ib] p]; simpl in *.
      destruct tann as [[ta tb] q]; simpl in *.
      dseq_u; simpl; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp A + PlusIdentityIsTimesAnnihilator_comp B
      -> PlusIdentityIsTimesAnnihilator_comp prodBisemigroup.
   Proof. intros [pa | pb] pid tann.
      assert (p1 := pa (hasPlusId_back_a pid) (hasTimesAnn_back_a tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p1. auto.

      assert (p2 := pb (hasPlusId_back_b pid) (hasTimesAnn_back_b tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p2, orb_true_r. auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity A * PlusAnnihilatorIsTimesIdentity B
      -> PlusAnnihilatorIsTimesIdentity prodBisemigroup.
   Proof. intros [pa pb] pid tann.
      assert (p1 := pa (hasPlusAnn_back_a pid) (hasTimesId_back_a tann)).
      assert (p2 := pb (hasPlusAnn_back_b pid) (hasTimesId_back_b tann)).
      simpl in *.
      destruct pid as [[ia ib] p]; simpl in *.
      destruct tann as [[ta tb] q]; simpl in *.
      dseq_u; simpl; toProp; tauto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp A + PlusAnnihilatorIsTimesIdentity_comp B
      -> PlusAnnihilatorIsTimesIdentity_comp prodBisemigroup.
   Proof. intros [pa | pb] pid tann.
      assert (p1 := pa (hasPlusAnn_back_a pid) (hasTimesId_back_a tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p1. auto.

      assert (p2 := pb (hasPlusAnn_back_b pid) (hasTimesId_back_b tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p2, orb_true_r. auto.
   Defined.

   (**************************************************************************)
   (*               A - Commutative & Idempotent properties                  *)
   (**************************************************************************)
   Lemma isCommutative_back_a : IsCommutative (plusSmg prodBisemigroup) -> IsCommutative (plusSmg A).
   Proof. intros comm a b; assert (p := comm (a, choose B) (b, choose B)); dseq_u; simpl in *; toProp; tauto. Defined.

   Lemma isCommutative_back_b : IsCommutative (plusSmg prodBisemigroup) -> IsCommutative (plusSmg B).
   Proof. intros comm a b; assert (p := comm (choose A, a) (choose A, b)); dseq_u; simpl in *; toProp; tauto. Defined.
   
   Lemma isIdempotent_back_a : IsIdempotent (plusSmg prodBisemigroup) -> IsIdempotent (plusSmg A).
   Proof. intros idem a; assert (p := idem (a, choose B)); dseq_u; simpl in *; toProp; tauto. Defined.

   Lemma isIdempotent_back_b : IsIdempotent (plusSmg prodBisemigroup) -> IsIdempotent (plusSmg B).
   Proof. intros idem a; assert (p := idem (choose A, a)); dseq_u; simpl in *; toProp; tauto. Defined.

   Ltac comm_idem_A comm idem :=
      assert (A_comm := (isCommutative_back_a comm));
      assert (A_idem := (isIdempotent_back_a idem));
      red in A_comm, A_idem; 
      simpl in A_comm, A_idem.

   Ltac comm_idem_B comm idem :=
      assert (B_comm := (isCommutative_back_b comm));
      assert (B_idem := (isIdempotent_back_b idem));
      red in B_comm, B_idem; 
      simpl in B_comm, B_idem.
   
   Ltac comm_idem_AB comm idem :=
      comm_idem_A comm idem;
      comm_idem_B comm idem.

   (*
   Inductive Cmp :=
      | eqv
      | ls
      | nn.
      
   Definition ceq (x y : Cmp) : bool :=
      match x, y with
         | eqv, eqv | ls, ls | nn, nn => true
         | _,_ => false
      end.

   Require Import Coq.Bool.Bool.
   
   Lemma test : forall (c1 c2 : Cmp),
      negb (ceq c1 ls) ||
      negb (ceq c2 ls) ||
      (ceq c2 nn && ceq c1 nn) ||
      (ceq c1 ls && (ceq c2 eqv || ceq c2 ls)) ||
      (ceq c2 ls && (ceq c1 eqv || ceq c1 ls)) = true.
   Proof. intros [] []; compute; trivial. Defined.
   *)
   
      
   Lemma isRightStrictStable_comp :
      IsRightStrictStable_comp A + IsRightStrictStable_comp B
      + RightDiscrete_comp A * IsRightCompEqCancel_comp B
      + RightDiscrete_comp B * IsRightCompEqCancel_comp A
      -> IsRightStrictStable_comp prodBisemigroup.
   Proof. intros [[[rssa|rssb]|[rda rcecb]]|[rdb rceca]] comm idem; comm_idem_AB comm idem.
      (* 1 *) destruct (rssa A_comm A_idem) as [x [y [z rss]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); 
      dseq_u; simpl; negb_p; toProp; do 2 rewrite B_idem; bool_p; tauto.
      (* 2 *) destruct (rssb B_comm B_idem) as [x [y [z rss]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); 
      dseq_u; simpl; negb_p; toProp; do 2 rewrite A_idem; bool_p; tauto.
      (* 3 *) destruct (rda A_comm A_idem) as [x1 [y1 [z1 rd]]].
      destruct (rcecb B_comm B_idem) as [x2 [y2 [z2 [p1 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2).
      simpl in *; negb_p; toProp;
      do 2 rewrite dseq_fold in rd;
      do 2 rewrite dseq_fold in p2;
      dseq_f; rewrite p1, (B_idem (y2 * z2)), (A_comm (y1 * z1) (x1 * z1)) in *;
      intuition.
      (* 4 *) destruct (rceca A_comm A_idem) as [x1 [y1 [z1 [p1 p2]]]];
      destruct (rdb B_comm B_idem) as [x2 [y2 [z2 rd]]];
      exists (x1, x2); exists (y1, y2); exists (z1, z2);
      simpl in *; negb_p; toProp;
      do 2 rewrite dseq_fold in rd;
      do 2 rewrite dseq_fold in p2;
      dseq_f; rewrite p1, (A_idem (y1 * z1)), (B_comm (y2 * z2) (x2 * z2)) in *;
      intuition.
   Defined.

   Lemma isRightStrictStable : 
      IsRightStrictStable A * IsRightStrictStable B 
      * (RightDiscrete A + IsRightCompEqCancel B)
      * (RightDiscrete B + IsRightCompEqCancel A)
      -> IsRightStrictStable prodBisemigroup.
   Proof. intros [[[rssa rssb] [rda | rcecb]] [rdb | rceca]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem;
      assert (rssa' := rssa A_comm A_idem x1 y1 z1);
      assert (rssb' := rssb B_comm B_idem x2 y2 z2);
      (assert (x1 <= y1 -> y1 <= x1 -> (x1 * z1 <= y1 * z1) /\ (y1 * z1 <= x1 * z1)) as w1;
         [clear - A_comm A_idem; intros p q; dseq_f; rewrite A_comm, p in q; rewrite q, A_idem; auto|]);
      (assert (x2 <= y2 -> y2 <= x2 -> (x2 * z2 <= y2 * z2) /\ (y2 * z2 <= x2 * z2)) as w2;
         [clear - B_comm B_idem; intros p q; dseq_f; rewrite B_comm, p in q; rewrite q, B_idem; auto|]).
      
      Ltac rss_cases x1 y1 z1 x2 y2 z2 :=
         simpl; toBool;
         destruct (x1 <= y1); destruct (y1 <= x1);
         destruct (x2 <= y2); destruct (y2 <= x2);
         destruct (x1 * z1 <= y1 * z1); destruct (y1 * z1 <= x1 * z1);
         destruct (x2 * z2 <= y2 * z2); destruct (y2 * z2 <= x2 * z2);
         simpl in *; auto; try discriminate.
     
      assert (rda' := rda A_comm A_idem x1 y1 z1);
      assert (rdb' := rdb B_comm B_idem x2 y2 z2);
      rss_cases x1 y1 z1 x2 y2 z2.
      
      assert (rda' := rda A_comm A_idem x1 y1 z1);
      assert (rda'' := rda A_comm A_idem y1 x1 z1);
      assert (rssa'' := rssa A_comm A_idem y1 x1 z1);
      destruct rssa' as [[rssa' p] | [rssa' _]]; try (toProp; tauto);
      destruct rssa'' as [[rssa'' p] | [rssa'' _]]; try (toProp; tauto);
      assert (x1 * z1 <= y1 * z1 -> y1 * z1 <= x1 * z1 -> x1 <=> y1);
         [ intros p q; apply (rceca A_comm A_idem x1 y1 z1); dseq_f; rewrite <- p, A_comm, q; auto |];
      rss_cases x1 y1 z1 x2 y2 z2.

      assert (rdb' := rdb B_comm B_idem x2 y2 z2);
      assert (rdb'' := rdb B_comm B_idem y2 x2 z2);
      assert (rssb'' := rssb B_comm B_idem y2 x2 z2);
      destruct rssb' as [[rssb' p] | [rssb' _]]; try (toProp; tauto);
      destruct rssb'' as [[rssb'' p] | [rssb'' _]]; try (toProp; tauto);
      assert (x2 * z2 <= y2 * z2 -> y2 * z2 <= x2 * z2 -> x2 <=> y2);
         [ intros p q; apply (rcecb B_comm B_idem x2 y2 z2); dseq_f; rewrite <- p, B_comm, q; auto |];
      rss_cases x1 y1 z1 x2 y2 z2.

      assert (x1 * z1 <= y1 * z1 -> y1 * z1 <= x1 * z1 -> x1 <=> y1);
         [ intros p q; apply (rceca A_comm A_idem x1 y1 z1); dseq_f; rewrite <- p, A_comm, q; auto |];
      assert (x2 * z2 <= y2 * z2 -> y2 * z2 <= x2 * z2 -> x2 <=> y2);
         [ intros p q; apply (rcecb B_comm B_idem x2 y2 z2); dseq_f; rewrite <- p, B_comm, q; auto |];
      assert (rssa'' := rssa A_comm A_idem y1 x1 z1);
      assert (rssb'' := rssb B_comm B_idem y2 x2 z2);
      rss_cases x1 y1 z1 x2 y2 z2.
   Defined.
        
      
   Lemma isLeftStrictStable_comp :
      IsLeftStrictStable_comp A
      + IsLeftStrictStable_comp B
      + (LeftDiscrete_comp A * IsLeftCompEqCancel_comp B)
      + (LeftDiscrete_comp B * IsLeftCompEqCancel_comp A)
      -> IsLeftStrictStable_comp prodBisemigroup.
   Proof. intros [[[rssa|rssb]|[rda rcecb]]|[rdb rceca]] comm idem; comm_idem_AB comm idem.
      (* 1 *) destruct (rssa A_comm A_idem) as [x [y [z rss]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); 
      dseq_u; simpl; negb_p; toProp; do 2 rewrite B_idem; bool_p; tauto.
      (* 2 *) destruct (rssb B_comm B_idem) as [x [y [z rss]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); 
      dseq_u; simpl; negb_p; toProp; do 2 rewrite A_idem; bool_p; tauto.
      (* 3 *) destruct (rda A_comm A_idem) as [x1 [y1 [z1 rd]]].
      destruct (rcecb B_comm B_idem) as [x2 [y2 [z2 [p1 p2]]]].
      exists (x1, x2); exists (y1, y2); exists (z1, z2).
      simpl in *; negb_p; toProp;
      do 2 rewrite dseq_fold in rd;
      do 2 rewrite dseq_fold in p2;
      dseq_f; rewrite p1, (B_idem (z2 * y2)), (A_comm (z1 * y1) (z1 * x1)) in *;
      intuition.
      (* 4 *) destruct (rceca A_comm A_idem) as [x1 [y1 [z1 [p1 p2]]]];
      destruct (rdb B_comm B_idem) as [x2 [y2 [z2 rd]]];
      exists (x1, x2); exists (y1, y2); exists (z1, z2);
      simpl in *; negb_p; toProp;
      do 2 rewrite dseq_fold in rd;
      do 2 rewrite dseq_fold in p2;
      dseq_f; rewrite p1, (A_idem (z1 * y1)), (B_comm (z2 * y2) (z2 * x2)) in *;
      intuition.
   Defined.

   Lemma isLeftStrictStable : 
      IsLeftStrictStable A 
      * IsLeftStrictStable B 
      * (LeftDiscrete A + IsLeftCompEqCancel B)
      * (LeftDiscrete B + IsLeftCompEqCancel A)
      -> IsLeftStrictStable prodBisemigroup.
   Proof. intros [[[rssa rssb] [rda | rcecb]] [rdb | rceca]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem;
      assert (rssa' := rssa A_comm A_idem x1 y1 z1);
      assert (rssb' := rssb B_comm B_idem x2 y2 z2);
      (assert (x1 <= y1 -> y1 <= x1 -> (z1 * x1 <= z1 * y1) /\ (z1 * y1 <= z1 * x1)) as w1;
         [clear - A_comm A_idem; intros p q; dseq_f; rewrite A_comm, p in q; rewrite q, A_idem; auto|]);
      (assert (x2 <= y2 -> y2 <= x2 -> (z2 * x2 <= z2 * y2) /\ (z2 * y2 <= z2 * x2)) as w2;
         [clear - B_comm B_idem; intros p q; dseq_f; rewrite B_comm, p in q; rewrite q, B_idem; auto|]).
      
      Ltac lss_cases x1 y1 z1 x2 y2 z2 :=
         simpl; toBool;
         destruct (x1 <= y1); destruct (y1 <= x1);
         destruct (x2 <= y2); destruct (y2 <= x2);
         destruct (z1 * x1 <= z1 * y1); destruct (z1 * y1 <= z1 * x1);
         destruct (z2 * x2 <= z2 * y2); destruct (z2 * y2 <= z2 * x2);
         simpl in *; auto; try discriminate.
     
      assert (rda' := rda A_comm A_idem x1 y1 z1);
      assert (rdb' := rdb B_comm B_idem x2 y2 z2);
      lss_cases x1 y1 z1 x2 y2 z2.
      
      assert (rda' := rda A_comm A_idem x1 y1 z1);
      assert (rda'' := rda A_comm A_idem y1 x1 z1);
      assert (rssa'' := rssa A_comm A_idem y1 x1 z1);
      destruct rssa' as [[rssa' p] | [rssa' _]]; try (toProp; tauto);
      destruct rssa'' as [[rssa'' p] | [rssa'' _]]; try (toProp; tauto);
      assert (z1 * x1 <= z1 * y1 -> z1 * y1 <= z1 * x1 -> x1 <=> y1);
         [ intros p q; apply (rceca A_comm A_idem x1 y1 z1); dseq_f; rewrite <- p, A_comm, q; auto |];
      lss_cases x1 y1 z1 x2 y2 z2.

      assert (rdb' := rdb B_comm B_idem x2 y2 z2);
      assert (rdb'' := rdb B_comm B_idem y2 x2 z2);
      assert (rssb'' := rssb B_comm B_idem y2 x2 z2);
      destruct rssb' as [[rssb' p] | [rssb' _]]; try (toProp; tauto);
      destruct rssb'' as [[rssb'' p] | [rssb'' _]]; try (toProp; tauto);
      assert (z2 * x2 <= z2 * y2 -> z2 * y2 <= z2 * x2 -> x2 <=> y2);
         [ intros p q; apply (rcecb B_comm B_idem x2 y2 z2); dseq_f; rewrite <- p, B_comm, q; auto |];
      lss_cases x1 y1 z1 x2 y2 z2.

      assert (z1 * x1 <= z1 * y1 -> z1 * y1 <= z1 * x1 -> x1 <=> y1);
         [ intros p q; apply (rceca A_comm A_idem x1 y1 z1); dseq_f; rewrite <- p, A_comm, q; auto |];
      assert (z2 * x2 <= z2 * y2 -> z2 * y2 <= z2 * x2 -> x2 <=> y2);
         [ intros p q; apply (rcecb B_comm B_idem x2 y2 z2); dseq_f; rewrite <- p, B_comm, q; auto |];
      assert (rssa'' := rssa A_comm A_idem y1 x1 z1);
      assert (rssb'' := rssb B_comm B_idem y2 x2 z2);
      lss_cases x1 y1 z1 x2 y2 z2.
   Defined.

   (* move to Bisemigroup properties !!! *)
   Lemma leftDiscreteComparable : forall (BS : Bisemigroup), 
       IsCommutative (plusSmg BS) -> 
       IsIdempotent (plusSmg BS) ->
       LeftDiscrete BS -> LeftComparable BS -> forall x y z : BS, z * x == z * y.
   Proof. intros BS comm idem ld lc x y z.
      assert (ld' := ld comm idem x y z); 
      assert (ld'' := ld comm idem y x z); 
      assert (lc' := lc comm idem x y z).
      assert (z * x <= z * y) as p; [negb_p; toProp; tauto|].
      assert (z * y <= z * x) as q; [negb_p; toProp; tauto|].
      clear - p q comm idem. dseq_f.
      assert (h := comm (z * y) (z * x)); simpl in h;
      rewrite h, p in q; auto.
   Defined.

   (* move to Bisemigroup properties !!! *)
   Lemma rightDiscreteComparable : forall (BS : Bisemigroup), 
       IsCommutative (plusSmg BS) -> 
       IsIdempotent (plusSmg BS) ->
       RightDiscrete BS -> RightComparable BS -> forall x y z : BS, x * z == y * z.
   Proof. intros BS comm idem ld lc x y z.
      assert (ld' := ld comm idem x y z); 
      assert (ld'' := ld comm idem y x z); 
      assert (lc' := lc comm idem x y z).
      assert (x * z <= y * z) as p; [negb_p; toProp; tauto|].
      assert (y * z <= x * z) as q; [negb_p; toProp; tauto|].
      clear - p q comm idem. dseq_f.
      assert (h := comm (y * z) (x * z)); simpl in h;
      rewrite h, p in q; auto.
   Defined.

   Lemma leftDiscrete_comp : 
         LeftDiscrete_comp A + LeftDiscrete_comp B
      -> LeftDiscrete_comp prodBisemigroup.
   Proof. intros [lda | ldb] comm idem; comm_idem_AB comm idem.
      destruct (lda A_comm A_idem) as [x [y [z p]]];
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl in *;
      negb_p; toProp; rewrite B_idem; bool_p; tauto.
      destruct (ldb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl in *;
      negb_p; toProp; rewrite A_idem; bool_p; tauto.
   Defined.

   Lemma leftDiscrete : LeftDiscrete A * LeftDiscrete B -> LeftDiscrete prodBisemigroup.
   Proof. intros [lda ldb] comm idem [x1 x2] [y1 y2] [z1 z2]; comm_idem_AB comm idem;
      assert (ld1 := lda A_comm A_idem x1 y1 z1);
      assert (ld2 := ldb B_comm B_idem x2 y2 z2);
      simpl in *; negb_p; toProp; tauto.
   Defined.

   Lemma rightDiscrete_comp : 
         RightDiscrete_comp A + RightDiscrete_comp B
      -> RightDiscrete_comp prodBisemigroup.
   Proof. intros [lda | ldb] comm idem; comm_idem_AB comm idem.
      destruct (lda A_comm A_idem) as [x [y [z p]]];
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl in *;
      negb_p; toProp; rewrite B_idem; bool_p; tauto.
      destruct (ldb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl in *;
      negb_p; toProp; rewrite A_idem; bool_p; tauto.
   Defined.

   Lemma rightDiscrete : RightDiscrete A * RightDiscrete B -> RightDiscrete prodBisemigroup.
   Proof. intros [lda ldb] comm idem [x1 x2] [y1 y2] [z1 z2]; comm_idem_AB comm idem;
      assert (ld1 := lda A_comm A_idem x1 y1 z1);
      assert (ld2 := ldb B_comm B_idem x2 y2 z2);
      simpl in *; negb_p; toProp; tauto.
   Defined.
   
   Lemma leftComparable :
      LeftComparable A * LeftComparable B * (LeftDiscrete A + LeftDiscrete B)
      -> LeftComparable prodBisemigroup.
   Proof. intros [[lca lcb] [lda | ldb]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem.
      assert (p := leftDiscreteComparable _ A_comm A_idem lda lca x1 y1 z1);
      assert (q := lcb B_comm B_idem x2 y2 z2);
      simpl; toProp; dseq_f; rewrite p, A_idem; intuition.
      assert (p := leftDiscreteComparable _ B_comm B_idem ldb lcb x2 y2 z2);
      assert (q := lca A_comm A_idem x1 y1 z1);
      simpl; toProp; dseq_f; rewrite p, B_idem; intuition.
   Defined.

   Lemma leftComparable_comp : 
      LeftComparable_comp A + LeftComparable_comp B + (LeftDiscrete_comp A * LeftDiscrete_comp B)
      -> LeftComparable_comp prodBisemigroup.
   Proof. intros [[lca | lcb] | [lda ldb]] comm idem; comm_idem_AB comm idem.
      (* 1 *) destruct (lca A_comm A_idem) as [x [y [z p]]];
      exists (x, choose B); exists (y, choose B); exists (z, choose B).
      simpl in *; negb_p; toProp; tauto.
      (* 2 *) destruct (lcb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A, z);
      simpl in *; negb_p; toProp; tauto.
      (* 3 *) destruct (lda A_comm A_idem) as [x1 [y1 [z1 p]]];
      destruct (ldb B_comm B_idem) as [x2 [y2 [z2 p2]]];
      exists (y1, x2); exists (x1, y2); exists (z1, z2);
      simpl in *; negb_p; toProp; tauto.
   Defined.

   Lemma rightComparable :
      RightComparable A * RightComparable B * (RightDiscrete A + RightDiscrete B)
      -> RightComparable prodBisemigroup.
   Proof. intros [[lca lcb] [lda | ldb]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem.
      assert (p := rightDiscreteComparable _ A_comm A_idem lda lca x1 y1 z1);
      assert (q := lcb B_comm B_idem x2 y2 z2);
      simpl; toProp; dseq_f; rewrite p, A_idem; intuition.
      assert (p := rightDiscreteComparable _ B_comm B_idem ldb lcb x2 y2 z2);
      assert (q := lca A_comm A_idem x1 y1 z1);
      simpl; toProp; dseq_f; rewrite p, B_idem; intuition.
   Defined.

   Lemma rightComparable_comp : 
      RightComparable_comp A + RightComparable_comp B + (RightDiscrete_comp A * RightDiscrete_comp B)
      -> RightComparable_comp prodBisemigroup.
   Proof. intros [[lca | lcb] | [lda ldb]] comm idem; comm_idem_AB comm idem.
      (* 1 *) destruct (lca A_comm A_idem) as [x [y [z p]]];
      exists (x, choose B); exists (y, choose B); exists (z, choose B).
      simpl in *; negb_p; toProp; tauto.
      (* 2 *) destruct (lcb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A, z);
      simpl in *; negb_p; toProp; tauto.
      (* 3 *) destruct (lda A_comm A_idem) as [x1 [y1 [z1 p]]];
      destruct (ldb B_comm B_idem) as [x2 [y2 [z2 p2]]];
      exists (y1, x2); exists (x1, y2); exists (z1, z2);
      simpl in *; negb_p; toProp; tauto.
   Defined.

   Lemma isRightCompEqCancel :
         IsRightCompEqCancel A 
         * IsRightCompEqCancel B 
         * (RightCancelative (timesSmg A) + RightCancelative (timesSmg B))
      -> IsRightCompEqCancel prodBisemigroup.
   Proof. intros [[lceca lcecb] [lca | lcb]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem;
      unfold dseq; simpl; toProp; intros [h1 h2].

      assert (q := lca x1 y1 z1 h1); simpl in q; dseq_f; rewrite q, A_idem;
      assert (p := lcecb B_comm B_idem x2 y2 z2 h2); toProp; intuition.

      assert (q := lcb x2 y2 z2 h2); simpl in q; dseq_f; rewrite q, B_idem;
      assert (p := lceca A_comm A_idem x1 y1 z1 h1); toProp; intuition.
   Defined.

   Lemma isRightCompEqCancel_comp :
      IsRightCompEqCancel_comp A 
      + IsRightCompEqCancel_comp B 
      + RightCancelative_comp (timesSmg A) * RightCancelative_comp (timesSmg B)
      -> IsRightCompEqCancel_comp prodBisemigroup.
   Proof. intros [[lceca | lcecb] | [[a1 [b1 [c1 lca]]] [a2 [b2 [c2 lcb]]]]] comm idem;
      comm_idem_AB comm idem.
      (* 1 *) destruct (lceca A_comm A_idem) as [x1 [y1 [z1 [p p1]]]];
      exists (x1, choose B); exists (y1, choose B); exists (z1, choose B);
      dseq_u; simpl in *; negb_p; toProp; dseq_f; intuition.
      (* 2 *) destruct (lcecb B_comm B_idem) as [x2 [y2 [z2 [p' p1']]]];
      exists (choose A, x2); exists (choose A, y2); exists (choose A, z2);
      dseq_u; simpl in *; negb_p; toProp; dseq_f; intuition.
      (* 3 *) simpl in lca, lcb; destruct lca; destruct lcb.
      copy_destruct (a1 <= b1) as ab1;
      copy_destruct (a2 <= b2) as ab2; dseq_f.
      exists (a1, b2); exists (b1, a2); exists (c1, c2);
      unfold dseq; simpl; negb_p; toProp; dseq_f; intuition;
      [ apply or_intror; intros h; elim H2; dseq_f; rewrite B_comm, ab2 in h; auto
      | apply or_introl; intros h; elim H0; dseq_f; rewrite A_comm, ab1 in h; auto].
      exists (a1, a2); exists (b1, b2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition;
      apply or_introl; intros h; elim H0; dseq_f; rewrite A_comm, ab1 in h; auto.
      exists (a1, a2); exists (b1, b2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition;
      apply or_intror; intros h; elim H2; dseq_f; rewrite B_comm, ab2 in h; auto.
      exists (a1, b2); exists (b1, a2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition.
   Defined.

   Lemma isLeftCompEqCancel :
         IsLeftCompEqCancel A 
         * IsLeftCompEqCancel B 
         * (LeftCancelative (timesSmg A) + LeftCancelative (timesSmg B))
      -> IsLeftCompEqCancel prodBisemigroup.
   Proof. intros [[lceca lcecb] [lca | lcb]] comm idem [x1 x2] [y1 y2] [z1 z2];
      comm_idem_AB comm idem;
      unfold dseq; simpl; toProp; intros [h1 h2].

      assert (q := lca x1 y1 z1 h1); simpl in q; dseq_f; rewrite q, A_idem;
      assert (p := lcecb B_comm B_idem x2 y2 z2 h2); toProp; intuition.

      assert (q := lcb x2 y2 z2 h2); simpl in q; dseq_f; rewrite q, B_idem;
      assert (p := lceca A_comm A_idem x1 y1 z1 h1); toProp; intuition.
   Defined.

   Lemma isLeftCompEqCancel_comp :
      IsLeftCompEqCancel_comp A 
      + IsLeftCompEqCancel_comp B 
      + LeftCancelative_comp (timesSmg A) * LeftCancelative_comp (timesSmg B)
      -> IsLeftCompEqCancel_comp prodBisemigroup.
   Proof. intros [[lceca | lcecb] | [[a1 [b1 [c1 lca]]] [a2 [b2 [c2 lcb]]]]] comm idem;
      comm_idem_AB comm idem.
      (* 1 *) destruct (lceca A_comm A_idem) as [x1 [y1 [z1 [p p1]]]];
      exists (x1, choose B); exists (y1, choose B); exists (z1, choose B);
      dseq_u; simpl in *; negb_p; toProp; dseq_f; intuition.
      (* 2 *) destruct (lcecb B_comm B_idem) as [x2 [y2 [z2 [p' p1']]]];
      exists (choose A, x2); exists (choose A, y2); exists (choose A, z2);
      dseq_u; simpl in *; negb_p; toProp; dseq_f; intuition.
      (* 3 *) simpl in lca, lcb; destruct lca; destruct lcb.
      copy_destruct (a1 <= b1) as ab1;
      copy_destruct (a2 <= b2) as ab2; dseq_f.
      exists (a1, b2); exists (b1, a2); exists (c1, c2);
      unfold dseq; simpl; negb_p; toProp; dseq_f; intuition;
      [ apply or_intror; intros h; elim H2; dseq_f; rewrite B_comm, ab2 in h; auto
      | apply or_introl; intros h; elim H0; dseq_f; rewrite A_comm, ab1 in h; auto].
      exists (a1, a2); exists (b1, b2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition;
      apply or_introl; intros h; elim H0; dseq_f; rewrite A_comm, ab1 in h; auto.
      exists (a1, a2); exists (b1, b2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition;
      apply or_intror; intros h; elim H2; dseq_f; rewrite B_comm, ab2 in h; auto.
      exists (a1, b2); exists (b1, a2); exists (c1, c2);
      unfold dseq; simpl; negb_p; bool_p; toProp; dseq_f; intuition.
   Defined.
   
(*
   Lemma isLeftCompCancel_comp :
           (IsSelective_comp (plusSmg A) * LeftComparable_comp B)
         + (IsSelective_comp (plusSmg B) * LeftComparable_comp A)
         + (IsSingleton_comp (plusSmg A) * IsSingleton_comp (plusSmg B))
         -> IsLeftCompCancel_comp prodBisemigroup.
   Proof. 
      assert (forall a b c d e f g h, ((a || b) && (c || d)) && ((e || f) && (g || h)) =
         a && c && e && g ||
         a && c && e && h ||
         a && c && f && g ||
         a && c && f && h ||
         a && d && e && g ||
         a && d && e && h ||
         a && d && f && g ||
         a && d && f && h ||
         b && c && e && g ||
         b && c && e && h ||
         b && c && f && g ||
         b && c && f && h ||
         b && d && e && g ||
         b && d && e && h ||
         b && d && f && g ||
         b && d && f && h
      ) as dnf; [intros [|][|][|][|][|][|][|][|]; auto |].
      
      intros [
                  [ [[x1 [y1 sa]] lcb]
                  | [[x2 [y2 sa]] lcb]
                 ]| [sga sgb]
                 ] comm idem;
      comm_idem_AB comm idem.

      destruct (lcb B_comm B_idem) as [x2 [y2 [z2 lb]]].
      exists (x1, x2); exists (y1, y2); exists (x1, z2); simpl. negb_p.
      simpl in *. toProp.
      destruct sa as [p1 p2].
      rewrite (A_comm x1 y1) in p2. tauto.

      destruct (lcb A_comm A_idem) as [x1 [y1 [z1 lb]]].
      exists (x1, x2); exists (y1, y2); exists (z1, x2); simpl. negb_p.
      simpl in *. toProp.
      destruct sa as [p1 p2].
      rewrite (B_comm x2 y2) in p2. tauto.
      
   Defined.
*)

(*
   Lemma isLeftCompCancel : IsLeftCompCancel prodBisemigroup.
   Proof. intros comm idem [x1 x2] [y1 y2] [z1 z2]. simpl.
      negb_p.
      assert (forall (a b : bool), (a -> b) <-> negb a || b).
         intros [|][|]; intuition.
      rewrite H; clear H.
      negb_p.
      assert (forall a b c d e f g h, ((a && b) || (c && d)) || ((e && f) || (g && h)) =
         (a || c || e || g) &&
         (a || c || e || h) &&
         (a || c || f || g) &&
         (a || c || f || h) &&
         (a || d || e || g) &&
         (a || d || e || h) &&
         (a || d || f || g) &&
         (a || d || f || h) &&
         (b || c || e || g) &&
         (b || c || e || h) &&
         (b || c || f || g) &&
         (b || c || f || h) &&
         (b || d || e || g) &&
         (b || d || e || h) &&
         (b || d || f || g) &&
         (b || d || f || h)
      ) as cnf; [intros [|][|][|][|][|][|][|][|]; auto |].
      rewrite cnf; clear cnf.

      toProp.
      intros h.
      toBool.
      assert (forall a b c d, (a && b || c && d) = (a || c) && (a || d) && (b || c) && (b || d)).
         intros [|] [|] [|] [|]; auto.
      rewrite H; clear H.
      toProp. split. split. split.
      Focus 2.
      destruct h as [[p1 | p1] [p2 | p2]].
      Focus 4.
   Defined.
*)

      (*
      1. IsLeftCompCancel A
      2. LeftComparable A + Singleton B
      3. LeftComparable A + Singleton B
      ---- 4. LeftComparable A + IsSelective (plusSmg B)

      5. (x # y -> zx == zy) A + LeftCondensed B
      6. (zx <= zy \/ x <= y) A + (zx <= zy \/ x <= y) B
      7. (zx <= zy \/ y <= x) A + (zx <= zy \/ y <= x) B
      8. LeftCondensed A + (x # y -> zx == zy) B

      9. (x # y -> zx == zy) A + LeftCondensed B
      10. (zx <= zy \/ x <= y) A + (zx <= zy \/ x <= y) B
      11. (zx <= zy \/ y <= x) A + (zx <= zy \/ y <= x) B
      12. LeftCondensed A + (x # y -> zx == zy) B
      
      ---- 13. IsSelective (plusSmg A) + LeftComparable B
      14. Singleton A + LeftComparable B
      15. Singleton A + LeftComparable B
      16. IsLeftCompCancel B
      *)

   Lemma leftIncreasing : LeftIncreasing A * LeftIncreasing B -> LeftIncreasing prodBisemigroup.
   Proof. intros [la lb] comm idem [x1 x2] [y1 y2]; comm_idem_AB comm idem.
      dseq_u; simpl. toProp; split.
      apply (la A_comm A_idem).
      apply (lb B_comm B_idem).
   Defined.
   
   Lemma leftIncreasing_comp : LeftIncreasing_comp A + LeftIncreasing_comp B -> LeftIncreasing_comp prodBisemigroup.
   Proof. intros [la | lb] comm idem; comm_idem_AB comm idem.
      destruct (la A_comm A_idem) as [x [y p]];
      exists (x, choose B); exists (y, choose B); dseq_u; simpl; toProp; tauto.
      destruct (lb B_comm B_idem) as [x [y p]];
      exists (choose A, x); exists (choose A, y); dseq_u; simpl; toProp; tauto.
   Defined.

   Lemma rightIncreasing : RightIncreasing A * RightIncreasing B -> RightIncreasing prodBisemigroup.
   Proof. intros [la lb] comm idem [x1 x2] [y1 y2]; comm_idem_AB comm idem.
      dseq_u; simpl. toProp; split.
      apply (la A_comm A_idem).
      apply (lb B_comm B_idem).
   Defined.
   
   Lemma rightIncreasing_comp : RightIncreasing_comp A + RightIncreasing_comp B -> RightIncreasing_comp prodBisemigroup.
   Proof. intros [la | lb] comm idem; comm_idem_AB comm idem.
      destruct (la A_comm A_idem) as [x [y p]];
      exists (x, choose B); exists (y, choose B); dseq_u; simpl; toProp; tauto.
      destruct (lb B_comm B_idem) as [x [y p]];
      exists (choose A, x); exists (choose A, y); dseq_u; simpl; toProp; tauto.
   Defined.
   
   Lemma leftStrictIncreasing : LeftIncreasing A * LeftStrictIncreasing B
      + LeftStrictIncreasing A * LeftIncreasing B -> LeftStrictIncreasing prodBisemigroup.
   Proof. intros [[la lb] | [la lb]] comm idem [x1 x2] [y1 y2]; comm_idem_AB comm idem;
      assert (p := la A_comm A_idem x1 y1);
      assert (q := lb B_comm B_idem x2 y2);
      simpl; negb_p; toProp; intuition.
   Defined.

   Lemma leftStrictIncreasing_comp : (LeftIncreasing_comp A + LeftStrictIncreasing_comp B)
      * (LeftStrictIncreasing_comp A + LeftIncreasing_comp B) -> LeftStrictIncreasing_comp prodBisemigroup.
   Proof. intros [[la | lsb] [lsa | lb]] comm idem; comm_idem_AB comm idem.
      destruct (la A_comm A_idem) as [x1 [y1 p]];
      exists (x1, choose B); exists (y1, choose B); negb_p; simpl; negb_p; toProp; intuition.
      destruct (la A_comm A_idem) as [x1 [y1 p]];
      exists (x1, choose B); exists (y1, choose B); negb_p; simpl; negb_p; toProp; intuition.
      destruct (lsa A_comm A_idem) as [x1 [y1 p]];
      destruct (lsb B_comm B_idem) as [x2 [y2 q]];
      exists (x1, x2); exists (y1, y2); negb_p; simpl; negb_p; toProp; intuition.
      destruct (lb B_comm B_idem) as [x2 [y2 p]];
      exists (choose A, x2); exists (choose A, y2); negb_p; simpl; negb_p; toProp; intuition.
   Defined.

   Lemma rightStrictIncreasing : RightIncreasing A * RightStrictIncreasing B
      + RightStrictIncreasing A * RightIncreasing B -> RightStrictIncreasing prodBisemigroup.
   Proof. intros [[la lb] | [la lb]] comm idem [x1 x2] [y1 y2]; comm_idem_AB comm idem;
      assert (p := la A_comm A_idem x1 y1);
      assert (q := lb B_comm B_idem x2 y2);
      simpl; negb_p; toProp; intuition.
   Defined.

   Lemma rightStrictIncreasing_comp : (RightIncreasing_comp A + RightStrictIncreasing_comp B)
      * (RightStrictIncreasing_comp A + RightIncreasing_comp B) -> RightStrictIncreasing_comp prodBisemigroup.
   Proof. intros [[la | lsb] [lsa | lb]] comm idem; comm_idem_AB comm idem.
      destruct (la A_comm A_idem) as [x1 [y1 p]];
      exists (x1, choose B); exists (y1, choose B); negb_p; simpl; negb_p; toProp; intuition.
      destruct (la A_comm A_idem) as [x1 [y1 p]];
      exists (x1, choose B); exists (y1, choose B); negb_p; simpl; negb_p; toProp; intuition.
      destruct (lsa A_comm A_idem) as [x1 [y1 p]];
      destruct (lsb B_comm B_idem) as [x2 [y2 q]];
      exists (x1, x2); exists (y1, y2); negb_p; simpl; negb_p; toProp; intuition.
      destruct (lb B_comm B_idem) as [x2 [y2 p]];
      exists (choose A, x2); exists (choose A, y2); negb_p; simpl; negb_p; toProp; intuition.
   Defined.
   
(*
   Lemma leftWStrictIncreasing : LeftIncreasing A * LeftStrictIncreasing B
      + LeftStrictIncreasing A * LeftIncreasing B + IsSingleton A * IsSingleton B -> LeftWStrictIncreasing prodBisemigroup.
   Proof. intros [[[ia sib]|[sia ib]]|[[a sga] [b sgb]]] comm idem hid [x1 x2] [y1 y2]; comm_idem_AB comm idem.
      toBool. simpl; negb_p; toProp.
      apply or_intror; split. split. apply ia; auto.
      assert (p := sib B_comm B_idem x2 y2). toProp; tauto.
      apply or_intror.
      assert (p := sib B_comm B_idem x2 y2). toProp; tauto.

      toBool; simpl; negb_p; toProp.
      apply or_intror; split. split.
      assert (p := sia A_comm A_idem x1 y1). toProp; tauto.
      apply ib; auto.
      apply or_introl.
      assert (p := sia A_comm A_idem x1 y1). toProp; tauto.
      
      toBool; simpl; negb_p; toProp.
      apply or_introl. destruct hid as [[id1 id2] hid]; simpl.
      toProp; dseq_f.
      rewrite (sga x1), (sga id1), (sgb x2), (sgb id2); auto.
   Qed.
   
   Lemma leftWStrictIncreasing_comp : (LeftIncreasing_comp A + LeftStrictIncreasing_comp B)
      * (LeftStrictIncreasing_comp A + LeftIncreasing_comp B)
      * (IsSingleton_comp A + IsSingleton_comp B) -> LeftWStrictIncreasing_comp prodBisemigroup.
   Proof. intros [[[ia | sib] [sia | ib]] [sga | sgb]] comm idem hid; comm_idem_AB comm idem.
      destruct (sia A_comm A_idem)  as [x [y sia']].
      negb_p. toProp; dseq_f.
*)

      
   (**************************************************************************)
   (*                         Identity properties                            *)
   (**************************************************************************)

   Lemma isLeftTimesMapToIdConstantPlus : 
      IsLeftTimesMapToIdConstantPlus A * IsLeftTimesMapToIdConstantPlus B
      -> IsLeftTimesMapToIdConstantPlus prodBisemigroup.
   Proof. intros [tica ticb] hasId [x1 x2] [y1 y2] [z1 z2].
      assert (t1 := tica (hasPlusId_back_a hasId) x1 y1 z1);
      assert (t2 := ticb (hasPlusId_back_b hasId) x2 y2 z2);
      destruct hasId as [[ida idb] p]; dseq_u; simpl in *; toProp; dseq_f; tauto.
   Defined.
   
   Lemma isLeftTimesMapToIdConstantPlus_comp : 
      IsLeftTimesMapToIdConstantPlus_comp A + IsLeftTimesMapToIdConstantPlus_comp B
      -> IsLeftTimesMapToIdConstantPlus_comp prodBisemigroup.
   Proof. intros [tica | ticb] hasId.
      (* 1 *) destruct (tica (hasPlusId_back_a hasId)) as [x1 [y1 [z1 p1]]];
      destruct hasId as [[ida idb] q]; 
      exists (x1, idb); exists (y1, idb); exists (z1, idb);
      dseq_u; simpl in *; negb_p; toProp; auto.
      (* 2 *)destruct (ticb (hasPlusId_back_b hasId)) as [x2 [y2 [z2 p2]]];
      destruct hasId as [[ida idb] q];
      exists (ida, x2); exists (ida, y2); exists (ida, z2);
      dseq_u; simpl in *; negb_p; toProp; auto.
   Defined.

   Lemma isRightTimesMapToIdConstantPlus : 
      IsRightTimesMapToIdConstantPlus A * IsRightTimesMapToIdConstantPlus B
      -> IsRightTimesMapToIdConstantPlus prodBisemigroup.
   Proof. intros [tica ticb] hasId [x1 x2] [y1 y2] [z1 z2].
      assert (t1 := tica (hasPlusId_back_a hasId) x1 y1 z1);
      assert (t2 := ticb (hasPlusId_back_b hasId) x2 y2 z2);
      destruct hasId as [[ida idb] p]; dseq_u; simpl in *; toProp; dseq_f; tauto.
   Defined.
   
   Lemma isRightTimesMapToIdConstantPlus_comp : 
      IsRightTimesMapToIdConstantPlus_comp A +
      IsRightTimesMapToIdConstantPlus_comp B
      -> IsRightTimesMapToIdConstantPlus_comp prodBisemigroup.
   Proof. intros [tica | ticb] hasId.
      (* 1 *) destruct (tica (hasPlusId_back_a hasId)) as [x1 [y1 [z1 p1]]];
      destruct hasId as [[ida idb] q]; 
      exists (x1, idb); exists (y1, idb); exists (z1, idb);
      dseq_u; simpl in *; negb_p; toProp; auto.
      (* 2 *)destruct (ticb (hasPlusId_back_b hasId)) as [x2 [y2 [z2 p2]]];
      destruct hasId as [[ida idb] q];
      exists (ida, x2); exists (ida, y2); exists (ida, z2);
      dseq_u; simpl in *; negb_p; toProp; auto.
   Defined.
   
   Lemma plusIdentityIsTimesLeftAnnihilator :
      PlusIdentityIsTimesLeftAnnihilator A * PlusIdentityIsTimesLeftAnnihilator B
      -> PlusIdentityIsTimesLeftAnnihilator prodBisemigroup.
   Proof. intros [tica ticb] hasId [x1 x2].
      assert (t1 := tica (hasPlusId_back_a hasId) x1);
      assert (t2 := ticb (hasPlusId_back_b hasId) x2);
      destruct hasId as [[ida idb] p]; dseq_u; simpl in *; toProp; dseq_f; tauto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp :
      PlusIdentityIsTimesLeftAnnihilator_comp A + PlusIdentityIsTimesLeftAnnihilator_comp B
      -> PlusIdentityIsTimesLeftAnnihilator_comp prodBisemigroup.
   Proof. intros [tica | ticb] hasId.
      (* 1 *) destruct (tica (hasPlusId_back_a hasId)) as [x1 p1];
      destruct hasId as [[ida idb] q]; 
      exists (x1, idb); dseq_u; simpl in *; negb_p; toProp; auto.
      (* 2 *)destruct (ticb (hasPlusId_back_b hasId)) as [x2 p2];
      destruct hasId as [[ida idb] q];
      exists (ida, x2); dseq_u; simpl in *; negb_p; toProp; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator :
      PlusIdentityIsTimesRightAnnihilator A * PlusIdentityIsTimesRightAnnihilator B
      -> PlusIdentityIsTimesRightAnnihilator prodBisemigroup.
   Proof. intros [tica ticb] hasId [x1 x2].
      assert (t1 := tica (hasPlusId_back_a hasId) x1);
      assert (t2 := ticb (hasPlusId_back_b hasId) x2);
      destruct hasId as [[ida idb] p]; dseq_u; simpl in *; toProp; dseq_f; tauto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator_comp :
      PlusIdentityIsTimesRightAnnihilator_comp A + PlusIdentityIsTimesRightAnnihilator_comp B
      -> PlusIdentityIsTimesRightAnnihilator_comp prodBisemigroup.
   Proof. intros [tica | ticb] hasId.
      (* 1 *) destruct (tica (hasPlusId_back_a hasId)) as [x1 p1];
      destruct hasId as [[ida idb] q]; 
      exists (x1, idb); dseq_u; simpl in *; negb_p; toProp; auto.
      (* 2 *)destruct (ticb (hasPlusId_back_b hasId)) as [x2 p2];
      destruct hasId as [[ida idb] q];
      exists (ida, x2); dseq_u; simpl in *; negb_p; toProp; auto.
   Defined.

   Close Scope Bisemigroup_scope.

End DiretcProduct.
