Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.Postfix.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.Constructions.Semigroups.Seq.
Require Import Metarouting.Constructions.Bisemigroups.NatMinPlus.
Require Import Metarouting.Constructions.Bisemigroups.PrefixSeq.
Require Import Metarouting.Constructions.Bisemigroups.RevTimes.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.
Require Import Coq.Arith.Min.

Section PostfixSeq.

   Variable A : DecSetoid.
   
   Definition postfixSeqBisemigroup : Bisemigroup :=
      glueBSmg (postfixSemigroup A) (seqSemigroup A) (dsEq_refl _).

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Definition isoPostfixPrefixSeqBisemigroup_dsIso : DsIso postfixSeqBisemigroup (revTimesBisemigroup (prefixSeqBisemigroup A)).
      split with (@rev A) (@rev A).
      split.
      
      intros x y. apply (rev_pres_eq A).
      
      intros x y. apply (rev_pres_eq A).
      
      intros x; rewrite rev_involutive; auto.
      
      intros x; rewrite rev_involutive; auto.
   Defined.
   
   Definition isoPostfixPrefixSeqBisemigroup : BSmgIso postfixSeqBisemigroup (revTimesBisemigroup (prefixSeqBisemigroup A)).
      split with (isoPostfixPrefixSeqBisemigroup_dsIso).
      split.
      
      intros x y; simpl. unfold postfix; rewrite rev_involutive; auto.
      
      intros x y; simpl. unfold postfix; repeat rewrite rev_involutive; auto.
      
      intros x y; simpl. rewrite distr_rev; auto.
      
      intros x y; simpl. rewrite distr_rev; auto.
   Defined.
   
End PostfixSeq.