Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Min.
Require Import Coq.Setoids.Setoid.

Section NatMinPlus.

   Open Scope Bisemigroup_scope.

   Definition natMinPlusBisemigroup : Bisemigroup :=
      glueBSmg natMinSemigroup natPlusSemigroup (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _). *)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma isLeftDistributive : IsLeftDistributive natMinPlusBisemigroup.
   Proof. intros x y z; dseq_u; simpl; rewrite beq_nat_eq; induction z; simpl; auto. Defined.

   Lemma isRightDistributive : IsRightDistributive natMinPlusBisemigroup.
   Proof. intros x y z; dseq_u; simpl; rewrite beq_nat_eq; 
      rewrite plus_comm, (plus_comm x), (plus_comm y); induction z; simpl; auto.
   Defined.
   
(*
   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp natMinPlusBisemigroup.
   Proof.
      red. simpl. exists 1; exists 1; exists 1. trivial.
   Defined.
   
   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp natMinPlusBisemigroup.
   Proof.
      red. exists 1; exists 1; exists 1. trivial.
   Defined.
*)
   
   (* always irrelevant : plusIdentityIsTimesAnnihilator *)

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp natMinPlusBisemigroup.
   Proof. intros q [an p]; (assert (False); [|tauto]); clear q;
      destruct (p 1); dseq_u; simpl in *.
      rewrite beq_nat_eq in H.
      apply (lt_irrefl an).
      rewrite <- H at 2.
      rewrite plus_comm.
      apply lt_n_Sn.
   Defined.
      
   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity natMinPlusBisemigroup.
   Proof. intros pann tid.
      destruct pann as [[|n] p]; simpl in *; [ | destruct (p 0); discriminate H ].
      destruct tid as [[|n] q]; simpl in *; [ | destruct (q 0); discriminate H ].
      auto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma plus_pres_min_l : forall a b c : nat, (min (a + c) (b + c) = (a + c))%nat <-> min a b = a.
   Proof. intros a b c. rewrite (plus_comm a), (plus_comm b).
      split; intros h; induction c; auto. simpl; rewrite IHc; auto.
   Qed.
   
   Lemma plus_pres_min_r : forall a b c : nat, (min (a + c) (b + c) = (b + c))%nat <-> min a b = b.
   Proof. intros a b c. rewrite (plus_comm a), (plus_comm b).
      split; intros h; induction c; auto. simpl; rewrite IHc; auto.
   Qed.
 
   Lemma isRightStrictStable : IsRightStrictStable natMinPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      rewrite plus_pres_min_l, plus_pres_min_l.
      copy_destruct ((x == y)%bool) as p.
      simpl in p; dseq_f; rewrite beq_nat_eq in p; rewrite p; rewrite min_idemp; auto.
      bool_p. simpl in p. rewrite beq_nat_eq in p.
      destruct (min_dec x y) as [h|h]; rewrite h, min_comm, h; auto.
   Defined.

   Lemma isLeftStrictStable : IsLeftStrictStable natMinPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
      repeat rewrite (plus_comm z);
      rewrite plus_pres_min_l, plus_pres_min_l.
      copy_destruct ((x == y)%bool) as p.
      simpl in p; dseq_f; rewrite beq_nat_eq in p; rewrite p; rewrite min_idemp; auto.
      bool_p. simpl in p. rewrite beq_nat_eq in p.
      destruct (min_dec x y) as [h|h]; rewrite h, min_comm, h; auto.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel natMinPlusBisemigroup.
   Proof. intros _ _ x y z _; destruct (min_dec x y);
      dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq; auto.
      rewrite (min_comm y); auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natMinPlusBisemigroup.
   Proof. intros _ _ x y z _; destruct (min_dec x y);
      dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq; auto.
      rewrite (min_comm y); auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natMinPlusBisemigroup.
   Proof. intros _ _ x y z _; destruct (min_dec x y);
      dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq; auto.
      rewrite (min_comm y); auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natMinPlusBisemigroup.
   Proof. intros _ _ x y z _; destruct (min_dec x y);
      dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq; auto.
      rewrite (min_comm y); auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natMinPlusBisemigroup.
   Proof. intros comm idem. simpl.
      exists 0; exists 1; exists 0; compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natMinPlusBisemigroup.
   Proof. intros comm idem.
      exists 0; exists 1; exists 0; compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natMinPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     repeat rewrite (plus_comm z).
     rewrite plus_pres_min_l, plus_pres_min_l.
     rewrite (min_comm y); destruct (min_dec x y); auto.
   Defined.

   Lemma rightComparable : RightComparable natMinPlusBisemigroup.
   Proof. intros comm idem x y z; dseq_u; simpl; negb_p; toProp; repeat rewrite beq_nat_eq.
     repeat rewrite (plus_comm z).
     rewrite plus_pres_min_l, plus_pres_min_l.
     rewrite (min_comm y); destruct (min_dec x y); auto.
   Defined.
   
   Lemma leftIncreasing : LeftIncreasing natMinPlusBisemigroup.
   Proof. intros _ _ x y. dseq_u; simpl; rewrite beq_nat_eq.
      rewrite min_l; auto. apply le_plus_r.
   Defined.

   Lemma rightIncreasing : RightIncreasing natMinPlusBisemigroup.
   Proof. intros _ _ x y. dseq_u; simpl; rewrite beq_nat_eq.
      rewrite min_l; auto. apply le_plus_l.
   Defined.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natMinPlusBisemigroup.
   Proof. intros _ _; exists 0; exists 0; compute; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natMinPlusBisemigroup.
   Proof. intros _ _; exists 0; exists 0; compute; auto. Defined.
   
(*
   (* IRRELEVANT *)
   Lemma leftWStrictIncreasing : LeftWStrictIncreasing natMinPlusBisemigroup.
   Proof. intros _ _ [id hid].
      destruct (NatMin.hasIdentity_comp id) as [a pa].
      assert (p := hid a).
      toProp. tauto.
   Qed.

   (* IRRELEVANT *)
   Lemma rightWStrictIncreasing : RightWStrictIncreasing natMinPlusBisemigroup.
   Proof. intros _ _ [id hid].
      destruct (NatMin.hasIdentity_comp id) as [a pa].
      assert (p := hid a).
      toProp. tauto.
   Qed.
*)

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma hasId_false : HasIdentity (plusSmg natMinPlusBisemigroup) -> False.
   Proof. intros [id hasId]. destruct (NatMin.hasIdentity_comp id) as [x p].
      destruct (hasId x) as [y q]. simpl in *. toProp. tauto.
   Defined.

   Lemma isRightTimesMapToIdConstantPlus : IsRightTimesMapToIdConstantPlus natMinPlusBisemigroup.
   Proof. intros i; elim (hasId_false i). Defined.
   
   Lemma isLeftTimesMapToIdConstantPlus : IsLeftTimesMapToIdConstantPlus natMinPlusBisemigroup.
   Proof. intros i; elim (hasId_false i). Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator natMinPlusBisemigroup.
   Proof. intros i; elim (hasId_false i). Defined.
      
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator natMinPlusBisemigroup.
   Proof. intros i; elim (hasId_false i). Defined.

   Close Scope Bisemigroup_scope.

End NatMinPlus.
